/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ManifestSection;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.InstanceSupport;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoaderPoolNode
extends AbstractNode {
    private static LoaderPoolNode loaderPoolNode;
    private static final Logger err;
    private static LoaderChildren myChildren;
    private static List<DataLoader> loaders;
    private static Set<DataLoader> modifiedLoaders;
    private static Map<String, DataLoader> names2Loaders;
    private static Map<String, DataLoader> repNames2Loaders;
    private static Map<String, String[]> installBefores;
    private static Map<String, String[]> installAfters;
    private static DataLoader[] loadersArray;
    private static boolean installationFinished;
    private static boolean updatingBatch;
    private static boolean updatingBatchUsed;
    private static final String LOADER_POOL_NAME = "loaders.ser";
    private static NbLoaderPool nbLoaderPool;

    private LoaderPoolNode() {
        super((Children)new LoaderChildren());
        myChildren = (LoaderChildren)this.getChildren();
        this.setName("LoaderPoolNode");
        this.setDisplayName(NbBundle.getMessage(LoaderPoolNode.class, (String)"CTL_LoaderPool"));
        this.getCookieSet().add((Node.Cookie)new Index());
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)LoaderPoolNode.getNbLoaderPool()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LoaderPoolNode.class);
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(ReorderAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public static synchronized void beginUpdates() {
        updatingBatch = true;
        updatingBatchUsed = false;
    }

    public static synchronized void endUpdates() {
        if (!updatingBatch) {
            throw new IllegalStateException();
        }
        updatingBatch = false;
        if (updatingBatchUsed) {
            updatingBatchUsed = false;
            LoaderPoolNode.resort();
        }
    }

    public static void waitFinished() {
        LoaderPoolNode.getNbLoaderPool().fireTask.waitFinished();
    }

    public static void add(ManifestSection.LoaderSection loaderSection) throws Exception {
        DataLoader dataLoader = (DataLoader)loaderSection.getInstance();
        LoaderPoolNode.doAdd(dataLoader, loaderSection);
    }

    static synchronized void doAdd(DataLoader dataLoader, ManifestSection.LoaderSection loaderSection) throws Exception {
        Class<?> clazz;
        Iterator<DataLoader> iterator;
        if (err.isLoggable(Level.FINE) && loaderSection != null) {
            iterator = loaderSection.getInstallBefore() == null ? null : Arrays.asList(loaderSection.getInstallBefore());
            clazz = loaderSection.getInstallAfter() == null ? null : Arrays.asList(loaderSection.getInstallAfter());
            err.fine("add: " + dataLoader + " repclass: " + dataLoader.getRepresentationClass().getName() + " before: " + iterator + " after: " + clazz);
        }
        iterator = loaders.iterator();
        clazz = dataLoader.getClass();
        while (iterator.hasNext()) {
            if (iterator.next().getClass() != clazz) continue;
            iterator.remove();
            break;
        }
        loaders.add(dataLoader);
        dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        dataLoader.addPropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        String string = clazz.getName();
        names2Loaders.put(string, dataLoader);
        repNames2Loaders.put(dataLoader.getRepresentationClassName(), dataLoader);
        if (loaderSection != null) {
            String[] stringArray;
            String[] stringArray2 = loaderSection.getInstallBefore();
            if (stringArray2 != null) {
                installBefores.put(string, stringArray2);
            }
            if ((stringArray = loaderSection.getInstallAfter()) != null) {
                installAfters.put(string, stringArray);
            }
        }
        if (updatingBatch) {
            updatingBatchUsed = true;
        } else {
            LoaderPoolNode.resort();
        }
    }

    private static synchronized void resort() {
        HashMap<DataLoader, List<DataLoader>> hashMap = new HashMap<DataLoader, List<DataLoader>>();
        LoaderPoolNode.add2Deps(hashMap, installBefores, true);
        LoaderPoolNode.add2Deps(hashMap, installAfters, false);
        if (err.isLoggable(Level.FINE)) {
            err.fine("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.topologicalSort(loaders, hashMap);
            if (err.isLoggable(Level.FINE)) {
                err.fine("After sort: " + loaders);
            }
        }
        catch (TopologicalSortException topologicalSortException) {
            err.log(Level.WARNING, null, topologicalSortException);
            err.warning("Contradictory loader ordering: " + hashMap);
        }
        LoaderPoolNode.update();
    }

    private static void add2Deps(Map<DataLoader, List<DataLoader>> map, Map map2, boolean bl) {
        for (Map.Entry entry : map2.entrySet()) {
            String string = (String)entry.getKey();
            DataLoader dataLoader = names2Loaders.get(string);
            if (dataLoader == null) {
                throw new IllegalStateException("No such loader: " + string);
            }
            String[] stringArray = (String[])entry.getValue();
            if (stringArray == null) {
                throw new IllegalStateException("Null Install-" + (bl ? "Before" : "After") + " for " + string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                DataLoader dataLoader2 = repNames2Loaders.get(string2);
                if (dataLoader2 != null) {
                    if (bl) {
                        LoaderPoolNode.addDep(map, dataLoader, dataLoader2);
                        continue;
                    }
                    LoaderPoolNode.addDep(map, dataLoader2, dataLoader);
                    continue;
                }
                dataLoader2 = names2Loaders.get(string2);
                if (dataLoader2 == null) continue;
                LoaderPoolNode.warn(string, string2, dataLoader2.getRepresentationClassName());
            }
        }
    }

    private static void addDep(Map<DataLoader, List<DataLoader>> map, DataLoader dataLoader, DataLoader dataLoader2) {
        List<DataLoader> list = map.get(dataLoader);
        if (list == null) {
            list = new LinkedList<DataLoader>();
            map.put(dataLoader, list);
        }
        if (!list.contains(dataLoader2)) {
            list.add(dataLoader2);
        }
    }

    private static void warn(String string, String string2, String string3) {
        err.warning("Warning: a possible error in the manifest containing " + string + " was found.");
        err.warning("The loader specified an Install-{After,Before} on " + string2 + ", but this is a DataLoader class.");
        err.warning("Probably you wanted " + string3 + " which is the loader's representation class.");
    }

    static void installationFinished() {
        installationFinished = true;
        if (!modifiedLoaders.isEmpty()) {
            LoaderPoolNode.getNbLoaderPool().superFireChangeEvent();
        }
        if (myChildren != null) {
            myChildren.update();
        }
    }

    static synchronized boolean isModified(DataLoader dataLoader) {
        return modifiedLoaders.contains(dataLoader);
    }

    private static synchronized void writePool(ObjectOutputStream objectOutputStream) throws IOException {
        String string;
        if (err.isLoggable(Level.FINE)) {
            err.fine("writePool");
        }
        objectOutputStream.writeObject(new HashMap());
        objectOutputStream.writeObject(new HashMap());
        Collection collection = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (DataLoader object22 : loaders) {
            if (!LoaderPoolNode.isModified(object22)) {
                string = object22.getClass().getName();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("writing unmodified " + string);
                }
                objectOutputStream.writeObject("=" + string);
                continue;
            }
            try {
                string = new NbMarshalledObject((Object)object22);
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, null, iOException);
                string = null;
            }
            if (string == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing modified " + object22.getClass().getName());
            }
            Object iOException = object22.getClass();
            Iterator iOException2 = collection.iterator();
            boolean bl = false;
            while (iOException2.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iOException2.next();
                if (!moduleInfo.isEnabled() || !moduleInfo.owns((Class)iOException)) continue;
                if (err.isLoggable(Level.FINE)) {
                    err.fine("belongs to module: " + moduleInfo.getCodeNameBase());
                }
                objectOutputStream.writeObject(moduleInfo.getCodeNameBase());
                int n = moduleInfo.getCodeNameRelease();
                objectOutputStream.writeInt(n);
                SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
                if (specificationVersion != null) {
                    objectOutputStream.writeObject(specificationVersion.toString());
                } else {
                    objectOutputStream.writeObject(null);
                }
                bl = true;
                break;
            }
            if (!bl && err.isLoggable(Level.FINE)) {
                err.fine("does not belong to any module");
            }
            objectOutputStream.writeObject(string);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        objectOutputStream.writeObject(null);
        Enumeration enumeration = LoaderPoolNode.getNbLoaderPool().allLoaders();
        while (enumeration.hasMoreElements()) {
            string = (DataLoader)enumeration.nextElement();
            if (loaders.contains(string)) continue;
            if (!LoaderPoolNode.isModified((DataLoader)string)) {
                iOException = string.getClass().getName();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("skipping unmodified " + (String)iOException);
                continue;
            }
            try {
                iOException = new NbMarshalledObject((Object)string);
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, null, iOException);
                iOException = null;
            }
            if (iOException == null) continue;
            if (err.isLoggable(Level.FINE)) {
                err.fine("writing " + string.getClass().getName());
            }
            objectOutputStream.writeObject(iOException);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("writing null");
        }
        objectOutputStream.writeObject(null);
        if (err.isLoggable(Level.FINE)) {
            err.fine("done writing");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void readPool(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Iterator<DataLoader> iterator;
        objectInputStream.readObject();
        objectInputStream.readObject();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<DataLoader> linkedList = new LinkedList<DataLoader>();
        Iterator iterator2 = Lookup.getDefault().lookupAll(ModuleInfo.class).iterator();
        HashMap<String, Iterator<DataLoader>> hashMap = new HashMap<String, Iterator<DataLoader>>();
        while (iterator2.hasNext()) {
            iterator = (ModuleInfo)iterator2.next();
            hashMap.put(iterator.getCodeNameBase(), iterator);
        }
        while (true) {
            Object object2;
            if ((iterator = objectInputStream.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            if (iterator instanceof String) {
                SpecificationVersion specificationVersion;
                object = (String)((Object)iterator);
                if (((String)object).length() > 0 && ((String)object).charAt(0) == '=') {
                    String string = ((String)object).substring(1);
                    object2 = names2Loaders.get(string);
                    if (object2 != null) {
                        if (err.isLoggable(Level.FINE)) {
                            err.fine("reading unmodified " + string);
                        }
                        linkedList.add((DataLoader)object2);
                        hashSet.add(object2.getClass());
                        continue;
                    }
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("skipping unmodified nonexistent " + string);
                    continue;
                }
                int n = objectInputStream.readInt();
                object2 = (String)objectInputStream.readObject();
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)objectInputStream.readObject();
                ModuleInfo moduleInfo = (ModuleInfo)hashMap.get(object);
                if (moduleInfo == null) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("No known module " + (String)object + ", skipping loader");
                    continue;
                }
                if (!moduleInfo.isEnabled()) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is disabled, skipping loader");
                    continue;
                }
                if (moduleInfo.getCodeNameRelease() < n) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (object2 != null && ((specificationVersion = moduleInfo.getSpecificationVersion()) == null || specificationVersion.compareTo((Object)new SpecificationVersion((String)object2)) < 0)) {
                    if (!err.isLoggable(Level.FINE)) continue;
                    err.fine("Module " + (String)object + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                if (err.isLoggable(Level.FINE)) {
                    err.fine("Module " + (String)object + " is OK, will try to restore loader");
                }
            } else {
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)iterator;
            }
            object = null;
            try {
                void object4;
                DataLoader dataLoader = (DataLoader)object4.get();
                if (dataLoader == null) continue;
                object2 = dataLoader.getClass();
                if (err.isLoggable(Level.FINE)) {
                    err.fine("reading modified " + ((Class)object2).getName());
                }
                linkedList.add(dataLoader);
                hashSet.add(object2);
            }
            catch (IOException iOException) {
                object = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
            }
        }
        while (true) {
            if ((iterator = (NbMarshalledObject)objectInputStream.readObject()) == null) {
                if (!err.isLoggable(Level.FINE)) break;
                err.fine("reading null");
                break;
            }
            Object var6_10 = null;
            try {
                object = (DataLoader)iterator.get();
                if (!err.isLoggable(Level.FINE)) continue;
                err.fine("reading " + object.getClass().getName());
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
            }
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("done reading");
        }
        for (DataLoader dataLoader : loaders) {
            if (hashSet.contains(dataLoader.getClass())) continue;
            linkedList.add(dataLoader);
        }
        if (linkedList.size() > new HashSet(linkedList).size()) {
            throw new IllegalStateException("Duplicates in " + linkedList);
        }
        loaders = linkedList;
        LoaderPoolNode.resort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() throws IOException {
        if (modifiedLoaders.isEmpty()) {
            return;
        }
        FileObject fileObject = LoaderPoolNode.getLoaderPoolStorage(true);
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(outputStream);
            NbObjectOutputStream.writeSafely((ObjectOutput)nbObjectOutputStream, (Object)LoaderPoolNode.getNbLoaderPool());
            nbObjectOutputStream.flush();
            nbObjectOutputStream.close();
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws IOException {
        FileObject fileObject = LoaderPoolNode.getLoaderPoolStorage(false);
        if (fileObject != null) {
            try {
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(fileObject.getInputStream());
                try {
                    NbObjectInputStream.readSafely((ObjectInput)nbObjectInputStream);
                }
                finally {
                    nbObjectInputStream.close();
                }
            }
            catch (IOException iOException) {
                fileObject.delete();
                throw iOException;
            }
        }
    }

    private static FileObject getLoaderPoolStorage(boolean bl) throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(LOADER_POOL_NAME);
        if (fileObject == null && bl) {
            fileObject = fileSystem.getRoot().createData(LOADER_POOL_NAME);
        }
        return fileObject;
    }

    private static synchronized void update() {
        if (err.isLoggable(Level.FINE)) {
            err.fine("update");
        }
        loadersArray = null;
        NbLoaderPool nbLoaderPool = LoaderPoolNode.getNbLoaderPool();
        if (nbLoaderPool != null && installationFinished) {
            nbLoaderPool.superFireChangeEvent();
        }
        if (nbLoaderPool != null) {
            Enumeration enumeration = nbLoaderPool.allLoaders();
            while (enumeration.hasMoreElements()) {
                DataLoader dataLoader = (DataLoader)enumeration.nextElement();
                dataLoader.removePropertyChangeListener((PropertyChangeListener)nbLoaderPool);
                dataLoader.addPropertyChangeListener((PropertyChangeListener)nbLoaderPool);
            }
        }
    }

    public static synchronized boolean remove(DataLoader dataLoader) {
        if (loaders.remove(dataLoader)) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("remove: " + dataLoader);
            }
            String string = dataLoader.getClass().getName();
            names2Loaders.remove(string);
            repNames2Loaders.remove(dataLoader.getRepresentationClassName());
            installBefores.remove(string);
            installAfters.remove(string);
            dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
            if (updatingBatch) {
                updatingBatchUsed = true;
            } else {
                LoaderPoolNode.resort();
            }
            modifiedLoaders.remove(dataLoader);
            return true;
        }
        return false;
    }

    public static synchronized LoaderPoolNode getLoaderPoolNode() {
        if (loaderPoolNode == null) {
            loaderPoolNode = new LoaderPoolNode();
        }
        return loaderPoolNode;
    }

    public static synchronized NbLoaderPool getNbLoaderPool() {
        if (nbLoaderPool == null) {
            nbLoaderPool = (NbLoaderPool)DataLoaderPool.getDefault();
        }
        return nbLoaderPool;
    }

    static /* synthetic */ DataLoader[] access$402(DataLoader[] dataLoaderArray) {
        loadersArray = dataLoaderArray;
        return dataLoaderArray;
    }

    static {
        err = Logger.getLogger("org.netbeans.core.LoaderPoolNode");
        loaders = new ArrayList<DataLoader>();
        modifiedLoaders = new HashSet<DataLoader>();
        names2Loaders = new HashMap<String, DataLoader>(200);
        repNames2Loaders = new HashMap<String, DataLoader>(200);
        installBefores = new HashMap<String, String[]>();
        installAfters = new HashMap<String, String[]>();
        installationFinished = false;
        updatingBatch = false;
        updatingBatchUsed = false;
        nbLoaderPool = null;
    }

    private final class Index
    extends Index.Support {
        Index() {
        }

        public Node[] getNodes() {
            Enumeration enumeration = LoaderPoolNode.this.getChildren().nodes();
            ArrayList<LoaderPoolItemNode> arrayList = new ArrayList<LoaderPoolItemNode>();
            while (enumeration.hasMoreElements()) {
                LoaderPoolItemNode loaderPoolItemNode = (LoaderPoolItemNode)((Object)enumeration.nextElement());
                if (loaderPoolItemNode.isSystem) continue;
                arrayList.add(loaderPoolItemNode);
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] nArray) {
            Class<LoaderPoolNode> clazz = LoaderPoolNode.class;
            synchronized (LoaderPoolNode.class) {
                DataLoader[] dataLoaderArray;
                DataLoader[] dataLoaderArray2 = loaders.toArray(new DataLoader[loaders.size()]);
                if (dataLoaderArray2.length == nArray.length) {
                    dataLoaderArray = new DataLoader[dataLoaderArray2.length];
                    for (int i = 0; i < dataLoaderArray2.length; ++i) {
                        if (dataLoaderArray[nArray[i]] != null) {
                            throw new IllegalArgumentException();
                        }
                        dataLoaderArray[nArray[i]] = dataLoaderArray2[i];
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                loaders = new ArrayList<DataLoader>(Arrays.asList(dataLoaderArray));
                LoaderPoolNode.update();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NbLoaderPool
    extends DataLoaderPool
    implements PropertyChangeListener,
    Runnable,
    LookupListener {
        private static final long serialVersionUID = -8488524097175567566L;
        static boolean IN_TEST = false;
        private transient RequestProcessor.Task fireTask;
        private transient Lookup.Result mimeResolvers;
        private static RequestProcessor rp = new RequestProcessor("Refresh Loader Pool");
        private final FileChangeListener listener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                NbLoaderPool.this.maybeFireChangeEvent();
            }

            public void fileDeleted(FileEvent fileEvent) {
                NbLoaderPool.this.maybeFireChangeEvent();
            }
        };

        public NbLoaderPool() {
            this.fireTask = rp.create((Runnable)this, true);
            this.mimeResolvers = Lookup.getDefault().lookupResult(MIMEResolver.class);
            this.mimeResolvers.addLookupListener((LookupListener)this);
            this.listenToDeclarativeResolvers();
        }

        private void listenToDeclarativeResolvers() {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/MIMEResolver");
            if (fileObject != null) {
                fileObject.addFileChangeListener(this.listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Enumeration<DataLoader> loaders() {
            Object[] objectArray = loadersArray;
            if (objectArray != null) return Enumerations.array((Object[])objectArray);
            Class<LoaderPoolNode> clazz = LoaderPoolNode.class;
            synchronized (LoaderPoolNode.class) {
                objectArray = LoaderPoolNode.access$402(loaders.toArray(new DataLoader[loaders.size()]));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Enumerations.array((Object[])objectArray);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataLoader dataLoader = (DataLoader)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("actions".equals(string) && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            modifiedLoaders.add(dataLoader);
            if (err.isLoggable(Level.FINE)) {
                err.fine("Got change in " + dataLoader.getClass().getName() + "." + string);
            }
            if ("actions".equals(string) || "displayName".equals(string)) {
                return;
            }
            if (installationFinished) {
                this.superFireChangeEvent();
            }
        }

        void superFireChangeEvent() {
            err.fine("Change in loader pool scheduled");
            this.fireTask.schedule(1000);
        }

        @Override
        public void run() {
            err.fine("going to fire change in loaders");
            super.fireChangeEvent(new ChangeEvent(this));
            err.fine("change event fired");
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            LoaderPoolNode.writePool(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            LoaderPoolNode.readPool(objectInputStream);
        }

        private Object readResolve() {
            return LoaderPoolNode.getNbLoaderPool();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.maybeFireChangeEvent();
        }

        private void maybeFireChangeEvent() {
            if (IN_TEST || Main.isInitialized()) {
                this.superFireChangeEvent();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LoaderChildren
    extends Children.Keys<DataLoader>
    implements ChangeListener {
        public LoaderChildren() {
            this.update();
            LoaderPoolNode.getNbLoaderPool().addChangeListener(this);
        }

        public void update() {
            this.setKeys(Collections.list(LoaderPoolNode.getNbLoaderPool().allLoaders()));
        }

        protected Node[] createNodes(DataLoader dataLoader) {
            try {
                return new Node[]{new LoaderPoolItemNode(dataLoader)};
            }
            catch (IntrospectionException introspectionException) {
                err.log(Level.WARNING, null, introspectionException);
                return new Node[0];
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderPoolItemNode
    extends BeanNode<DataLoader> {
        boolean isSystem;

        public LoaderPoolItemNode(DataLoader dataLoader) throws IntrospectionException {
            super((Object)dataLoader);
            this.setSynchronizeName(false);
            String string = this.getDisplayName();
            this.setName(dataLoader.getClass().getName());
            boolean bl = this.isSystem = !loaders.contains(dataLoader);
            if (this.isSystem) {
                this.setDisplayName(NbBundle.getMessage(LoaderPoolNode.class, (String)"LBL_system_data_loader", (Object)string));
            } else {
                this.setDisplayName(string);
            }
        }

        public Action[] getActions(boolean bl) {
            if (this.isSystem) {
                return new Action[]{SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return new Action[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }

        public Action getPreferredAction() {
            return SystemAction.get(PropertiesAction.class);
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            HelpCtx helpCtx = super.getHelpCtx();
            if (helpCtx == null || helpCtx.getHelpID() == null || helpCtx.getHelpID().equals(BeanNode.class.getName())) {
                helpCtx = new HelpCtx(LoaderPoolItemNode.class);
            }
            return helpCtx;
        }
    }
}

