/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import org.traccar.BaseDataHandler;
import org.traccar.database.IdentityManager;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class CopyAttributesHandler
extends BaseDataHandler {
    private IdentityManager identityManager;

    public CopyAttributesHandler(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    protected Position handlePosition(Position position) {
        String attributesString = this.identityManager.lookupAttributeString(position.getDeviceId(), "processing.copyAttributes", "", false, true);
        Position last = this.identityManager.getLastPosition(position.getDeviceId());
        if (last != null) {
            for (String attribute : attributesString.split("[ ,]")) {
                if (!last.getAttributes().containsKey(attribute) || position.getAttributes().containsKey(attribute)) continue;
                position.getAttributes().put(attribute, last.getAttributes().get(attribute));
            }
        }
        return position;
    }
}

