/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.IdentityManager;
import org.traccar.geocoder.Geocoder;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class GeocoderHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocoderHandler.class);
    private final Geocoder geocoder;
    private final IdentityManager identityManager;
    private final boolean ignorePositions;
    private final boolean processInvalidPositions;
    private final int geocoderReuseDistance;

    public GeocoderHandler(Config config, Geocoder geocoder, IdentityManager identityManager) {
        this.geocoder = geocoder;
        this.identityManager = identityManager;
        this.ignorePositions = Context.getConfig().getBoolean(Keys.GEOCODER_IGNORE_POSITIONS);
        this.processInvalidPositions = config.getBoolean(Keys.GEOCODER_PROCESS_INVALID_POSITIONS);
        this.geocoderReuseDistance = config.getInteger(Keys.GEOCODER_REUSE_DISTANCE, 0);
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) {
        if (message instanceof Position && !this.ignorePositions) {
            final Position position = (Position)message;
            if (this.processInvalidPositions || position.getValid()) {
                Position lastPosition;
                if (this.geocoderReuseDistance != 0 && (lastPosition = this.identityManager.getLastPosition(position.getDeviceId())) != null && lastPosition.getAddress() != null && position.getDouble("distance") <= (double)this.geocoderReuseDistance) {
                    position.setAddress(lastPosition.getAddress());
                    ctx.fireChannelRead((Object)position);
                    return;
                }
                this.geocoder.getAddress(position.getLatitude(), position.getLongitude(), new Geocoder.ReverseGeocoderCallback(){

                    @Override
                    public void onSuccess(String address) {
                        position.setAddress(address);
                        ctx.fireChannelRead((Object)position);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        LOGGER.warn("Geocoding failed", e);
                        ctx.fireChannelRead((Object)position);
                    }
                });
            } else {
                ctx.fireChannelRead((Object)position);
            }
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

