/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class ArmoliProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("[M").number("(d{15})").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("([NS])(dd.d{6})").number("([EW])(ddd.d{6})").number("(d)").number("(x)").number("(xx)").number("(ddd)").number("(xxx)").number("(xxx)").number("(xx)").number("(xx)").number("(x{6})").any().compile();

    public ArmoliProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        char type = sentence.charAt(1);
        if (type != 'M') {
            if (channel != null && (type == 'Q' || type == 'L')) {
                channel.writeAndFlush((Object)new NetworkMessage("[TX,];;", remoteAddress));
            }
            return null;
        }
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
        position.setValid(parser.nextInt() > 0);
        position.set("sat", parser.nextHexInt());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextHexInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.set("adc1", (double)parser.nextHexInt().intValue() / 27.0 * 1000.0);
        position.set("adc1", (double)parser.nextHexInt().intValue() / 27.0 * 1000.0);
        position.set("status", parser.nextHexInt());
        position.set("maxSpeed", parser.nextHexInt());
        position.set("odometer", parser.nextHexInt());
        return position;
    }
}

