/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class FlexCommProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("7E").number("(dd)").number("(d{15})").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").expression("([01])").number("(d{9})").number("(d{10})").number("(d{4})").number("(ddd)").number("(ddd)").number("(dd)").number("(dd)").number("(dd)").number("(ddd)").number("(ddd)").number("(x{6})").number("(x{6})").expression("([01])([01])([01])").expression("([01])([01])").number("(ddd)").number("(d{4})").number("(ddd)").number("(ddd)").any().compile();

    public FlexCommProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double parseSignedValue(Parser parser, int decimalPoints) {
        String stringValue = parser.next();
        boolean negative = stringValue.charAt(0) == '1';
        double value = (double)Integer.parseInt(stringValue.substring(1)) * Math.pow(10.0, -decimalPoints);
        return negative ? -value : value;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        int i;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("status", parser.nextInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("1"));
        position.setLatitude(FlexCommProtocolDecoder.parseSignedValue(parser, 6));
        position.setLongitude(FlexCommProtocolDecoder.parseSignedValue(parser, 6));
        position.setAltitude(FlexCommProtocolDecoder.parseSignedValue(parser, 0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextDouble(0.0));
        position.set("satVisible", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.set("rssi", parser.nextInt());
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue())));
        for (i = 1; i <= 3; ++i) {
            position.set("in" + i, parser.nextInt());
        }
        for (i = 1; i <= 2; ++i) {
            position.set("out" + i, parser.nextInt());
        }
        position.set("fuel", parser.nextInt());
        position.set("temp1", FlexCommProtocolDecoder.parseSignedValue(parser, 0));
        position.set("batteryLevel", parser.nextInt());
        position.set("power", (double)parser.nextInt().intValue() * 0.1);
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("{01}", remoteAddress));
        }
        return position;
    }
}

