/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;

public class R12wProtocolDecoder
extends BaseProtocolDecoder {
    public R12wProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, String type, String id, String data) {
        if (channel != null) {
            Object sentence = String.format("$HX,%s,%s,%s,#", type, id, data);
            sentence = (String)sentence + String.format(",%02x,\r\n", Checksum.xor((String)sentence));
            channel.writeAndFlush((Object)new NetworkMessage(sentence, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        String[] values = sentence.split(",");
        String type = values[1];
        String id = values[2];
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        if (type.equals("0001")) {
            this.sendResponse(channel, "1001", id, values[3] + ",OK");
        }
        return null;
    }
}

