/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class SwiftechProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("@@").number("(d+),").expression("[^,]*,").expression("[^,]*,").number("(dd)(dd)(dd),").number("(dd)(dd.d+),").expression("([NS]),").number("(d{2,3})(dd.d+),").expression("([EW]),").number("(d+.d+),").number("(dd)(dd)(dd),").expression("([AV]),").number("(d{4}),").number("([01]),").number("d+,").number("(d+),").number("(d+),").any().compile();

    public SwiftechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble());
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.setValid(parser.next().equals("A"));
        position.set("status", parser.nextInt());
        position.set("charge", parser.nextInt() > 0);
        position.set("adc1", (double)parser.nextInt().intValue() * 0.001);
        position.set("adc2", (double)parser.nextInt().intValue() * 0.001);
        return position;
    }
}

