/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Xexun2ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_POSITION = 20;

    public Xexun2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type, int index, ByteBuf imei) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(250);
            response.writeByte(175);
            response.writeShort(type);
            response.writeShort(index);
            response.writeBytes(imei);
            response.writeShort(1);
            response.writeShort(65534);
            response.writeByte(1);
            response.writeByte(250);
            response.writeByte(175);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(long value) {
        if (BitUtil.check(value, 0)) {
            return "sos";
        }
        if (BitUtil.check(value, 15)) {
            return "fallDown";
        }
        return null;
    }

    private double convertCoordinate(double value) {
        double degrees = Math.floor(value / 100.0);
        double minutes = value - degrees * 100.0;
        return degrees + minutes / 60.0;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        int type = buf.readUnsignedShort();
        int index = buf.readUnsignedShort();
        ByteBuf imei = buf.readSlice(8);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)imei).substring(0, 15));
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, type, index, imei);
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        if (type == 20) {
            int i;
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            ArrayList<Position> positions = new ArrayList<Position>();
            int count = buf.readUnsignedByte();
            for (i = 0; i < count; ++i) {
                lengths.add(buf.readUnsignedShort());
            }
            for (i = 0; i < count; ++i) {
                int endIndex = buf.readerIndex() + (Integer)lengths.get(i);
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("index", buf.readUnsignedByte());
                position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
                position.set("rssi", buf.readUnsignedByte());
                int battery = buf.readUnsignedShort();
                position.set("charge", BitUtil.check(battery, 15));
                position.set("batteryLevel", BitUtil.to(battery, 15));
                short mask = buf.readUnsignedByte();
                if (BitUtil.check(mask, 0)) {
                    position.set("alarm", this.decodeAlarm(buf.readUnsignedInt()));
                }
                if (BitUtil.check(mask, 1)) {
                    int j;
                    short positionMask = buf.readUnsignedByte();
                    if (BitUtil.check(positionMask, 0)) {
                        position.setValid(true);
                        position.setFixTime(position.getDeviceTime());
                        position.set("sat", buf.readUnsignedByte());
                        position.setLongitude(this.convertCoordinate(buf.readFloat()));
                        position.setLatitude(this.convertCoordinate(buf.readFloat()));
                    }
                    Network network = new Network();
                    if (BitUtil.check(positionMask, 1)) {
                        int wifiCount = buf.readUnsignedByte();
                        for (j = 0; j < wifiCount; ++j) {
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readUnsignedByte()));
                        }
                    }
                    if (BitUtil.check(positionMask, 2)) {
                        int cellCount = buf.readUnsignedByte();
                        for (j = 0; j < cellCount; ++j) {
                            network.addCellTower(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readInt(), buf.readUnsignedInt(), buf.readUnsignedByte()));
                        }
                    }
                    if (network.getWifiAccessPoints() != null || network.getCellTowers() != null) {
                        position.setNetwork(network);
                    }
                    if (BitUtil.check(positionMask, 3)) {
                        buf.skipBytes(12 * buf.readUnsignedByte());
                    }
                    if (BitUtil.check(positionMask, 5)) {
                        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
                        position.setCourse((double)buf.readUnsignedShort() * 0.1);
                    }
                    if (BitUtil.check(positionMask, 6)) {
                        position.setValid(true);
                        position.setFixTime(position.getDeviceTime());
                        position.set("sat", buf.readUnsignedByte());
                        position.setLongitude(this.convertCoordinate(buf.readDouble()));
                        position.setLatitude(this.convertCoordinate(buf.readDouble()));
                    }
                }
                if (BitUtil.check(mask, 3)) {
                    buf.readUnsignedInt();
                }
                if (BitUtil.check(mask, 4)) {
                    buf.skipBytes(20);
                    buf.skipBytes(8);
                    buf.skipBytes(10);
                }
                if (BitUtil.check(mask, 5)) {
                    buf.skipBytes(12);
                }
                if (!position.getValid()) {
                    this.getLastLocation(position, position.getDeviceTime());
                }
                positions.add(position);
                buf.readerIndex(endIndex);
            }
            return positions;
        }
        return null;
    }
}

