/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.jparsec.Lexicon;
import org.jparsec.Parser;
import org.jparsec.StringCase;
import org.jparsec.Tokens;
import org.jparsec.internal.annotations.Private;

final class Keywords {
    Keywords() {
    }

    @Private
    static String[] unique(Comparator<String> c, String ... names) {
        TreeSet<String> set = new TreeSet<String>(c);
        set.addAll(Arrays.asList(names));
        return set.toArray(new String[set.size()]);
    }

    static Lexicon lexicon(Parser<String> wordScanner, Collection<String> keywordNames, StringCase stringCase, Function<String, ?> defaultMap) {
        HashMap<String, Tokens.Fragment> map = new HashMap<String, Tokens.Fragment>();
        for (String n : Keywords.unique(stringCase, keywordNames.toArray(new String[keywordNames.size()]))) {
            Tokens.Fragment value = Tokens.reserved(n);
            map.put(stringCase.toKey(n), value);
        }
        Function<String, Object> keywordMap = stringCase.byKey(map::get);
        return new Lexicon(keywordMap, wordScanner.map(Lexicon.fallback(keywordMap, defaultMap)));
    }
}

