/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.AbstractProcessor;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ExposedBindingImpl;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.ProcessedBindingData;
import com.google.inject.internal.Scoping;
import com.google.inject.internal.State;
import com.google.inject.internal.UntargettedBindingImpl;
import com.google.inject.spi.DefaultBindingTargetVisitor;

abstract class AbstractBindingProcessor
extends AbstractProcessor {
    private static final ImmutableSet<Class<?>> FORBIDDEN_TYPES = ImmutableSet.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, new Class[]{Module.class, Provider.class, Scope.class, Stage.class, TypeLiteral.class});
    protected final ProcessedBindingData bindingData;

    AbstractBindingProcessor(Errors errors, ProcessedBindingData bindingData) {
        super(errors);
        this.bindingData = bindingData;
    }

    protected <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injector, Key<T> key2, Object source2) {
        return new UntargettedBindingImpl<T>(injector, key2, source2);
    }

    protected void putBinding(BindingImpl<?> binding2) {
        Key<?> key2;
        block6: {
            key2 = binding2.getKey();
            Class<?> rawType = key2.getTypeLiteral().getRawType();
            if (FORBIDDEN_TYPES.contains(rawType)) {
                this.errors.cannotBindToGuiceType(rawType.getSimpleName());
                return;
            }
            Binding original = this.injector.getExistingBinding((Key)key2);
            if (original != null) {
                if (this.injector.state.getExplicitBinding(key2) != null) {
                    try {
                        if (!this.isOkayDuplicate((BindingImpl<?>)original, binding2, this.injector.state)) {
                            this.errors.bindingAlreadySet(key2, ((BindingImpl)original).getSource());
                            return;
                        }
                        break block6;
                    }
                    catch (Throwable t) {
                        this.errors.errorCheckingDuplicateBinding(key2, ((BindingImpl)original).getSource(), t);
                        return;
                    }
                }
                this.errors.jitBindingAlreadySet(key2);
                return;
            }
        }
        this.injector.state.parent().blacklist(key2, this.injector.state, binding2.getSource());
        this.injector.state.putBinding(key2, binding2);
    }

    private boolean isOkayDuplicate(BindingImpl<?> original, BindingImpl<?> binding2, State state) {
        if (original instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposed = (ExposedBindingImpl)original;
            InjectorImpl exposedFrom = (InjectorImpl)exposed.getPrivateElements().getInjector();
            return exposedFrom == binding2.getInjector();
        }
        original = (BindingImpl)state.getExplicitBindingsThisLevel().get(binding2.getKey());
        if (original == null) {
            return false;
        }
        return original.equals(binding2);
    }

    private <T> void validateKey(Object source2, Key<T> key2) {
        Annotations.checkForMisplacedScopeAnnotations(key2.getTypeLiteral().getRawType(), source2, this.errors);
    }

    abstract class Processor<T, V>
    extends DefaultBindingTargetVisitor<T, V> {
        final Object source;
        final Key<T> key;
        final Class<? super T> rawType;
        Scoping scoping;

        Processor(BindingImpl<T> binding2) {
            this.source = binding2.getSource();
            this.key = binding2.getKey();
            this.rawType = this.key.getTypeLiteral().getRawType();
            this.scoping = binding2.getScoping();
        }

        protected void prepareBinding() {
            AbstractBindingProcessor.this.validateKey(this.source, this.key);
            this.scoping = Scoping.makeInjectable(this.scoping, AbstractBindingProcessor.this.injector, AbstractBindingProcessor.this.errors);
        }

        protected void scheduleInitialization(BindingImpl<?> binding2) {
            AbstractBindingProcessor.this.bindingData.addUninitializedBinding(this.asRunnable(binding2));
        }

        protected void scheduleDelayedInitialization(BindingImpl<?> binding2) {
            AbstractBindingProcessor.this.bindingData.addDelayedUninitializedBinding(this.asRunnable(binding2));
        }

        private Runnable asRunnable(final BindingImpl<?> binding2) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        binding2.getInjector().initializeBinding(binding2, AbstractBindingProcessor.this.errors.withSource(Processor.this.source));
                    }
                    catch (ErrorsException e2) {
                        AbstractBindingProcessor.this.errors.merge(e2.getErrors());
                    }
                }
            };
        }
    }
}

