#!/bin/sh

# Copyright (C) 2021 Internet Systems Consortium, Inc. ("ISC")
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# shellcheck disable=SC1091
# SC1091: Not following: ... was not specified as input (see shellcheck -x).

# Exit with error if commands exit with non-zero and if undefined variables are
# used.
set -eu

# shellcheck disable=SC2034
# SC2034: ... appears unused. Verify use (or export if used externally).
prefix="/usr/local"

# Include utilities. Use installed version if available and
# use build version if it isn't.
if [ -e ${prefix}/share/kea/scripts/admin-utils.sh ]; then
    . "${prefix}/share/kea/scripts/admin-utils.sh"
else
    . "/local/pobj/kea-2.0.2-mysql/kea-2.0.2/src/bin/admin/admin-utils.sh"
fi

# Check version.
version=$(mysql_version "${@}")
if test "${version}" != "9.5"; then
    printf 'This script upgrades 9.5 to 9.6. '
    printf 'Reported version is %s. Skipping upgrade.\n' "${version}"
    exit 0
fi

# Add column only if it doesn't exist to work around the 1.9.4 leak of
# cache_threshold and cache_max_age column alters in subnet and shared network
# tables in schema version 9.5.
if ! mysql "${@}" -e 'SELECT cache_threshold FROM dhcp4_subnet LIMIT 1' &> /dev/null; then
    mysql "${@}" <<EOF
# Add new lease cache parameters.
ALTER TABLE dhcp4_subnet
    ADD COLUMN cache_threshold FLOAT DEFAULT NULL,
    ADD COLUMN cache_max_age INT(10) DEFAULT NULL;

ALTER TABLE dhcp4_shared_network
    ADD COLUMN cache_threshold FLOAT DEFAULT NULL,
    ADD COLUMN cache_max_age INT(10) DEFAULT NULL;

ALTER TABLE dhcp6_subnet
    ADD COLUMN cache_threshold FLOAT DEFAULT NULL,
    ADD COLUMN cache_max_age INT(10) DEFAULT NULL;

ALTER TABLE dhcp6_shared_network
    ADD COLUMN cache_threshold FLOAT DEFAULT NULL,
    ADD COLUMN cache_max_age INT(10) DEFAULT NULL;
EOF
fi

mysql "${@}" <<EOF
# Add an auto-increment ID as primary key to support Percona.
ALTER TABLE logs
    ADD id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY;

# Update the schema version number
UPDATE schema_version
    SET version = '9', minor = '6';

# This line concludes database upgrade to version 9.6.
EOF
