/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.LinkHandler;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.ResizeConstraint;
import net.miginfocom.layout.UnitValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Grid {
    public static final boolean TEST_GAPS = true;
    private static final Float[] GROW_100 = new Float[]{ResizeConstraint.WEIGHT_100};
    private static final DimConstraint DOCK_DIM_CONSTRAINT = new DimConstraint();
    private static final int MAX_GRID = 30000;
    private static final int MAX_DOCK_GRID = Short.MAX_VALUE;
    private static final ResizeConstraint GAP_RC_CONST;
    private static final ResizeConstraint GAP_RC_CONST_PUSH;
    private final LC lc;
    private final ContainerWrapper container;
    private final LinkedHashMap<Integer, Cell> grid = new LinkedHashMap();
    private HashMap<Integer, BoundSize> wrapGapMap = null;
    private final TreeSet<Integer> rowIndexes = new TreeSet();
    private final TreeSet<Integer> colIndexes = new TreeSet();
    private final AC rowConstr;
    private final AC colConstr;
    private FlowSizeSpec colFlowSpecs = null;
    private FlowSizeSpec rowFlowSpecs = null;
    private ArrayList<LinkedDimGroup>[] colGroupLists;
    private ArrayList<LinkedDimGroup>[] rowGroupLists;
    private int[] width = null;
    private int[] height = null;
    private ArrayList<int[]> debugRects = null;
    private HashMap<String, Boolean> linkTargetIDs = null;
    private final int dockOffY;
    private final int dockOffX;
    private final Float[] growXs;
    private final Float[] growYs;
    private final ArrayList<LayoutCallback> callbackList;
    private static WeakHashMap[] PARENT_ROWCOL_SIZES_MAP;
    private static WeakHashMap<Object, LinkedHashMap<Integer, Cell>> PARENT_GRIDPOS_MAP;

    public Grid(ContainerWrapper container, LC lc, AC rowConstr, AC colConstr, Map<ComponentWrapper, CC> ccMap, ArrayList<LayoutCallback> callbackList) {
        int i;
        CompWrap cw;
        int i2;
        String sgx;
        ArrayList<CompWrap> sizeGroupCWs;
        HashMap<String, int[]> sizeGroupMapY;
        CompWrap cw2;
        this.lc = lc;
        this.rowConstr = rowConstr;
        this.colConstr = colConstr;
        this.container = container;
        this.callbackList = callbackList;
        int wrap = lc.getWrapAfter() != 0 ? lc.getWrapAfter() : (lc.isFlowX() ? colConstr : rowConstr).getConstaints().length;
        ComponentWrapper[] comps = container.getComponents();
        boolean hasTagged = false;
        boolean hasPushX = false;
        boolean hasPushY = false;
        boolean hitEndOfRow = false;
        int[] p = new int[2];
        ArrayList<int[]> spannedRects = new ArrayList<int[]>(2);
        Object[] specs = (lc.isFlowX() ? rowConstr : colConstr).getConstaints();
        int sizeGroupsX = 0;
        int sizeGroupsY = 0;
        int[] dockInsets = null;
        LinkHandler.clearTemporaryBounds(container.getLayout());
        int i3 = 0;
        while (i3 < comps.length) {
            boolean spanRestOfRow;
            Cell cell;
            int hideMode;
            ComponentWrapper comp = comps[i3];
            CC rootCc = Grid.getCC(comp, ccMap);
            this.addLinkIDs(rootCc);
            int n = comp.isVisible() ? -1 : (hideMode = rootCc.getHideMode() != -1 ? rootCc.getHideMode() : lc.getHideMode());
            if (hideMode == 3) {
                this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                ++i3;
                continue;
            }
            if (rootCc.getHorizontal().getSizeGroup() != null) {
                ++sizeGroupsX;
            }
            if (rootCc.getVertical().getSizeGroup() != null) {
                ++sizeGroupsY;
            }
            UnitValue[] pos = this.getPos(comp, rootCc);
            BoundSize[] cbSz = this.getCallbackSize(comp);
            if (pos != null || rootCc.isExternal()) {
                cw2 = new CompWrap(comp, rootCc, hideMode, pos, cbSz);
                cell = this.grid.get(null);
                if (cell == null) {
                    this.grid.put(null, new Cell(cw2));
                } else {
                    cell.compWraps.add(cw2);
                }
                if (!rootCc.isBoundsInGrid() || rootCc.isExternal()) {
                    this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                    ++i3;
                    continue;
                }
            }
            if (rootCc.getDockSide() != -1) {
                if (dockInsets == null) {
                    dockInsets = new int[]{-32767, -32767, Short.MAX_VALUE, Short.MAX_VALUE};
                }
                this.addDockingCell(dockInsets, rootCc.getDockSide(), new CompWrap(comp, rootCc, hideMode, pos, cbSz));
                ++i3;
                continue;
            }
            Boolean cellFlowX = rootCc.getFlowX();
            cell = null;
            if (rootCc.isNewline()) {
                this.wrap(p, rootCc.getNewlineGapSize());
            } else if (hitEndOfRow) {
                this.wrap(p, null);
            }
            hitEndOfRow = false;
            boolean rowNoGrid = lc.isNoGrid() || ((DimConstraint)LayoutUtil.getIndexSafe(specs, lc.isFlowX() ? p[1] : p[0])).isNoGrid();
            int cx = rootCc.getCellX();
            int cy = rootCc.getCellY();
            if (!(cx >= 0 && cy >= 0 || rowNoGrid)) {
                while (!this.isCellFree(p[1], p[0], spannedRects)) {
                    if (Math.abs(this.increase(p, 1)) < wrap) continue;
                    this.wrap(p, null);
                }
            } else {
                if (cx >= 0 && cy >= 0) {
                    if (cy >= 0) {
                        p[0] = cx;
                        p[1] = cy;
                    } else if (lc.isFlowX()) {
                        p[0] = cx;
                    } else {
                        p[1] = cx;
                    }
                }
                cell = this.getCell(p[1], p[0]);
            }
            int skipCount = rootCc.getSkip();
            for (int s = 0; s < skipCount; ++s) {
                if (Math.abs(this.increase(p, 1)) < wrap) continue;
                this.wrap(p, null);
            }
            if (cell == null) {
                int spanx = Math.min(rowNoGrid && lc.isFlowX() ? 2097051 : rootCc.getSpanX(), 30000 - p[0]);
                int spany = Math.min(rowNoGrid && !lc.isFlowX() ? 2097051 : rootCc.getSpanY(), 30000 - p[1]);
                cell = new Cell(spanx, spany, cellFlowX != null ? cellFlowX.booleanValue() : lc.isFlowX());
                this.setCell(p[1], p[0], cell);
                if (spanx > 1 || spany > 1) {
                    spannedRects.add(new int[]{p[0], p[1], spanx, spany});
                }
            }
            boolean wrapHandled = false;
            boolean splitExit = false;
            boolean bl = spanRestOfRow = (lc.isFlowX() ? rootCc.getSpanX() : rootCc.getSpanY()) == 2097051;
            for (int splitLeft = rowNoGrid ? 2097051 : rootCc.getSplit() - 1; splitLeft >= 0 && i3 < comps.length; --splitLeft) {
                ComponentWrapper compAdd = comps[i3];
                CC cc = Grid.getCC(compAdd, ccMap);
                this.addLinkIDs(cc);
                int n2 = compAdd.isVisible() ? -1 : (hideMode = cc.getHideMode() != -1 ? cc.getHideMode() : lc.getHideMode());
                if (cc.isExternal() || hideMode == 3) {
                    ++i3;
                    ++splitLeft;
                    continue;
                }
                hasPushX |= cc.getPushX() != null;
                hasPushY |= cc.getPushY() != null;
                if (cc != rootCc) {
                    if (cc.isNewline() || !cc.isBoundsInGrid() || cc.getDockSide() != -1) break;
                    if (splitLeft > 0 && cc.getSkip() > 0) {
                        splitExit = true;
                        break;
                    }
                    pos = this.getPos(compAdd, cc);
                    cbSz = this.getCallbackSize(compAdd);
                }
                CompWrap cw3 = new CompWrap(compAdd, cc, hideMode, pos, cbSz);
                cell.compWraps.add(cw3);
                cell.hasTagged = (byte)(cell.hasTagged | (cc.getTag() != null ? 1 : 0));
                hasTagged |= cell.hasTagged;
                if (cc != rootCc) {
                    if (cc.getHorizontal().getSizeGroup() != null) {
                        ++sizeGroupsX;
                    }
                    if (cc.getVertical().getSizeGroup() != null) {
                        ++sizeGroupsY;
                    }
                }
                ++i3;
                if (!cc.isWrap() && (!spanRestOfRow || splitLeft != 0)) continue;
                if (cc.isWrap()) {
                    this.wrap(p, cc.getWrapGapSize());
                } else {
                    hitEndOfRow = true;
                }
                wrapHandled = true;
                break;
            }
            if (wrapHandled || rowNoGrid) continue;
            int span = lc.isFlowX() ? cell.spanx : cell.spany;
            if (Math.abs(lc.isFlowX() ? p[0] : p[1]) + span >= wrap) {
                hitEndOfRow = true;
                continue;
            }
            this.increase(p, splitExit ? span - 1 : span);
        }
        if (sizeGroupsX > 0 || sizeGroupsY > 0) {
            HashMap<String, int[]> sizeGroupMapX = sizeGroupsX > 0 ? new HashMap<String, int[]>(sizeGroupsX) : null;
            sizeGroupMapY = sizeGroupsY > 0 ? new HashMap<String, int[]>(sizeGroupsY) : null;
            sizeGroupCWs = new ArrayList<CompWrap>(Math.max(sizeGroupsX, sizeGroupsY));
            for (Cell cell : this.grid.values()) {
                for (int i4 = 0; i4 < cell.compWraps.size(); ++i4) {
                    cw2 = (CompWrap)cell.compWraps.get(i4);
                    sgx = cw2.cc.getHorizontal().getSizeGroup();
                    String sgy = cw2.cc.getVertical().getSizeGroup();
                    if (sgx == null && sgy == null) continue;
                    if (sgx != null && sizeGroupMapX != null) {
                        Grid.addToSizeGroup(sizeGroupMapX, sgx, cw2.horSizes);
                    }
                    if (sgy != null && sizeGroupMapY != null) {
                        Grid.addToSizeGroup(sizeGroupMapY, sgy, cw2.verSizes);
                    }
                    sizeGroupCWs.add(cw2);
                }
            }
            for (i2 = 0; i2 < sizeGroupCWs.size(); ++i2) {
                cw = (CompWrap)sizeGroupCWs.get(i2);
                if (sizeGroupMapX != null) {
                    cw.setSizes((int[])sizeGroupMapX.get(cw.cc.getHorizontal().getSizeGroup()), true);
                }
                if (sizeGroupMapY == null) continue;
                cw.setSizes((int[])sizeGroupMapY.get(cw.cc.getVertical().getSizeGroup()), false);
            }
        }
        if (sizeGroupsX > 0 || sizeGroupsY > 0) {
            HashMap<String, int[]> sizeGroupMapX = sizeGroupsX > 0 ? new HashMap<String, int[]>(sizeGroupsX) : null;
            sizeGroupMapY = sizeGroupsY > 0 ? new HashMap<String, int[]>(sizeGroupsY) : null;
            sizeGroupCWs = new ArrayList(Math.max(sizeGroupsX, sizeGroupsY));
            for (Cell cell : this.grid.values()) {
                for (int i5 = 0; i5 < cell.compWraps.size(); ++i5) {
                    cw2 = (CompWrap)cell.compWraps.get(i5);
                    sgx = cw2.cc.getHorizontal().getSizeGroup();
                    String sgy = cw2.cc.getVertical().getSizeGroup();
                    if (sgx == null && sgy == null) continue;
                    if (sgx != null && sizeGroupMapX != null) {
                        Grid.addToSizeGroup(sizeGroupMapX, sgx, cw2.horSizes);
                    }
                    if (sgy != null && sizeGroupMapY != null) {
                        Grid.addToSizeGroup(sizeGroupMapY, sgy, cw2.verSizes);
                    }
                    sizeGroupCWs.add(cw2);
                }
            }
            for (i2 = 0; i2 < sizeGroupCWs.size(); ++i2) {
                cw = (CompWrap)sizeGroupCWs.get(i2);
                if (sizeGroupMapX != null) {
                    cw.setSizes((int[])sizeGroupMapX.get(cw.cc.getHorizontal().getSizeGroup()), true);
                }
                if (sizeGroupMapY == null) continue;
                cw.setSizes((int[])sizeGroupMapY.get(cw.cc.getVertical().getSizeGroup()), false);
            }
        }
        if (hasTagged) {
            Grid.sortCellsByPlatform(this.grid.values(), container);
        }
        boolean ltr = LayoutUtil.isLeftToRight(lc, container);
        for (Cell cell : this.grid.values()) {
            ArrayList cws = cell.compWraps;
            int lastI = cws.size() - 1;
            for (int i6 = 0; i6 <= lastI; ++i6) {
                cw2 = (CompWrap)cws.get(i6);
                ComponentWrapper cwBef = i6 > 0 ? ((CompWrap)cws.get(i6 - 1)).comp : null;
                ComponentWrapper cwAft = i6 < lastI ? ((CompWrap)cws.get(i6 + 1)).comp : null;
                String tag = Grid.getCC(cw2.comp, ccMap).getTag();
                CC ccBef = cwBef != null ? Grid.getCC(cwBef, ccMap) : null;
                CC ccAft = cwAft != null ? Grid.getCC(cwAft, ccMap) : null;
                cw2.calcGaps(cwBef, ccBef, cwAft, ccAft, tag, cell.flowx, ltr);
            }
        }
        this.dockOffX = Grid.getDockInsets(this.colIndexes);
        this.dockOffY = Grid.getDockInsets(this.rowIndexes);
        int iSz = rowConstr.getCount();
        for (i = 0; i < iSz; ++i) {
            this.rowIndexes.add(new Integer(i));
        }
        iSz = colConstr.getCount();
        for (i = 0; i < iSz; ++i) {
            this.colIndexes.add(new Integer(i));
        }
        this.colGroupLists = this.divideIntoLinkedGroups(false);
        this.rowGroupLists = this.divideIntoLinkedGroups(true);
        this.growXs = this.getDefaultGrowWeights(hasPushX, false);
        this.growYs = this.getDefaultGrowWeights(hasPushY, true);
        if (LayoutUtil.isDesignTime(container)) {
            Grid.saveGrid(container, this.grid);
        }
    }

    private static CC getCC(ComponentWrapper comp, Map<ComponentWrapper, CC> ccMap) {
        CC cc = ccMap.get(comp);
        return cc != null ? cc : new CC();
    }

    private void addLinkIDs(CC cc) {
        String[] linkIDs = cc.getLinkTargets();
        for (int lx = 0; lx < linkIDs.length; ++lx) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap();
            }
            this.linkTargetIDs.put(linkIDs[lx], null);
        }
    }

    public void invalidateContainerSize() {
        this.colFlowSpecs = null;
    }

    public boolean layout(int[] bounds, UnitValue alignX, UnitValue alignY, boolean debug, boolean checkPrefChange) {
        if (debug) {
            this.debugRects = new ArrayList();
        }
        this.checkSizeCalcs();
        this.resetLinkValues(true, true);
        this.layoutInOneDim(bounds[2], alignX, false, this.growXs);
        this.layoutInOneDim(bounds[3], alignY, true, this.growYs);
        HashMap<String, Integer> endGrpXMap = null;
        HashMap<String, Integer> endGrpYMap = null;
        int compCount = this.container.getComponentCount();
        boolean layoutAgain = false;
        if (compCount > 0) {
            block0: for (int j = 0; j < (this.linkTargetIDs != null ? 2 : 1); ++j) {
                boolean doAgain;
                int count = 0;
                do {
                    doAgain = false;
                    Iterator<Cell> it = this.grid.values().iterator();
                    while (it.hasNext()) {
                        ArrayList compWraps = it.next().compWraps;
                        int iSz = compWraps.size();
                        for (int i = 0; i < iSz; ++i) {
                            CompWrap cw = (CompWrap)compWraps.get(i);
                            if (j == 0 && !(doAgain |= this.doAbsoluteCorrections(cw, bounds))) {
                                if (cw.cc.getHorizontal().getEndGroup() != null) {
                                    endGrpXMap = Grid.addToEndGroup(endGrpXMap, cw.cc.getHorizontal().getEndGroup(), cw.x + cw.w);
                                }
                                if (cw.cc.getVertical().getEndGroup() != null) {
                                    endGrpYMap = Grid.addToEndGroup(endGrpYMap, cw.cc.getVertical().getEndGroup(), cw.y + cw.h);
                                }
                            }
                            if (this.linkTargetIDs != null && j != 1) continue;
                            if (cw.cc.getHorizontal().getEndGroup() != null) {
                                cw.w = (Integer)endGrpXMap.get(cw.cc.getHorizontal().getEndGroup()) - cw.x;
                            }
                            if (cw.cc.getVertical().getEndGroup() != null) {
                                cw.h = (Integer)endGrpYMap.get(cw.cc.getVertical().getEndGroup()) - cw.y;
                            }
                            cw.x += bounds[0];
                            cw.y += bounds[1];
                            layoutAgain |= cw.transferBounds(checkPrefChange && !layoutAgain);
                            if (this.callbackList == null) continue;
                            for (int cb = 0; cb < this.callbackList.size(); ++cb) {
                                this.callbackList.get(cb).correctBounds(cw.comp);
                            }
                        }
                    }
                    this.clearGroupLinkBounds();
                    if (++count <= (compCount << 3) + 10) continue;
                    System.err.println("Unstable Cyclic Dependency in Absolute-Linked Values!");
                    continue block0;
                } while (doAgain);
            }
        }
        if (debug) {
            Collection<Cell> cwColl = this.grid.values();
            Iterator<Cell> it = cwColl.iterator();
            while (it.hasNext()) {
                ArrayList compWraps = it.next().compWraps;
                int iSz = compWraps.size();
                for (int i = 0; i < iSz; ++i) {
                    CompWrap cw = (CompWrap)compWraps.get(i);
                    LinkedDimGroup hGrp = Grid.getGroupContaining(this.colGroupLists, cw);
                    LinkedDimGroup vGrp = Grid.getGroupContaining(this.rowGroupLists, cw);
                    if (hGrp == null || vGrp == null) continue;
                    this.debugRects.add(new int[]{hGrp.lStart + bounds[0] - (hGrp.fromEnd ? hGrp.lSize : 0), vGrp.lStart + bounds[1] - (vGrp.fromEnd ? vGrp.lSize : 0), hGrp.lSize, vGrp.lSize});
                }
            }
        }
        return layoutAgain;
    }

    public void paintDebug() {
        if (this.debugRects != null) {
            this.container.paintDebugOutline();
            ArrayList<int[]> painted = new ArrayList<int[]>();
            int iSz = this.debugRects.size();
            for (int i = 0; i < iSz; ++i) {
                int[] r = this.debugRects.get(i);
                if (painted.contains(r)) continue;
                this.container.paintDebugCell(r[0], r[1], r[2], r[3]);
                painted.add(r);
            }
            Iterator<Cell> it = this.grid.values().iterator();
            while (it.hasNext()) {
                ArrayList compWraps = it.next().compWraps;
                int iSz2 = compWraps.size();
                for (int i = 0; i < iSz2; ++i) {
                    ((CompWrap)compWraps.get(i)).comp.paintDebugOutline();
                }
            }
        }
    }

    public final int[] getWidth() {
        this.checkSizeCalcs();
        return this.width;
    }

    public final int[] getHeight() {
        this.checkSizeCalcs();
        return this.height;
    }

    private void checkSizeCalcs() {
        if (this.colFlowSpecs == null) {
            this.colFlowSpecs = this.calcRowsOrColsSizes(true);
            this.rowFlowSpecs = this.calcRowsOrColsSizes(false);
            this.width = this.getMinPrefMaxSumSize(true);
            this.height = this.getMinPrefMaxSumSize(false);
            if (this.linkTargetIDs == null) {
                this.resetLinkValues(false, true);
            } else {
                this.layout(new int[4], null, null, false, false);
                this.resetLinkValues(false, false);
            }
            this.adjustSizeForAbsolute(true);
            this.adjustSizeForAbsolute(false);
        }
    }

    private final UnitValue[] getPos(ComponentWrapper cw, CC cc) {
        UnitValue[] cbPos = null;
        if (this.callbackList != null) {
            for (int i = 0; i < this.callbackList.size() && cbPos == null; ++i) {
                cbPos = this.callbackList.get(i).getPosition(cw);
            }
        }
        UnitValue[] ccPos = cc.getPos();
        if (cbPos == null || ccPos == null) {
            return cbPos != null ? cbPos : ccPos;
        }
        for (int i = 0; i < 4; ++i) {
            UnitValue cbUv = cbPos[i];
            if (cbUv == null) continue;
            ccPos[i] = cbUv;
        }
        return ccPos;
    }

    private final BoundSize[] getCallbackSize(ComponentWrapper cw) {
        if (this.callbackList != null) {
            for (int i = 0; i < this.callbackList.size(); ++i) {
                BoundSize[] bs = this.callbackList.get(i).getSize(cw);
                if (bs == null) continue;
                return bs;
            }
        }
        return null;
    }

    private static final int getDockInsets(TreeSet<Integer> set) {
        int c = 0;
        Iterator<Integer> it = set.iterator();
        while (it.hasNext() && it.next() < -30000) {
            ++c;
        }
        return c;
    }

    private boolean setLinkedBounds(ComponentWrapper cw, CC cc, int x, int y, int w, int h, boolean external) {
        String id;
        String string = id = cc.getId() != null ? cc.getId() : cw.getLinkId();
        if (id == null) {
            return false;
        }
        String gid = null;
        int grIx = id.indexOf(46);
        if (grIx != -1) {
            gid = id.substring(0, grIx);
            id = id.substring(grIx + 1);
        }
        Object lay = this.container.getLayout();
        boolean changed = false;
        if (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(id)) {
            changed = LinkHandler.setBounds(lay, id, x, y, w, h, !external, false);
        }
        if (gid != null && (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(gid))) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap(4);
            }
            this.linkTargetIDs.put(gid, Boolean.TRUE);
            changed |= LinkHandler.setBounds(lay, gid, x, y, w, h, !external, true);
        }
        return changed;
    }

    private final int increase(int[] p, int cnt) {
        return this.lc.isFlowX() ? p[0] + cnt : p[1] + cnt;
    }

    private final void wrap(int[] cellXY, BoundSize gapSize) {
        boolean flowx = this.lc.isFlowX();
        cellXY[0] = flowx ? 0 : cellXY[0] + 1;
        int n = cellXY[1] = flowx ? cellXY[1] + 1 : 0;
        if (gapSize != null) {
            if (this.wrapGapMap == null) {
                this.wrapGapMap = new HashMap(8);
            }
            this.wrapGapMap.put(new Integer(cellXY[flowx ? 1 : 0]), gapSize);
        }
        if (flowx) {
            this.rowIndexes.add(new Integer(cellXY[1]));
        } else {
            this.colIndexes.add(new Integer(cellXY[0]));
        }
    }

    private static void sortCellsByPlatform(Collection<Cell> cells, ContainerWrapper parent) {
        String order = PlatformDefaults.getButtonOrder();
        String orderLo = order.toLowerCase();
        int unrelSize = PlatformDefaults.convertToPixels(1.0f, "u", true, 0.0f, parent, null);
        if (unrelSize == -87654312) {
            throw new IllegalArgumentException("'unrelated' not recognized by PlatformDefaults!");
        }
        int[] gapUnrel = new int[]{unrelSize, unrelSize, -2147471302};
        int[] flGap = new int[]{0, 0, -2147471302};
        for (Cell cell : cells) {
            if (!cell.hasTagged) continue;
            CompWrap prevCW = null;
            boolean nextUnrel = false;
            boolean nextPush = false;
            ArrayList<CompWrap> sortedList = new ArrayList<CompWrap>(cell.compWraps.size());
            int iSz = orderLo.length();
            for (int i = 0; i < iSz; ++i) {
                char c = orderLo.charAt(i);
                if (c == '+' || c == '_') {
                    nextUnrel = true;
                    if (c != '+') continue;
                    nextPush = true;
                    continue;
                }
                String tag = PlatformDefaults.getTagForChar(c);
                if (tag == null) continue;
                int jSz = cell.compWraps.size();
                for (int j = 0; j < jSz; ++j) {
                    CompWrap cw = (CompWrap)cell.compWraps.get(j);
                    if (!tag.equals(cw.cc.getTag())) continue;
                    if (Character.isUpperCase(order.charAt(i))) {
                        int min = PlatformDefaults.getMinimumButtonWidth().getPixels(0.0f, parent, cw.comp);
                        if (min > cw.horSizes[0]) {
                            ((CompWrap)cw).horSizes[0] = min;
                        }
                        Grid.correctMinMax(cw.horSizes);
                    }
                    sortedList.add(cw);
                    if (nextUnrel) {
                        (prevCW != null ? prevCW : cw).mergeGapSizes(gapUnrel, cell.flowx, prevCW == null);
                        if (nextPush) {
                            cw.forcedPushGaps = 1;
                            nextUnrel = false;
                            nextPush = false;
                        }
                    }
                    if (c == 'u') {
                        nextUnrel = true;
                    }
                    prevCW = cw;
                }
            }
            if (sortedList.size() > 0) {
                CompWrap cw = (CompWrap)sortedList.get(sortedList.size() - 1);
                if (nextUnrel) {
                    cw.mergeGapSizes(gapUnrel, cell.flowx, false);
                    if (nextPush) {
                        cw.forcedPushGaps |= 2;
                    }
                }
                if (cw.cc.getHorizontal().getGapAfter() == null) {
                    cw.setGaps(flGap, 3);
                }
                if ((cw = (CompWrap)sortedList.get(0)).cc.getHorizontal().getGapBefore() == null) {
                    cw.setGaps(flGap, 1);
                }
            }
            if (cell.compWraps.size() == sortedList.size()) {
                cell.compWraps.clear();
            } else {
                cell.compWraps.removeAll(sortedList);
            }
            cell.compWraps.addAll(sortedList);
        }
    }

    private Float[] getDefaultGrowWeights(boolean hasPush, boolean isRows) {
        if (!hasPush && !(isRows ? this.lc.isFillY() : this.lc.isFillX())) {
            return null;
        }
        ArrayList<LinkedDimGroup>[] groupLists = isRows ? this.rowGroupLists : this.colGroupLists;
        Float[] gwArr = GROW_100;
        int i = 0;
        int ix = 1;
        while (i < groupLists.length) {
            ArrayList<LinkedDimGroup> grps = groupLists[i];
            Float rowGw = null;
            for (int j = 0; j < grps.size(); ++j) {
                LinkedDimGroup grp = grps.get(j);
                for (int c = 0; c < grp._compWraps.size(); ++c) {
                    Float gw;
                    CompWrap cw = (CompWrap)grp._compWraps.get(c);
                    Float f = hasPush ? (isRows ? cw.cc.getPushY() : cw.cc.getPushX()) : (gw = (isRows ? cw.cc.getVertical() : cw.cc.getHorizontal()).getGrow());
                    if (rowGw != null && (gw == null || !(gw.floatValue() > rowGw.floatValue()))) continue;
                    rowGw = gw;
                }
            }
            if (rowGw != null) {
                if (gwArr == GROW_100) {
                    gwArr = new Float[(groupLists.length << 1) + 1];
                }
                gwArr[ix] = rowGw;
            }
            ++i;
            ix += 2;
        }
        return gwArr;
    }

    private void clearGroupLinkBounds() {
        if (this.linkTargetIDs == null) {
            return;
        }
        for (Map.Entry<String, Boolean> o : this.linkTargetIDs.entrySet()) {
            if (o.getValue() != Boolean.TRUE) continue;
            LinkHandler.clearBounds(this.container.getLayout(), o.getKey());
        }
    }

    private void resetLinkValues(boolean parentSize, boolean compLinks) {
        Object lay = this.container.getLayout();
        if (compLinks) {
            LinkHandler.clearTemporaryBounds(lay);
        }
        boolean defIns = !this.hasDocks();
        int parW = parentSize ? this.lc.getWidth().constrain(this.container.getWidth(), Grid.getParentSize(this.container, true), this.container) : 0;
        int parH = parentSize ? this.lc.getHeight().constrain(this.container.getHeight(), Grid.getParentSize(this.container, false), this.container) : 0;
        int insX = LayoutUtil.getInsets(this.lc, 0, defIns).getPixels(0.0f, this.container, null);
        int insY = LayoutUtil.getInsets(this.lc, 1, defIns).getPixels(0.0f, this.container, null);
        int visW = parW - insX - LayoutUtil.getInsets(this.lc, 2, defIns).getPixels(0.0f, this.container, null);
        int visH = parH - insY - LayoutUtil.getInsets(this.lc, 3, defIns).getPixels(0.0f, this.container, null);
        LinkHandler.setBounds(lay, "visual", insX, insY, visW, visH, true, false);
        LinkHandler.setBounds(lay, "container", 0, 0, parW, parH, true, false);
    }

    private static LinkedDimGroup getGroupContaining(ArrayList<LinkedDimGroup>[] groupLists, CompWrap cw) {
        for (int i = 0; i < groupLists.length; ++i) {
            ArrayList<LinkedDimGroup> groups = groupLists[i];
            int jSz = groups.size();
            for (int j = 0; j < jSz; ++j) {
                ArrayList cwList = groups.get(j)._compWraps;
                int kSz = cwList.size();
                for (int k = 0; k < kSz; ++k) {
                    if (cwList.get(k) != cw) continue;
                    return groups.get(j);
                }
            }
        }
        return null;
    }

    private boolean doAbsoluteCorrections(CompWrap cw, int[] bounds) {
        boolean changed = false;
        int[] stSz = this.getAbsoluteDimBounds(cw, bounds[2], true);
        if (stSz != null) {
            cw.setDimBounds(stSz[0], stSz[1], true);
        }
        if ((stSz = this.getAbsoluteDimBounds(cw, bounds[3], false)) != null) {
            cw.setDimBounds(stSz[0], stSz[1], false);
        }
        if (this.linkTargetIDs != null) {
            changed = this.setLinkedBounds(cw.comp, cw.cc, cw.x, cw.y, cw.w, cw.h, false);
        }
        return changed;
    }

    private void adjustSizeForAbsolute(boolean isHor) {
        int[] curSizes = isHor ? this.width : this.height;
        Cell absCell = this.grid.get(null);
        if (absCell == null || absCell.compWraps.size() == 0) {
            return;
        }
        ArrayList cws = absCell.compWraps;
        int maxEnd = 0;
        int cwSz = absCell.compWraps.size();
        for (int j = 0; j < cwSz + 3; ++j) {
            boolean doAgain = false;
            for (int i = 0; i < cwSz; ++i) {
                CompWrap cw = (CompWrap)cws.get(i);
                int[] stSz = this.getAbsoluteDimBounds(cw, 0, isHor);
                int end = stSz[0] + stSz[1];
                if (maxEnd < end) {
                    maxEnd = end;
                }
                if (this.linkTargetIDs == null) continue;
                doAgain |= this.setLinkedBounds(cw.comp, cw.cc, stSz[0], stSz[0], stSz[1], stSz[1], false);
            }
            if (!doAgain) break;
            maxEnd = 0;
            this.clearGroupLinkBounds();
        }
        if (curSizes[0] < (maxEnd += LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, !this.hasDocks()).getPixels(0.0f, this.container, null))) {
            curSizes[0] = maxEnd;
        }
        if (curSizes[1] < maxEnd) {
            curSizes[1] = maxEnd;
        }
    }

    private int[] getAbsoluteDimBounds(CompWrap cw, int refSize, boolean isHor) {
        int sz;
        if (cw.cc.isExternal()) {
            if (isHor) {
                return new int[]{cw.comp.getX(), cw.comp.getWidth()};
            }
            return new int[]{cw.comp.getY(), cw.comp.getHeight()};
        }
        int[] plafPad = this.lc.isVisualPadding() ? cw.comp.getVisualPadding() : null;
        UnitValue[] pad = cw.cc.getPadding();
        if (cw.pos == null && plafPad == null && pad == null) {
            return null;
        }
        int st = isHor ? cw.x : cw.y;
        int n = sz = isHor ? cw.w : cw.h;
        if (cw.pos != null) {
            UnitValue stUV;
            UnitValue unitValue = cw.pos != null ? cw.pos[isHor ? 0 : 1] : (stUV = null);
            UnitValue endUV = cw.pos != null ? cw.pos[isHor ? 2 : 3] : null;
            int minSz = cw.getSize(0, isHor);
            int maxSz = cw.getSize(2, isHor);
            sz = Math.min(Math.max(cw.getSize(1, isHor), minSz), maxSz);
            if (stUV != null) {
                st = stUV.getPixels(stUV.getUnit() == 12 ? (float)sz : (float)refSize, this.container, cw.comp);
                if (endUV != null) {
                    sz = Math.min(Math.max((isHor ? cw.x + cw.w : cw.y + cw.h) - st, minSz), maxSz);
                }
            }
            if (endUV != null) {
                if (stUV != null) {
                    sz = Math.min(Math.max(endUV.getPixels(refSize, this.container, cw.comp) - st, minSz), maxSz);
                } else {
                    st = endUV.getPixels(refSize, this.container, cw.comp) - sz;
                }
            }
        }
        if (pad != null) {
            UnitValue uv = pad[isHor ? 1 : 0];
            int p = uv != null ? uv.getPixels(refSize, this.container, cw.comp) : 0;
            st += p;
            uv = pad[isHor ? 3 : 2];
            sz += -p + (uv != null ? uv.getPixels(refSize, this.container, cw.comp) : 0);
        }
        if (plafPad != null) {
            int p = plafPad[isHor ? 1 : 0];
            st += p;
            sz += -p + plafPad[isHor ? 3 : 2];
        }
        return new int[]{st, sz};
    }

    private void layoutInOneDim(int refSize, UnitValue align, boolean isRows, Float[] defaultGrowW) {
        int curPos;
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        FlowSizeSpec fss = isRows ? this.rowFlowSpecs : this.colFlowSpecs;
        ArrayList<LinkedDimGroup>[] rowCols = isRows ? this.rowGroupLists : this.colGroupLists;
        int[] rowColSizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, defaultGrowW, 1, refSize);
        if (LayoutUtil.isDesignTime(this.container)) {
            TreeSet<Integer> indexes = isRows ? this.rowIndexes : this.colIndexes;
            int[] ixArr = new int[indexes.size()];
            int ix = 0;
            for (Integer i : indexes) {
                ixArr[ix++] = i;
            }
            Grid.putSizesAndIndexes(this.container.getComponent(), rowColSizes, ixArr, isRows);
        }
        int n = curPos = align != null ? Math.round(align.getPixels(refSize - LayoutUtil.sum(rowColSizes), this.container, null)) : 0;
        if (fromEnd) {
            curPos = refSize - curPos;
        }
        for (int i = 0; i < rowCols.length; ++i) {
            ArrayList<LinkedDimGroup> linkedGroups = rowCols[i];
            int scIx = i - (isRows ? this.dockOffY : this.dockOffX);
            int bIx = i << 1;
            int bIx2 = bIx + 1;
            curPos += fromEnd ? -rowColSizes[bIx] : rowColSizes[bIx];
            DimConstraint primDC = scIx >= 0 ? primDCs[scIx >= primDCs.length ? primDCs.length - 1 : scIx] : DOCK_DIM_CONSTRAINT;
            int rowSize = rowColSizes[bIx2];
            for (int j = 0; j < linkedGroups.size(); ++j) {
                LinkedDimGroup group = linkedGroups.get(j);
                int groupSize = rowSize;
                if (group.span > 1) {
                    groupSize = LayoutUtil.sum(rowColSizes, bIx2, Math.min((group.span << 1) - 1, rowColSizes.length - bIx2 - 1));
                }
                group.layout(primDC, curPos, groupSize, group.span);
            }
            curPos += fromEnd ? -rowSize : rowSize;
        }
    }

    private static void addToSizeGroup(HashMap<String, int[]> sizeGroups, String sizeGroup, int[] size) {
        int[] sgSize = sizeGroups.get(sizeGroup);
        if (sgSize == null) {
            sizeGroups.put(sizeGroup, new int[]{size[0], size[1], size[2]});
        } else {
            sgSize[0] = Math.max(size[0], sgSize[0]);
            sgSize[1] = Math.max(size[1], sgSize[1]);
            sgSize[2] = Math.min(size[2], sgSize[2]);
        }
    }

    private static HashMap<String, Integer> addToEndGroup(HashMap<String, Integer> endGroups, String endGroup, int end) {
        if (endGroup != null) {
            Integer oldEnd;
            if (endGroups == null) {
                endGroups = new HashMap(2);
            }
            if ((oldEnd = endGroups.get(endGroup)) == null || end > oldEnd) {
                endGroups.put(endGroup, new Integer(end));
            }
        }
        return endGroups;
    }

    private FlowSizeSpec calcRowsOrColsSizes(boolean isHor) {
        int r;
        BoundSize cSz;
        ArrayList<LinkedDimGroup>[] groupsLists = isHor ? this.colGroupLists : this.rowGroupLists;
        Float[] defGrow = isHor ? this.growXs : this.growYs;
        int refSize = isHor ? this.container.getWidth() : this.container.getHeight();
        BoundSize boundSize = cSz = isHor ? this.lc.getWidth() : this.lc.getHeight();
        if (!cSz.isUnset()) {
            refSize = cSz.constrain(refSize, Grid.getParentSize(this.container, isHor), this.container);
        }
        DimConstraint[] primDCs = (isHor ? this.colConstr : this.rowConstr).getConstaints();
        TreeSet<Integer> primIdexes = isHor ? this.colIndexes : this.rowIndexes;
        int[][] rowColBoundSizes = new int[primIdexes.size()][];
        HashMap<String, int[]> sizeGroupMap = new HashMap<String, int[]>(2);
        DimConstraint[] allDCs = new DimConstraint[primIdexes.size()];
        Iterator<Integer> primIt = primIdexes.iterator();
        for (r = 0; r < rowColBoundSizes.length; ++r) {
            int cellIx = primIt.next();
            int[] rowColSizes = new int[3];
            allDCs[r] = cellIx >= -30000 && cellIx <= 30000 ? primDCs[cellIx >= primDCs.length ? primDCs.length - 1 : cellIx] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groups = groupsLists[r];
            int[] groupSizes = new int[]{Grid.getTotalGroupsSizeParallel(groups, 0, false), Grid.getTotalGroupsSizeParallel(groups, 1, false), 2097051};
            Grid.correctMinMax(groupSizes);
            BoundSize dimSize = allDCs[r].getSize();
            for (int sType = 0; sType <= 2; ++sType) {
                int rowColSize = groupSizes[sType];
                UnitValue uv = dimSize.getSize(sType);
                if (uv != null) {
                    int unit = uv.getUnit();
                    rowColSize = unit == 14 ? groupSizes[1] : (unit == 13 ? groupSizes[0] : (unit == 15 ? groupSizes[2] : uv.getPixels(refSize, this.container, null)));
                } else if (cellIx >= -30000 && cellIx <= 30000 && rowColSize == 0) {
                    rowColSize = LayoutUtil.isDesignTime(this.container) ? LayoutUtil.getDesignTimeEmptySize() : 0;
                }
                rowColSizes[sType] = rowColSize;
            }
            Grid.correctMinMax(rowColSizes);
            Grid.addToSizeGroup(sizeGroupMap, allDCs[r].getSizeGroup(), rowColSizes);
            rowColBoundSizes[r] = rowColSizes;
        }
        if (sizeGroupMap.size() > 0) {
            for (r = 0; r < rowColBoundSizes.length; ++r) {
                if (allDCs[r].getSizeGroup() == null) continue;
                rowColBoundSizes[r] = (int[])sizeGroupMap.get(allDCs[r].getSizeGroup());
            }
        }
        ResizeConstraint[] resConstrs = Grid.getRowResizeConstraints(allDCs);
        boolean[] fillInPushGaps = new boolean[allDCs.length + 1];
        int[][] gapSizes = this.getRowGaps(allDCs, refSize, isHor, fillInPushGaps);
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(resConstrs, fillInPushGaps, rowColBoundSizes, gapSizes);
        this.adjustMinPrefForSpanningComps(allDCs, defGrow, fss, groupsLists);
        return fss;
    }

    private static int getParentSize(ComponentWrapper cw, boolean isHor) {
        ContainerWrapper p = cw.getParent();
        return p != null ? (isHor ? cw.getWidth() : cw.getHeight()) : 0;
    }

    private int[] getMinPrefMaxSumSize(boolean isHor) {
        int[][] sizes = isHor ? this.colFlowSpecs.sizes : this.rowFlowSpecs.sizes;
        int[] retSizes = new int[3];
        BoundSize sz = isHor ? this.lc.getWidth() : this.lc.getHeight();
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] == null) continue;
            int[] size = sizes[i];
            for (int sType = 0; sType <= 2; ++sType) {
                if (sz.getSize(sType) != null) {
                    if (i != 0) continue;
                    retSizes[sType] = sz.getSize(sType).getPixels(Grid.getParentSize(this.container, isHor), this.container, null);
                    continue;
                }
                int s = size[sType];
                if (s != -2147471302) {
                    if (sType == 1) {
                        int bnd = size[2];
                        if (bnd != -2147471302 && bnd < s) {
                            s = bnd;
                        }
                        if ((bnd = size[0]) > s) {
                            s = bnd;
                        }
                    }
                    int n = sType;
                    retSizes[n] = retSizes[n] + s;
                }
                if (size[2] != -2147471302) continue;
                retSizes[2] = 2097051;
            }
        }
        Grid.correctMinMax(retSizes);
        return retSizes;
    }

    private static ResizeConstraint[] getRowResizeConstraints(DimConstraint[] specs) {
        ResizeConstraint[] resConsts = new ResizeConstraint[specs.length];
        for (int i = 0; i < resConsts.length; ++i) {
            resConsts[i] = specs[i].resize;
        }
        return resConsts;
    }

    private static ResizeConstraint[] getComponentResizeConstraints(ArrayList<CompWrap> compWraps, boolean isHor) {
        ResizeConstraint[] resConsts = new ResizeConstraint[compWraps.size()];
        for (int i = 0; i < resConsts.length; ++i) {
            CC fc = compWraps.get(i).cc;
            resConsts[i] = fc.getDimConstraint((boolean)isHor).resize;
            int dock = fc.getDockSide();
            if (!(isHor ? dock == 0 || dock == 2 : dock == 1 || dock == 3)) continue;
            ResizeConstraint dc = resConsts[i];
            resConsts[i] = new ResizeConstraint(dc.shrinkPrio, dc.shrink, dc.growPrio, ResizeConstraint.WEIGHT_100);
        }
        return resConsts;
    }

    private static boolean[] getComponentGapPush(ArrayList<CompWrap> compWraps, boolean isHor) {
        boolean[] barr = new boolean[compWraps.size() + 1];
        for (int i = 0; i < barr.length; ++i) {
            boolean push;
            boolean bl = push = i > 0 ? compWraps.get(i - 1).isPushGap(isHor, false) : false;
            if (!push && i < barr.length - 1) {
                push = compWraps.get(i).isPushGap(isHor, true);
            }
            barr[i] = push;
        }
        return barr;
    }

    private int[][] getRowGaps(DimConstraint[] specs, int refSize, boolean isHor, boolean[] fillInPushGaps) {
        BoundSize defGap;
        BoundSize boundSize = defGap = isHor ? this.lc.getGridGapX() : this.lc.getGridGapY();
        if (defGap == null) {
            defGap = isHor ? PlatformDefaults.getGridGapX() : PlatformDefaults.getGridGapY();
        }
        int[] defGapArr = defGap.getPixelSizes(refSize, this.container, null);
        boolean defIns = !this.hasDocks();
        UnitValue firstGap = LayoutUtil.getInsets(this.lc, isHor ? 1 : 0, defIns);
        UnitValue lastGap = LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, defIns);
        int[][] retValues = new int[specs.length + 1][];
        int wgIx = 0;
        for (int i = 0; i < retValues.length; ++i) {
            BoundSize wrapGapSize;
            boolean edgeAfter;
            DimConstraint specBefore = i > 0 ? specs[i - 1] : null;
            DimConstraint specAfter = i < specs.length ? specs[i] : null;
            boolean edgeBefore = specBefore == DOCK_DIM_CONSTRAINT || specBefore == null;
            boolean bl = edgeAfter = specAfter == DOCK_DIM_CONSTRAINT || specAfter == null;
            if (edgeBefore && edgeAfter) continue;
            BoundSize boundSize2 = wrapGapSize = this.wrapGapMap == null || isHor == this.lc.isFlowX() ? null : this.wrapGapMap.get(new Integer(wgIx++));
            if (wrapGapSize == null) {
                int[] gapAfter;
                int[] gapBefore = specBefore != null ? specBefore.getRowGaps(this.container, null, refSize, false) : null;
                int[] nArray = gapAfter = specAfter != null ? specAfter.getRowGaps(this.container, null, refSize, true) : null;
                if (edgeBefore && gapAfter == null && firstGap != null) {
                    int bef = firstGap.getPixels(refSize, this.container, null);
                    retValues[i] = new int[]{bef, bef, bef};
                } else if (edgeAfter && gapBefore == null && firstGap != null) {
                    int aft = lastGap.getPixels(refSize, this.container, null);
                    retValues[i] = new int[]{aft, aft, aft};
                } else {
                    int[] nArray2;
                    if (gapAfter != gapBefore) {
                        nArray2 = Grid.mergeSizes(gapAfter, gapBefore);
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = defGapArr[0];
                        nArray3[1] = defGapArr[1];
                        nArray2 = nArray3;
                        nArray3[2] = defGapArr[2];
                    }
                    retValues[i] = nArray2;
                }
                if ((specBefore == null || !specBefore.isGapAfterPush()) && (specAfter == null || !specAfter.isGapBeforePush())) continue;
                fillInPushGaps[i] = true;
                continue;
            }
            retValues[i] = wrapGapSize.isUnset() ? new int[]{defGapArr[0], defGapArr[1], defGapArr[2]} : wrapGapSize.getPixelSizes(refSize, this.container, null);
            fillInPushGaps[i] = wrapGapSize.getGapPush();
        }
        return retValues;
    }

    private static int[][] getGaps(ArrayList<CompWrap> compWraps, boolean isHor) {
        int compCount = compWraps.size();
        int[][] retValues = new int[compCount + 1][];
        retValues[0] = compWraps.get(0).getGaps(isHor, true);
        for (int i = 0; i < compCount; ++i) {
            int[] gap1 = compWraps.get(i).getGaps(isHor, false);
            int[] gap2 = i < compCount - 1 ? compWraps.get(i + 1).getGaps(isHor, true) : null;
            retValues[i + 1] = Grid.mergeSizes(gap1, gap2);
        }
        return retValues;
    }

    private boolean hasDocks() {
        return this.dockOffX > 0 || this.dockOffY > 0 || this.rowIndexes.last() > 30000 || this.colIndexes.last() > 30000;
    }

    private void adjustMinPrefForSpanningComps(DimConstraint[] specs, Float[] defGrow, FlowSizeSpec fss, ArrayList<LinkedDimGroup>[] groupsLists) {
        for (int r = 0; r < groupsLists.length; ++r) {
            ArrayList<LinkedDimGroup> groups = groupsLists[r];
            for (int i = 0; i < groups.size(); ++i) {
                LinkedDimGroup group = groups.get(i);
                if (group.span == 1) continue;
                int[] sizes = group.getMinPrefMax();
                for (int s = 0; s <= 1; ++s) {
                    int cSize = sizes[s];
                    if (cSize == -2147471302) continue;
                    int rowSize = 0;
                    int sIx = (r << 1) + 1;
                    int len = Math.min(group.span << 1, fss.sizes.length - sIx) - 1;
                    for (int j = sIx; j < sIx + len; ++j) {
                        int sz = fss.sizes[j][s];
                        if (sz == -2147471302) continue;
                        rowSize += sz;
                    }
                    if (rowSize >= cSize) continue;
                    int newRowSize = 0;
                    for (int eag = 0; eag < 4 && newRowSize < cSize; ++eag) {
                        newRowSize = fss.expandSizes(specs, defGrow, cSize, sIx, len, s, eag);
                    }
                }
            }
        }
    }

    private ArrayList<LinkedDimGroup>[] divideIntoLinkedGroups(boolean isRows) {
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        TreeSet<Integer> primIndexes = isRows ? this.rowIndexes : this.colIndexes;
        TreeSet<Integer> secIndexes = isRows ? this.colIndexes : this.rowIndexes;
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        ArrayList[] groupLists = new ArrayList[primIndexes.size()];
        int gIx = 0;
        for (int i : primIndexes) {
            DimConstraint dc = i >= -30000 && i <= 30000 ? primDCs[i >= primDCs.length ? primDCs.length - 1 : i] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groupList = new ArrayList<LinkedDimGroup>(2);
            groupLists[gIx++] = groupList;
            for (int j : secIndexes) {
                boolean isPar;
                int span;
                Cell cell = isRows ? this.getCell(i, j) : this.getCell(j, i);
                if (cell == null || cell.compWraps.size() == 0) continue;
                int n = span = isRows ? cell.spany : cell.spanx;
                if (span > 1) {
                    span = Grid.convertSpanToSparseGrid(i, span, primIndexes);
                }
                boolean bl = isPar = cell.flowx == isRows;
                if (!isPar && cell.compWraps.size() > 1 || span > 1) {
                    int linkType = isPar ? 1 : 0;
                    LinkedDimGroup lg = new LinkedDimGroup("p," + j, span, linkType, !isRows, fromEnd);
                    lg.setCompWraps(cell.compWraps);
                    groupList.add(lg);
                    continue;
                }
                for (int cwIx = 0; cwIx < cell.compWraps.size(); ++cwIx) {
                    CompWrap cw = (CompWrap)cell.compWraps.get(cwIx);
                    boolean rowBaselineAlign = isRows && this.lc.isTopToBottom() && dc.getAlignOrDefault(!isRows) == UnitValue.BASELINE_IDENTITY;
                    boolean isBaseline = isRows && cw.isBaselineAlign(rowBaselineAlign);
                    String linkCtx = isBaseline ? "baseline" : null;
                    boolean foundList = false;
                    int lastGl = groupList.size() - 1;
                    for (int glIx = 0; glIx <= lastGl; ++glIx) {
                        LinkedDimGroup group = (LinkedDimGroup)groupList.get(glIx);
                        if (group.linkCtx != linkCtx && (linkCtx == null || !linkCtx.equals(group.linkCtx))) continue;
                        group.addCompWrap(cw);
                        foundList = true;
                        break;
                    }
                    if (foundList) continue;
                    int linkType = isBaseline ? 2 : 1;
                    LinkedDimGroup lg = new LinkedDimGroup(linkCtx, 1, linkType, !isRows, fromEnd);
                    lg.addCompWrap(cw);
                    groupList.add(lg);
                }
            }
        }
        return groupLists;
    }

    private static int convertSpanToSparseGrid(int curIx, int span, TreeSet<Integer> indexes) {
        int lastIx = curIx + span;
        int retSpan = 1;
        for (int ix : indexes) {
            if (ix <= curIx) continue;
            if (ix >= lastIx) break;
            ++retSpan;
        }
        return retSpan;
    }

    private final boolean isCellFree(int r, int c, ArrayList<int[]> occupiedRects) {
        if (this.getCell(r, c) != null) {
            return false;
        }
        for (int i = 0; i < occupiedRects.size(); ++i) {
            int[] rect = occupiedRects.get(i);
            if (rect[0] > c || rect[1] > r || rect[0] + rect[2] <= c || rect[1] + rect[3] <= r) continue;
            return false;
        }
        return true;
    }

    private Cell getCell(int r, int c) {
        return this.grid.get(new Integer((r << 16) + c));
    }

    private void setCell(int r, int c, Cell cell) {
        if (c < 0 || c > 30000 || r < 0 || r > 30000) {
            throw new IllegalArgumentException("Cell position out of bounds. row: " + r + ", col: " + c);
        }
        this.rowIndexes.add(new Integer(r));
        this.colIndexes.add(new Integer(c));
        this.grid.put(new Integer((r << 16) + c), cell);
    }

    private void addDockingCell(int[] dockInsets, int side, CompWrap cw) {
        int c;
        int r;
        int spanx = 1;
        int spany = 1;
        switch (side) {
            case 0: 
            case 2: {
                int n;
                if (side == 0) {
                    int n2 = dockInsets[0];
                    n = n2;
                    dockInsets[0] = n2 + 1;
                } else {
                    int n3 = dockInsets[2];
                    n = n3;
                    dockInsets[2] = n3 - 1;
                }
                r = n;
                c = dockInsets[1];
                spanx = dockInsets[3] - dockInsets[1] + 1;
                this.colIndexes.add(new Integer(dockInsets[3]));
                break;
            }
            case 1: 
            case 3: {
                int n;
                if (side == 1) {
                    int n4 = dockInsets[1];
                    n = n4;
                    dockInsets[1] = n4 + 1;
                } else {
                    int n5 = dockInsets[3];
                    n = n5;
                    dockInsets[3] = n5 - 1;
                }
                c = n;
                r = dockInsets[0];
                spany = dockInsets[2] - dockInsets[0] + 1;
                this.rowIndexes.add(new Integer(dockInsets[2]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error 123.");
            }
        }
        this.rowIndexes.add(new Integer(r));
        this.colIndexes.add(new Integer(c));
        this.grid.put(new Integer((r << 16) + c), new Cell(cw, spanx, spany, spanx > 1));
    }

    private static void layoutBaseline(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, int sizeType, int spanCount) {
        int[] aboveBelow = Grid.getBaselineAboveBelow(compWraps, sizeType, true);
        int blRowSize = aboveBelow[0] + aboveBelow[1];
        CC cc = compWraps.get(0).cc;
        UnitValue align = cc.getVertical().getAlign();
        if (spanCount == 1 && align == null) {
            align = dc.getAlignOrDefault(false);
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        int offset = start + aboveBelow[0] + (align != null ? Math.max(0, align.getPixels(size - blRowSize, parent, null)) : 0);
        int iSz = compWraps.size();
        for (int i = 0; i < iSz; ++i) {
            CompWrap cw = compWraps.get(i);
            cw.y += offset;
            if (cw.y + cw.h <= start + size) continue;
            cw.h = start + size - cw.y;
        }
    }

    private static void layoutSerial(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, boolean isHor, int spanCount, boolean fromEnd) {
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(Grid.getComponentResizeConstraints(compWraps, isHor), Grid.getComponentGapPush(compWraps, isHor), Grid.getComponentSizes(compWraps, isHor), Grid.getGaps(compWraps, isHor));
        Float[] growW = dc.isFill() ? GROW_100 : null;
        int[] sizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, growW, 1, size);
        Grid.setCompWrapBounds(parent, sizes, compWraps, dc.getAlignOrDefault(isHor), start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[] allSizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        int totSize = LayoutUtil.sum(allSizes);
        CC cc = compWraps.get(0).cc;
        UnitValue align = Grid.correctAlign(cc, rowAlign, isHor, fromEnd);
        int cSt = start;
        int slack = size - totSize;
        if (slack > 0 && align != null) {
            int al = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
            cSt += fromEnd ? -al : al;
        }
        int bIx = 0;
        int iSz = compWraps.size();
        for (int i = 0; i < iSz; ++i) {
            CompWrap cw = compWraps.get(i);
            if (fromEnd) {
                cw.setDimBounds((cSt -= allSizes[bIx++]) - allSizes[bIx], allSizes[bIx], isHor);
                cSt -= allSizes[bIx++];
                continue;
            }
            cw.setDimBounds(cSt += allSizes[bIx++], allSizes[bIx], isHor);
            cSt += allSizes[bIx++];
        }
    }

    private static void layoutParallel(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc, int start, int size, boolean isHor, boolean fromEnd) {
        int[][] sizes = new int[compWraps.size()][];
        for (int i = 0; i < sizes.length; ++i) {
            CompWrap cw = compWraps.get(i);
            DimConstraint cDc = cw.cc.getDimConstraint(isHor);
            ResizeConstraint[] resConstr = new ResizeConstraint[]{cw.isPushGap(isHor, true) ? GAP_RC_CONST_PUSH : GAP_RC_CONST, cDc.resize, cw.isPushGap(isHor, false) ? GAP_RC_CONST_PUSH : GAP_RC_CONST};
            int[][] sz = new int[][]{cw.getGaps(isHor, true), isHor ? cw.horSizes : cw.verSizes, cw.getGaps(isHor, false)};
            Float[] growW = dc.isFill() ? GROW_100 : null;
            sizes[i] = LayoutUtil.calculateSerial(sz, resConstr, growW, 1, size);
        }
        UnitValue rowAlign = dc.getAlignOrDefault(isHor);
        Grid.setCompWrapBounds(parent, sizes, compWraps, rowAlign, start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[][] sizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        for (int i = 0; i < sizes.length; ++i) {
            CompWrap cw = compWraps.get(i);
            UnitValue align = Grid.correctAlign(cw.cc, rowAlign, isHor, fromEnd);
            int[] cSizes = sizes[i];
            int gapBef = cSizes[0];
            int cSize = cSizes[1];
            int gapAft = cSizes[2];
            int cSt = fromEnd ? start - gapBef : start + gapBef;
            int slack = size - cSize - gapBef - gapAft;
            if (slack > 0 && align != null) {
                int al = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
                cSt += fromEnd ? -al : al;
            }
            cw.setDimBounds(fromEnd ? cSt - cSize : cSt, cSize, isHor);
        }
    }

    private static UnitValue correctAlign(CC cc, UnitValue rowAlign, boolean isHor, boolean fromEnd) {
        UnitValue align = (isHor ? cc.getHorizontal() : cc.getVertical()).getAlign();
        if (align == null) {
            align = rowAlign;
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        if (fromEnd) {
            if (align == UnitValue.LEFT) {
                align = UnitValue.RIGHT;
            } else if (align == UnitValue.RIGHT) {
                align = UnitValue.LEFT;
            }
        }
        return align;
    }

    private static int[] getBaselineAboveBelow(ArrayList<CompWrap> compWraps, int sType, boolean centerBaseline) {
        int maxAbove = Short.MIN_VALUE;
        int maxBelow = Short.MIN_VALUE;
        int iSz = compWraps.size();
        for (int i = 0; i < iSz; ++i) {
            CompWrap cw = compWraps.get(i);
            int height = cw.getSize(sType, false);
            if (height >= 2097051) {
                return new int[]{1048525, 1048525};
            }
            int baseline = cw.getBaseline(sType);
            int above = baseline + cw.getGapBefore(sType, false);
            maxAbove = Math.max(above, maxAbove);
            maxBelow = Math.max(height - baseline + cw.getGapAfter(sType, false), maxBelow);
            if (!centerBaseline) continue;
            cw.setDimBounds(-baseline, height, false);
        }
        return new int[]{maxAbove, maxBelow};
    }

    private static int getTotalSizeParallel(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int size = sType == 2 ? 2097051 : 0;
        int iSz = compWraps.size();
        for (int i = 0; i < iSz; ++i) {
            CompWrap cw = compWraps.get(i);
            int cwSize = cw.getSizeInclGaps(sType, isHor);
            if (cwSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? cwSize < size : cwSize > size)) continue;
            size = cwSize;
        }
        return Grid.constrainSize(size);
    }

    private static final int getTotalSizeSerial(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int totSize = 0;
        int iSz = compWraps.size();
        int lastGapAfter = 0;
        for (int i = 0; i < iSz; ++i) {
            CompWrap wrap = compWraps.get(i);
            int gapBef = wrap.getGapBefore(sType, isHor);
            if (gapBef > lastGapAfter) {
                totSize += gapBef - lastGapAfter;
            }
            totSize += wrap.getSize(sType, isHor);
            lastGapAfter = wrap.getGapAfter(sType, isHor);
            if ((totSize += lastGapAfter) < 2097051) continue;
            return 2097051;
        }
        return Grid.constrainSize(totSize);
    }

    private static final int getTotalGroupsSizeParallel(ArrayList<LinkedDimGroup> groups, int sType, boolean countSpanning) {
        int size = sType == 2 ? 2097051 : 0;
        int iSz = groups.size();
        for (int i = 0; i < iSz; ++i) {
            LinkedDimGroup group = groups.get(i);
            if (!countSpanning && group.span != 1) continue;
            int grpSize = group.getMinPrefMax()[sType];
            if (grpSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? grpSize < size : grpSize > size)) continue;
            size = grpSize;
        }
        return Grid.constrainSize(size);
    }

    private static int[][] getComponentSizes(ArrayList<CompWrap> compWraps, boolean isHor) {
        int[][] compSizes = new int[compWraps.size()][];
        for (int i = 0; i < compSizes.length; ++i) {
            CompWrap cw = compWraps.get(i);
            compSizes[i] = isHor ? cw.horSizes : cw.verSizes;
        }
        return compSizes;
    }

    private static FlowSizeSpec mergeSizesGapsAndResConstrs(ResizeConstraint[] resConstr, boolean[] gapPush, int[][] minPrefMaxSizes, int[][] gapSizes) {
        int[][] sizes = new int[(minPrefMaxSizes.length << 1) + 1][];
        ResizeConstraint[] resConstsInclGaps = new ResizeConstraint[sizes.length];
        sizes[0] = gapSizes[0];
        int i = 0;
        int crIx = 1;
        while (i < minPrefMaxSizes.length) {
            resConstsInclGaps[crIx] = resConstr[i];
            sizes[crIx] = minPrefMaxSizes[i];
            sizes[crIx + 1] = gapSizes[i + 1];
            if (sizes[crIx - 1] != null) {
                ResizeConstraint resizeConstraint = resConstsInclGaps[crIx - 1] = gapPush[i < gapPush.length ? i : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            if (i == minPrefMaxSizes.length - 1 && sizes[crIx + 1] != null) {
                resConstsInclGaps[crIx + 1] = gapPush[i + 1 < gapPush.length ? i + 1 : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            ++i;
            crIx += 2;
        }
        for (i = 0; i < sizes.length; ++i) {
            if (sizes[i] != null) continue;
            sizes[i] = new int[3];
        }
        return new FlowSizeSpec(sizes, resConstsInclGaps);
    }

    private static final int[] mergeSizes(int[] oldValues, int[] newValues) {
        if (oldValues == null) {
            return newValues;
        }
        if (newValues == null) {
            return oldValues;
        }
        int[] ret = new int[oldValues.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Grid.mergeSizes(oldValues[i], newValues[i], true);
        }
        return ret;
    }

    private static final int mergeSizes(int oldValue, int newValue, boolean toMax) {
        if (oldValue == -2147471302 || oldValue == newValue) {
            return newValue;
        }
        if (newValue == -2147471302) {
            return oldValue;
        }
        return toMax != oldValue > newValue ? newValue : oldValue;
    }

    private static final int constrainSize(int s) {
        return s > 0 ? (s < 2097051 ? s : 2097051) : 0;
    }

    private static final void correctMinMax(int[] s) {
        if (s[0] > s[2]) {
            s[0] = s[2];
        }
        if (s[1] < s[0]) {
            s[1] = s[0];
        }
        if (s[1] > s[2]) {
            s[1] = s[2];
        }
    }

    private static Float[] extractSubArray(DimConstraint[] specs, Float[] arr, int ix, int len) {
        if (arr == null || arr.length < ix + len) {
            Float[] growLastArr = new Float[len];
            for (int i = ix + len - 1; i >= 0; i -= 2) {
                int specIx = i >> 1;
                if (specs[specIx] == DOCK_DIM_CONSTRAINT) continue;
                growLastArr[i - ix] = ResizeConstraint.WEIGHT_100;
                return growLastArr;
            }
            return growLastArr;
        }
        Float[] newArr = new Float[len];
        for (int i = 0; i < len; ++i) {
            newArr[i] = arr[ix + i];
        }
        return newArr;
    }

    private static synchronized void putSizesAndIndexes(Object parComp, int[] sizes, int[] ixArr, boolean isRows) {
        if (PARENT_ROWCOL_SIZES_MAP == null) {
            PARENT_ROWCOL_SIZES_MAP = new WeakHashMap[]{new WeakHashMap(4), new WeakHashMap(4)};
        }
        PARENT_ROWCOL_SIZES_MAP[isRows ? 0 : 1].put(parComp, new int[][]{ixArr, sizes});
    }

    static synchronized int[][] getSizesAndIndexes(Object parComp, boolean isRows) {
        if (PARENT_ROWCOL_SIZES_MAP == null) {
            return null;
        }
        return (int[][])PARENT_ROWCOL_SIZES_MAP[isRows ? 0 : 1].get(parComp);
    }

    private static synchronized void saveGrid(ComponentWrapper parComp, LinkedHashMap<Integer, Cell> grid) {
        if (PARENT_GRIDPOS_MAP == null) {
            PARENT_GRIDPOS_MAP = new WeakHashMap();
        }
        PARENT_GRIDPOS_MAP.put(parComp.getComponent(), grid);
    }

    static synchronized HashMap<Object, int[]> getGridPositions(Object parComp) {
        if (PARENT_GRIDPOS_MAP == null) {
            return null;
        }
        LinkedHashMap<Integer, Cell> grid = PARENT_GRIDPOS_MAP.get(parComp);
        if (grid == null) {
            return null;
        }
        HashMap<Object, int[]> retMap = new HashMap<Object, int[]>();
        for (Map.Entry<Integer, Cell> e : grid.entrySet()) {
            Cell cell = e.getValue();
            Integer xyInt = e.getKey();
            if (xyInt == null) continue;
            int xy = xyInt;
            int x = xy & 0xFFFF;
            int y = xy >> 16;
            for (CompWrap cw : cell.compWraps) {
                retMap.put(cw.comp.getComponent(), new int[]{x, y, cell.spanx, cell.spany});
            }
        }
        return retMap;
    }

    static {
        DOCK_DIM_CONSTRAINT.setGrowPriority(0);
        GAP_RC_CONST = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, null);
        GAP_RC_CONST_PUSH = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, ResizeConstraint.WEIGHT_100);
        PARENT_ROWCOL_SIZES_MAP = null;
        PARENT_GRIDPOS_MAP = null;
    }

    private static final class FlowSizeSpec {
        private final int[][] sizes;
        private final ResizeConstraint[] resConstsInclGaps;

        private FlowSizeSpec(int[][] sizes, ResizeConstraint[] resConstsInclGaps) {
            this.sizes = sizes;
            this.resConstsInclGaps = resConstsInclGaps;
        }

        private final int expandSizes(DimConstraint[] specs, Float[] defGrow, int targetSize, int fromIx, int len, int sizeType, int eagerness) {
            ResizeConstraint[] resConstr = new ResizeConstraint[len];
            int[][] sizesToExpand = new int[len][];
            for (int i = 0; i < len; ++i) {
                int size = this.sizes[i + fromIx][sizeType];
                sizesToExpand[i] = new int[]{size, size, this.sizes[i + fromIx][2]};
                if (eagerness <= 1 && i % 2 == 0) {
                    int cIx = i + fromIx - 1 >> 1;
                    DimConstraint spec = (DimConstraint)LayoutUtil.getIndexSafe(specs, cIx);
                    BoundSize sz = spec.getSize();
                    if (sizeType == 0 && sz.getMin() != null && sz.getMin().getUnit() != 13 || sizeType == 1 && sz.getPreferred() != null && sz.getPreferred().getUnit() != 14) continue;
                }
                resConstr[i] = (ResizeConstraint)LayoutUtil.getIndexSafe(this.resConstsInclGaps, i + fromIx);
            }
            Float[] growW = eagerness == 1 || eagerness == 3 ? Grid.extractSubArray(specs, defGrow, fromIx, len) : null;
            int[] newSizes = LayoutUtil.calculateSerial(sizesToExpand, resConstr, growW, sizeType, targetSize);
            int newSize = 0;
            for (int i = 0; i < len; ++i) {
                int s;
                this.sizes[i + fromIx][sizeType] = s = newSizes[i];
                newSize += s;
            }
            return newSize;
        }
    }

    private static final class CompWrap {
        private final ComponentWrapper comp;
        private final CC cc;
        private final UnitValue[] pos;
        private int[][] gaps;
        private final int[] horSizes = new int[3];
        private final int[] verSizes = new int[3];
        private int x = -2147471302;
        private int y = -2147471302;
        private int w = -2147471302;
        private int h = -2147471302;
        private int forcedPushGaps = 0;

        private CompWrap(ComponentWrapper c, CC cc, int eHideMode, UnitValue[] pos, BoundSize[] callbackSz) {
            this.comp = c;
            this.cc = cc;
            this.pos = pos;
            if (eHideMode <= 0) {
                BoundSize hBS = callbackSz != null && callbackSz[0] != null ? callbackSz[0] : cc.getHorizontal().getSize();
                BoundSize vBS = callbackSz != null && callbackSz[1] != null ? callbackSz[1] : cc.getVertical().getSize();
                for (int i = 0; i <= 2; ++i) {
                    this.horSizes[i] = this.getSize(hBS, i, true, -1);
                    this.verSizes[i] = this.getSize(vBS, i, false, this.horSizes[i]);
                }
                Grid.correctMinMax(this.horSizes);
                Grid.correctMinMax(this.verSizes);
            }
            if (eHideMode > 1) {
                this.gaps = new int[4][];
                for (int i = 0; i < this.gaps.length; ++i) {
                    this.gaps[i] = new int[3];
                }
            }
        }

        private final int getSize(BoundSize uvs, int sizeType, boolean isHor, int sizeHint) {
            if (uvs == null || uvs.getSize(sizeType) == null) {
                switch (sizeType) {
                    case 0: {
                        return isHor ? this.comp.getMinimumWidth(sizeHint) : this.comp.getMinimumHeight(sizeHint);
                    }
                    case 1: {
                        return isHor ? this.comp.getPreferredWidth(sizeHint) : this.comp.getPreferredHeight(sizeHint);
                    }
                }
                return isHor ? this.comp.getMaximumWidth(sizeHint) : this.comp.getMaximumHeight(sizeHint);
            }
            ContainerWrapper par = this.comp.getParent();
            return uvs.getSize(sizeType).getPixels(isHor ? (float)par.getWidth() : (float)par.getHeight(), par, this.comp);
        }

        private final void calcGaps(ComponentWrapper before, CC befCC, ComponentWrapper after, CC aftCC, String tag, boolean flowX, boolean isLTR) {
            BoundSize befGap;
            ContainerWrapper par = this.comp.getParent();
            int parW = par.getWidth();
            int parH = par.getHeight();
            BoundSize boundSize = before != null ? (flowX ? befCC.getHorizontal() : befCC.getVertical()).getGapAfter() : (befGap = null);
            BoundSize aftGap = after != null ? (flowX ? aftCC.getHorizontal() : aftCC.getVertical()).getGapBefore() : null;
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, befGap, flowX ? null : before, tag, parH, 0, isLTR), false, true);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, befGap, flowX ? before : null, tag, parW, 1, isLTR), true, true);
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, aftGap, flowX ? null : after, tag, parH, 2, isLTR), false, false);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, aftGap, flowX ? after : null, tag, parW, 3, isLTR), true, false);
        }

        private final void setDimBounds(int start, int size, boolean isHor) {
            if (isHor) {
                this.x = start;
                this.w = size;
            } else {
                this.y = start;
                this.h = size;
            }
        }

        private final boolean isPushGap(boolean isHor, boolean isBefore) {
            if (isHor && ((isBefore ? 1 : 2) & this.forcedPushGaps) != 0) {
                return true;
            }
            DimConstraint dc = this.cc.getDimConstraint(isHor);
            BoundSize s = isBefore ? dc.getGapBefore() : dc.getGapAfter();
            return s != null && s.getGapPush();
        }

        private final boolean transferBounds(boolean checkPrefChange) {
            BoundSize vSz;
            this.comp.setBounds(this.x, this.y, this.w, this.h);
            return checkPrefChange && this.w != this.horSizes[1] && (vSz = this.cc.getVertical().getSize()).getPreferred() == null && this.comp.getPreferredHeight(-1) != this.verSizes[1];
        }

        private final void setSizes(int[] sizes, boolean isHor) {
            if (sizes == null) {
                return;
            }
            int[] s = isHor ? this.horSizes : this.verSizes;
            s[0] = sizes[0];
            s[1] = sizes[1];
            s[2] = sizes[2];
        }

        private void setGaps(int[] minPrefMax, int ix) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            this.gaps[ix] = minPrefMax;
        }

        private final void mergeGapSizes(int[] sizes, boolean isHor, boolean isTL) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            if (sizes == null) {
                return;
            }
            int gapIX = this.getGapIx(isHor, isTL);
            int[] oldGaps = this.gaps[gapIX];
            if (oldGaps == null) {
                oldGaps = new int[]{0, 0, 2097051};
                this.gaps[gapIX] = oldGaps;
            }
            oldGaps[0] = Math.max(sizes[0], oldGaps[0]);
            oldGaps[1] = Math.max(sizes[1], oldGaps[1]);
            oldGaps[2] = Math.min(sizes[2], oldGaps[2]);
        }

        private final int getGapIx(boolean isHor, boolean isTL) {
            return isHor ? (isTL ? 1 : 3) : (isTL ? 0 : 2);
        }

        private final int getSizeInclGaps(int sizeType, boolean isHor) {
            return this.filter(sizeType, this.getGapBefore(sizeType, isHor) + this.getSize(sizeType, isHor) + this.getGapAfter(sizeType, isHor));
        }

        private final int getSize(int sizeType, boolean isHor) {
            return this.filter(sizeType, isHor ? this.horSizes[sizeType] : this.verSizes[sizeType]);
        }

        private final int getGapBefore(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, true);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private final int getGapAfter(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, false);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private final int[] getGaps(boolean isHor, boolean isTL) {
            return this.gaps[this.getGapIx(isHor, isTL)];
        }

        private final int filter(int sizeType, int size) {
            if (size == -2147471302) {
                return sizeType != 2 ? 0 : 2097051;
            }
            return Grid.constrainSize(size);
        }

        private final boolean isBaselineAlign(boolean defValue) {
            Float g = this.cc.getVertical().getGrow();
            if (g != null && g.intValue() != 0) {
                return false;
            }
            UnitValue al = this.cc.getVertical().getAlign();
            return (al != null ? al == UnitValue.BASELINE_IDENTITY : defValue) && this.comp.hasBaseline();
        }

        private final int getBaseline(int sizeType) {
            return this.comp.getBaseline(this.getSize(sizeType, true), this.getSize(sizeType, false));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedDimGroup {
        private static final int TYPE_SERIAL = 0;
        private static final int TYPE_PARALLEL = 1;
        private static final int TYPE_BASELINE = 2;
        private final String linkCtx;
        private final int span;
        private final int linkType;
        private final boolean isHor;
        private final boolean fromEnd;
        private ArrayList<CompWrap> _compWraps = new ArrayList(4);
        private int[] sizes = null;
        private int lStart = 0;
        private int lSize = 0;

        private LinkedDimGroup(String linkCtx, int span, int linkType, boolean isHor, boolean fromEnd) {
            this.linkCtx = linkCtx;
            this.span = span;
            this.linkType = linkType;
            this.isHor = isHor;
            this.fromEnd = fromEnd;
        }

        private void addCompWrap(CompWrap cw) {
            this._compWraps.add(cw);
            this.sizes = null;
        }

        private void setCompWraps(ArrayList<CompWrap> cws) {
            if (this._compWraps != cws) {
                this._compWraps = cws;
                this.sizes = null;
            }
        }

        private void layout(DimConstraint dc, int start, int size, int spanCount) {
            this.lStart = start;
            this.lSize = size;
            if (this._compWraps.size() == 0) {
                return;
            }
            ContainerWrapper parent = this._compWraps.get(0).comp.getParent();
            if (this.linkType == 1) {
                Grid.layoutParallel(parent, this._compWraps, dc, start, size, this.isHor, this.fromEnd);
            } else if (this.linkType == 2) {
                Grid.layoutBaseline(parent, this._compWraps, dc, start, size, 1, spanCount);
            } else {
                Grid.layoutSerial(parent, this._compWraps, dc, start, size, this.isHor, spanCount, this.fromEnd);
            }
        }

        private int[] getMinPrefMax() {
            if (this.sizes == null && this._compWraps.size() > 0) {
                this.sizes = new int[3];
                for (int sType = 0; sType <= 1; ++sType) {
                    if (this.linkType == 1) {
                        this.sizes[sType] = Grid.getTotalSizeParallel(this._compWraps, sType, this.isHor);
                        continue;
                    }
                    if (this.linkType == 2) {
                        int[] aboveBelow = Grid.getBaselineAboveBelow(this._compWraps, sType, false);
                        this.sizes[sType] = aboveBelow[0] + aboveBelow[1];
                        continue;
                    }
                    this.sizes[sType] = Grid.getTotalSizeSerial(this._compWraps, sType, this.isHor);
                }
                this.sizes[2] = 2097051;
            }
            return this.sizes;
        }
    }

    private static class Cell {
        private final int spanx;
        private final int spany;
        private final boolean flowx;
        private final ArrayList<CompWrap> compWraps = new ArrayList(1);
        private boolean hasTagged = false;

        private Cell(CompWrap cw) {
            this(cw, 1, 1, true);
        }

        private Cell(int spanx, int spany, boolean flowx) {
            this(null, spanx, spany, flowx);
        }

        private Cell(CompWrap cw, int spanx, int spany, boolean flowx) {
            if (cw != null) {
                this.compWraps.add(cw);
            }
            this.spanx = spanx;
            this.spany = spany;
            this.flowx = flowx;
        }
    }
}

