/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class NamespaceHelper {
    private long id = 0L;
    private static HashSet<String> expectedNamespaces = new HashSet();
    private Stack<NamespaceContext> contexts = new Stack();
    static final Pattern xmlnsUriPattern;

    private static boolean isExpectedNamespace(String uri) {
        return uri != null ? expectedNamespaces.contains(uri) : false;
    }

    public NamespaceHelper() {
        this.contexts.push(new NamespaceContext(this.id++));
    }

    private void pushContext() {
        ++this.id;
        NamespaceContext currentContext = this.contexts.peek();
        currentContext.incrementUseCount();
    }

    private String findMatchingPrefix(String qName) {
        NamespaceContext currentContext = this.contexts.peek();
        for (NamespaceInstance instance : currentContext.getUriMap().values()) {
            Pattern p = instance.getPrefixPattern();
            Matcher m = p.matcher(qName);
            if (!m.find()) continue;
            return instance.getPrefix();
        }
        return null;
    }

    public String findPrefixForUri(String uri) {
        NamespaceInstance instance;
        String prefix = null;
        NamespaceContext currentContext = this.contexts.peek();
        if (uri != null && (instance = (NamespaceInstance)currentContext.getUriMap().get(uri)) != null) {
            prefix = instance.getPrefix();
        }
        return prefix;
    }

    private void recordPrefixUse(String prefix) {
        NamespaceInstance instance;
        NamespaceContext currentContext = this.contexts.peek();
        String uri = (String)currentContext.getPrefixMap().get(prefix);
        if (uri != null && (instance = (NamespaceInstance)currentContext.getUriMap().get(uri)) != null && !instance.isInUse()) {
            instance.setInUse(true);
        }
    }

    private void recordUriUse(String uri) {
        NamespaceInstance instance;
        NamespaceContext currentContext = this.contexts.peek();
        if (uri != null && (instance = (NamespaceInstance)currentContext.getUriMap().get(uri)) != null && !instance.isInUse()) {
            instance.setInUse(true);
        }
    }

    private void popContext(Report report) {
        NamespaceContext currentContext = this.contexts.peek();
        if (0 == currentContext.decrementUseCount()) {
            for (NamespaceInstance instance : currentContext.getUriMap().values()) {
                if (currentContext.getId() != instance.getId() || instance.isInUse()) continue;
                report.message(MessageId.HTM_044, instance.getLocation(), instance.getUri());
            }
            this.contexts.pop();
        }
    }

    public void declareNamespace(String prefix, String uri, EPUBLocation location, Report report) {
        NamespaceContext currentContext = this.contexts.peek();
        if (this.id != currentContext.getId()) {
            NamespaceContext newContext = new NamespaceContext(this.id, currentContext);
            this.contexts.push(newContext);
            currentContext = newContext;
        }
        currentContext.getPrefixMap().put(prefix, uri);
        currentContext.getUriMap().put(uri, new NamespaceInstance(this.id, prefix, uri, location));
        if (!NamespaceHelper.isExpectedNamespace(uri)) {
            report.message(MessageId.HTM_010, location, uri);
        }
    }

    public void onStartElement(String fileName, Locator locator, String uri, String qName, Attributes attributes, Report report) {
        this.pushContext();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String aqName = attributes.getQName(i);
            Matcher m = xmlnsUriPattern.matcher(aqName);
            if (m.matches()) {
                this.declareNamespace(m.group(1), attributes.getValue(i), EPUBLocation.create(fileName, locator.getLineNumber(), locator.getColumnNumber(), aqName), report);
                continue;
            }
            String foundPrefix = this.findMatchingPrefix(aqName);
            if (foundPrefix == null) continue;
            this.recordPrefixUse(foundPrefix);
        }
        String prefix = this.findMatchingPrefix(qName);
        if (prefix != null && prefix.length() > 0) {
            this.recordPrefixUse(prefix);
        }
        if (uri != null && uri.length() > 0) {
            this.recordUriUse(uri);
        }
    }

    public void onEndElement(Report report) {
        this.popContext(report);
    }

    static {
        expectedNamespaces.add("");
        expectedNamespaces.add("http://www.idpf.org/2007/ops");
        expectedNamespaces.add("http://www.w3.org/XML/1998/namespace");
        expectedNamespaces.add("http://www.w3.org/1999/xhtml");
        expectedNamespaces.add("http://www.idpf.org/2007/opf");
        expectedNamespaces.add("urn:oasis:names:tc:opendocument:xmlns:container");
        expectedNamespaces.add("http://purl.org/dc/elements/1.1/");
        xmlnsUriPattern = Pattern.compile("xmlns:([a-zA-Z]+)");
    }

    private class NamespaceContext {
        private long id;
        private int useCount;
        private IdHashMap<String, String> prefixMap;
        private IdHashMap<String, NamespaceInstance> uriMap;

        public NamespaceContext(long id) {
            this.useCount = 1;
            this.id = id;
            this.prefixMap = new IdHashMap(id);
            this.uriMap = new IdHashMap(id);
        }

        public NamespaceContext(long id, NamespaceContext other) {
            other.decrementUseCount();
            this.useCount = 1;
            this.id = id;
            this.prefixMap = new IdHashMap<String, String>(id, other.getPrefixMap());
            this.uriMap = new IdHashMap<String, NamespaceInstance>(id, other.getUriMap());
        }

        public long getId() {
            return this.id;
        }

        public int getUseCount() {
            return this.useCount;
        }

        public int incrementUseCount() {
            return ++this.useCount;
        }

        public int decrementUseCount() {
            return --this.useCount;
        }

        public IdHashMap<String, String> getPrefixMap() {
            return this.prefixMap;
        }

        public IdHashMap<String, NamespaceInstance> getUriMap() {
            return this.uriMap;
        }
    }

    private class NamespaceInstance {
        private long id;
        private String prefix;
        private String uri;
        private EPUBLocation location;
        private boolean inUse;
        private Pattern prefixPattern;

        public NamespaceInstance(long id, String prefix, String uri, EPUBLocation location) {
            this.setId(id);
            this.setPrefix(prefix);
            this.setUri(uri);
            this.setLocation(location);
            this.setInUse(false);
            this.setPrefixPattern(Pattern.compile("^" + prefix + ":.+"));
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public EPUBLocation getLocation() {
            return this.location;
        }

        public void setLocation(EPUBLocation location) {
            this.location = location;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void setInUse(boolean inUse) {
            this.inUse = inUse;
        }

        public Pattern getPrefixPattern() {
            return this.prefixPattern;
        }

        public void setPrefixPattern(Pattern prefixPattern) {
            this.prefixPattern = prefixPattern;
        }

        public String toString() {
            if (this.getUri() != null && this.getUri().length() > 0) {
                return "xmlns" + this.getPrefix() + "=" + this.getUri();
            }
            return "xmlns" + this.getPrefix();
        }
    }

    private class IdHashMap<K, V>
    extends HashMap<K, V> {
        final long id;

        public long getId() {
            return this.id;
        }

        public IdHashMap(long id) {
            this.id = id;
        }

        public IdHashMap(long id, Map<K, V> m) {
            super(m);
            this.id = id;
        }
    }
}

