/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.HashSet;
import java.util.Set;

class FindElementFunction
extends AbstractPatternFunction<VoidValue> {
    private final ValidatorPatternBuilder builder;
    private final Name name;
    private final Set<Pattern> processed = new HashSet<Pattern>();
    private int specificity = -1;
    private Pattern pattern = null;

    public static Pattern findElement(ValidatorPatternBuilder validatorPatternBuilder, Name name, Pattern pattern) {
        FindElementFunction findElementFunction = new FindElementFunction(validatorPatternBuilder, name);
        pattern.apply(findElementFunction);
        if (findElementFunction.pattern == null) {
            return validatorPatternBuilder.makeNotAllowed();
        }
        return findElementFunction.pattern;
    }

    private FindElementFunction(ValidatorPatternBuilder validatorPatternBuilder, Name name) {
        this.builder = validatorPatternBuilder;
        this.name = name;
    }

    private boolean haveProcessed(Pattern pattern) {
        if (this.processed.contains(pattern)) {
            return true;
        }
        this.processed.add(pattern);
        return false;
    }

    private VoidValue caseBinary(BinaryPattern binaryPattern) {
        if (!this.haveProcessed(binaryPattern)) {
            binaryPattern.getOperand1().apply(this);
            binaryPattern.getOperand2().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    @Override
    public VoidValue caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public VoidValue caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        if (!this.haveProcessed(oneOrMorePattern)) {
            oneOrMorePattern.getOperand().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseElement(ElementPattern elementPattern) {
        if (!this.haveProcessed(elementPattern)) {
            int n = elementPattern.getNameClass().containsSpecificity(this.name);
            if (n > this.specificity) {
                this.specificity = n;
                this.pattern = elementPattern.getContent();
            } else if (n == this.specificity && n != -1) {
                this.pattern = this.builder.makeChoice(this.pattern, elementPattern.getContent());
            }
            elementPattern.getContent().apply(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseOther(Pattern pattern) {
        return VoidValue.VOID;
    }
}

