/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSource;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultAutoCommit;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultReadOnly;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultTransactionIsolation;
import org.mybatis.guice.datasource.dbcp.PerUserMaxActive;
import org.mybatis.guice.datasource.dbcp.PerUserMaxIdle;
import org.mybatis.guice.datasource.dbcp.PerUserMaxWait;

public final class PerUserPoolDataSourceProvider
implements Provider<DataSource> {
    private final PerUserPoolDataSource dataSource = new PerUserPoolDataSource();

    @Inject(optional=true)
    public void setConnectionPoolDataSource(ConnectionPoolDataSource cpds) {
        this.dataSource.setConnectionPoolDataSource(cpds);
    }

    @Inject(optional=true)
    public void setDataSourceName(@Named(value="DBCP.name") String name) {
        this.dataSource.setDataSourceName(name);
    }

    @Inject(optional=true)
    public void setDefaultAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setDefaultAutoCommit(autoCommit);
    }

    @Inject(optional=true)
    public void setDefaultReadOnly(@Named(value="DBCP.defaultReadOnly") boolean defaultReadOnly) {
        this.dataSource.setDefaultReadOnly(defaultReadOnly);
    }

    @Inject(optional=true)
    public void setDefaultTransactionIsolation(@Named(value="DBCP.defaultTransactionIsolation") int defaultTransactionIsolation) {
        this.dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    @Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.dataSource.setDescription(description);
    }

    @Inject(optional=true)
    public void setJndiEnvironment(@Named(value="DBCP.jndi.key") String key, @Named(value="DBCP.jndi.value") String value) {
        this.dataSource.setJndiEnvironment(key, value);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        this.dataSource.setLoginTimeout(loginTimeout);
    }

    @Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") int minEvictableIdleTimeMillis) {
        this.dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.dataSource.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @Inject(optional=true)
    public void setRollbackAfterValidation(@Named(value="DBCP.rollbackAfterValidation") boolean rollbackAfterValidation) {
        this.dataSource.setRollbackAfterValidation(rollbackAfterValidation);
    }

    @Inject(optional=true)
    public void setTestOnBorrow(@Named(value="DBCP.testOnBorrow") boolean testOnBorrow) {
        this.dataSource.setTestOnBorrow(testOnBorrow);
    }

    @Inject(optional=true)
    public void setTestOnReturn(@Named(value="DBCP.testOnReturn") boolean testOnReturn) {
        this.dataSource.setTestOnReturn(testOnReturn);
    }

    @Inject(optional=true)
    public void setTestWhileIdle(@Named(value="DBCP.testWhileIdle") boolean testWhileIdle) {
        this.dataSource.setTestWhileIdle(testWhileIdle);
    }

    @Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    @Inject(optional=true)
    public void setValidationQuery(@Named(value="DBCP.validationQuery") String validationQuery) {
        this.dataSource.setValidationQuery(validationQuery);
    }

    @Inject(optional=true)
    public void setDefaultMaxActive(@Named(value="DBCP.maxActive") int maxActive) {
        this.dataSource.setDefaultMaxActive(maxActive);
    }

    @Inject(optional=true)
    public void setDefaultMaxIdle(@Named(value="DBCP.maxIdle") int defaultMaxIdle) {
        this.dataSource.setDefaultMaxIdle(defaultMaxIdle);
    }

    @Inject(optional=true)
    public void setDefaultMaxWait(@Named(value="DBCP.maxWait") int defaultMaxWait) {
        this.dataSource.setDefaultMaxWait(defaultMaxWait);
    }

    @Inject(optional=true)
    public void setPerUserDefaultAutoCommit(@PerUserDefaultAutoCommit Map<String, Boolean> perUserDefaultAutoCommit) {
        for (Map.Entry<String, Boolean> entry : perUserDefaultAutoCommit.entrySet()) {
            this.dataSource.setPerUserDefaultAutoCommit(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserDefaultReadOnly(@PerUserDefaultReadOnly Map<String, Boolean> perUserDefaultReadOnly) {
        for (Map.Entry<String, Boolean> entry : perUserDefaultReadOnly.entrySet()) {
            this.dataSource.setPerUserDefaultReadOnly(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserDefaultTransactionIsolation(@PerUserDefaultTransactionIsolation Map<String, Integer> perUserDefaultTransactionIsolation) {
        for (Map.Entry<String, Integer> entry : perUserDefaultTransactionIsolation.entrySet()) {
            this.dataSource.setPerUserDefaultTransactionIsolation(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxActive(@PerUserMaxActive Map<String, Integer> perUserMaxActive) {
        for (Map.Entry<String, Integer> entry : perUserMaxActive.entrySet()) {
            this.dataSource.setPerUserMaxActive(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxIdle(@PerUserMaxIdle Map<String, Integer> perUserMaxIdle) {
        for (Map.Entry<String, Integer> entry : perUserMaxIdle.entrySet()) {
            this.dataSource.setPerUserMaxIdle(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxWait(@PerUserMaxWait Map<String, Integer> perUserMaxWait) {
        for (Map.Entry<String, Integer> entry : perUserMaxWait.entrySet()) {
            this.dataSource.setPerUserMaxWait(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public DataSource get() {
        return this.dataSource;
    }
}

