/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_VertexCacheStatistics")
public class MeshoptVertexCacheStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTICES_TRANSFORMED;
    public static final int WARPS_EXECUTED;
    public static final int ACMR;
    public static final int ATVR;

    public MeshoptVertexCacheStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptVertexCacheStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int vertices_transformed() {
        return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
    }

    @NativeType(value="unsigned int")
    public int warps_executed() {
        return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
    }

    public float acmr() {
        return MeshoptVertexCacheStatistics.nacmr(this.address());
    }

    public float atvr() {
        return MeshoptVertexCacheStatistics.natvr(this.address());
    }

    public static MeshoptVertexCacheStatistics malloc() {
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeshoptVertexCacheStatistics calloc() {
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeshoptVertexCacheStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeshoptVertexCacheStatistics create(long address) {
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)address);
    }

    @Nullable
    public static MeshoptVertexCacheStatistics createSafe(long address) {
        return address == 0L ? null : (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeshoptVertexCacheStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptVertexCacheStatistics.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeshoptVertexCacheStatistics mallocStack() {
        return MeshoptVertexCacheStatistics.mallocStack(MemoryStack.stackGet());
    }

    public static MeshoptVertexCacheStatistics callocStack() {
        return MeshoptVertexCacheStatistics.callocStack(MemoryStack.stackGet());
    }

    public static MeshoptVertexCacheStatistics mallocStack(MemoryStack stack) {
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptVertexCacheStatistics callocStack(MemoryStack stack) {
        return (MeshoptVertexCacheStatistics)MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeshoptVertexCacheStatistics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeshoptVertexCacheStatistics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptVertexCacheStatistics.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nvertices_transformed(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTICES_TRANSFORMED);
    }

    public static int nwarps_executed(long struct) {
        return UNSAFE.getInt(null, struct + (long)WARPS_EXECUTED);
    }

    public static float nacmr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ACMR);
    }

    public static float natvr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ATVR);
    }

    static {
        Struct.Layout layout = MeshoptVertexCacheStatistics.__struct((Struct.Member[])new Struct.Member[]{MeshoptVertexCacheStatistics.__member((int)4), MeshoptVertexCacheStatistics.__member((int)4), MeshoptVertexCacheStatistics.__member((int)4), MeshoptVertexCacheStatistics.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTICES_TRANSFORMED = layout.offsetof(0);
        WARPS_EXECUTED = layout.offsetof(1);
        ACMR = layout.offsetof(2);
        ATVR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MeshoptVertexCacheStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptVertexCacheStatistics ELEMENT_FACTORY = MeshoptVertexCacheStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptVertexCacheStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int vertices_transformed() {
            return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
        }

        @NativeType(value="unsigned int")
        public int warps_executed() {
            return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
        }

        public float acmr() {
            return MeshoptVertexCacheStatistics.nacmr(this.address());
        }

        public float atvr() {
            return MeshoptVertexCacheStatistics.natvr(this.address());
        }
    }
}

