### help.tcl: Help pages for Scid.
### This file uses UTF-8
#################################################

set helpTitle(Contents) "Contents"
set helpText(Contents) {<h1>Scid Help Contents</h1>
  
  <h4>Starting out and general help</h4>
  <ul>
  <li><a Guide><b>Quick Guide</b> to using Scid</a> <red>(Read this first)</red></li>
  <li><a Hints><b>Hints</b> for getting more out of Scid</a></li>
  <li><a MainWindow>The Scid <b>main window</b></a></li>
  <li><a Menus>Scid <b>menus</b></a></li>
  <li><a Moves>Entering <b>chess moves</b></a></li>
  <li><a Searches><b>Searches</b> in Scid</a></li>
  <li><a Clipbase>Using the <b>Clipbase</b> database</a></li>
  <li><a Annotating><b>Annotating games</b></a></li>
  </ul>
  
  <h4>Other Scid windows</h4>
  <ul>
  <li><a Analysis><b>Analysis</b> window</a></li>
  <li><a Book><b>Book</b> window</a></li>
  <li><a CalVar><b>Calculation of variations</b> window</a></li>
  <li><a Comment><b>Comment editor</b> window</a></li>
  <li><a Crosstable><b>Crosstable</b> window</a></li>
  <li><a Switcher><b>Database Switcher</b> window</a></li>
  <li><a Email><b>Email</b> chess manager window</a></li>
  <li><a Finder><b>File Finder</b> window</a></li>
  <li><a GameList><b>Game List</b> window</a></li>
  <li><a Import><b>Import game</b> window</a></li>
  <li><a OpeningTrainer><b>Opening Trainer</b> window </a></li>
  <li><a Reports><b>Reports</b></a></li>
  <li><a PGN><b>PGN</b> (game text) window</a></li>
  <li><a PTracker><b>Piece Tracker</b></a></li>
  <li><a PList><b>Player Finder</b> window</a></li>
  <li><a PInfo><b>Player Info</b> window</a></li>
  <li><a TacticalGame><b>Tactical game</b> window</a></li>
  <li><a Tmt><b>Tournament Finder</b> window</a></li>
  <li><a Tree><b>Tree</b> window</a></li>
  <li><a Graphs><b>Graph</b> windows</a></li>
  <li><a TB>Using <b>Tablebases</b> in Scid</a></li>
  </ul>
  
  <h4>Other utilities and information</h4>
  <ul>
  <li><a Bookmarks><b>Bookmarks</b></a></li>
  <li><a Cmdline>Command-line options</a></li>
  <li><a Compact><b>Compacting</b> a database</a></li>
  <li><a Correspondence>Correspondence Chess</a></li>
  <li><a Maintenance><b>Database maintenance</b> tools</a></li>
  <li><a ECO><b>ECO</b> openings classification</a></li>
  <li><a EPD><b>EPD</b> files</a></li>
  <li><a Export><b>Exporting</b> games to text files</a></li>
  <li><a Flags>Game <b>Flags</b></a></li>
  <li><a LaTeX>Using <b>LaTeX</b> with Scid</a></li>
  <li><a Options><b>Options</b> and preferences</a></li>
  <li><a Sorting><b>Sorting</b> a database</a></li>
  <li><a Pgnscid><b>Pgnscid</b>: converting <a PGN>PGN</a> files</a></li>
  <li><a NAGs>Standard <b>NAG</b> annotation values</a></li>
  <li><a Formats>Scid database <b>file formats</b></a></li>
  <li><a Author>Contact information</a></li>
  </ul>
  
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}

###############
### Topic Index

set helpTitle(Index) "Scid Help Topic Index"
set helpText(Index) {<h1>Scid Help Topic Index</h1>
  
  <h3>A</h3>
  <ul>
  <li><a Analysis>Analysis</a> window</li>
  <li><a Annotating>Annotating games</a></li>
  <li><a NAGs>Annotation symbols</a></li>
  <li><a Author>Author, contacting</a></li>
  <li><a MainWindow Autoplay>Autoplay mode</a></li>
  </ul>
  
  <h3>B</h3>
  <ul>
  <li><a Tree Best>Best games</a> window</li>
  <li><a Searches Board>Board searches</a></li>
  <li><a Book>Book</a> window</li>
  <li><a BookTuning>Book</a> tuning</li>
  <li><a Bookmarks>Bookmarks</a></li>
  <li><a GameList Browsing>Browsing games</a></li>
  </ul>
  
  <h3>C</h3>
  <ul>
  <li><a Maintenance Cleaner>Cleaner</a></li>
  <li><a Clipbase>Clipbase</a></li>
  <li><a Cmdline>Command-line options</a></li>
  <li><a Comment>Comment editor</a></li>
  <li><a Compact>Compacting a database</a></li>
  <li><a Correspondence>Correspondence Chess</a></li>
  <li><a CCIcons>Correspondence Chess Icons</a></li>
  <li><a Author>Contact information</a></li>
  <li><a Contents>Contents</a></li>
  <li><a Crosstable>Crosstable</a> window</li>
  <li><a Appearance>Customize Appearance</a></li>
  </ul>
  
  <h3>D</h3>
  <ul>
  <li><a Compact>Database compaction</a></li>
  <li><a Formats>Database file formats</a></li>
  <li><a Metadata>Database information (Metadata)</a></li>
  <li><a Maintenance>Database maintenance</a></li>
  <li><a Sorting>Database sorting</a></li>
  <li><a Switcher>Database switcher</a> window</li>
  <li><a Maintenance Twins>Deleting twin games</a></li>
  <li><a HardwareConfig>DGT Electronic Chess Board</a></li>
  <li><a InputEngine>DGT usage</a></li>
  <li><a Metadata>Dublin Core Metadata</a></li>
  </ul>
  
  <h3>E</h3>
  <ul>
  <li><a ECO Browser>ECO Browser</a> window</li>
  <li><a ECO Codes>ECO code system</a></li>
  <li><a ECO>ECO openings classification</a></li>
  <li><a Menus Edit>Edit menu</a></li>
  <li><a Email>Email manager</a> window</li>
  <li><a CCeMailChess>Email Chess</a></li>
  <li><a Analysis List>Engines list</a></li>
  <li><a Moves>Entering chess moves</a></li>
  <li><a EPD>EPD files</a></li>
  <li><a Export>Exporting games to text files</a></li>
  <li><a HardwareConfig>External Hardware (Novag, DGT...)</a></li>
  </ul>
  
  <h3>F</h3>
  <ul>
  <li><a FICSLogin>FICS Login</a></li>
  <li><a FICSfindOpp>FICS Find opponent</a></li>
  <li><a FICS>Play on the Internet (FICS)</a></li>
  <li><a FICS Training>FICS lectures</a></li>
  <li><a Finder>File Finder</a></li>
  <li><a FindBestMove>Training: Find best move</a></li>
  <li><a Formats>File formats</a></li>
  <li><a Menus File>File menu</a></li>
  <li><a Searches Filter>Filter</a></li>
  <li><a Export>Filter, exporting</a></li>
  <li><a Graphs Filter>Filter graph</a></li>
  <li><a Flags>Flags</a></li>
  <li><a Options Fonts>Fonts</a></li>
  </ul>
  
  <h3>G</h3>
  <ul>
  <li><a Flags>Game flags</a></li>
  <li><a GameList>Game List</a> window</li>
  <li><a Menus Game>Game menu</a></li>
  <li><a Graphs>Graph windows</a></li>
  </ul>
  
  <h3>H</h3>
  <ul>
  <li><a Searches Header>Header searches</a></li>
  <li><a Menus Help>Help menu</a></li>
  <li><a Hints>Hints</a></li>
  <li><a HardwareConfig>Using Hardware (Novag, DGT)</a></li>
  </ul>
  
  <h3>I</h3>
  <ul>
  <li><a CCIcons>Icons for Correspondence Chess</a></li>
  <li><a Import>Import</a> window</li>
  <li><a Moves Informant>Informant Symbols</a></li>
  <li><a InputEngine>Input Engine drivers</a></li>
  </ul>
  
  <h3>L</h3>
  <ul>
  <li><a LaTeX>LaTeX</a> output format</li>
  </ul>
  
  <h3>M</h3>
  <ul>
  <li><a MainWindow>Main Window</a></li>
  <li><a Maintenance>Maintenance tools</a></li>
  <li><a TreeMasks>Masks for Trees</a></li>
  <li><a Searches Material>Material/pattern searches</a></li>
  <li><a Menus>Menus</a></li>
  <li><a GameList Browsing>Merging games</a></li>
  <li><a Metadata>Metadata</a></li>
  <li><a Moves>Move entry</a></li>
  </ul>
  
  <h3>N</h3>
  <ul>
  <li><a Maintenance Editing>Names, editing</a></li>
  <li><a Maintenance Spellcheck>Names, spellchecking</a></li>
  <li><a NAGs>NAG annotation values</a></li>
  <li><a Annotating Null>Null moves</a></li>
  <li><a HardwareConfig>Novag Citrine Electronic Chess Board</a></li>
  <li><a Novag>Novag Citrine usage</a></li>
  </ul>
  
  <h3>O</h3>
  <ul>
  <li><a ECO>Opening classification (ECO)</a></li>
  <li><a Reports Opening>Opening report</a> window</li>
  <li><a OpeningTrainer>Training: Openings</a></li>
  <li><a Options>Options</a></li>
  </ul>
  
  <h3>P</h3>
  <ul>
  <li><a PGN>PGN</a> window</li>
  <li><a Pgnscid>Pgnscid</a></li>
  <li><a FICS>Play on the Internet (FICS)</a></li>
  <li><a PTracker>Piece Tracker</a> window</li>
  <li><a PList>Player Finder</a> window</li>
  <li><a PInfo>Player Info</a> window</li>
  <li><a Reports Player>Player report</a> window</li>
  <li><a TacticalGame>Play tactical game</a></li>
  <li><a SeriousGame>Play serious game</a></li>
  </ul>
  
  <h3>Q</h3>
  <ul>
  <li><a Guide>Quick guide to using Scid</a></li>
  </ul>
  
  <h3>R</h3>
  <ul>
  <li><a Graphs Rating>Rating graph</a></li>
  </ul>
  
  <h3>S</h3>
  <ul>
  <li><a Searches Filter>Search filter</a></li>
  <li><a Menus Search>Search menu</a></li>
  <li><a Searches>Searches</a></li>
  <li><a SeriousGame>Play serious game</a></li>
  <li><a Sorting>Sorting a database</a></li>
  <li><a Maintenance Spellcheck>Spellchecking names</a></li>
  <li><a Switcher>Switcher</a> window</li>
  </ul>
  
  <h3>T</h3>
  <ul>
  <li><a TB>Tablebases</a></li>
  <li><a TacticalGame>Tactical game</a></li>
  <li><a Menus Tools>Tools menu</a></li>
  <li><a Tmt>Tournament finder</a></li>
  <li><a FindBestMove>Training: Find best move</a></li>
  <li><a OpeningTrainer>Training: Openings</a></li>
  <li><a TacticsTrainer>Training: Tactics</a></li>
  <li><a FICS Training>Training: FICS lectures</a></li>
  <li><a Tree>Tree window</a></li>
  <li><a TreeMasks>Masks for Trees</a></li>
  <li><a Moves Trial>Trial mode</a></li>
  <li><a Maintenance Twins>Twin (duplicate) games</a></li>
  </ul>
  
  <h3>V</h3>
  <ul>
  <li><a Annotating Vars>Variations</a></li>
  </ul>
  
  <h3>W</h3>
  <ul>
  <li><a Menus Windows>Windows menu</a></li>
  </ul>

  <h3>X</h3>
  <ul>
  <li><a CCXfcc>Xfcc support</a></li>
  </ul>

  <p><footer>(Updated: Scid 3.6.23, March 2008)</footer></p>
}


####################
### Quick Guide help:

set helpTitle(Guide) "Quick Guide to using Scid"
set helpText(Guide) {<h1>Quick Guide to using Scid</h1>
  <p>
  Scid is a chess database application; with it you can browse
  databases of chess games, edit games and <a Searches>search</a>
  for games by various criteria.
  </p>
  <p>
  Scid uses its own special three-file <a Formats>database format</a>
  which is very compact and fast, but it can convert to and from
  the standard <a PGN>PGN</a> (Portable Game Notation) format.
  Scid's <a PGN>PGN window</a> displays the text of the current game in
  <a PGN>PGN</a> format.
  </p>
  <p>
  You can use Scid to add chess games to a database, using the keyboard or
  mouse to enter moves. See the help page on <a Moves>entering chess moves</a>
  for more details.
  </p>
  <p>
  You can also use Scid as a <a PGN>PGN</a> file browser, by pasting
  <a PGN>PGN</a> text into Scid's <a Import>Import</a> window or by
  opening a <a PGN>PGN</a> file in Scid.  However, <a PGN>PGN</a>
  files cannot be edited by Scid (it opens them read-only) and they
  use more memory and are slower to load, so for large <a PGN>PGN</a>
  files it is recommended that you create a Scid database from them
  first with the <a Pgnscid>pgnscid</a> utility.
  </p>
  <p>
  Windows can be used in docked mode or as independent windows (see
  flag in the options menu).  In docked mode, the most important
  windows are embedded into a main one. The windows can be reordered
  by right-clicking on the tab (where the title of the window is) and
  by dragging tabs from one notebook to another. The menu for each
  window that has one (marked with a triangle at the left of the tab)
  is opened by left clicking on the tab.
  </p>
  <p>
  The <a MainWindow>main window</a>
  of Scid (with the graphical chess board) shows details of
  the active game and database. At any time, you can have up to nine
  databases open (five including the <a Clipbase>clipbase</a>),
  and each will have its own active game.
  (A game numbered 0 indicates a scratch game that is not part of the
  actual database).
  You can switch between the open databases with the
  <a Menus File>File menu</a>.
  </p>
  <p>
  For more information, please read the other help pages listed in the
  <a Index>Help Index</a>.
  </p>
  <p>
  See the <a Author>contact information</a> page if you need to contact the
  author of Scid.
  </p>
  
  <p><footer>(Updated: Scid 3.6.7, December 2008)</footer></p>
}


####################
### Hints page:
set helpTitle(Hints) "Scid Hints"
set helpText(Hints) {<h1>Scid Hints</h1>
  <p>
  This page contains useful hints in question and answer format to
  help you use Scid better. If you are new to Scid, please read the <a
  Guide>quick guide</a> first.  Most of the information on this page
  is available in more detail on the other help pages listed in the <a
  Index>index</a>.  If you think of a useful hint to add to this page,
  please send it to the <a Author>author of Scid</a>.
  </p>
  
  <h4>Can I get Scid to load a database when it starts?</h4>
  <p>
  Yes, you can add databases, <a PGN>PGN</a> files or <a EPD>EPD files</a>
  to the command line. For example:
  <ul>
  <li> <b>scid  mybase  games.pgn.gz</b> </li>
  </ul>
  will load the Scid database <b>mybase</b> and also load the
  Gzip-compressed <a PGN>PGN</a> file <b>games.pgn.gz</b>.
  </p>
  
  <h4>Is there an easier way to change the board size than using the
  options menu?</h4>
  <p>
  Yes, you can use the shortcut keys <b>Control+Shift+LeftArrow</b> and
  <b>Control+Shift+RightArrow</b> to decrease or increase the board size.
  </p>
  
  <h4>I am training by playing through a game, so I do not want Scid to
  print the next move in the game information area below the chessboard.
  Can I hide it?</h4>
  <p>
  You can hide the next move by pressing the <b>right</b> mouse button in the
  game information area, and selecting <b>Hide next move</b> from the
  menu that appears.
  </p>
  
  <h4>How can I see the ECO opening code for the current position?</h4>
  <p>
  The ECO code is displayed on the bottom line of the game
  information box, below the chessboard in the <a MainWindow>main window</a>,
  if you have the ECO classification file (<b>scid.eco</b>) loaded. <br>
  The <a ECO>ECO codes</a> help page explains how to load the ECO classification
  file and save options so it will be loaded every time you start Scid.
  </p>
  
  <h4>I am entering a game, and I am up to move 30, but just saw that move
  10 was wrong. How can I correct it and keep all the moves after it?</h4>
  <p>
  You can use the <a Import>Import</a> window; see the
  <a Moves Mistakes>entering moves</a> help page for more information.
  </p>
  
  <h4>How do I copy games from one database to another?</h4>
  <p>
  Use the <a Switcher>database switcher window</a>: drag from the source
  database to the target database to copy all games in the source database
  <a Searches Filter>filter</a>.
  </p>
  
  <h4>Every time I enter a move where one already exists, I get a
  "Replace move?" dialog box. How do I avoid that?</h4>
  <p>
  Turn it off with the <b>Ask before replacing moves</b> option in the
  <menu>Options: Moves</menu> menu.
  Or, get into the habit of taking back moves using the right-mouse button,
  which actually removes the move from the game if you are at the last move of
  the game.
  </p>
  
  <h4>How do I change column widths in the Game List window?</h4>
  <p>
  Click the left or right mouse button on each column title.
  </p>
  
  <h4>How can I use the tree window on a selection of games, not my whole
  database?</h4>
  <p>
  Use the <a Clipbase>clipbase</a>. Set your database filter to contain the
  games you want to use the tree on, then copy them to the clipbase using the
  <a Switcher>database switcher</a>. Then, just open the tree window in the
  clipbase.
  </p>
  
  <h4>The Tree is slow for large databases. How do I speed it up?</h4>
  <p>
  Save the Tree cache often, to save tree results for future use.
  See the caching section of the <a Tree>Tree</a> help page for details.
  </p>
  
  <h4>How can I edit the <a PGN>PGN</a> representation of the game directly?</h4>
  <p>
  You cannot use the <a PGN>PGN</a> window to edit the current game, but you can
  still edit its <a PGN>PGN</a> representation using the <a Import>Import game</a> window.
  Just open it (shortcut key: <b>Control+Shift+I</b>) and then press the
  <b>Paste current game</b> button, then edit the game, then press <b>Import</b>.
  </p>
  
  <h4>My database has several spellings for some player names. How do I
  correct them all?</h4>
  <p>
  You can edit individual names or spellcheck all the names in a database
  with the commands in the <menu>File: Maintenance</menu> menu.
  See the <a Maintenance Editing>maintenance</a> page.
  </p>
  
  <h4>I have two databases open: one with my own games, and a large database of
  grandmaster games. How do I compare one of my games to those in the large
  database?</h4>
  <p>
  Just open the <a Tree>Tree</a> window for the reference database and
  switch back to the game to compare by means of the database
  switcher. Alternatively, a base can directly be opened as tree via
  the <term>File</term> menu.
  </p>
  
  <p><footer>(Updated: Scid 3.6.28, December 2008)</footer></p>
}


####################
### Main window help:

set helpTitle(MainWindow) "Scid main window"
set helpText(MainWindow) {<h1>Scid main window</h1>
  <p>
  The main window in Scid displays the current board position of the
  active game and information about the current game and database.
  Separate help pages describe the <a Menus>menus</a> and ways to
  <a Moves>enter chess moves</a>.
  </p>
  
  <h3>The game information area</h3>
  <p>
  The area below the chessboard showing information about the game is
  called the <term>game information area</term>.  Its first three
  lines show information such as the players, their country, result,
  date, and site.  This information is drawn from the games PGN
  header. To show country information the fields
  WhiteCountry/BlackCountry need to be available. The fourth line
  indicates the current position in the game, and what the next move
  is.
  </p>
  <p>
  Additionally, flags set for a given game are shown. Here, custom
  flags only show up by their respective number while the standard
  flags also show their textual meaning.
  </p>
  <p>
  Next to the flags a link called <term>Bib</term> may show up in case the
  PGN header contains a bibliographic link, ie. a link to the chess
  literature. This link is to be placed in a special header field
  called <term>Bib</term> and links the game to a BibTeX database containing
  the bibliographic information. This linking is done by almost
  standard LaTeX structure, that is the <term>Bib</term> field
  contains first the BibTeX key. Additional information (e.g. page,
  game number...) may be added by <b>, addinfo</b>. To give more than
  one bibliographic link several of this entries may be separated by
  <b> ; </b> (ie. space semicolon space). To resolve the bibliographic
  reference, Scid first searches a .bib-file named like the database
  in the database directory. If it can not find such a file it resorts
  to <b>~/.scid/data/Bookshelf.bib</b>.
  </p>
  <p>
  The fifth line shows the <a ECO>ECO</a> (Encyclopedia of Chess
  Openings) code for the current position, if the position appears in
  the ECO file being used.
  </p>
  <p>
  If Scid can find a suitable photo file (either in ~/.scid or Scid's
  share directory within the photos folder) and photos for the players
  exist, also these photos show up in the information area. (Suitable
  photo files can be downloaded from the <url
  http://scid.sourceforge.net/>Scid website</url>; a documentation of
  their format is contained within these files.) However, the player
  photos tend to hide some text in the information area.  Therefore,
  they can be minimised temporarily by clicking on them.
  </p>
  <p>
  The game information area has a menu activated with the right mouse button,
  with options to hide the next move (useful if you are training using a game
  and want to guess each move) and to delete or undelete the current game.
  You can also activate this menu without using the mouse, by pressing the
  <b>[F9]</b> function key.
  </p>
  <p>
  On the right hand side of the board the material balance can be
  displayed by small piece symbols. E.g. if white has captured a
  bishop while black has captured a knight, a white bishop and a black
  knight show up.
  </p>
  
  <h4>Tablebases</h4>
  <p>
  The game information area also displays tablebase results whenever the
  displayed position reaches a material configuration found in a
  tablebase file. See the <a TB>tablebases</a> help page for details.
  </p>
  
  <h3>The status bar</h3>
  <p>
  The status bar shows information about the current database.
  The first field indicates the game status: <b>XX</b> means it has been
  altered and not yet saved, while <b>--</b> means it is unchanged,
  and <b>%%</b> indicates the database is read-only (not alterable).
  </p>
  <p>
  If you want a database to be opened read-only, just set the permissions
  of its Scid files, or at least its index file, for example:
  <b>chmod a-w myfile.si3</b>
  as a shell command, and it will be opened read-only by Scid.
  </p>
  <p>
  The status bar also shows how many games are currently in the
  <a Searches Filter>filter</a>.
  </p>
  
  <p><footer>(Updated: Scid 4.3, October 2011)</footer></p>
}


####################
### Menus help screen:

set helpTitle(Menus) "Menus"
set helpText(Menus) {<h1>Scid menus</h1>
  
  <h3><name File>File</name></h3>
  <ul>
  <li><menu>New</menu>: Creates a new empty Scid database.</li>
  <li><menu>Open</menu>: Opens an existing Scid database.</li>
  <li><menu>Close</menu>: Closes the current Scid database.</li>
  <li><menu>Finder</menu>: Opens the <a Finder>File Finder</a>.</li>
  <li><menu>Bookmarks</menu>: <a Bookmarks>Bookmarks</a> and bookmark
  functions.</li>
  <br>
  <li><menu>Open base as tree</menu>: Opens the tree window for a
  selected database</li>
  <li><menu>Open recent base as tree</menu>: Offers a list of recently
  opened bases to get their tree window.</li>
  <br>
  <li><menu>Maintenance</menu>: Database <a Maintenance>maintenance</a>
  functions.</li>
  <ul>
  <li><menu>Maintenance window</menu>: Opens/closes the database maintenance
  window.</li>
  <li><menu>Delete twin games</menu>: Finds <a Maintenance Twins>twin</a>
  games in the database.</li>
  <li><menu>ECO-Classify games</menu>: Recomputes the
  <a ECO>ECO code</a> for all games in the database. </li>
  <li><menu>Name editor</menu>: Replaces all occurrences of a player,
  event site or round name.</li>
  </ul>
  <li><menu>Read-Only</menu>: Makes the current database read-only.</li>
  <br>
  <li><menu>Switch to Database</menu>: These commands let you switch between
  the 8 available database slots and the <a Clipbase>clipbase</a>
  database.</li>
  <li>1/2/3/4/5/...</li> Offers a list of recently used databases for
  easy recall.</li>
  <li><menu>Exit</menu>: Exits Scid. </li>
  </ul>
  
  <h3><name Edit>Edit</name></h3>
  <ul>
  <li><menu>Add Variation</menu>: Adds a new empty variation for the
  next move, or for the previous move if there is no next move yet.</li>
  <li><menu>Delete Variation</menu>: Provides a submenu of variations for
  the current move, so one can be deleted.</li>
  <li><menu>Make First Variation</menu>: Promotes a variation to be the
  first variation of the current move.</li>
  <li><menu>Promote Variation to Main line</menu>: Promotes a variation
  to be the main line, swapping it with its parent.</li>
  <li><menu>Try Variation</menu>: Enters <a Moves Trial>trial mode</a> for
  testing a temporary variation without altering the current game.</li>
  <li><menu>Strip</menu>: Strips all comments or variations from the current
  game.</li>
  <li><menu>Undo</menu>: Allows to undo up to 10 recent changes.</li>
  <br>
  <li><menu>Empty Clipbase</menu>: Empties the <a Clipbase>clipbase</a>
  so it contains no games.</li>
  <li><menu>Copy this game to clipbase</menu>: Copies the current game
  to the <a Clipbase>clipbase</a> database. Additionally, the games
  current <term>PGN notation</term> is added to the system clipboard.</li>
  <li><menu>Paste last clipbase game</menu>: Pastes the active game of
  the <a Clipbase>clipbase</a> to be the active game of the current
  database.</li>
  <br>
  <li><menu>Setup start board</menu>: Sets the starting position for the
  current game.</li>
  <li><menu>Copy position</menu>: Copies the current position as
  <term>FEN notation</term> to the system clipboard.</li>
  <li><menu>Paste start board</menu>: Sets the start board from the current
  text selection (clipboard). This selection has to be a valid
  <term>FEN</term> notation.</li>
  </ul>
  
  <h3><name Game>Game</name></h3>
  <ul>
  <li><menu>New Game</menu>: Resets the active game to an empty state,
  discarding any unsaved changes.</li>
  <li><menu>Load First/Previous/Next/Last Game</menu>: These load the first,
  previous, next or last game in the <a Searches Filter>filter</a>.</li>
  <li><menu>Reload this game</menu>: Reloads the current game, discarding
  any changes made.</li>
  <li><menu>Load Game Number</menu>: Loads the game given its game number
  in the current database.</li>
  <br>
  <li><menu>Save: Replace game</menu>: Saves the current game, replacing
  its original version in the database.</li>
  <li><menu>Save: Add new game</menu>: Saves the current game as a new
  game, appending to the end of the database.</li>
  <br>
  <li><menu>Identify opening</menu>: Finds the deepest
  position in the current game that is in the ECO file.</li>
  <li><menu>Goto move number</menu>: Goes to the specified move number in
  the current game.</li>
  <li><menu>Find novelty</menu>: Finds the first move of the current game
  that has not been played before in the current base.</li>
  </ul>
  
  <h3><name Search>Search</name></h3>
  <ul>
  <li><menu>Reset Filter</menu>: Resets the <a Searches Filter>filter</a>
  so all games are included. This does not affect a filter created by
  an eventually opened <a Tree>tree window</a>.</li>
  <li><menu>Negate filter</menu>: Inverts the filter criteria that are
  not set by an eventually opened <a Tree>tree window</a>.</li>
  <br>
  <li><menu>Current board</menu>: Searches for the
  <a Searches Board>current board</a> position.</li>
  <li><menu>Header</menu>: Searches by <a Searches Header>header</a>
  information such as player names. This filter is cumulative to
  a filter eventually set by an open <a Tree>tree window</a>.</li>
  <li><menu>Material/Pattern</menu>: Searches by
  <a Searches Material>material</a> or chessboard patterns</a>. This
  filter is cumulative to a filter eventually set by an open <a
  Tree>tree window</a>.</li>
  <br>
  <li><menu>Using search file</menu>: Searches using
  <a Searches Settings>settings</a> from a SearchOptions file. This
  filter is cumulative to a filter eventually set by an open <a
  Tree>tree window</a>.</li>
  </ul>
  
  <h3><name Windows>Windows</name></h3>
  <ul>
  <li><menu>Comment Editor</menu>: Opens/closes the
  <a Comment>Comment Editor</a> window.</li>
  <li><menu>Game List window</menu>: Opens/closes the
  <a GameList>Game List window</a>.</li>
  <li><menu>PGN window</menu>: Opens/closes the
  <a PGN>PGN window</a>.</li>
  <li><menu>Tournament Finder</menu>: Opens/closes the
  <a Tmt>Tournament Finder</a> window.</li>
  <br>
  <li><menu>Database switcher</menu>: Opens/closes the
  <a Switcher>Database Switcher</a> window, which lets you switch to
  another database or copy games between databases easily.</li>
  <li><menu>Maintenance window</menu>: Opens/closes the database
  <a Maintenance>maintenance</a> window.</li>
  <br>
  <li><menu>ECO Browser</menu>: Opens/closes the
  <a ECO browser>ECO Browser</a> window.</li>
  <li><menu>Statistics window</menu>: Opens/closes the
  <term>Filter statistics window</term> which gives a win/loss summary
  of the games in the <a Searches Filter>filter.</a></li>
  <li><menu>Tree window</menu>: Opens/closes the <a Tree>tree window</a>.</li>
  <li><menu>Endgame Tablebase window</menu>: Opens/closes the window that
  displays <a TB>tablebase</a> information.</li>
  <li><menu>Correspondence window</menu>: Opens/closes the window for
  for handling correspondence chess games.</li>
  </ul>

  <h3><name Play>Play</name></h3>
  <ul>
  <li><menu>Serious game</menu>: Allows to play an installed
  <term>UCI</term> chess engine in a serious game, ie. in tournament
  conditions.</li>
  <li><menu>Tactical game</menu>: Allows to play the Phalanx chess
  engine at an adjustable level.</li>
  <li><menu>Play on FICS</menu>: Gives access to the Free Internet
  Chess Server (FICS) to play games of chess against human opponents
  or chess engines, observe games, or take part in trainings
  sessions.</li>
  <li><menu>Training</menu>: access various trainings modes available
  in Scid.</li>
  <li><menu>Correspondence Chess</menu>: access the functions for
  <a CCSetupDialog>correspondence chess configuration</a> and <a
  Correspondence>game play</a></li>
  <ul>
	  <li><menu>Configure</menu>: allows <a
	  CCSetupDialog>configuration</a> of the <a
	  Correspondence>correspondence chess</a> subsystem.
	  </li>
	  <li><menu>Observe games</menu>: allows to observe games by
	  fetching them from a website.
	  </li>
	  <li><menu>Open database</menu>: opens the default correspondence
	  chess database (cf. <a CCSetupDialog>configuration</a>)
	  </li>
	  <li><menu>Retrieve games</menu>: Fetch games form a server using
	  the <a CCXfcc>Xfcc</a> protocol.
	  </li>
	  <li><menu>Process inbox</menu>: Processes the correspondence
	  chess <a CCWorkflow>inbox to work in new games and moves</a> into
	  the current database. 
	  </li>
	  <li><menu>Send move</menu>: Transmits to a server a move using
	  the <a CCXfcc>Xfcc</a> protocol.
	  </li>
	  <li><menu>Resign</menu>: resigns the current game (requires <a
	  CCXfcc>Xfcc</a>.)
	  </li>
	  <li><menu>Claim draw</menu>: claim a draw in the current game (requires <a
	  CCXfcc>Xfcc</a>.)
	  </li>
	  <li><menu>Offer draw</menu>: offer a draw in the current game
	  (requires <a CCXfcc>Xfcc</a>.)
	  </li>
	  <li><menu>Accept draw</menu>: accept the draw offer from the
	  opponent (requires <a CCXfcc>Xfcc</a>.)
	  </li>
	  <li><menu>Game page</menu>: opens the web page associated with a
	  <a CCXfcc>Xfcc</a> game.
	  </li>
	  <li><menu>New eMail Game</menu>: starts a new eMail based game.
	  </li>
	  <li><menu>Mail move</menu>: mails the move to the opponent in an
	  email based game.
	  </li>
  </ul>
  </ul>
  
  <h3><name Tools>Tools</name></h3>
  <ul>
  <li><menu>Analysis engine</menu>: Displays a list of all installed
  chess engines available for analysis to select and start one of
  them as analysis engine 1.</li>
  <li><menu>Analysis engine #2</menu>: Displays a list of all installed
  chess engines available for analysis to select and start one of
  them as analysis engine 2.
  </li>
  <li><menu>Start engine 1</menu>: Starts/stops the chess analysis
  engine, displaying the evaluation of the current position
  in the <a Analysis>analysis window</a>.</li>
  <li><menu>Start engine #2</menu>: Starts/stops a second analysis
  engine.</li>
  <li><menu>Crosstable</menu>: Constructs a tournament
  <a Crosstable>crosstable</a> for the current game. </li>
  <li><menu>Email manager</menu>: Opens/closes the <a Email>email manager</a>
  window, for managing email correspondence games.</li>
  <br>
  <li><menu>Rel. filter graph</menu>: Generates a <a
  FilterGraph>relative filter graph</a> e.g. to investigate popularity
  of the current opening by comparison of the current position against
  the whole database.
  </li>
  <li><menu>Abs. filter graph</menu>:  Generates a <a
  FilterGraph>absolute filter graph</a>
  </li>
  <li><menu>Opening report</menu>: Generates an
  <a Reports Opening>opening report</a> for the current position.</li>
  <li><menu>Piece Tracker</menu>: Opens the <a PTracker>piece tracker</a>
  window.</li>
  <li><menu>Book tuning</menu>: allows to adjust the probability
  values of a moved played in a selectable <a Book>opening book</a>).
  </li>
  <li><menu>Connect hardware</menu>: Allows external hardware to be
  used to enter moves. (E.g.  DGT electronic chessboard, Novag
  Citrine) 
  <ul>
		<li><menu>Configure</menu>: allows  <a HardwareConfig>basic
		parameters</a> to be set for usage of external hardware
		</li>
		<li><menu>Connect Input Engine</menu>: hooks up with hardware
		that supplies an Input Engine compatible driver (e.g. <url
		http://dgtdrv.sourceforge.net>dgtdrv website</url>.)
		</li>
		<li><menu>Connect Novag Citrine</menu>: hooks up with a Novag
		Citrine board.
		</li>
  </ul>
  </li>
  <br>
  <li><menu>Player information</menu>: Displays <a PInfo>player information</a>
  for one of the two players of the current game.</li>
  <ul>
	<li><menu>White</menu>: use the White player of the current game.</li>
	<li><menu>Black</menu>: use the Black player of the current game.</li>
  </ul>
  <li><menu>Player report</menu>: generates a <a Reports Player>player
  report</a>
  <li><menu>Rating graph</menu>: Displays the
  <a Graphs Rating>rating graph</a>.</li>
  <li><menu>Score graph</menu>: Displays the
  <a Graphs Score>score graph</a>.</li>
  <br>
  <li><menu>Export current game</menu>: Saves the current game to a text
  file in PGN, HTML or LaTeX format. See the <a Export>export</a> help
  page.</li>
  <li><menu>Export all filter games</menu>: Saves all games in the
  search <a Searches Filter>filter</a> to a text file in PGN, HTML or
  LaTeX format. See the <a Export>export</a> help page.</li>
  <br>
  <li><menu>Import <a PGN>PGN</a> game</menu>: Opens the <a Import>Import window</a>
  for entering a game by typing or pasting its text in
  <a PGN>PGN format</a>.</li>
  <li><menu>Import file of <a PGN>PGN</a> games</menu>: Imports a whole file containing
  games in <a PGN>PGN</a> format to the current database. Note, that several PGN
  files can be selected in this dialogue at once.</li>
  </ul>
  
  <h3><name Options>Options</name></h3>
  <p>
  This menu provides entries for setting most of Scid's configurable
  options.
  The <menu>Save options</menu> entry saves the current options to the
  file "<b>~/.scid/config/options.dat</b>" (or "<b>options.dat</b>" in the
  sub directory "<b>config</b>" of the Scid executable programs for Windows
  users); this file is loaded each time you start up Scid.
  </p>
  
  <h3><name Help>Help</name></h3>
  <p>
  This menu contains help functions, and access to the tip of the day
  window or the startup window which provides information about the
  files Scid loaded when it started.
  </p>
  
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}


####################
### Entering moves help:

set helpTitle(Moves) "Entering moves"
set helpText(Moves) {<h1>Entering chess moves</h1>
  <p>
  In Scid, you can enter the moves for a game using the
  mouse or the keyboard. As you move the mouse over a square,
  it and one other square will change color if there is a legal
  move to or from that square. This is the <term>suggested move</term>.
  To make this move simply click the <term>left</term> mouse button.
  You can turn off move suggestion using the Options menu if it annoys you.
  </p>
  <p>
  To make any move other than the suggested move, you can use
  the <term>left</term> mouse button: just press the button over one square,
  and release it over the other square.
  </p>
  <p>
  If you want to enter a variation without being asked for a
  confirmation, use the middle mouse button of the mouse to enter the
  move.
  </p>
  <p>
  Depending on <menu>Options / Moves / Highlight last moves</menu> and
  the settings made there, Scid will mark the last move by a coloured
  frame around the involved fields.
  </p>
  
  <h4>Retracting a move</h4>
  <p>
  To take back a move, press the right mouse button, Control + Delete
  or Control + Backspace. This goes back one move, and deletes the
  move if it is the last in the game or variation.
  </p>
  
  <h4>Replacing old moves</h4>
  <p>
  When you enter a move at a point in the game where a move already exists,
  Scid will present a dialog box asking if you really want to replace the
  old move (the old move and all moves after it will be lost), or want
  to add the new move as a variation instead. Some people may find this
  dialog box annoying and always want to replace old moves, so it can be
  turned off with the <menu>Options: Moves</menu> menu option
  "<i>Ask before replacing moves</i>".
  </p>

  <h4>Marking fields and directions</h4>
  <p>
  colored squares and arrows can be entered directly on the board
  without the use of the <a Comment>Comment editor</a> by using the mouse
  buttons. For colored squares one can Shift-click on the square in
  question. Shift-Left button marks the square in green, the middle
  button in yellow, the right button in red. To draw arrows one can
  Ctrl-click on the source and target squares. The left mouse button
  again results in a green, the middle in a yellow and the right mouse
  button in a red arrow.
  </p>
  
  <h4><name Trial>Trial mode</name></h4>
  <p>
  If you are studying a game and reach a position where you want to try
  an alternative variation on the board without altering the game, select
  <b>Try variation</b> from the <menu>Edit</menu> menu to enter trial
  mode. In this mode, you can make temporary moves and changes to the
  game, then return to the original position when you exit trial mode.
  </p>
  
  <h3><name Mistakes>Correcting mistakes</name></h3>
  <p>
  If you are entering a game and suddenly see an incorrect move several
  moves earlier, it is possible to correct it without losing the extra
  moves you have added. The only way is to edit the <a PGN>PGN</a> representation
  of the game: open the <a Import>Import</a> window, select "Paste current
  game", correct the incorrect move, then select "Import".
  </p>
  
  <h3>Keyboard move entry</h3>
  <p>
  To enter moves at the keyboard, simply press letter and digit
  keys. Note that accepted moves should be in <term>SAN notation</term>,
  <i>without</i> the capture symbol (x) or the promotion symbol (=).
  Moves are matched case-insensitively, so you can type
  [n][f][3] instead of Nf3, for example -- but see the note below
  about conflicts with pawn moves.
  </p>
  <p>
  To ensure that no move is a prefix of any other move, the notation
  for kingside and queenside castling is [O][K] and
  [O][Q] respectively, instead of the usual O-O and O-O-O.
  </p>
  <p>
  As you enter a move, the status bar will show the list of matching moves.
  You can press the [space] bar at any time to choose the first
  matching move in the list and add it to the game.
  To delete a character, press [Backspace] or [Delete].
  </p>
  <p>
  <b>Note</b> that a lower-case letter matches to a pawn first, so a
  [b] can match to a pawn or Bishop, but if there is a conflict
  you must use a capital [B] for the Bishop move.
  </p>
  
  <h4>Auto-Completion</h4>
  <p>
  In the Options menu, you can turn on or off <term>Auto-Completion</term>
  of moves.
  With auto-completion, a move is made as soon as you have typed enough
  to distinguish it from any other legal move. For example, with
  auto-completion, you would only need to type [n][f] instead
  of [n][f][3] for <b>Nf3</b> in the starting position.
  </p>
  
  <h3><name Null>Entering null moves</name></h3>
  <p>
  <a Annotating Null>Null</a> (empty) moves can be useful in variations, where
  you want to skip a move for one side. You can enter a null move with the
  mouse by capturing one king with the other king, or with the keyboard by
  typing "<b>--</b>" (that is, pressing the minus key twice).
  </p>
  
  <h3><name Informant>Entering common annotation symbols</h3>
  <p>
  You can also add common <a NAGs>annotation symbols</a> using the keyboard
  in the main window, without needing to use the <a Comment>comment editor</a>
  window. The following list shows which symbols you can add, and their
  keyboard shortcuts:
  <ul>
  <li> !  : [!][Return] </li>
  <li> ?  : [?][Return] </li>
  <li> !? : [!][?][Return] </li>
  <li> ?! : [?][!][Return] </li>
  <li> !! : [!][!][Return] </li>
  <li> ?? : [?][?][Return] </li>
  <li> </li>
  <li> +- : [+][-] </li>
  <li> +/-: [+][/] </li>
  <li> += : [+][=] </li>
  <li> =  : [=][Return] </li>
  <li> -+ : [-][+] </li>
  <li> -/+: [-][/] </li>
  <li> =+ : [=][+] </li>
  </ul>
  <b>Note</b> Scid uses some of these symbols for automatic
  annotations, also. To this end, these symbols have to be associated
  with a certain pawn value. These pawn values can be set via Options
  / Game information / Configure Informant values. Note that since
  Scid 4.0 many NAGs can be displayed symbolically if your system
  supports UTF-8 properly. The connection between a NAGs numeric value
  and its symbolic representation within Scid is given on the page <a
  NAGs>Standard NAG values</a> which can be accessed e.g. by Ctrl-N
  from the <a Comment>Comment editor</a>
  
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}


########################################
### Searches help screen:

set helpTitle(Searches) "Searches"
set helpText(Searches) {<h1>Searches in Scid</h1>
  <p>
  Scid can perform many different types of search on a database.
  The three main types of search are:
  <ul>
  <li><b>1)</b> for the current board, </li>
  <li><b>2)</b> for specified material and piece patterns, and </li>
  <li><b>3)</b> by header information such as players, result, date. </li>
  </ul>
  <p>
  In addition to these, there is also an automatic search mode called the
  <a Tree>Tree window</a> which is explained separately.
  </p>
  
  <h3><name Filter>The Search Filter</name></h3>
  <p>
  Searches in Scid are based on the concept of a <term>filter</term>.
  The filter represents a subset of the current database; at any time,
  each game is either included in or excluded from the filter.
  </p>
  <p>
  With each type of search, you can choose to restrict the existing
  filter, add to it, or ignore it and search the whole database.
  This choice permits complex searches to be built up incrementally.
  </p>
  <p>
  You can also copy all games in the filter of one database to another,
  using the <a Switcher>database switcher</a> window.
  </p>
  <p>
  With exact position, <a Tree>tree</a> or material/pattern searches, the
  move number of the first matching position of each matching game is
  remembered, so when you load each game it will show the matching position
  automatically.
  </p>
  <p>
  <b>Note</b> that searches only apply to the main line moves of a game,
  not to any moves in variations.
  </p>
  
  <h3><name Board>Search: Current Board</name></h3>
  <p>
  This search finds games that contain the current displayed position,
  ignoring castling and <i>en passant</i> rights.
  </p>
  <p>
  There are four board search types available. All four require a position
  to have the same exact material and side to move for a match.
  The types are:
  <ul>
  <li> [1] exact (the two positions must match on every square), </li>
  <li> [2] pawns (the pawn structure must match exactly, but other pieces
  can be anywhere), </li>
  <li> [3] files (the number of white and black pawns on each file must match
  exactly, but other pieces can be anywhere), and </li>
  <li> [4] material (pawns and pieces can be anywhere). </li>
  </ul>
  <p>
  The pawns search is useful for studying openings by pawn structure, and
  the files and material searches are useful for finding similar positions
  in an endgame.
  </p>
  <p>
  To search for an arbitrary position, you can set the position first
  (from the <menu>Edit: Setup Start Board</menu> menu) and then
  start the search.
  </p>
  <p>
  You can request that the search look in variations (instead of only
  examining actual game moves) by selecting the <b>Look in variations</b>
  checkbox, but this may make the search much slower if your database
  is large and has many games with variations.
  </p>
  
  <h3><name Material>Search: Material/Pattern</name></h3>
  <p>
  This search is useful for finding endgame or middlegame themes.
  You can specify minimum and maximum amounts of each type of material,
  and find patterns such as a Bishop on f7, or a pawn on the f-file.
  </p>
  <p>
  A number of common material and pattern settings are provided, such
  as Rook vs. Pawn endings, or isolated Queens pawns.
  </p>
  <p>
  <b>Hints:</b><br>
  The speed of pattern searches can vary widely. You can reduce the time
  needed for a search by setting restrictions intelligently. For example,
  if you set the minimum move number to 20 for an ending, all games that
  end in under 20 moves can be skipped.
  </p>
  
  <h3><name Header>Search: Header</name></h3>
  <p>
  This search can be used to find aspects of the game that are stored
  in the header (such as date, result, names, flags and ratings), so
  it does not require any moves to be decoded.
  </p>
  <p>
  For a game to match a Header search, <b>all</b> fields that you
  specify must match.
  </p>
  <p>
  The name fields (White, Black, Event, Site and Round) match on any text
  inside the name, case-insensitive and ignoring spaces.
  </p>
  <p>
  You can do case-sensitive wildcard searches for the White, Black, Event,
  Site and Round fields (with <b>?</b> representing one character and
  <b>*</b> representing zero or more characters) by putting the
  search text in double quotes. For example a search for the site <b>USA</b>
  will find American cities and also <b>Lausanne SUI</b>, which is probably
  not what you wanted! A search for the site <b>"*USA"</b> (remember to
  use the double-quotes) will only match cities in the United States.
  </p>
  <p>
  If you are searching for a particular player (or pair of opponents) as White
  or Black and it does not matter what color they played, select the
  <b>Ignore Colors</b> option.
  </p>
  <p>
  Additionally, an Annotator may be searched case insensitively. Note
  that this function requires the <b>Annotator</b> header field to be
  set properly. The checkbox <menu>annotated games only</menu> acts as
  a logical OR filter for the flags <b>Comments, Variations,
  Annotations</b>, that is can be used to select only those games that
  got any type of annotations.
  </p>
  <p>
  Finally, the Header search can be used to find any text
  (case-sensitive and without wildcards) in the <a PGN>PGN</a> representation of
  each game.  You may enter up to three text phrases, and they must
  all appear in a game for it to be a match.  This search is very
  useful for searching in the comments or extra tags of a game (such
  as <b>lost on time</b> or <b>Annotator</b>), or for a move sequence
  like <b>Bxh7+</b> and <b>Kxh7</b> for a bishop sacrifice on h7 that
  was accepted.  However, this type of search can be <i>very</i> slow
  since all the games that match other criteria must be decoded and
  scanned for the text phrases.  So it is a good idea to limit these
  searches as much as possible.  Here are some examples.  To find
  games with under-promotions to a rook, search for <b>=R</b> and also
  set the <b>Promotions</b> flag to Yes.  When searching for text that
  would appear in comments, set the <b>Comments</b> flag to Yes.  If
  you are searching for the moves <b>Bxh7+</b> and <b>Kxh7</b>, you
  may want to restrict the search to games with a 1-0 result and at
  least 40 half-moves, for example, or do a material/pattern search
  first to find games where a white bishop moves to h7.
  </p>
  <p>
  <b>Note</b> If a search by <a ECO>ECO</a> code is performed, games
  that have no ECO code attached are ignored.
  </p>
  
  <h3><name Settings>Saving search settings</name></h3>
  <p>
  The Material/Pattern and Header search windows provide a
  <term>Save settings</term> button. This lets you save the current
  search settings for later use, to a <term>SearchOptions</term> file
  (suffix .sso).
  To search using a previously saved SearchOptions (.sso) file, select
  <menu>Open</menu> from the <menu>Search</menu> menu.
  </p>
  
  <h3>Search times and skipped games</h3>
  <p>
  Most searches produce a message indicating the time taken and the number
  of games that were <term>skipped</term>. A skipped game is one that can
  be excluded from the search without decoding any of its moves, based on
  information stored in the index. See the help page on
  <a Formats>file formats</a> for more information.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}


#################
### Clipbase help:

set helpTitle(Clipbase) "The Clipbase"
set helpText(Clipbase) {<h1>The Clipbase database</h1>
  <p>
  In addition to the databases you have open, Scid provides
  a <term>clipbase</term> database, which is just like any other database
  except that it exists in memory only and has no files for permanent storage.
  </p>
  <p>
  The clipbase is useful as a temporary database, for merging
  the results of searches on more than one database or for treating the
  results of a search as a separate database.
  </p>
  <p>
  For example, assume you want to prepare for an opponent and have searched
  a database so the <a Searches Filter>filter</a> contains only games where
  the opponent played White.
  You can copy these games to the clipbase (by dragging from their database
  to the clipbase in the <a Switcher>database switcher</a> window),
  switch to the clipbase database, and then open
  the <a Tree>Tree window</a> to examine that players repertoire.
  </p>
  <p>
  Note that you can copy games in the filter of one database directly to another
  opened database (without needing the clipbase as an intermediary
  location) using the <a Switcher>database switcher</a> window.
  </p>
  <p>
  Note that the clipbase <i>cannot</i> be closed; selecting the
  <menu>File: Close</menu> command while in the clipbase is equivalent
  to <menu>Edit: Reset Clipbase</menu> which empties the clipbase.
  </p>
  <p>
  The clipbase has a limit of 100,000 games at any time, since it exists in
  memory only.
  </p>
  
  <p><footer>(Updated: Scid 3.6.8,March  2007)</footer></p>
}

#################################
### Variations and comments help:

set helpTitle(Annotating) "Annotating games"
set helpText(Annotating) {<h1>Annotating games</h1>
  <p>
  Scid lets you add notes to games. There are three types of
  annotation you can add after a move: symbols, a comment, and
  variations. This section describes manual annotations, see the <a
  Analysis Annotating>Analysis</a> for engine supported analysis.
  </p>
  
  <h3>Symbols and comments</h3>
  <p>
  Symbols are used to indicate an evaluation of the position (such as
  "+-" or "=") or point out good ("!") and bad ("?") moves, while
  comments can be any text. To add symbols and comments to a game, use
  the <a Comment>Comment editor</a> window.
  There is also a help page listing <a NAGs>standard symbol values</a>.
  </p>
  <p>
  Note that each move can have more than one annotation symbol, but only
  one comment. A comment before the first move of the game is printed as text
  before the start of the game.
  </p>
  
  <h3><name Vars>Variations</name></h3>
  <p>
  A <term>variation</term> of a move is an alternative sequence of
  moves at a particular point in a game. Variations can contain
  comments and even recursively have sub-variations. The buttons
  above the board with a "<b>V</b>" symbol, and commands in the
  <menu>Edit</menu> menu, can be used to create, navigate and edit
  variations.
  </p>
  
  <h4>Keyboard shortcuts</h4>
  <p>
  When a move has variations, they are shown in the game information
  area. The first will be named <b>v1</b>, the second <b>v2</b>, etc.
  You can click on a variation to enter it, or press "<b>v</b>". In
  the latter case the <term>Variation</term> window will pop up
  allowing to select a variation using the cursor keys. Setting
  Options / Moves / Show variation window will pop up this window
  automatically every time a move with a variation is found while
  navigating through the game using the cursor keys. In the variation
  window one can enter the variation by selecting it with the up/down
  cursor keys and hitting enter or clicking on it with the mouse. This
  allows for navigation through the game with the cursor keys only.
  To leave a variation, you can use the "<b>z</b>" shortcut key. At
  the beginning of the variation, the up arrow can be used
  alternatively.
  </p>
  <p>
  Note that in case a game has variations you can also enter the
  variation by just playing the move of the variation in question. To
  explicitly add a new variation starting with the same move (e.g. to
  simplify deeply nested variation trees) press Ctrl-A to explicitly
  add a variation and only then play the move.
  </p>
  <p>
  Setting Options / Moves / Show arrows for variations may be set to
  display the existing variations on the main board. This can be
  especially helpful on computers with small displays (Netbooks)
  and/or in conjunction with disabling both PGN window and game
  information area (Options / Windows / Show game information).
  </p>
  
  <h3><name Null>Null moves</name></h3>
  <p>
  Sometimes, you may find it useful in a variation to skip over a move
  for one side. For example, you may want to add the move 14.Bd3 to
  a variation and point out that it threatens 15.Bxh7+ Kxh7 16.Ng5+
  with an attack. You can do this by making a <term>null move</term>
  between 14.Bd3 and 15.Bxh7+, in the above example. A null move is
  displayed as "<b>--</b>" and can be inserted using the mouse by making
  an illegal move of capturing one king with the other, or from the
  keyboard by typing "<b>--</b>" (two minus signs).
  </p>
  <p>
  Note that null moves are not a part of the <a PGN>PGN</a> standard, so if you
  export games with null moves to a <a PGN>PGN</a> file, Scid will provide (among
  other export options) an option to preserve null moves or convert them
  to comments for compatibility with other software.
  See the <a Export>Exporting</a> help page for more details.
  </p>
  <p>
  Also note, that Scid is capable of handling the move <term>Z0</term>
  as a null move, a notation that is common in some commercial chess
  applications.
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

###############################
### Comment editor window help:

set helpTitle(Comment) "Comment Editor window"
set helpText(Comment) {<h1>The Comment Editor window</h1>
  <p>
  The Comment Editor window lets you add or edit comments and symbolic
  annotation symbols for moves in the active chess game.
  </p>
  
  <h3>Annotation symbols</h3>
  <p>
  Scid uses the <a Author Related>PGN standard</a> for annotation
  symbols, accepting <a NAGs>NAG (numeric annotation glyph)</a> values
  for annotations.  Some of the most common symbols (such as "!" or
  "+-") are displayed as symbols, and have a button in the comment
  editor window for fast entry. For other symbols, you can enter the
  appropriate numeric NAG value which is a number from 1 to 255.  For
  example, the NAG value 36 means "White has the initiative" and will
  be displayed as "$36" in the <a PGN>PGN text</a> of the game. If
  your system properly supports UTF-8 character sets many of the NAG
  symbols can be displayed by their <a NAGs>glyphs</a>. 
  </p>
  <p>
  See the help page of <a NAGs>NAG values</a> for NAG values defined
  by the <a PGN>PGN</a> standard. This page can be accessed from the
  Comment editor by pressing Ctrl-N.
  </p>
  <p>
  <b>Hint:</b> You can add the common move evaluation symbols (!, ?,
  !!, ??, !? and ?!) while in the main window, without needing to use
  the comment editor window, by typing the symbol followed by the
  [Return] key.  This is especially useful if you are <a
  Moves>entering chess moves</a> using the keyboard. Also note that
  the <a PGN>PGN window's</a> context menu offers many of the most
  common symbols for direct annotation.
  </p>
  
  <h3>Comments</h3>
  <p>
  You can edit comments by typing in the text area provided and using
  the Clear, Revert and Store buttons. You do not need to press the
  Store button to update a comment; it is automatically updated
  whenever you leave the comment editor window e.g. by activating
  another window or tab.
  </p>
  <p>
  You can move through the moves of a game directly from within the
  comment editor by pressing Alt and the left/right cursor keys. To
  jump from the NAG entry and the free text entry Alt-N may be used
  for speedy navigation.
  </p>
  <p>
  <b>Hint:</b> To add a comment before the first move in a variation,
  go to the first move and hit the left arrow key once and then insert
  the comment. Also note that by pressing Ctrl-A a variation can be
  added right from within the comment editor. This eases creation
  of a pre move comment for the first move of a variation.
  </p>
  
  <h3>Coloring squares</h3>
  <p>
  Colored markers may be added to the chess board by drawing them on
  the little helper board that can be expanded left of the comment
  window. The display of this board is toggled by <button tb_coords>.
  Scid will remember the state of this board if options are saved.
  Once the little helper board is expanded, select the marker to use
  from the buttons below the board, and the color from the color
  palette above and just click on the square to mark.
  </p>
  <p>
  A square may also be colored by using a special embedded command
  which can appear anywhere in a comment. The command format is:
  </p>
  <ul>
  <li><b>[%draw marker,square,color]</b><li>
  </ul>
  <p>
  where <b>square</b> is a square name like d4 and <b>color</b> is any
  recognized color name (such as red, blue4, darkGreen, lightSteelBlue, etc)
  or RGB code (a <b>#</b> followed by six hexadecimal digits, such as #a0b0c8).
  If the color is omitted, it defaults to <red>red</red>.
  <b>marker</b< may be full,circle,disk,x,+,-,?,!,= or the numbers
  1..9.
  </p>
  <p>
  A comment may contain any number of color commands, but each must have
  in its own <b>[%draw...]</b> tag.
  For example, the comment text</p>
  <p>
  Now d6 [%draw full,d6,red] is weak and the knight can attack it
  from b5. [%draw circle,b5,#000070]
  </p>
  <p>
  will color d6 <red>red</red> and b5 with the dark-blue color
  <darkblue>#000070</darkblue>.
  </p>
  
  <h3>Drawing arrows</h3>
  <p>
  You can draw an arrow from one square to another using a special
  comment command similar to the for coloring squares described above.
  The format is:
  </p>
  <ul>
  <li><b>[%arrow fromSquare toSquare color]</b><li>
  </ul>
  <p>
  where <b>fromSquare</b> and <b>toSquare</b> are square names like d4
  and <b>color</b> is any recognized color name (such as red, blue4, etc)
  or RGB code (like #a0b0c0).
  If the color is omitted, it defaults to <red>red</red>.
  </p>
  <p>
  For example, the comment text
  </p>
  <p>
  The c3-knight and c4-bishop control the weak d5 square.
  [%arrow c3 d5 red] [%arrow c4 d5 blue]
  </p>
  <p>
  will draw a red arrow from c3 to d5 and a blue one from c4 to d5.
  </p>

  <p>
  <b>Note</b>
  Colored squares and arrows can be entered directly on the board
  without the use of the Comment editor by using the mouse
  buttons. For colored squares one can Shift-click on the square in
  question. Shift-Left button marks the square in green, the middle
  button in yellow, the right button in red. To draw arrows one can
  Ctrl-click on the source and target squares. The left mouse button
  again results in a green, the middle in a yellow and the right mouse
  button in a red arrow.
  </p>
  
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}

####################
### Crosstable window help:

set helpTitle(Crosstable) "Crosstable window"
set helpText(Crosstable) {<h1>The Crosstable window</h1>
  <p>
  The crosstable window shows the tournament crosstable for the
  current game. Each time you refresh the crosstable window (by
  pressing its Refresh button, by pressing the <b>Return</b> key in the
  crosstable window, or by typing <b>Control+Shift+X</b> in the
  <a MainWindow>main</a> or <a GameList>game list</a> windows), Scid
  searches for all games in the same tournament as the current game.
  </p>
  <p>
  Any game played up to <b>twelve months before or after</b> the current game,
  with the <b>exact same Event and Site tags</b>, is considered to be in
  the tournament.
  </p>
  <p>
  A single left-mouse button click on any result in the crosstable
  loads the corresponding game.
  You can add all the games in the tournament to the
  <a Searches Filter>filter</a>
  with the <b>Add to filter</b> button in the crosstable window.
  </p>
  
  <h4>Crosstable window menus</h4>
  <p>
  The <menu>File</menu> menu lets you print the current table to a file
  in plain text, LaTeX or HTML table format.
  </p>
  <p>
  The <menu>Display</menu> menu allows you to choose the table format:
  <b>All-play-all</b>, <b>Swiss</b> or <b>Knockout</b> or <b>Auto</b>.
  </p>
  <p>
  The all-play-all format (for round-robin-type events) has a limit of 30
  players, but the Swiss format (for tournaments with many players) can
  display up to 200 players and up to 20 rounds. <b>Auto</b>, which chooses
  the best format automatically for each tournament, is the default.
  </p>
  <p>
  Note that Scid uses the <b>Round</b> tag of each game to produce a Swiss
  crosstable, so you will not see any games in the Swiss table for a tournament
  if its games do not have numeric round values: 1, 2, 3, etc.
  </p>
  <p>
  The Display menu also lets you customize the data presented to
  include or exclude ratings, countries and player titles. You can also
  choose whether color allocations in Swiss tables are displayed.
  </p>
  <p>
  The <b>Separate score groups</b> option only affects the layout of the table
  when the players are sorted by score: it causes a blank line to be inserted
  between each group of players with the same score.
  </p>
  <p>
  The <menu>Sort</menu> menu allows you to sort the players by name, rating
  or score; by score is the default.
  </p>
  <p>
  The <menu>Color</menu> menu lets you turn color (hypertext) display on or off.
  Since it can take a long time to format and display large crosstables in
  hypertext, selecting <b>Plain text</b> for large events will save a
  lot of time.
  However, in plain text mode you cannot click on players or games.
  </p>
  
  <h4>Duplicate games in crosstables</h4>
  <p>
  To get good results with the crosstable, you should mark duplicate games
  for deletion and your games should have consistent spelling of player,
  site and event names.
  See the <a Maintenance>database maintenance</a> page for help on
  deleting duplicate games and editing (or spellchecking)
  player/event/site names.
  </p>
  
  <p><footer>(Updated: Scid 3.6.15, May 2007)</footer></p>
}


####################
### Database switcher help:

set helpTitle(Switcher) "Database Switcher"
set helpText(Switcher) {<h1>The Database Switcher window</h1>
  <p>
  The Database Switcher window provides a view which makes it easy to
  switch between databases or copy games between databases.
  The name, <a Searches Filter>filter</a> state and graphic type icon
  of each database is displayed, and the active database is highlighted
  with a yellow background.
  </p>
  <p>
  You can open the database switcher window from the <menu>Windows</menu> menu,
  or by its shortcut key: <b>Control+D</b>.
  </p>
  <p>
  To copy all the filtered games in one database to another, drag with the
  left mouse button from the source base to the target base. You will then
  see a confirmation dialog (if the target database is not the
  <a Clipbase>clipbase</a>) if the games can be copied, or an error message
  if the games cannot be copied (for example, if a selected database is not
  open).
  </p>
  <p>
  Pressing right mouse button over a database produces a popup menu applying
  to that database, from which you can change the database type icon or
  reset its <a Searches Filter>filter</a>. You can also use this menu to
  change the orientation of the window (to arrange the database slots
  vertically or horizontally) which is useful for smaller screens.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}


####################
### File Finder window help:

set helpTitle(Finder) "File Finder window"
set helpText(Finder) {<h1>The File Finder window</h1>
  <p>
  The <term>File Finder</term> helps you find files of any type you can
  use in Scid: databases, <a PGN>PGN</a> files, <a EPD>EPD</a> files,
  and <a Repertoire>repertoire</a> files.
  </p>
  <p>
  The Finder shows useful information about each file, such as its size
  (see below) and date of last modification. You can open any displayed
  file by selecting it with a single left mouse button click.
  </p>
  
  <h3>Looking in subdirectories</h3>
  <p>
  When you want to find all files in all subdirectories of the current
  directory, turn on the <b>Look in subdirectories</b> checkbox. This
  will make Scid recursively examine every subdirectory for files that
  can be opened in Scid. This can take a long time if there are many
  subdirectories, so you may not want to do it for a directory near the
  root of the file system. You can interrupt the file search by pressing
  the <b>Stop</b> button.
  </p>
  
  <h3>File sizes</h3>
  <p>
  The meaning of a file size displayed by the Finder depends on the file
  type. For Scid databases, it is the number of games. For
  all other files, it is the size in kilobyte.
  </p>

  <p>
  For easy manipulation of Scid databases, the Finder offers a context
  menu. From this menu, accessible by a right mouse click as usual,
  the following functions can be performed
  <ul>
      <li><term>Open</term> will open the file in question, this is
      the same as just clicking on the file with the left mouse
      button.</li>
      <li><term>Backup</term> copies the file to its original name
      appended by the current date and time.</li>
      <li><term>Copy</term> copies the selected database to a new
      location.</li>
      <li><term>Move</term> moves the selected database to a new
      location.</li>
      <li><term>Delete</term> deletes the selected database.</li>
   </ul>
   These functions are especially helpful for Scid databases as these
   consist of several files.
  </p>
}

####################
### Tournament Finder window help:

set helpTitle(Tmt) "Tournament Finder window"
set helpText(Tmt) {<h1>The Tournament Finder window</h1>
  <p>
  The <term>Tournament Finder</term> lets you find tournaments in the
  current database. It scans all the database games and collates data
  about the tournaments found. Note that two games are considered to
  be in the same tournament if they have the same Event tag, same Site
  tag and were played within three months of each other.
  </p>
  <p>
  You can limit the list of tournaments by the number of players and
  games, date, mean Elo rating and country, by editing the fields below
  the tournament list and then pressing the <b>Update</b> button.
  </p>
  <p>
  The displayed list can be sorted by date, number of players, number
  of games, mean Elo rating, site, event or the surname of the winner.
  Select the category from the <menu>Sort</menu> menu or click on a
  column title to change the sort field.
  </p>
  <p>
  To load the first game of any displayed tournament, just click the
  left mouse button when its line is highlighted. This will also
  update the <a Crosstable>Crosstable</a> window if it is open.
  If you press the right mouse button instead, the game will be loaded
  and the Crosstable window will be opened even if it is closed.
  </p>
  <p>
  To speed up the tournament searching process, it is a good idea to
  set a fairly small date range (like a few years at most) or select
  a particular country (by its three-letter standard code). Doing
  these will greatly reduce the number of games Scid has to consider
  when trying to form tournaments out of the games in the database.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### GameList window help:

set helpTitle(GameList) "Game List window"
set helpText(GameList) {<h1>The Game List window</h1>
  <p>
  The Game List window displays a one-line summary for each game included
  in the current <term>filter</term>.
  </p>
  
  <h3>Navigating the game list</h3>
  <p>
  You can scroll the game list using the slider bar or the four
  buttons under the list.
  You can also use the [Home], [End],
  [Page Up], [Page Down] and arrow keys to scroll
  using the keyboard.
  </p>
  <p>
  You can find the next game in the list which has certain text in its
  White, Black, Event or Site field, using the <b>Find text</b> box.
  </p>
  
  <h3>Actions on games in the list</h3>
  <p>
  To load a game from the game list, double-click the left mouse button
  on the game.
  Clicking the middle mouse button shows the initial moves of a game;
  this can be useful for checking a games opening before loading it.
  </p>
  <p>
  The right mouse button produces a menu for the selected game, in which
  you can browse or merge the game (see below), delete (or undelete) the
  game, or exclude it from the filter.
  Note that deleting a game only turns on its delete flag; it will remain in
  the database until you <a Compact>compact</a> it.
  </p>
  
  <h3>Configuring the game list</h3>
  <p>
  Click the left or right mouse button on a column title to configure the
  game list. You can alter widths, add or remove columns, and change
  the color for each column.
  </p>
  <p>
  If you only want to change the width of a column, there is a shortcut:
  while pressing the <b>Control</b> (or <b>Shift</b>) key, pressing
  the left mouse button on the column title will make it narrower
  and pressing the right mouse button will make it wider.
  </p>
  
  <h3>Altering the size of the game list</h3>
  <p>
  The size of the game list window is stored in the options file
  whenever you save options.
  So if you want the game list to show 10 games by default, just resize
  the game list window and then select <menu>Save options</menu>
  from the <menu>Options</menu> menu.
  </p>
  
  <h3><name Browsing>Browsing and merging games</name></h3>
  <p>
  The game list right-mouse menu (and some other windows, such as the
  <a Reports Opening>opening report</a> window and the
  <a Tree Best>best games list</a> of the <a Tree>tree</a> window)
  provide the choice of loading, browsing or merging a game.
  </p>
  <p>
  When <term>Browse game</term> is selected, the moves of the selected
  game (without comments or variations) will be displayed in a separate
  window. This is a useful way of previewing another game without
  affecting the currently loaded game. The size of this window may be
  changes by +/- keys or Ctrl-Mousewheel.
  </p>
  <p>
  The <term>Merge game</term> feature provides a way to include the
  selected game as a variation of the current game. Scid finds the
  deepest point where the selected game differs from the current
  game (taking transpositions into account) and adds a variation
  for the selected game at that position. The selected game can also be merged
  with the current game of another opened base (this base must not be set read only).
  You can change the number
  of moves of the selected game to be shown, depending on whether you
  are interested in adding the whole game or just its opening phase.
  </p>
  
  <p><footer>(Updated: Scid 3.7.2, april 2009)</footer></p>
}


####################
### Import window help:

set helpTitle(Import) "Import window"
set helpText(Import) {<h1>The Import window</h1>
  <p>
  Scid's Import window provides an easy way for you to paste a game
  in <a PGN>PGN format</a> into Scid from some other application or window.
  </p>
  <p>
  The large white frame in the window is where you type or paste
  the text of the game in <a PGN>PGN</a> format, and the gray frame below it
  provides feedback of any errors or warnings.
  </p>
  
  <h3>Editing the current game with the Import window</h3>
  <p>
  The Import window also doubles as a convenient way to make a few changes
  to the current game: you can paste the current game into the
  Import window (with the <b>Paste current game</b> button), edit the
  text, and click <b>Import</b> when done.
  </p>
  
  <h3>PGN tags in the Import window</h3>
  <p>
  Scid expects to see <a PGN>PGN</a> header tags such as
  <ul>
  <li> <b>[Result "*"]</b> </li>
  </ul>
  before any moves, but you can just paste in a game fragment like
  <ul>
  <li> <b>1.e4 e5 2.Bc4 Bc5 3.Qh5?! Nf6?? 4.Qxf7# 1-0</b> </li>
  </ul>
  without any header tags and Scid will import it.
  </p>
  
  <h3>Using <a PGN>PGN</a> files in Scid</h3>
  <p>
  If you want to use a <a PGN>PGN</a> format file in Scid but do not
  want to convert it with <a Pgnscid>pgnscid</a> first, there are two
  possible ways.
  </p>
  <p>
  First, you can import the games in the file to an existing database
  with the <menu>Tools: Import file of <a PGN>PGN</a> games...</menu> menu command.
  </p>
  <p>
  The alternative is to open the <a PGN>PGN</a> file directly in Scid. However, PGN
  format files are opened read-only and consume more memory than a
  comparable Scid database, so this is only recommended for relatively
  small <a PGN>PGN</a> files.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Exporting help:

set helpTitle(Export) "Exporting games"
set helpText(Export) {<h1>Exporting games</h1>
  <p>
  You can use commands under the <menu>Tools</menu> menu to export the
  current game or all games in the current filter to a text file.
  </p>
  <p>
  Four text file formats are available: <a PGN>PGN</a> (portable game
  notation), HTML (for web pages), HTML and JavaScript (for
  interactive web pages) and LaTeX (a popular typesetting system).
  </p>
  <p>
  When exporting, you can choose to create a new file, or add the
  games to an existing file of games exported by Scid.
  </p>
  
  <h3>Diagrams</h3>
  <p>
  When exporting in HTML or LaTeX format, Scid will automatically add
  a diagram wherever a diagram <a NAGs>nag</a> ("D") or a <a
  Comment>comment</a> that starts with the character "#" appears in
  the game.
  </p>
  
  <h3><name Null>Null moves in <a PGN>PGN</a> Export</name></h3>
  <p>
  Scid allows <a Annotating Null>null (empty) moves</a> to be stored
  in games, as they can be helpful when annotating games using
  variations.  However, the <a PGN>PGN</a> standard has no null move concept. So
  if you export Scid games with null moves to a <a PGN>PGN</a> file, other
  PGN-reading software will not be able to read the null moves.
  </p>
  <p>
  To solve this problem, Scid provides an extra option,
  <b>Convert null moves to comments</b>, when exporting games in <a PGN>PGN</a> format.
  If you want to create a <a PGN>PGN</a> file that other software can use, turn this
  option on and variations containing null moves will be converted to
  comments. However, if you want to create a <a PGN>PGN</a> file that can be imported
  back into Scid later with null moves preserved, leave the option off.
  </p>
  
  <h3>HTML Export</h3>
  <p>
  Scid can export games to an HTML file. For diagrams to appear, you
  will need the diagram images (distributed with Scid in the directory
  "<b>bitmaps/</b>") to be in a subdirectory <b>bitmaps/</b> under the
  directory the HTML file is in.
  </p>

  <h3>HTML with JavaScript Export</h3>
  <p>
  While the HTML export generates a static file that may contain
  static board diagrams, this format offers dynamic HTML, that allows
  to move through the game interactively with the mouse.
  </p>
  <p>
  This format consists of several files that need to be stored in a
  specific structure. Therefore, it is advisable to first generate a
  empty folder that will contain these files. The name of the main
  file can be specified and it will get the extension html (e.g.
  mygame.html). This file should be loaded by the web browser. The
  other files are required to exist in exactly the position the export
  filter places them. However, the whole folder can easily be uploaded
  to some web server.
  </p>
  
  <h3>LaTeX Export</h3>
  <p>
  Scid can export games to a LaTeX file.  Games be printed two columns
  to a page and moves are in figurine algebraic notation with proper
  translation of the NAG symbols. Diagrams are added whenever a
  <term>D</term> comment is found.
  </p>
  <p>
  See the <a LaTeX>Using LaTeX with Scid</a> help page for more information.
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### LaTeX help:

set helpTitle(LaTeX) "Scid and LaTeX"
set helpText(LaTeX) {<h1>Using LaTeX with Scid</h1>
  <p>
  Scid can save games and opening reports to files in LaTeX format.
  LaTeX is an extension to TeX, a popular typesetting system.
  </p>
  <p>
  To typeset the LaTeX files produced by Scid, you must have
  LaTeX (of course) and have the "chess12" chess font package installed.
  This font package is usually not part of standard LaTeX installations,
  so even if you have LaTeX, you may not have the chess font.
  </p>
  <p>
  For information about downloading and installing the LaTeX chess font,
  visit the
  <url http://scid.sourceforge.net/latex.html>Using LaTeX with Scid</url>
  page at the <url http://scid.sourceforge.net/>Scid website</url>.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### <a PGN>PGN</a> window help:

set helpTitle(PGN) "PGN window"
set helpText(PGN) {<h1>The <a PGN>PGN</a> window</h1>
  <p>
  Scid's <a PGN>PGN</a> window displays the contents of the current game in
  standard <a PGN>PGN</a> representation. In the move text, comments appear {in
     braces} and variations appear (in parentheses).
  </p>
  
  <h3>PGN format</h3>
  <p>
  <a PGN>PGN</a> (Portable Game Notation) is a common standard for transferring
  chess games between computer programs.  A <a PGN>PGN</a> game consists of two
  sections. The first is the header, which contains tags such as
  <b>[White "Kasparov, Gary"]</b>
  and
  <b>[Result "1/2-1/2"]</b>.
  </p>
  <p>
  The second section contains the actual moves of the game, in
  standard algebraic notation (SAN) along with any variations,
  <a NAGs>annotation symbols</a> and <a Comment>comments</a>.
  </p>
  
  <h3>Actions in the <a PGN>PGN</a> window</h3>
  <p>
  You can use the <a PGN>PGN</a> window to navigate around the game: clicking the
  left mouse button on a move will jump to that move. Click the left
  mouse button on a comment will edit it.  The arrow keys and
  (<b>v</b> and <b>z</b> keys for entering or leaving variations) work
  for game navigation just as in the main window.  As in the main
  window, hitting v will cause the <term>Variation</term> window to
  pop up allowing to select a variation using the cursor keys. Setting
  Options / Moves / Show variation window will pop up this window
  automatically every time a move with a variation is found while
  navigating through the game using the cursor keys. In the variation
  window one can enter the variation by selecting it with the up/down
  cursor keys and hitting enter or clicking on it with the mouse. This
  allows for navigation through the game with the cursor keys only.
  Clicking on a move with middle mouse button will display a small
  board. Clicking on right mouse button will popup a contextual menu.
  </p>
  <p>
  From the context menu the following functions are available
  <ul>
     <li><term>Delete Variation:</term>
     Deletes the current variation
     </li>
     <li><term>Make First Variation:</term>
     Moves the current variation to the first position of all
     variations on that level
     </li>
     <li><term>Promote Variation to Mainline</term>
     Promotes the current variation to the mainline and demotes the
     current mainline to a variation.
     </li>
     <li><term>Strip:Moves from the beginning</term>
     </li>
     <li><term>Strip:Moves to the End</term>
     </li>
     <li><term>Strip:Comments</term>
     Removes all comments
     </li>
     <li><term>Strip:Variations</term>
     Removes all variations
     </li>
  </ul>
  </p>

  <h3>PGN display options</h3>
  <p>
  The <a PGN>PGN</a> window menus contain options that affect the <a PGN>PGN</a> window display.
  Scid can display the game in color or plain text -- see the
  <menu>Display</menu> menu in the <a PGN>PGN</a> window.
  The color display is easier to read, and allows you to select moves and
  comments using the mouse, but it is much slower to update. For very long
  games, you may want to select plain text display.
  </p>
  <p>
  You can also alter the format of comments and variations, choosing
  to display them indented on a separate line for greater visibility.
  </p>
  <p>
  The <a PGN>PGN</a> display options, and the size of the <a PGN>PGN</a> window, are saved to the
  options file whenever you <b>Save Options</b> from the <menu>Options</menu>
  menu of the main window.
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}


####################
### Piece Tracker help:

set helpTitle(PTracker) "Piece tracker"
set helpText(PTracker) {<h1>The Piece Tracker window</h1>
  <p>
  The <term>Piece Tracker</term> is a tool that tracks the movements
  of a particular piece in all games in the current filter, and
  generates a "footprint" showing how often each square has been
  visited by the piece.
  </p>
  <p>
  To use the Piece Tracker, first make sure the filter contains the
  games you are interested in, such as games reaching a particular
  opening position or all games where a certain player had the white pieces.
  Then, select the piece to track and set other tracking options; these are
  explained below. Then press the <b>Update</b> button.
  </p>
  <p>
  The tracked piece movement information is displayed in two ways: a
  graphical "footprint", and a text list with one line of data per square.
  </p>
  
  <h3>Selecting the tracked piece</h3>
  <p>
  The chess pieces are displayed as in the standard chess starting position
  below the footprint chart. A single piece (such as the White b1 knight or
  the Black d7 pawn) can be selected with the left mouse button, and all
  pieces of the same type and color (such as all White pawns or both Black
  rooks) can be selected using the right mouse button.
  </p>
  
  <h3>Other piece tracker settings</h3>
  <p>
  The move number range controls when tracking should start and stop in
  each game. The default range of 1-20 (meaning tracking should stop after
  Black's 20th move) is appropriate for examining opening themes, but (for
  example) a range like 15-35 would be better when looking for middlegame
  trends.
  </p>
  <p>
  There are two types of statistic the tracker can generate:
  <ul>
  <li> <b>% games with move to square</b>: shows what proportion of filter
  games contain a move by the tracked piece to each square. This is
  the default setting and usually the most suitable choice.
  <li> <b>% time in each square</b>: shows the proportion of time the
  tracked piece has spent on each square.
  </ul>
  </p>
  
  <h3>Hints</h3>
  <p>
  There are (at least) three good uses for the Piece Tracker: opening
  preparation, middlegame themes, and player preparation.
  </p>
  <p>
  For opening preparation, use the piece tracker with the <a Tree>Tree</a>
  opened. By tracking pieces you can see trends in the current opening
  such as common pawn pushes, knight outposts, and where the bishops are
  most often placed. You may find it useful to set the move number range
  to start after the current move in the game, so the moves made to reach
  the current position are not included in the statistics.
  </p>
  <p>
  For middlegame themes, the piece tracker can be useful when the filter
  has been set to contain a certain ECO range (using a
  <a Searches Header>Header search</a>) or perhaps a pattern such as a
  White IQP (using a <a Searches Material>Material/pattern search</a>).
  Set the move range to something suitable (such as 20-40), and track
  pieces to see pawn pushes in the late middlegame or early endgame,
  for example.
  </p>
  <p>
  For player preparation, use a <a Searches Header>Header search</a> or
  the <a PInfo>Player information</a> window to find all games by a
  certain player with one color. The Piece Tracker can then be used to
  discover how likely the player is to fianchetto bishops, castle
  queenside, or set up a d5 or e5 pawn wedge, for example.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Tree window help:

set helpTitle(Tree) "Tree window"
set helpText(Tree) {<h1>The Tree window</h1>
  <p>
  The <term>Tree</term> window displays information on all the
  moves made from the current position in games in the database.
  In tree mode, the tree window is updated automatically whenever the
  main windows board changes. This can be slow for large databases and
  can therefore be disabled using the <button tb_search_on>. To visualise
  that a tree is not automatically refreshed this button changes to
  <button tb_search_off>.
  </p>
  <p>To open the <term>Tree</term> window one can either first open a
  database and then choose Windows / Tree Window (Ctrl-T) from the
  menu, or open the base as tree right from the file menu.
  <p>
  Note that whenever the tree window is updated, the <a Searches
  Filter>filter</a> is reset and only the games that contain the
  current position will be included. This is also the case if e.g. a
  header search was done: once the next move is entered, the tree
  window updates and the filter is set to the games matching the tree
  window.
  </p>
  <p>
  Clicking the left mouse button on a move in the tree window adds
  that move to the game.
  </p>
  <h3>Tree window contents</h3>
  <p>
  The tree window shows the <a ECO>ECO code</a> (if any), frequency
  (both as number of games, and a percentage) and score of each move.
  The <term>score</term> is always computed from the <b>White</b>
  perspective, so 100% means all White wins and 0% means all Black
  wins. Scores are highlighted for moves that have good (green) or bad
  (red) results. On average a move should score 53.8% for white,
  highlighting appears if a move scores more than 3% better or worse
  than this average and if at least 15 games are contained in the
  database. The <term>AvElo</term> (average Elo) corresponds to the
  player's on move and <term>Perf</term> (performance) represents the
  opponent's strength. Additionally, <term>AvYear</term> shows the
  average year of games played in this move and <term>%Draws</term>
  gives the percentage of draws for the line displayed. All these
  values are calculated for the database displayed in the tree, and
  therefore depend of course on the games in this database.
  </p>
  <p>
  Additional information is displayed if a <term>Mask</term> has been
  opened. For the use of <term>Masks</term> see below.
  <p>
  The moves in the tree window can be sorted by move (alphabetically),
  ECO code, frequency, or score. You can change the sort method using
  the <menu>Sort</menu> menu.
  </p>

  <h3><name Best>Best games window</name></h3>
  <p>
  The tree window has a File menu command and button for opening the
  <term>Best games</term> window, which shows a list of the
  highest-rated games in the currently displayed tree branch.
  (Equivalently, one can use the <button tb_list> button).  The games
  are listed in order of average rating, and you can restrict the list
  to show games with a particular result and also limit the number of
  games shown in this list. Additionally, up to 4 flags of the games
  in the list show up in the best games list. The special flag
  <b>A</b> marks a game as <b>Annotated</a>, ie. these games contain
  either comments, variations or NAGs (or any combination of those).
  Note that if a header search was ran against the database, the best
  games list is restricted to the results of this header search.
  </p>
  
  <h3><name Graph>Tree graph window</name></h3>
  <p>
  The tree window buttons include a button marked <term>Graph</term>
  (<button tb_bargraph>) which produces a graphical display of the
  relative performance of each move from the current position.  All
  moves that have been played at least 1% of the time, and at least 5
  times, are displayed.  Percentage scores are always from White's
  perspective even when it is Black to move. The graphs can be saved
  in PostScript format via the file menu.
  </p>
  <p>
  In the tree graph, a red line is plotted showing the mean over all games
  from the current position, and the area between 50 and 55% (where most
  standard openings are expected to score) is colored blue
  to assist comparison of moves. Note that white usually scores around 55%
  in master level chess.
  </p>
  
  <h3><name Lock>Locking the tree window</name></h3>
  <p>
  Each tree window is associated with a specific base, that is, if
  several bases are opened simultaneously, several tree windows may
  exist. If the <term>Lock</term> button in the tree window is
  enabled, closing the tree window will also close the database
  associated with this specific tree. Additionally, this also closes
  associated graph or best games windows. If the <term>Lock</term>
  button is not checked closing the tree will leave all these windows
  opened and just close the tree view of the base.
  </p>
  <p>
  Note that opening a base as tree from the file menu will
  automatically lock the database by default.
  </p>
  
  <h3><name Training>Training</name></h3>
  <p>
  When the <term>Training</term> checkbox in the tree window is selected,
  Scid will randomly make a move every time you add a move to the game.
  The move Scid chooses depends on database statistics, so a move played
  in 80% of database games will be chosen by Scid with 80% probability.
  Turning on this feature, then hiding (or iconifying) the Tree window and
  playing openings against a large database, is a great way to test your
  knowledge of your opening repertoire. Another option to train an
  opening offers <a OpeningTrainer>Training / Openings</a>.
  </p>

  
  <h3>Caching for faster results</h3>
  <p>
  Scid maintains a cache of tree search results for the positions with the
  most matching games. If you move forward and back in a game in tree mode,
  you will see the tree window update almost instantly when the position
  being searched for is in the cache.
  </p>
  <p>
  The tree window has a file menu command named <term>Save Cache</term>.
  When you select this, the current contents of the tree cache in memory
  are written to a file (with the suffix <b>.stc</b>) to speed up future
  use of Tree mode with this database.
  </p>
  <p>
  The <term>Fill cache file</term> command in the file menu of the tree
  window fills the cache file with data for many opening positions.
  It does a tree search for about 100 of the most common opening positions,
  then saves the cache file.
  </p>
  <p>
  The maximum number of lines in the Cache can be configured by File /
  Cache size. The default are up to 1000 lines.
  </p>
  <p>
  Alternatively, one can fill the cache also with the content of a
  base or a game by choosing File / Fill Cache with base and File /
  Fill Cache with game, respectively. The cache will be filled with
  the contents of these including all variations. This is most helpful
  if one has one or more repertoire bases that can serve as input. (See
  also <a OpeningTrainer> about this type of bases.)
  <p>
  Tree refresh can be dramatically enhanced if the database is sorted
  by ECO code then compacted (see the <a Maintenance>maintenance</a>
  window). Once this is achieved (the whole process can last several
  hours), turn on the option <term>Fast mode</term>. The refresh of
  the Tree window will be 20 times faster in average at the cost of
  some inaccuracies (games not in current filter will not be taken
  into account). By turning off the <term>Fast mode</term> option you
  will see the difference in the number of games when all the
  transpositions are taken into account.  If you want to get a preview
  of statistics then get a precise Tree, use the option <term>Fast and
  slow mode</term> 
  </p>
  <p>
  Note that a tree cache (.stc) file is completely redundant; you can remove
  it without affecting the database, and in fact it is removed by Scid
  whenever an action occurs that could leave it out of date -- for example,
  adding or replacing a game, or sorting the database.
  </p>
  
  <p><footer>(Updated: Scid 4.3, November 2010)</footer></p>
}

set helpTitle(TreeMasks) "Masks for Trees"
set helpText(TreeMasks) {<h1>Masks for Trees</h1>
  <h3>Basics</h3>
  <p>
  The <term>Tree</term> window displays information on all the moves
  made from the current position in games in the database. See also <a
  Tree>The Tree window</a>  for more details.
  </p>
  <p>
  To add additional information beyond pure statistical data a
  <term>Mask</term> can be defined. One can imagine a
  <term>Mask</term> as a transparent layer above the current tree, that
  holds additional data e.g. commentaries for moves or positions, own
  evaluations and ones own opening repertoire. <term>Masks</term> are
  stored in a Mask file (.stm) and thus are independent of the
  databases to be used with. That is, one can define a
  <term>Mask</term> once and use it with various databases by just
  loading it from the <term>Tree</term> windows menu.
  </p>
  <p>
  As soon as a <term>Mask</term> file is opened, the displays of
  the <term>Tree</term> window change. First of all, all moves from
  the current position that are present in the mask are highlighted.
  Additionally, NAGs and markers may show up in front of a move or
  commentaries concerning the move will show up at the end of its
  line. Finally, the current position may also hold a comment.
  </p>
  <p>
  <b>Note</b>: The independence of <term>Masks</term> from a database
  make them a very powerful tool to handle opening repertoires.
  Contrary to the traditional way of opening lines, <term>Masks</term>
  have the advantage to handle transpositions transparently, simply
  cause they are based on the current positions instead of a line
  leading to it.
  </p>
  <h3>Using a Masks</h3>
  <p>
  As <term>Masks</term> operate on the tree view of a given database,
  first of all the tree view has to be opened either by <menu>Window /
  Tree window</menu> or the shortcut <b>ctrl-t</b>. For starting out
  it makes sense to open a larger reference database as this
  simplifies the addition of moves to a <term>Mask</term>. However,
  Masks work with every database, even the <term>Clipbase</term>, that
  is one could also import a collection of games from a <a PGN>PGN</a> file to
  the Clipbase to set up a <term>Mask</term>.
  </p>
  <p>
  Now, a mask file has to be created or loaded. These files use the
  extension .stm. To create a new mask file select <menu>Mask /
  New</menu> from the <term>Tree</term> windows menu. Similarly, an
  existing mask can be opened using <menu>Mask / Open</menu>. Finally,
  <menu>Mask / Open recent</menu> is a shortcut to the recently used
  <term>Mask</term> files. 
  </p>
  <p>
  Once a Mask file is opened new commentary can be added to this
  specific mask. Note again, that the Mask is independent of database
  used for its creation. It can later applied to any database of ones
  liking. For an opening repertoire it might thus make sense to
  generate two masks, one for the White and one for the Black
  openings.
  </p>
  <p>
  To add markers or comments to moves, first add the move
  to the mask by choosing <term>Add to mask</term> from the context
  menu available by clicking on the line with the right mouse button.
  After a line was added, it is highlighted in <blue>blue</blue>
  within the tree window. Similarly, a move can be removed from the
  mask by <menu>Remove from mask</menu> from the context menu.
  </p>
  <p>
  <b>Note</b>: If the move to be added is not displayed in the tree
  window Scid offers a list of all possible moves by means of the
  context menu. As this might be quite a bunch of moves, they are
  split into several context menu items at the end of the available
  choices. All are labeled by <menu>Add this move to mask</menu> and in
  case necessary numbered. Just select a move from one of those lists
  if it does not show up in the tree anyway.
  <p>
  After a move was added to the <term>Mask</term> and one can select
  the following markers from the context menu. These markers will show
  up left to the move annotated:
  <ul>
  <li><term>NAG</term> symbols are the simplest annotation symbol. The
  menu displays only those nags sensible for a move (not a position)
  which results in the following symbols possible <term>!!, !, !?, ?!,
  ?, ??, ~</term>
  </li>
  <li>By selecting <menu>Marker 1</menu> and <menu>Marker 2</menu> up
  to two additional graphical markers can be attached to a move. They
  are mainly meant to handle opening repertoires. The available options
  are:
     <ul>
     <li> <img tb_tick> Include line in repertoire</li>
     <li> <img tb_cross> Exclude line from repertoire</li>
     <li> <img tb_mainline> Main Line</li>
     <li> <img tb_bkm> Bookmark</li>
     <li> <img tb_white> White</li>
     <li> <img tb_black> Black</li>
     <li> <img tb_new> New line</li>
     <li> <img tb_rfilter> To be verified by further analysis</li>
     <li> <img tb_msearch> To train</li>
     <li> <img tb_help_small> Dubious line</li>
     <li> <img tb_cut> To remove</li>
     </ul>
	  To remove a marker just select the item <menu>No marker</menu>.
  </li>
  <li><term>Color</term> Allows to add a little colored square in
  front of the move for ones own highlighting. To remove it again
  select <menu>White</menu></li>
  <li><term>Comment move</term> allows to add a textual comment for
  the line. This comment is shown  right to the line it is
  associated. Note that only a part of the first line shows up there
  to give some visual feedback that commentary exists. The whole
  comment shows up in a tooltip once the mouse is moved over the line
  in question.
  </li>
  <li><term>Comment position</term> can be used to add a comment for the
  current position. This comment is shown on top of <term>Tree</term>
  window once the commented position is reached. Note that Scid
  displays only the first line of the comment to save space in the
  <term>Tree</term> window. However, if the mouse is moved over that
  line the whole commentary shows up in a tooltip.
  </li>
  </ul>
  Don't forget to save the Mask! You will be prompted to do it
  if you close a Mask that has been modified or if a <term>Tree</term>
  window is closed.
  </p>
  <p>
  To search for commentary, symbols etc. use <menu>Masks /
  Search</menu>. Here one can select various check boxes that use the
  selected search option as criterion. After selecting
  <button>Search</button> a list of all positions found is displayed
  in <term>FEN</term> notation followed by the move in question and
  the commentary if any.
  </p>
  <p>
  <menu>Display mask</menu> will display the current Mask in a line
  style. Stating at the current position all subsequent moves are
  sorted into some unfoldable tree to give an overview of the current
  lines of play similar to what is found in many repertoire books.
  Note that not all information are displayed (e.g. comments are
  shorted to fit the display). Additionally, as <term>Masks</term>
  work on positions rather than move sequences they may contain loops
  (ie. transpositions) which can not be unfolded in a line wise
  display perfectly. That is, this display may be cut at a certain
  point.
  </p>
  <h3>Conversion to Masks</h3>
  <p>
  Setting up a mask can be a tedious task especially for complex
  opening repertoires. However, if such a repertoire is available as a
  Scid database or a number of <a PGN>PGN</a> games, or lines stored in usual
  chess games, Scid can use that information to set up suitable
  <term>Masks</term> automatically.
  </p>
  <p>
  First of all one has to load the information into a Scid database.
  In case the information is already available as a Scid database this
  is as easy as opening it. In case a <a PGN>PGN</a> file is use it should be
  either imported into a Scid database or one can use the
  <term>Clipbase</term> to import it temporarily. In that case one
  should make sure that the <term>Clipbase</term> is empty before
  importing. (<menu>Edit / Empty Clipbase</menu>).
  </p>
  <p>
  The next step is to open the tree for the just opened Scid database.
  Then a new <term>Mask</term> should be created or an existing one
  opened. <b>Note</b> that this function may be used to consolidate
  several bases into a single <term>Mask</term>.
  </p>
  <p>
  Now, the <term>Mask</term> can be filled automatically with the game
  content of the database. In this process, comments within the games
  will be converted to move comments (appending to those existing
  eventually) in the <term>Mask</term>. <term>NAG</term> symbols will
  be added as well. To initiate this process one can chose either
  <menu>Masks / Fill with game</menu> to fill the <term>Mask</term>
  with the contents of a single game, or <menu>Fill with
  Database</menu> to loop over all games in the database.
  </p>
  <p>
  <b>Note</b>: especially filling a <term>Mask</term> with an entire
  base can be quite time consuming.
  </p>
  <p>
  <b>Note</b>: The <term>mask</term> is filled with all moves till the
  end of the game including all variations within a game. Therefore,
  it is sensible to use only bases for this procedure that end the
  games as soon as the middle game is reached.
  </p>

  <p><footer>(Updated: Scid 4.3, November 2010)</footer></p>
}

####################
### Compaction help:

set helpTitle(Compact) "Database compaction"
set helpText(Compact) {<h1>Database compaction</h1>
  <p>
  Database <term>compaction</term> is a specific type of
  <a Maintenance>maintenance</a> that keeps a database as small and
  efficient as possible.
  Compacting a database means removing any unused space in its files.
  There are two types: name file and game file compaction.
  </p>
  
  <h3>Name file compaction</h3>
  <p>
  Over time, you may find a database starts to contain a number of player,
  event, site or round names that are no longer used in any game. This will
  often happen after you spellcheck names. The unused names waste space in
  the name file, and can slow down name searches.
  Name file compaction removes all names that are not used in any games.
  </p>
  
  <h3>Game file compaction</h3>
  <p>
  Whenever a game is replaced or deleted, wasted space is left in the game
  file (the largest of the three files in a Scid database). Game file
  compaction removes all wasted space, leaving no deleted games in the
  database. Note that this operation is irreversible: after compaction,
  the deleted games are gone forever!
  </p>
  <p>
  Game file compaction is also recommended after <a Sorting>sorting</a> a
  database, to keep the order of the game file consistent with the sorted
  index file.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}


####################
### Database maintenance tools help:

set helpTitle(Maintenance) "Database maintenance"
set helpText(Maintenance) {<h1>Database maintenance</h1>
  <p>
  Scid provides a number of tools for maintaining databases,
  available from the Scid <a Menus File>File</a> menu. The
  database <a Compact>compaction</a> and <a Sorting>sorting</a>
  functions are explained in separate help pages.
  </p>
  
  <h3>Maintenance window</h3>
  <p>
  Most Scid database maintenance can be done from the Maintenance
  window, which can be opened from the <menu>File: Maintenance</menu>
  or <menu>Windows</menu> menus or the shortcut key <b>Ctrl+M</b>.
  </p>
  <p>
  You can use this window to maintain <a Flags>game flags</a>,
  spellcheck names, <a Compact>compact</a> or <a Sorting>sort</a>
  a database. Note that any operations that are not available
  for the current database (for example, because it may be read-only
  or a <a PGN>PGN</a> file) will be grayed out.
  </p>
  
  <h3><name Twins>Deleting twin games</name></h3>
  <p>
  The <menu>File: Maintenance</menu> menu has a command
  <menu>Delete twin games...</menu> for detecting extra copies
  (twins) of games in the database.
  This command finds all pairs of games that are twins and, for each pair,
  flags the shorter game deleted leaving the longer game undeleted.
  Two games are considered to be twins if their players
  (and any other tags that you can optionally specify) match exactly.
  </p>
  <p>
  If you specify the "same moves" option, each pair of games must have the
  same actual moves up to the length of the shorter game (or up to move 60,
  whichever comes first) to be twins.
  </p>
  <p>
  When you have deleted twins, it is a good idea to check that each
  game deleted really is a copy of another game.
  You can do this easily if you selected the
  "<b>Set filter to all deleted games</b>" option in the
  delete twins dialog box. The filter will now contain all deleted games.
  You can browse through them (using the <b>p</b> and <b>n</b> keys) with
  the <term>twins checker</term> window (available from the maintenance
  menu, or the shortcut key <b>Ctrl+Shift+T</b>) to verify that each game is
  deleted because it actually is a twin of another game.
  </p>
  
  <h3><name Editing>Editing player, event, site and round names</name></h3>
  <p>
  You may find mis-spelt names in your databases and want to correct them.
  You can do this in Scid with the <term>Name editor</term> window
  (shortcut key: <b>Control+Shift+N</b>),
  available from the <menu>File: Maintenance</menu> submenu.
  </p>
  <p>
  Each unique name is only stored once in the name file, so changing a name
  actually changes all occurrences of it.
  </p>
  
  <h3><name Spellcheck>Spellchecking names</name></h3>
  <p>
  Scid comes with a <term>spellcheck</term> file named <b>spelling.ssp</b>,
  for correction of player, event, site and round names.
  Scid will try to load the spellcheck file whenever it starts up; if it
  does not load, you can load it from the <menu>Options</menu> menu.
  </p>
  <p>
  Once the spellcheck file is loaded, you can use it on a
  a Scid database using the spellcheck commands in the
  <menu>File: Maintenance</menu> menu, or from the maintenance window.
  </p>
  <p>
  When you spellcheck a database, Scid produces a list of corrections that you
  can edit before actually making any corrections, so you can remove any
  corrections you do not want to make.
  </p>
  <p>
  Spellchecking is especially useful for standardizing a database so all
  instances of a particular player are spelt the same way.
  For example, with the standard spellcheck file, the names "Kramnik,V.",
  "Vladimir Kramnik", and "V. Kramnik" would all be corrected
  to "Kramnik, Vladimir".
  </p>
  <p>
  The spellcheck file has one
  additional use: when it is loaded, its player data is
  used to enhance the <a PInfo>player information</a> window and the
  <a Crosstable>crosstable</a> window:
  you will see FIDE master title
  (<b>gm</b> = International Grandmaster, <b>im</b> = International Master, etc)
  and country information for any player that is
  listed in the spellcheck file. Over 6500 strong players of the past and
  present are listed in the <b>spelling.ssp</b> file that comes with Scid.
  </p>
  
  <h3><name Ratings>Adding Elo ratings to games</name></h3>
  <p>
  The "Add Elo ratings..." button in the Maintenance window causes Scid
  to search the current database for games where a player does not have
  a rating, but the spellcheck file has an Elo rating listed for that
  player at the date of the game. Scid will add all such ratings
  automatically. This is very useful for a database of master-level games
  which has few ratings.
  </p>
  <p>
  The spellcheck file "spelling.ssp" that comes with Scid does not contain
  the Elo rating information needed for this function, but a larger version
  of it called "ratings.ssp" is available from the <url
  http://scid.sourceforge.net/>Scid website</url>.
  </p>
  
  <h3><name Cleaner>The Cleaner</name></h3>
  <p>
  The Scid <term>Cleaner</term> (available from the Maintenance window) is
  a tool for doing a number of maintenance tasks on a database in one
  action. You can choose which tasks you want to do, and Scid will
  perform them on the current database without requiring user interaction.
  This is especially useful for maintenance of large databases.
  </p>
  
  <h3>Setting the database autoload game</h3>
  <p>
  The <term>autoload</term> game of a database is the game automatically
  loaded whenever that database is opened. To change the autoload game of
  a database, use the "Autoload game number..." button. If you always want
  the last game of a database to be opened (regardless of the actual number
  of games in the database), just set it to a very high number such as
  9999999.
  </p>
  
  <h3>Repair a base</h3>
  <p>
  In the rare cases that a Scid database is corrupted one might try to
  repair it using File / Maintenance / Repair base. For this to work,
  the base in question must not be opened (which is not possible in
  most cases anyway). Scid will then try its best to get the database
  back in a consistent and usable state.
  </p>

  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Sorting help:

set helpTitle(Sorting) "Sorting a database"
set helpText(Sorting) {<h1>Sorting a database</h1>
  <p>
  The <term>sorting</term> function sorts all games in a database.
  You can select a number of sort criteria.
  When two games are equal according to the the first criteria, they
  are sorted using the second criteria, and so on.
  </p>
  
  <h3>Sort criteria</h3>
  <p>
  The available sorting criteria are:
  </p>
  <ul>
  <li> Date (oldest games first)
  <li> Year (same as date, but using the year only)
  <li> Event name
  <li> Site name
  <li> Country (last 3 letters of Site name)
  <li> Round name
  <li> White name
  <li> Rating (average of White and Black ratings, highest first)
  <li> Black name
  <li> Result (White wins, then draws, then Black wins)
  <li> Length (number of full moves in the game)
  <li> ECO (the <a ECO>Encyclopedia of Chess Openings code</a>)
  </ul>
  
  <h3>Sort results</h3>
  <p>
  When you sort a Scid database that is not read-only, the sort
  results are saved so the order of games in the database is
  permanently changed.  If you want to the sort results to be
  temporary, make the database read-only first using the <b>File:
  Read-only</b> menu command.
  </p>
  <p>
  When you sort a database that is read-only or is actually a PGN
  file, the sort results cannot be saved so the sorted order of games
  will be lost when the file is closed.
  </p>
  <p>
  Note that sorting a database resets the <a Searches Filter>search
  filter</a> to contain all games.
  </p>
  
  <h3>Important note about sorting databases:</h3>
  <p>
  When a database is sorted, the index file is altered but the game file
  is not changed. This means sorting a database will leave the game file
  records in a scrambled order relative to the index file. This can
  really <b>slow down</b> <a Tree>tree</a>, position and material/pattern
  <a Searches>searches</a>, so you should reorder the game file by
  <a Compact>compacting</a> it after sorting the database to maintain
  good search performance.
  </p>
  <p>
  Note that only a database sorted by <a ECO>ECO</a> codes can use the fast
  tree search modes. This however, also requires to compact the
  database after the sort procedure!
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Flags help:

set helpTitle(Flags) "Game Flags"
set helpText(Flags) {<h1>Game Flags</h1>
  
  <p>
  A <term>flag</term> is an indicator of some chess characteristic
  that can be turned on or off for each game in the database.
  There are 13 user-settable flags that you can directly set for
  each game. Of these, only the Delete flag has any special
  significance: games with the Delete flag turned on are marked
  for deletion and will removed when the database is
  <a Compact>compacted</a>.
  </p>
  <p>
  The other 12 user-settable flags and their symbols are:
  </p>
  
  <ul>
  <li>White opening (W)</li>
  <li>Black opening (B)</li>
  <li>Middlegame (M)</li>
  <li>Endgame (E)</li>
  <li>Novelty (N)</li>
  <li>Pawn structure (P)</li>
  <li>Tactics (T)</li>
  <li>Queenside play (Q)</li>
  <li>Kingside play (K)</li>
  <li>Brilliancy (!)</li>
  <li>Blunder (?)</li>
  <li>User-defined (U)</li>
  </ul>

  <p>
  Since Scid 4.0 additional 6 custom flags are available for
  individual use.  These flags are specific for each base and their
  textual description can be set via the <a Maintenance>maintenance
  window</a>. In the games list, game info area and so on they display
  as the numbers (1) .. (6). For <a Searches Header>header
  searches</a> they behave exactly like the predefined flags above.
  </p>
  
  <p>
  A flag can be set for the current game, all filter games, or all
  database games using the <a Maintenance>maintenance</a> window.
  </p>
  <p>
  You can use a <a Searches Header>header search</a> to find all
  games in a database that have a particular flag turned on or off,
  or use flags as part of more complex searches.
  </p>
  <p>
  Since all the user-settable flags (except the Delete flag) have
  no significance to Scid, you can use them for any purpose that
  suits your needs. For example, you could use the Kingside (K)
  flag for kingside pawn storms, or kingside heavy piece attacks,
  or even for endgames with all pawns on the kingside. Depending on
  usage, however a custom flag might be more suitable.
  </p>
  <p>
  Note, that sensible handling of flags can speed up searches
  significantly!
  </p>
  <p>
  The following functions of Scid set or require flags:
  <ul>
     <li><a OpeningTrainer>Opening Trainer</a>: can evaluate the (B) and (W) flags
     <li><a Analysis Annotate>Find best move</a>: evaluates the (T) flag
     <li><a Analysis Annotate>Find tactical exercise</a>: sets the (T) flag
  </ul>
  
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}

####################
### Analysis window help:

set helpTitle(Analysis) "Analysis window"
set helpText(Analysis) {<h1>The Analysis window</h1>
  <p>
  The Scid analysis window shows the analysis by a chess program
  (known as an <term>engine</term>) of the current board position.
  Whenever the board changes, Scid sends the new position to the
  engine and it shows its assessment of that position.
  Currently, up to two engines can be run simultaneously. To start the
  first analysis engine, the short cut <term>F2</term> can be used,
  for the second engine <term>F3</term>. To quickly close the engine
  window just hit <term>ESC</term>.
  </p>
  <p>
  The principal information of the current analysis is shown on
  top of the window. The first number signifies the evaluation value
  in pawn units.  The score shown in the analysis window is always
  from the perspective of White, so a negative score indicates Black
  is better. <b>Depth:</b> shows the search depth already reached by
  the engines calculations in half moves. The number after
  <b>Nodes:</b> gives the number of positions analysed for the current
  result while the number of positions per second (kn/s) is shown in
  brackets.  <b>Time:</b> finally shows the amount of time spent for
  the current analysis.
  </p>
  <p>
  Additional information can be accessed using the <button
  tb_engineinfo> button. A new line will be added to the status area
  showing the current move analysed, the number of tablebase hits, a
  more exact number of nodes analysed per second, the watermark of the
  engines hash and the current cpu load. Usually, this information is
  hidden to save space for the analysis.
  </p>
  <p>
  If the engine only analyses the line it considers the main
  continuation, the lower frame in the window (with the scrollbar)
  shows the history of evaluations produced by the engine for the
  current position, so you can see how the assessment has changed.
  </p>
  <p>
  Many recent <term>UCI</term> engines however allow to analyse
  several lines at once. Using this <term>Multi-PV</term> feature, the
  user can also see what the engine thinks is the second or third best
  continuation.  The best line is always on top and highlighted to
  ease reading.  If an engine allows for <term>Multi-PV
  analysis</term>, the spin box below the analysis lines can be used
  to set the number of principal variations that should be calculated
  and shown. In this case, instead of the calculation history, only
  the resulting principal lines are shown. However, if the number of
  principal lines is set to 1, one can again observe the evaluation
  history. The spin box is disabled, if an engine does offer this
  feature.
  </p>
  <p>
  <b>Note</b> the output of the current analysis can be hidden/shown
  by clicking with the right mouse button into the analysis window. In
  this mode only the current evaluation is shown in the status line.
  <p>
  To add the best move chosen by the engine as a new move in the current
  game, press the <b>Add move</b> button <button tb_addmove>. If the
  whole main line of the engine should be added just use the <b>Add
  Variation</b> button <button tb_addvar>. In case an engine offers
  the <term>Multi-PV</term> mode, using the <b>Add all Variations</b>
  button (<button tb_addallvars>) can be used to add all principal
  variations to the game. The insertion of variations from the
  analysis window will also add the name of the engine as a comment to
  the game.
  </p>
  <p>
  To temporarily interrupt the calculation process one can use the
  stop engine button (<button tb_eng_off>). Once pressed, this button
  changes to the start engine button (<button tb_eng_on>) which will
  restart the engines analysis. Note, however, that most engines will
  restart the whole analysis again, forgetting all results that where
  achieved in an earlier run. Only few engines are able to reuse the
  results they have calculated till the analysis was stopped. For the
  first analysis engine toggling start/stop engine is mapped to the
  hotkey <term>F4</term> while for the second engine <term>F5</term>
  can be used.
  </p>
  <p>
  To set an engine to analyse a position in the background while
  other functions of Scid are used one can <term>lock the
  position</term> using the <button tb_lockengine> button. Scid now
  stops to send any changes of the main board to the engine, and the
  engine stays calculating the position.
  </p>
  <p>
  To finish the current game by the engine ("shoot out" or "demo" mode)
  one can use the finish game button <button tb_finish_off>. To indicate
  the shootout mode this button turns to <button tb_finish_on>. This
  function is only available for the first analysis engine.
  </p>

  <h3><name List>The Analysis Engines List</name></h3>
  <p>
  Scid maintains a list of the engines you have used, along with an
  estimated Elo rating (if you guess one; additionally some pages on
  the Internet offer these values as results from large engine-engine
  tournaments) and the date when each engine was last used. You can
  sort the engine list by name, Elo rating, or date.
  Select the <b>New</b> or <b>Edit</b> buttons to add a new engine to
  the list or edit the details for an existing entry.
  </p>
  <h3><name Start>Engine commands and directories</name></h3>
  <p>
  For each engine, you must specify the executable file to run and
  which directory Scid should run it in.
  </p>
  <p>
  The most likely cause of engine starting problems is the choice of
  which directory the engine should run in. Some engines require an
  initialization or opening book file in their start directory to run
  properly.  Other engines (like Crafty) write log files to the
  directory they start in, so you will need to run them in a directory
  where you have write access.  If the directory setting for an engine
  is ".", Scid will just start the engine in the current directory.
  </p>
  <p>
  So if an engine that should work fine in Scid does not start, try
  changing its directory setting. To avoid engines creating log files
  in many different directories, I recommend starting engines in
  the directory of the Scid User files (this is where the <b>scid.exe</b>
  file is located on Windows, or <b>~/.scid/</b> on Unix); there is a
  button in the dialog box for editing engine details marked
  <b>scid.exe dir</b> on Windows or <b>~/.scid</b> on Unix that lets
  you set the engine to start in this directory.
  </p>
  <p>
  If an engine needs additional parameters for startup (e.g. a
  specific opening book) they can be specified in the
  <term>Parameters</term> field. Please refer to the engines
  documentation about the parameters required, if any.
  </p>
  <p><term>URL</term> allows you to set the engines homepage. This
  comes in handy to check for updates e.g. or to have a look at recent
  developments. Pressing the <term>Open...</term> button will open
  this page in the web browser.
  </p>
  <p>
  If the engine uses the <term>UCI</term> protocol please mark the
  associated checkbox. Generally, there are two major engine protocols
  available today: xboard sometimes referred to as winboard (UCI must
  not be checked) which many, especially older engines use, and the
  UCI protocol that can be found in most of the modern chess engines.
  The main advantage of an <term>UCI</term> engine is, that this
  protocol allows the user to configure the engines parameters from
  within his preferred chess GUI like Scid, while for the other
  engines usually configuration files are used that have to be edited.
  Therefore, if the engine is an <term>UCI</term> engine, pressing the
  <term>Configure UCI engine</term> button offers a graphical dialogue
  where all engine parameters can be tuned to the users liking. This
  dialogue will look different for each engine as each engine has
  other parameters that can be set. Most of them will influence the
  playing style of the engine. Please refer to the engines
  documentation.
  </p>

  
  <h3>Training</h3>
  <p>
  With the <b>Training</b> button, you can play moves against the analysis
  engine. The time for each move is fixed, and the analysis results are
  not shown when training mode is on.
  </p>
  
  <h3><a Annotate>Annotating a game</h3>
  <p>
  The <b>Add variation</b> button (<button tb_addvar> or <button
  tb_addallvars>)in the analysis window adds the current score and
  best line of play as a new variation in the game.
  </p>
  <p>
  You can do this automatically for a number of moves (annotating the
  game) by pressing the <b>Annotate</b> button, <button tb_annotate>.
  Besides, the engines best lines also <a Moves Informant>Informant</a>
  style evaluation symbols are added in this process.  First, the
  parameters for automatic annotations have to be set:
  <ul>
     <li><term>Set the time between moves in seconds:</term> this
     gives the time, the engine can spend on analysis before moving on
     to the next move.</li>
     <li><term>Add variations</term>: here, one has the choice if
     moves for both sides or only one color should be added, if all
     moves should get an annotation or only if the game move is not
     the best move according to the engines evaluation. Additionally,
     one can add an annotation only if the game move is a blunder. The
     threshold defines the drop of the evaluation necessary to signify
     a blunder, the number is given in units of pawns (i.e. 0.2 means
     that if the evaluation drops by more than 2 centi pawns, the game
     move is a blunder).
     </li>
     <li><term>Annotate variations</term> will include variations
     within the game in the analysis by the engine.</li>
     <li><term>Short annotations<term> will only add minimal
     annotations, that is the pure lines and NAG codes without the
     engines names and usually without the current scores.</li>
     <li><term>Add score to annotations</term> will add the engines
     evaluation in pawn units to the annotations. This information can
     be used later on to draw a <a Score>Score Graph</a> of the game
     as a visualisation of the positions reached.
     </li>
     <li><term>Add annotator tag</term> will add an "Annotator" tag to
     the game header. This is meant for the <term>Short
     annotations</term> mode which does not signify which engine was
     used to gain the current evaluations and lines.
     </li>
     <li><term>Use book</term> allows the specification of an opening
     book. Moves that are contained in this opening book are skipped
     in the annotation process, that is the annotation starts
     automatically in the middle game.</li>
     <li><term>Annotate several games</term>  Scid will first annotate
     the current game with the settings specified, store the results,
     then automatically load the next game and annotate that as well.
     This is repeated till the game loaded reaches the number given in
     the spin box. By this procedure, many games can be annotated
     automatically without any user intervention.
     </li>
     <li><term>Find opening errors</term> will check the opening phase
     up to the move specified for blunders. Additionally, the
     Annotator-tag gets an entry "opBlunder X" where X is the move the
     blunder occurred.
     </li>
     <li><term>Mark tactical exercises</term> This can be used to
     generate exercises for the training function <a FindBestMove>Find
     best move</a>. This option is only available for <term>UCI</term>
     engines.
     </li>
  </ul>
  After pressing the Ok button,  autoplay mode is enabled and the
  engine starts to analyse the game.  When autoplay mode is used and
  the analysis window is open, a variation containing the score and
  best line of play is automatically added for each position as
  autoplay mode moves through the game.  Only positions from the
  current position until the end of the game (or until you exit
  autoplay mode) are annotated, so you can skip annotation of opening
  moves by moving to a middlegame position before starting autoplay.
  </p>
  <p>
  To cancel annotation at any time, just turn off autoplay mode, for example by
  pressing the <b>Escape</b> key in the main window.
  </p>
  <p>
  Note that for simplicity, the <b>Annotate</b> button is only available
  in the window opened as analysis engine 1. If you open an engine as
  analysis engine 2, you cannot use it to annotate the game.
  </p>
  
  <h3>Analysis board</h3>
  <p>
  Pressing the button <button tb_coords> in an analysis window will
  show or hide the analysis board, which shows the position at the end
  of the current best line of play found by the engine. This works for
  most Scid-compatible engines but may not work for all; it depends on
  the move notation an engine uses.
  </p>
  
  <h3>Engine priority</h3>
  <p>
  If an engine is using too much CPU time and affecting the use of Scid
  or other applications, turning on the <b>Low CPU priority</b> button
  <button tb_cpu> may help; it gives the engine a low priority for CPU
  scheduling. On Windows, engines are run on low priority by default.
  </p>
  <p>
  <b>Note</b> that on Unix systems the engines priority can not be set
  back to normal.
  </p>

  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Calvar window help:

set helpTitle(CalVar) "Calculation of variation"
set helpText(CalVar) {<h1>The calculation of variation window</h1>
  <p>
   This training exercise is also known as the Stoyko exercise.  Its
   purpose is to analyse a complex position and evaluate as many sound
   lines as possible, and give a correct evaluation for each of them.
  </p> 
  <h3>Configuration</h3></p>
  <p>
  Three parameters are set :
  <ul>
     <li>The UCI engine that will analyse various lines</li>
     <li>The time, in seconds, the engine will use to analyse the position</li>
     <li>The time, in seconds, the engine will use to analyse each line entered by the user</li>
  </ul>
  </p>

  <h3>Entering lines</h3></p>
  <p>
  Moves are entered as usual with mouse clicks on the board but they
  will not be displayed. At the end of a line the user needs to provide
  an evaluation by clicking on one of the buttons with NAG codes.
  </p>

  <h3>Evaluation verification</h3>
  <p>
  Each time an evaluation is given to a line the engine calculates its
  value and append the line and score just below the user ones.
  </p>

  <h3>Done with position</h3>
  <p>
   When  the user thinks he found all best lines, pressing <term>Done with
   position</term> will append to the game (with the comment <term>Missed
   line</term>), the lines that have a score higher than the best line
   entered by the user.
  </p>

  <p><footer>(Updated: Scid 3.6.21, December 2007)</footer></p>
}


####################
### EPD files help:

set helpTitle(EPD) "EPD files"
set helpText(EPD) {<h1>EPD files</h1>
  <p>
  An EPD (extended position description) file is a collection of positions,
  where each position has some associated text. Like <a PGN>PGN</a>, it
  is a common standard for chess information.
  </p>
  <p>
  An EPD file has a number of defined <term>opcodes</term> (fields)
  which are stored separated by semicolons (<b>;</b>) in the file
  but are shown on separate lines in a Scid EPD window to make editing easier.
  A semicolon within an EPD field is stored as "<b>\s</b>" by Scid to
  distinguish it from an end-of-field marker.
  Each position and its associated opcodes are stored on one single line
  in the EPD file.
  </p>
  <p>
  Standard EPD opcodes include:
  <ul>
  <li> <b>acd</b> Analysis count: depth searched.</li>
  <li> <b>acn</b> Analysis count: number of nodes searched.</li>
  <li> <b>acs</b> Analysis count: search time in seconds.</li>
  <li> <b>bm</b> Best moves: move(s) judged best for some reason.</li>
  <li> <b>ce</b> Centipawn evaluation: evaluation in hundredths of a
  pawn from the perspective of the <b>side to move</b> -- note this
  differs from the Analysis window which shows evaluations in pawns from
  Whites perspective. </li>
  <li> <b>cX</b> Comment (where <b>X</b> is a digit, 0-9).</li>
  <li> <b>eco</b> <a ECO>ECO</a> system opening code.</li>
  <li> <b>id</b> Unique Identification for this position.</li>
  <li> <b>nic</b> <i>New In Chess</i> system opening code.</li>
  <li> <b>pm</b> Predicted move: the first move of the PV.</li>
  <li> <b>pv</b> Predicted variation: the line of best play.</li>
  </ul>
  
  <p>
  EPD files have a number of uses: Scid uses an EPD file to classify
  games according to the <a ECO>Encyclopedia of Chess Openings</a> (ECO)
  system, and you can create an EPD file for your opening repertoire,
  adding comments for positions you regularly reach in games.
  </p>
  <p>
  You can create a new EPD file or open an existing one, from the
  <menu>New</menu> and <menu>Open</menu> commands of the
  <menu>File</menu> menu. At most four EPD files can be open at any time.
  </p>
  
  <h3>EPD windows</h3>
  <p>
  For each open EPD file, you will see a window which shows the text for
  the current position. You do not have to press the Store button to store
  any changes you make to a positions text; the text will be stored whenever
  you move to a different position in the game.
  </p>
  
  <h3>Navigating EPD files</h3>
  <p>
  To browse through the positions in a EPD file, use the
  <menu>Next position</menu> and <menu>Previous position</menu> commands
  from the EPD window <menu>Tools</menu> menu, or use the shortcut
  keys <b>Ctrl+DownArrow</b> and <b>Ctrl+UpArrow</b>.
  These commands move to the next/previous position in the file, clearing
  the current game and setting its start position.
  </p>

  <h3>Annotating</h3>
  <p>
  EPD-files can be automatically annotated by selecting Tools /
  Annotate position. The upcoming dialogue asks for the time that
  should be used for the analysis, then the <a Analysis List>engine
  list</a> is opened for selection of an engine to be used. <b>Note</b> If an
  analysis window is already opened, the analysis is done using this
  engine without asking the user beforehand. Then the engine is
  started and the result added to the EPD. The EPD tags used are :
  acd, acn, ce and pv.
  </p>
  <p>

  <h3>Stripping out EPD fields</h3>
  <p>
  EPD files you find on the Internet may contain fields that do not
  interest you, and they can waste a lot of space in the file.
  For example, an EPD file of computer evaluations might have ce, acd,
  acn, pm, pv and id fields but you may only need the ce and pv fields.
  </p>
  <p>
  You can strip out an EPD opcode from all positions in the EPD file using
  the <menu>Strip out EPD field</menu> from the EPD window <menu>Tools</menu>
  menu.
  </p>

  <h3>The EPD window status bar</h3>
  <p>
  The status bar of each EPD window shows:
  <ul>
  <li>- the file status (<b>--</b> means unchanged, <b>XX</b> means
  changed, and <b>%%</b> means read-only); </li>
  <li>- the file name; </li>
  <li>- the number of positions in the file; </li>
  <li>- legal moves from the current position reach another position
  in this EPD file.</li>
  </ul>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Email window help:

set helpTitle(Email) "Email window"
set helpText(Email) {<h1>The Email window</h1>
  <p>
  Scid's email manager window provides a way for you to manage correspondence
  chess games played by email.
  If you do not play email chess, this will be of no interest to you.
  But if you play correspondence chess by email, you can send your email
  messages directly from Scid!
  </p>
  <p>
  To use the email manager:
  <ul>
  <li><b>1)</b> Create the game(s) for your opponent in the
  database. </li>
  <li><b>2)</b> In the email manager window, select <b>Add</b> and enter
  your opponents details: name, email address, and the game numbers in the
  database. </li>
  <li><b>3)</b> Select <b>Send email</b> in the email window each time you
  have added moves to the game(s) and want to send a message. </li>
  </ul>
  
  <p>
  When you send an email message, Scid generates the message with the games
  in <a PGN>PGN</a> format <b>without</b> any comments, annotations or variations, since
  you would not usually want your opponent to see your analysis.
  You can edit the message before sending it to add conditional moves or
  other text.
  </p>
  <p>
  For each opponent, you may have any number of games; one or two is most
  common. Note that Scid does not check if game numbers change, so after
  setting up the details of your opponents, be careful to avoid deleting games
  or sorting your database of email games, since this will rearrange games
  and the game numbers for each opponent will be incorrect.
  </p>
  
  <h3>Limitations</h3>
  <p>
  Scid does not have any capability to check your email folder yet, so you
  still need to add your opponents moves to the games manually.
  </p>
  
  <h3>Configuration</h3>
  <p>
  A copy of each email message sent by Scid is stored in the file
  <b>~/.scid/scidmail.log</b>. If you want them to be stored
  in a different file, you will need to edit the file <b>tcl/start.tcl</b>
  and recompile Scid.
  </p>
  <p>
  Scid can send email messages using an SMTP server or sendmail.
  User the <b>Settings</b> button in the Email Manager to specify which
  you want to use.
  </p>
  <p>
  Scid stores the opponent details for a database in a file
  with the same name as the database and the suffix "<b>.sem</b>".
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Reports help:

set helpTitle(Reports) "Reports"
set helpText(Reports) {<h1>Reports</h1>
  <p>
  A <term>Report</term> in Scid is a document containing information about
  a particular position and/or player. There are two types of report Scid can
  generate: Opening Reports and Player Reports.
  </p>
  
  <h3><name Opening>Opening Reports</name></h3>
  <p>
  Scid can produce an <term>opening report</term> that displays interesting
  facts about an opening position. To generate an opening report, first make
  sure the displayed position is the one you want a report for, then select
  <b>Opening Report</b> from the <b>Tools</b> menu.
  </p>
  <p>
  The <term>Opening Report</term> window displays the results of the report
  Scid generated. The <b>File</b> menu has commands to save the report
  to a file in plain text, HTML or <a LaTeX>LaTeX</a> format.
  </p>
  <p>
  The first sections of the report present information on the games that
  reach the report position, and moves played from the position. You can
  see if the opening is becoming more popular, if it has many short draws,
  and what move orders (transpositions) are used to reach it.
  </p>
  <p>
  The Positional Themes section reports the frequency of certain common
  positional themes in the report games. For this, the first 20 moves of
  each game (hence the first 40 positions of each game after the starting
  position) are examined. To be counted as containing a theme, a game must
  contain that particular theme in at least 4 positions of its first 20
  moves. This avoids the brief occurrence of a theme (such as an isolated
  Queen pawn which is quickly captured) distorting results.
  </p>
  <p>
  The final and largest part of the report is the theory table. When saving
  the report to a file, you can choose to save just the theory table, a compact
  report without the theory table, or the whole report.
  </p>
  <p>
  Almost all the report sections can be turned on or off or adjusted in
  the opening report options, so you can customize a report to only show
  the information that interests you.
  </p>
  <p>
  Most items of information in the report window that are shown in color,
  invoke some action when selected with the left mouse button. For example,
  you can click on a game reference to load that game, or click on a
  positional theme to set the filter to contain only the report games where
  that theme occurred.
  </p>
  <p>
  Choosing <term>Merge Games</term> will merge the games from the
  opening report into the currently displayed game. This merges in
  the whole games as variations to the game, including the full
  reference.
  </p>
  
  <h4>Favorites</h4>
  <p>
  The <menu>Favorites</menu> menu in the report window lets you maintain a
  collection of favorite opening report positions and generate the opening
  reports for all those positions easily. Selecting "Add Report..." from
  the Favorites menu will add the current position as a favorite report
  position; you will be prompted to enter a name that will be used as
  the filename when favorite reports are generated.
  </p>
  <p>
  Select "Generate Reports..." from the Favorites menu to generate a report
  for each of your favorite reports using the current database. A dialog
  box will appear allowing you to specify the report type and format, and
  a directory where report files will be saved. A suitable suffix for the
  format you selected (e.g. ".html" for HTML format) will be added to each
  report file name.
  </p>
  
  <h3><name Player>Player Reports</name></h3>
  <p>
  A <term>Player Report</term> is very similar to an opening report, but it
  contains information about the games of a single player with the white or
  black pieces. You can generate a player report from the Tools menu, or from
  the <a PInfo>Player Info</a> window.
  </p>
  <p>
  A player report can be generated either for all games by the specified player
  with the specified pieces, or for only the subset of those games which reach
  the current position on the main window chessboard.
  </p>
  
  <h3>Limits</h3>
  <p>
  There is a limit of 2000 games for most data generated by reports, so
  if the report position occurs in more than 2000 games, some results may
  be slightly incorrect.
  </p>
  <p>
  Also, there is a limit of 500 games for the theory table. If the report
  position occurs in more than 500 games, only the 500 games with the highest
  average Elo rating are used to generate the theory table. You can adjust the
  number of games used to generate the theory table in the Report options.
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}


####################
### Player List help:

set helpTitle(PList) "Player Finder window"
set helpText(PList) {<h1>The Player Finder window</h1>
  <p>
  The <term>Player Finder</term> window displays a list of names of
  players in the current database. Selecting a player will open the
  <a PInfo>Player Info</a> window to display more detailed information
  about that player.
  </p>
  <p>
  Five columns are displayed showing each player's name, peak Elo
  rating, number of games played and the year of their oldest and
  newest game.
  Click on any column title at the top of the list to sort the
  list by that column.
  </p>
  <p>
  The controls below the list allow you to filter the list contents.
  You can alter the maximum list size, enter a case-insensitive player
  name prefix (such as "ada" to search for "Adams"), and restrict the
  ranges of Elo rating and number of games played.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Player Info help:

set helpTitle(PInfo) "Player Info window"
set helpText(PInfo) {<h1>The Player Info window</h1>
  <p>
  
  The <term>Player Information</term> window is produced or updated whenever
  you click the left mouse button on a player name in the game information
  area (below the chessboard) or in the <a Crosstable>crosstable</a> window.
  </p>
  <p>
  It displays (hopefully) useful information about the player, including their
  success with White and Black, favorite openings (by <a ECO>ECO code</a>),
  and rating history.<br>
  The data for the Elo history can optionally be taken from the current database
  or from the spelling file/rating file. If you use a actual rating file the time
  periods can also be displayed, for which there are no games in the database.<br>
  Download a rating file with over 300.000 registered FIDE player with their
  ELO ratings from <url https://sourceforge.net/projects/scid/files/Player Data/>
  https://sourceforge.net/projects/scid/files/Player Data/</url>.
  </p>
  <p>
  All percentages displayed are an expected score (success rate), from the
  player's perspective -- so higher is always better for the player, whether they
  are White or Black.
  </p>
  <p>
  You can see the player's rating history in a graph by pressing the
  <a Graphs Rating>Rating graph</a> button.
  </p>
  <p>
  Any number printed in red can be clicked with the left mouse button to set
  the <a Searches Filter>filter</a> to the games it represents.
  </p>
  <p>
  If a current version of the ratings file (cf. <url
  http://scid.sourceforge.net/>Scid website</url>) is online links to
  additional resources may be present that will be accessible by the
  users web browser provided Internet access is available. These infos
  can be accessed by the following symbols in the player information
  window (note that not all symbols may be present!):
  <ul>
  <li><button fidelnk> Go to the players FIDE profile page</li>
  <li><button iccflnk> Go to the players ICCF profile page</li>
  <li><button dsblnk> Go to the players profile at the Deutscher
  Schachbund.</li>
  <li><button bcflnk> Go to the players profile at the British Chess
  Federation.</li>
  <li><button smlnk> Go to te players profile at SchemingMind.</li>
  <li><button wikiplnk> Call up the players Wikipedia profile page.
  Scid will try to use the language set for Scid itself. If no page is
  available, it will resort to German (for pure technical reasons).</li>
  <li><button dnblnk> Call up the German national library for books by
  or about the player.</li>
  <li><button seealsolnk> An alternative way to access Wikipedia.</li>
  <li><button viaflnk> Call up player information at the Virtual
  Authority File (VIAF). This could be used to call up books of/by this
  player in the contributing national libraries.</li>
  </ul>
  
  <p><footer>(Updated: Scid 4.7, November 2018)</footer></p>
}

####################
### Graphs help:

set helpTitle(Graphs) "Graph windows"
set helpText(Graphs) {<h1>Graph windows</h1>
  <p>
  Scid has a number of windows which display information graphically.
  They are explained below.
  </p>
  
  <h3><name FilterGraph>Relative and absolute Filter Graph windows</name></h3>
  <p>
  The <term>relative Filter Graph</term> window shows trends by date or by
  Elo rating for the games in the current filter, compared to the
  entire database. For example, it is useful when the <a Tree>tree</a>
  is open as a tool showing how the current opening position has changed
  in popularity in recent years or decades, or whether it is especially
  popular among higher-rated players such as grandmasters.
  Each point on the graph represents the number of games in the filter
  per 1000 games in the entire database, for a particular date or Elo
  rating range.
  </p>
  <p>
  The second Filter graph window is the <term>absolute Filter
  Graph</term> window. This graph shows the absolute quantity of games
  in the filter according the selected criteria. It is possible to select
  the criteria: Decade, Year, Rating and Moves.<br>
  The small button near the Close-Button opens the dialog to configure
  the graph. You can select the range (from, to) and the size of
  interval for the x-axes. The "decade"-criteria can't be configured,
  use Year instead. If "Estimate" selected a missing rating will be
  estimate like described below. In other case no estimation is done
  and missing ratings are count as zero. This matches the Min. Elo
  evaluation in the statistic-window. Use "Update" to start a new
  evaluation with the actual value without closing the dialog.
  </p>
  <p>
  Please note: The calculation can be need some time on large ranges and
  small intervals, in addition the readability decreases. 
  </p>
  <p>
  When plotting the Filter graph by rating, Scid uses the average (mean)
  rating for each game. Estimate ratings (such as those in the spelling file)
  are not used. If one player in a game has a rating but the opponent
  does not, the opponent is presumed to have the same up to a limit of 2200.
  For example, if one player is rated 2500 and the opponent has no rating,
  the mean rating is (2500+2200)/2=2350.
  </p>
  
  <h3><name Rating>Rating Graph window</name></h3>
  <p>
  The <term>Rating Graph</term> window shows the rating history of one
  player or the two players of the current game.
  You can produce the graph for a single player by pressing the
  <b>Rating graph</b> button in the <a PInfo>player information</a>
  window, or produce it for the two players of the current game by
  selecting <b>Rating graph</b> from the <menu>Tools</menu> menu.
  </p>
  
  <h3><name Score>Score Graph window</name></h3>
  <p>
  The <term>Score Graph</term> window shows the numeric evaluations (scores)
  stored in the comments of the current game as a graph.
  You can click the left mouse button anywhere in the score graph to go to the
  corresponding position in the game.
  </p>
  <p>
  Two types of evaluation comment are recognized: 
  <ul>
  All comments that contain a signed number, for example 
  <li><b>+1.23, -0.23</b></li>
  </ul>
  <ul>
  Tags with the name [%eval .. ]
  <li><b>[%emt 0:00:19][%eval -6.64/23]</b></li>
  </ul>
  </p>
  <p>
    Some scores are are only shown from whites perspective. You can invert the score for White or Black
    from the options menu to correct this. Select White and/or Black.
  </p>
  <p>
    In a <term>Time diagram</term> the time for the time consumption per move or the time remaining on the clock can also be displayed. For the evaluation of the time the tags[%clk 0:01:19] and [%emt 0:00:19] must be contained in the comment.
    The values are always displayed in minutes.
    Via the menu you can select which combination of the diagrams should be shown:
    <li><b>Both:</b> The game evaluation and time are displayed.</li>
    <li><b>Time:</b> Only the time graph is displayed ("Both" must be deselected!)</li>
    <li><b>Sum:</b> In the time display, the sum of the time consumed is displayed if the time is available as [%emt 00:12].</li>
  </p>
  
  <h3><name Tree>Tree Graph window</name></h3>
  <p>
  The <term>Tree Graph</term> window is available from the tree
  window. It shows the performance of the most popular moves from the
  current position. More information is available from the
  <a Tree Graph>Tree</a> help page.
  </p>
  
  <p><footer>(Updated: Scid 4.7, June 2018)</footer></p>
}

####################
### Tablebases help:

set helpTitle(TB) "Tablebases"
set helpText(TB) {<h1>Tablebases</h1>
  
  <p>
  A <term>tablebase</term> is a file containing the perfect result
  information about all positions of a particular material setup,
  such as King and Rook versus King and Pawn. Tablebases for all
  material situations up to five men (including the Kings) have been
  generated, and some simple 6-men tablebases are also available.
  </p>
  <p>
  Scid can use Nalimov-format tablebases that are used by many modern
  chess engines. These often end with the file suffix <b>.nbw.emd</b>
  or <b>.nbb.emd</b>. All 3-, 4- and 5-men Nalimov tablebases can be
  used in Scid.
  </p>
  
  <h3>Using tablebases in Scid</h3>
  <p>
  To use tablebase files in Scid, simply set their directories by
  selecting <b>Tablebase directory...</b> from the <menu>Options</menu> menu.
  You can select up to 4 directories where your tablebase files are stored.
  You can press a <b>...</b> button to the right of an entry to choose a
  file, to specify that the directory of that file should be used.
  </p>
  <p>
  When a position found in a tablebase file is reached, the game information
  area (below the chessboard) will show tablebase information. You can
  configure the amount of information shown by clicking the right-mouse
  button in that area or selecting <b>Game information</b> from the
  <menu>Options</menu> menu. Selecting the "result and best moves" option
  gives the most useful information, but is much often slower than
  the "result only" option.
  </p>
  
  <h3>The Tablebase window</h3>
  <p>
  You can get even more tablebase information about the current position
  by opening the <term>Tablebase window</term> (<menu>Windows</menu> menu,
  shortcut: Ctrl+Shift+=). This window shows the result with perfect play
  of all legal moves from the current position.
  </p>
  <p>
  The window has two main parts. The summary frame (on the left) shows
  which tablebases Scid found on your computer and a summary for each
  tablebase. The results frame (on the right) shows optimal results for
  all moves from the current position displayed in the main window.
  </p>
  
  <h4>The summary frame</h4>
  <p>
  The top part of the summary frame lets you select a particular
  tablebase. Those you have available are shown in blue and unavailable
  tablebases are shown in gray, but you can select any tablebase.
  The lower part of the summary frame shows summary information for the
  selected tablebase. (Not all tablebases have a summary recorded in
  Scid yet.)
  </p>
  <p>
  The summary includes the frequency (how many games per million reach a
  position with this material, computed from a database of more than
  600,000 master-level games), a longest mate for either side, and the
  number of mutual (or "reciprocal") zugzwangs. A mutual zugzwang is a
  position where white to move draws and black to move loses, or where
  white to move loses and black to move draws, or where whoever moves
  loses.
  </p>
  <p>
  For some tablebases with mutual zugzwangs, the summary also includes
  a list of all of the zugzwang positions or a selection of them. A full
  list for every tablebase is not feasible since some tablebases have
  thousands of mutual zugzwangs.
  </p>
  <p>
  You can set up a random position from the selected tablebase by pressing
  the <b>Random</b> button.
  </p>
  
  <h4>The results frame</h4>
  <p>
  The results frame is updated whenever the chessboard in the main window
  changes. The first line shows how many moves win (+), draw (=), lose (-),
  or have an unknown result (?). The rest of the frame gives a more detailed
  list of results, ranking them from shortest to longest mates, then draws,
  then longest to shortest losses. All distances are to checkmate.
  </p>
  
  <h4>The results board</h4>
  <p>
  In a tablebase position, it is often useful what the tablebase results
  would be if all the pieces in the current position were on their
  current squares but one particular piece was moved somewhere else.
  For example, you may want to determine how close a king has to be to
  a passed pawn to win or draw a particular position. In endgame books
  this information is often called the <i>winning zone</i> or
  <i>drawing zone</i> of a piece in a position.
  </p>
  <p>
  You can find this information in Scid by pressing the button with an
  image of a chessboard, to show the <term>results board</term> in the
  tablebase window.
  When you press the left mouse button on any piece in this board, a
  symbol is drawn in each empty square showing what the tablebase result
  would be (with the same side to move as the current main window position)
  if the selected piece was on that square.
  </p>
  <p>
  There are five different symbols a square can have:
  a white <b>#</b> means White wins;
  a black <b>#</b> means Black wins;
  a blue <b>=</b> means the position is drawn;
  a red <b>X</b> means the position is illegal (because the kings are
  adjacent or the side to move is giving check); and
  a red <b>?</b> means the result is unknown because the necessary
  tablebase file is not available.
  </p>
  
  <h3>Obtaining Tablebase files</h3>
  <p>
  See the <a Author Related>related links</a> section for help on finding
  tablebase files on the Internet.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Bookmarks help:

set helpTitle(Bookmarks) "Bookmarks"
set helpText(Bookmarks) {<h1>Bookmarks</h1>
  <p>
  Scid allows you to <term>bookmark</term> important games for easy
  future reference. The bookmarks menu is available from the
  <menu>File</menu> menu, the toolbar, or the <B>Ctrl+B</b> shortcut key.
  </p>
  <p>
  When you select a bookmarked game from the Bookmarks menu, Scid will
  open its database if necessary, find that game, and move to the game
  position at which it was bookmarked.
  </p>
  <p>
  Only games in a Scid format database (not a <a PGN>PGN</a> file or the clipbase)
  can be bookmarked.
  </p>
  <p>
  If the database of a bookmarked game is sorted or compacted, the bookmark
  details may become out of date. When that happens, Scid will search the
  database for the best matching game (comparing player names, site, etc)
  when the bookmark is selected, so the bookmarked game should still be
  loaded. However, if details of the bookmarked game change, it is possible
  that a different game will match the bookmark details better and be
  loaded instead. So it is a good idea to re-bookmark a game if you edit
  its players, site, result, round or year.
  </p>
  
  <h3>Editing bookmarks</h3>
  <p>
  With the bookmark editor, you can change the menu text displayed for
  each bookmarked game and add folders to categorize bookmarks.
  </p>
  
  <h3>Hints</h3>
  <p>
  You can use bookmarks for fast access to databases you use often
  by bookmarking a game from each database. Another good use for
  bookmarks is to add important games you find when studying a
  particular chess opening.
  </p>
  <p>
  The bookmarks menu contains an entry for controlling the display of
  bookmark folders: they can be shown as submenus (useful when there are
  many bookmarks), or as a single list.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Command-line options help:

set helpTitle(Cmdline) "Command-line options"
set helpText(Cmdline) {<h1>Command-line options</h1>
  <p>
  When you start Scid from a shell or console, there are command-line
  options you can specify. Scid-format databases (with or without a
  file suffix such as ".si3") and <a PGN>PGN</a> files to be opened can be given,
  for example:
  <ul>
  <li>scid mybase newgames.pgn</li>
  </ul>
  will start Scid and open the Scid database called mybase and the
  <a PGN>PGN</a> file named newgames.pgn.
  </p>
  <p>
  There are also optional arguments to control which files Scid should
  search for and use when it starts. You can turn off the use of
  <a TB>tablebases</a> with the <b>-xtb</b> (or <b>-xt</b>) option,
  avoid loading the <a ECO>ECO openings classification</a> file with
  <b>-xeco</b> or <b>-xe</b>, and avoid loading the
  <a Maintenance Spellcheck>spelling</a> file
  with <b>-xspell</b> or <b>-xs</b>. Also, the option <b>-fast</b>
  or <b>-f</b> does all three, so <b>scid -f</b> is equivalent
  to <b>scid -xeco -xspell -xtb</b>.
  </p>

  <p>
  Additionally, a filter file (.sso) can be used on the command line.
  <ul>
  <li>scid mybase myfilter</li>
  </ul>
  will open mybase and run myfilter immediately against it to select a
  set of games. This can e.g. be used to select a list of unfinished
  games in a pgn file.
  </p>
  
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Pgnscid help:

set helpTitle(Pgnscid) "Pgnscid"
set helpText(Pgnscid) {<h1>Pgnscid</h1>
  <p>
  <term>Pgnscid</term> is the separate program that you need to use to
  convert <a PGN>PGN</a> (portable game notation) files into Scid databases.
  </p>
  <p>
  To convert a file named <i>myfile.pgn</i>, simply type:
  <ul>
  <li> <b>pgnscid myfile.pgn</b> </li>
  </ul>
  and the scid database (consisting of <i>myfile.si3</i>, <i>myfile.sg3</i>
  and <i>myfile.sn3</i>) will be created.
  Any errors or warnings will be written to the file <i>myfile.err</i>.
  </p>
  <p>
  If you want the database to be created in a different directory or have
  a different name, you can add the database name to the command line,
  for example:
  <ul>
  <li> <b>pgnscid myfile.pgn mybase</b> </li>
  </ul>
  will create a database consisting of the files <i>mybase.si3</i>,
  <i>mybase.sg3</i> and <i>mybase.sn3</i>.
  </p>
  <p>
  Note that pgnscid (and scid) can read Gzipped <a PGN>PGN</a> files
  (e.g. <b>mybase.pgn.gz</b>)
  directly, so if you have a large <a PGN>PGN</a> file compressed with Gzip to save
  disk space, you do not have to un-gzip it first.
  </p>
  
  <h3>Options</h3>
  <p>
  There are two optional arguments pgnscid can accept before the filename:
  <b>-f</b> and <b>-x</b>.
  </p>
  <p>
  The <b>-f</b> option forces overwriting of an existing database; by
  default, pgnscid will not convert to a database that already exists.
  </p>
  <p>
  The <b>-x</b> option causes pgnscid to ignore all text between games.
  By default, text between games is stored as a pre-game comment of the
  game that follows. This option only affects text between games; standard
  comments inside each game are still converted and stored.
  </p>
  
  <h3>Formatting player names</h3>
  <p>
  To reduce the number of multiple spellings of names that refer to the
  same player, some basic formatting of player names is done by pgnscid.
  For example, the number of spaces after each comma is standardized to one,
  any spaces at the start and end of a name are removed, and a dot at the
  end of a name is removed.
  Dutch prefixes such as "van den" and "Van Der" are also normalized to have
  a capital V and small d.
  </p>
  <p>
  You can edit (and even spellcheck) player, event, site and round names in
  Scid; see the <a Maintenance Editing>Maintenance</a> help page for details.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}


####################
### File formats help:

set helpTitle(Formats) "File Formats"
set helpText(Formats) {<h1>Scid File Formats</h1>
  <p>
  Scid databases consist of three essential files: an Index file, a Name
  file and a Game file. All have a three-letter suffix starting with "s":
  ".si3" for index files, ".sn3" for name files, and ".sg3" for game files.
  </p>
  
  <h3>The Index (.si3) file</h3>
  <p>
  This file contains a description for the database and a small fixed-size
  entry for each game. The current size is 41 bytes per game.
  Of this, about 28 bytes is essential information such as the result,
  date, player/event/site name ID numbers (the actual names are in the
  Name file), etc.
  </p>
  <p>
  The remaining 13 bytes contain redundant but useful information about the
  game that is used to speed up position, material and pattern searches.
  See the section <a Formats Fast>Fast searches</a> below for more information.
  </p>
  
  <h3>The Name (.sn3) file</h3>
  <p>
  This file contains all player, event, site and round names used in the
  database. Each name is stored only once even if it occurs in many games.
  The name file is usually the smallest of the three essential files in a
  database.
  </p>

  <h3>The Game (.sg3) file</h3>
  <p>
  This file contains the actual moves, variations and comments of each game.
  The move encoding format is very compact: most moves take only one byte
  of storage.
  </p>
  <p>
  When a game is replaced, its new version is saved to the <i>end</i> of
  the game file, so wasted space can accumulate over time. You can restore
  a database to its minimal size by <a Compact>compacting</a> it.
  </p>
  
  <h3>Other Scid files</h3>
  <p>
  An <a EPD>EPD</a> file (suffix: ".epd")
  contains a number of chess positions, each with a text comment.
  The EPD file format is described in the <a Author Related>PGN standard</a>.
  </p>
  <p>
  An email (suffix: ".sem") file for a database stores details of the opponents
  you send email messages to.
  </p>
  <p>
  A SearchOptions (suffix: ".sso") file contains Scid
  <a Searches Header>header</a> or
  <a Searches Material>material/pattern</a> search settings.
  </p>
  
  <h3><name Fast>Fast searches in Scid</name></h3>
  <p>
  As mentioned above, the index file stores some redundant but useful
  information about each game to speed up position or material searches.
  </p>
  <p>
  For example, the material of the final position is stored. If you search
  for rook and pawn endings, then all games that end with a queen, bishop
  or knight on the board (and have no pawn promotions) will be quickly
  skipped over.
  </p>
  <p>
  Another useful piece of information stored is the order in which pawns
  leave their home squares (by moving, or by being captured). This is used
  to speed up tree or exact position searches, especially for opening
  positions. For example, when searching for the starting position of the
  French defence (1.e4 e6), every game starts with 1.e4 c5, or 1.d4, etc, will
  be skipped, but games starting with 1.e4 e5 will still need to be searched.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### Options and Fonts help:

set helpTitle(Options) "Options"
set helpText(Options) {<h1>Options and preferences</h1>
  <p>
  Many Scid options and preferences (such as the board size, colors, fonts,
  and default settings) are adjustable from the <menu>Options</menu> menu.
  All these (and more, such as the last directory you loaded a database from
  and the sizes of some windows) are saved to an options file when
  you select <b>Save Options</b> from the Options menu.
  The options file is loaded whenever you start Scid.
  </p>
  <p>
  If you use Windows, the options file is <b>scid.opt</b> in the directory
  where the Scid program file <b>scid.exe</b> is located. For users of Unix
  operating systems (such as Solaris or Linux) the file
  is <b>~/.scid/scidrc</b>.
  </p>
  
  <h3><name MyPlayerNames>Setting your player names</name></h3>
  <p>
  There may be a player name (or several names) for whom, whenever a game
  is loaded, you would like the main window chessboard to be displayed from
  the perspective of that player. You can configure a list of such names
  using <b>My Player Names...</b> from the <menu>Options/Chessboard</menu>
  menu. In the dialog box that appears, enter one player name on each line.
  Wildcard characters ("<b>?</b>" for exactly one character and "<b>*</b>"
  for a sequence of zero or more characters) can be used.
  </p>
  
  <h3><name Fonts>Setting Fonts</name></h3>
  <p>
  Scid has three basic fonts it uses in most of its windows, and you can
  customize all of them. They are called <b>regular</b>, <b>small</b> and
  <b>fixed</b>.
  </p>
  <p>
  The fixed font should be a fixed-width (not proportional) font. It is used
  for the <a Tree>tree</a> and <a Crosstable>crosstable</a> windows.
  </p>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}

####################
### NAG values help:

set helpTitle(NAGs) "NAG values"
set helpText(NAGs) {<h1>Standard NAG values</h1>
  <p>
  Standard NAG (Numeric Annotation Symbol) values defined in the
  <a Author Related>PGN standard</a> are:
  </p>
  <cyan>
  <ul>
  <li>  1     Good move                                                      : !       </li>
  <li>  2     Poor move                                                      : ?       </li>
  <li>  3     Excellent move                                                 : !!      </li>
  <li>  4     Blunder                                                        : ??      </li>
  <li>  5     Interesting move                                               : !?      </li>
  <li>  6     Dubious move                                                   : ?!      </li>
  <li>  7     Forced move                                                    : forced  </li>
  <li>  8     Singular move; no reasonable alternatives                      : □       </li>
  <li>  9     Worst move                                                     : worst   </li>
  <li> 10     Drawish position                                               : =       </li>
  <li> 11     Equal chances, quiet position                                  : =, quiet</li>
  <li> 12     Equal chances, active position                                 : ↹       </li>
  <li> 13     Unclear position                                               : ~       </li>
  <li> 14     White has a slight advantage                                   : +=      </li>
  <li> 15     Black has a slight advantage                                   : =+      </li>
  <li> 16     White has a moderate advantage                                 : +/-     </li>
  <li> 17     Black has a moderate advantage                                 : -/+     </li>
  <li> 18     White has a decisive advantage                                 : +-      </li>
  <li> 19     Black has a decisive advantage                                 : -+      </li>
  <li> 20     White has a crushing advantage                                 : +--     </li>
  <li> 21     Black has a crushing advantage                                 : --+     </li>
  <li> 22     White is in zugzwang                                           :  ⊙      </li>
  <li> 23     Black is in zugzwang                                           :  ⊙      </li>
  <li> 24     White has a slight space advantage                             :  ◯      </li>
  <li> 25     Black has a slight space advantage                             :  ◯      </li>
  <li> 26     White has a moderate space advantage                           :  ◯◯     </li>
  <li> 27     Black has a moderate space advantage                           :  ◯◯     </li>
  <li> 28     White has a decisive space advantage                           :  ◯◯◯    </li>
  <li> 29     Black has a decisive space advantage                           :  ◯◯◯    </li>
  <li> 30     White has a slight time (development) advantage                :  ↻      </li>
  <li> 31     Black has a slight time (development) advantage                :  ↺      </li>
  <li> 32     White has a moderate time (development) advantage              :  ↻↻     </li>
  <li> 33     Black has a moderate time (development) advantage              :  ↺↺     </li>
  <li> 34     White has a decisive time (development) advantage              :  ↻↻↻    </li>
  <li> 35     Black has a decisive time (development) advantage              :  ↺↺↺    </li>
  <li> 36     White has the initiative                                       :  ↑      </li>
  <li> 37     Black has the initiative                                       :  ↓      </li>
  <li> 38     White has a lasting initiative                                 :  ⇑      </li>
  <li> 39     Black has a lasting initiative                                 :  ⇓      </li>
  <li> 40     White has the attack                                           :  →      </li>
  <li> 41     Black has the attack                                           :  ←      </li>
  <li> 42     White has insufficient compensation for material deficit       :  &/-    </li>
  <li> 43     Black has insufficient compensation for material deficit       :  &/+    </li>
  <li> 44     White has sufficient compensation for material deficit         :  =/&    </li>
  <li> 45     Black has sufficient compensation for material deficit         :  =/&    </li>
  <li> 46     White has more than adequate compensation for material deficit :  +/&    </li>
  <li> 47     Black has more than adequate compensation for material deficit :  -/&    </li>
  <li> 48     White has a slight center control advantage                    :  ⊞      </li>
  <li> 49     Black has a slight center control advantage                    :  ⊞      </li>
  <li> 50     White has a moderate center control advantage                  :  ⊞⊞     </li>
  <li> 51     Black has a moderate center control advantage                  :  ⊞⊞     </li>
  <li> 52     White has a decisive center control advantage                  :  ⊞⊞⊞    </li>
  <li> 53     Black has a decisive center control advantage                  :  ⊞⊞⊞    </li>
  <li> 54     White has a slight kingside control advantage                  :  ⟩      </li>
  <li> 55     Black has a slight kingside control advantage                  :  ⟩      </li>
  <li> 56     White has a moderate kingside control advantage                :  ⟫      </li>
  <li> 57     Black has a moderate kingside control advantage                :  ⟫      </li>
  <li> 58     White has a decisive kingside control advantage                :  ⋙      </li>
  <li> 59     Black has a decisive kingside control advantage                :  ⋙      </li>
  <li> 60     White has a slight queenside control advantage                 :  ⟨      </li>
  <li> 61     Black has a slight queenside control advantage                 :  ⟨      </li>
  <li> 62     White has a moderate queenside control advantage               :  ⟪      </li>
  <li> 63     Black has a moderate queenside control advantage               :  ⟪      </li>
  <li> 64     White has a decisive queenside control advantage               :  ⋘      </li>
  <li> 65     Black has a decisive queenside control advantage               :  ⋘      </li>
  <li> 66     White has a vulnerable first rank                              :         </li>
  <li> 67     Black has a vulnerable first rank                              :         </li>
  <li> 68     White has a well protected first rank                          :         </li>
  <li> 69     Black has a well protected first rank                          :         </li>
  <li> 70     White has a poorly protected king                              :         </li>
  <li> 71     Black has a poorly protected king                              :         </li>
  <li> 72     White has a well protected king                                :         </li>
  <li> 73     Black has a well protected king                                :         </li>
  <li> 74     White has a poorly placed king                                 :         </li>
  <li> 75     Black has a poorly placed king                                 :         </li>
  <li> 76     White has a well placed king                                   :         </li>
  <li> 77     Black has a well placed king                                   :         </li>
  <li> 78     White has a very weak pawn structure                           :         </li>
  <li> 79     Black has a very weak pawn structure                           :         </li>
  <li> 80     White has a moderately weak pawn structure                     :         </li>
  <li> 81     Black has a moderately weak pawn structure                     :         </li>
  <li> 82     White has a moderately strong pawn structure                   :         </li>
  <li> 83     Black has a moderately strong pawn structure                   :         </li>
  <li> 84     White has a very strong pawn structure                         :         </li>
  <li> 85     Black has a very strong pawn structure                         :         </li>
  <li> 86     White has poor knight placement                                :         </li>
  <li> 87     Black has poor knight placement                                :         </li>
  <li> 88     White has good knight placement                                :         </li>
  <li> 89     Black has good knight placement                                :         </li>
  <li> 90     White has poor bishop placement                                :         </li>
  <li> 91     Black has poor bishop placement                                :         </li>
  <li> 92     White has good bishop placement                                :  ↗      </li>
  <li> 93     Black has good bishop placement                                :  ↖      </li>
  <li> 94     White has poor rook placement                                  :         </li>
  <li> 95     Black has poor rook placement                                  :         </li>
  <li> 96     White has good rook placement                                  :  ⇈      </li>
  <li> 97     Black has good rook placement                                  :  ⇊      </li>
  <li> 98     White has poor queen placement                                 :         </li>
  <li> 99     Black has poor queen placement                                 :         </li>
  <li>100     White has good queen placement                                 :         </li>
  <li>101     Black has good queen placement                                 :         </li>
  <li>102     White has poor piece coordination                              :         </li>
  <li>103     Black has poor piece coordination                              :         </li>
  <li>104     White has good piece coordination                              :         </li>
  <li>105     Black has good piece coordination                              :         </li>
  <li>106     White has played the opening very poorly                       :         </li>
  <li>107     Black has played the opening very poorly                       :         </li>
  <li>108     White has played the opening poorly                            :         </li>
  <li>109     Black has played the opening poorly                            :         </li>
  <li>110     White has played the opening well                              :         </li>
  <li>111     Black has played the opening well                              :         </li>
  <li>112     White has played the opening very well                         :         </li>
  <li>113     Black has played the opening very well                         :         </li>
  <li>114     White has played the middlegame very poorly                    :         </li>
  <li>115     Black has played the middlegame very poorly                    :         </li>
  <li>116     White has played the middlegame poorly                         :         </li>
  <li>117     Black has played the middlegame poorly                         :         </li>
  <li>118     White has played the middlegame well                           :         </li>
  <li>119     Black has played the middlegame well                           :         </li>
  <li>120     White has played the middlegame very well                      :         </li>
  <li>121     Black has played the middlegame very well                      :         </li>
  <li>122     White has played the ending very poorly                        :         </li>
  <li>123     Black has played the ending very poorly                        :         </li>
  <li>124     White has played the ending poorly                             :         </li>
  <li>125     Black has played the ending poorly                             :         </li>
  <li>126     White has played the ending well                               :         </li>
  <li>127     Black has played the ending well                               :         </li>
  <li>128     White has played the ending very well                          :         </li>
  <li>129     Black has played the ending very well                          :         </li>
  <li>130     White has slight counterplay                                   :  ⇄      </li>
  <li>131     Black has slight counterplay                                   :  ⇆      </li>
  <li>132     White has moderate counterplay                                 :  ⇄⇄     </li>
  <li>133     Black has moderate counterplay                                 :  ⇆⇆     </li>
  <li>134     White has decisive counterplay                                 :  ⇄⇄⇄    </li>
  <li>135     Black has decisive counterplay                                 :  ⇆⇆⇆    </li>
  <li>136     White has moderate time control pressure                       :  ⊕      </li>
  <li>137     Black has moderate time control pressure                       :  ⊖      </li>
  <li>138     White has severe time control pressure                         :  ⊕⊕     </li>
  <li>139     Black has severe time control pressure                         :  ⊖⊖     </li>
  </ul>
  </cyan>
  
  <p>
  Other proposed NAG values for Chess Informant publication symbols include:
  </p>
  <cyan>
  <ul>
  <li>140     With the idea ...           : △  </li>
  <li>141     Aimed against ...           :    </li>
  <li>142     Better move                 : ⌓  </li>
  <li>143     Worse move                  :    </li>
  <li>144     Equivalent move             : R  </li>
  <li>145     Editor's Remark             : RR </li>
  <li>146     Novelty                     : N  </li>
  <li>147     Weak point                  : ×  </li>
  <li>148     Endgame                     : ⊥  </li>
  <li>149     Line                        : ⟺  </li>
  <li>150     Diagonal                    : ⇗  </li>
  <li>151     White has a pair of Bishops : ◫  </li>
  <li>152     Black has a pair of Bishops :    </li>
  <li>153     Bishops of opposite color   : ◨  </li>
  <li>154     Bishops of same color       : ⊶  </li>
  </ul>
  </cyan>
  
  <p>
  Other suggested values are:
  </p>
  <cyan>
  <ul>
  <li>190     Etc.            : ǁ </li>
  <li>191     Doubled pawns   : ⡁ </li>
  <li>192     Isolated pawn   : ⚯ </li>
  <li>193     Connected pawns : ⚮ </li>
  <li>194     Hanging pawns   :   </li>
  <li>195     Backwards pawn  :   </li>
  </ul>
  </cyan>
  
  <p>
  Symbols defined by Scid for its own use are:
  </p>
  <cyan>
  <ul>
  <li>201   Diagram        : D or #</li>
  <li>210   see            : —     </li>
  <li>211   mate           : #     </li>
  <li>212   passed pawn    : ⚨     </li>
  <li>213   more pawns     :       </li>
  <li>214   with           : ⌊     </li>
  <li>215   without        : ⌋     </li>
  </ul>
  </cyan>
  
  <p><footer>(Updated: Scid 4.2.2, January 2010)</footer></p>
}


set helpTitle(ECO) "ECO guide"
set helpText(ECO) {<h1>ECO openings classification</h1>
  <p>
  Scid can classify chess games according to the <b>ECO</b>
  (Encyclopedia of Chess Openings) chess openings classification.
  An standard ECO code consists of a letter (A..E) followed by two
  digits, so there are 500 distinct standard ECO codes.
  </p>
  
  <h3>Scid extensions to the ECO system</h3>
  <p>
  The ECO system is very limited and not sufficient for modern games:
  some of the 500 codes are almost never seen any more, while some
  are seen very often. To improve this situation, Scid allows an optional
  extension to the basic ECO codes: each code can be extended with a
  letter (a..z), with a further extension (another digit, 1..4) being
  possible but not used in the standard Scid ECO file yet.
  So an extended Scid ECO code looks like "<b>A41e</b>" or "<b>E99b2</b>".
  Many of the most common ECO codes found in modern master-level games have
  extensions defined in the Scid ECO file.
  </p>
  
  <h3><name Browser>The ECO Browser window</name></h3>
  <p>
  The <term>ECO Browser</term> window shows you the positions that are
  used to classify each ECO code, and the frequency and performance of
  ECO codes in the current database.
  </p>
  <p>
  The upper pane shows the frequency of each ECO code in the current
  database. The bars in the graph have three sections: the lowest
  (lightest color) is the number of White wins, the middle is the
  number of draws, and the highest (darkest) is the number of Black wins.
  This lets you see at a glance the characteristics of an opening: for
  example, if White is scoring very well, or if draws are very common.
  </p>
  <p>
  To go to a deeper ECO level, click the left mouse button
  on a bar in the graph (or type the
  letter or digit it corresponds to). To go back to the higher level,
  click the right mouse button anywhere in the graph, or press the left
  arrow (or delete or backspace) key.
  </p>
  <p>
  The lower pane shows the positions that comprise a particular ECO code,
  according to the ECO file you have loaded.
  </p>
  
  <h3>Loading the Scid ECO file</h3>
  <p>
  The ECO file that comes with Scid is called <b>scid.eco</b>,
  and Scid tries to load this when it starts up.
  If Scid cannot find it, you will need to do the following to enable ECO
  classification:
  <ul>
  <li>(a) In Scid, use the menu command
  <menu>Options: Load ECO file</menu>
  and select the file <b>scid.eco</b>. </li>
  <li>(b) Save options (from the <menu>Options</menu> menu). </li>
  </ul>
  After you do this, the ECO file will be loaded every time you start Scid.
  </p>
  
  <h3><name Codes>ECO code system</name></h3>
  <p>
  The basic structure of the ECO system is:
  </p>
  <p>
  <b><blue><run ::windows::eco::Refresh A>A</run></blue></b>
  1.d4 Nf6 2...;  1.d4 ...;  1.c4;  1.various
  <ul>
  <li>  <b>A0</b>  1.<i>various</i>
  (<b>A02-A03</b> 1.f4: <i>Bird's Opening</i>,
  <b>A04-A09</b>  1.Nf3: <i>Reti, King's Indian Attack</i>) </li>
  <li>  <b>A1</b>  1.c4 ...: <i>English</i> </li>
  <li>  <b>A2</b>  1.c4 e5: <i>King's English</i> </li>
  <li>  <b>A3</b>  1.c4 c5: <i>English, Symmetrical </i> </li>
  <li>  <b>A4</b>  1.d4 ...: <i>Queen's Pawn</i> </li>
  <li>  <b>A5</b>  1.d4 Nf6 2.c4 ..: <i>Indian Defence </i> </li>
  <li>  <b>A6</b>  1.d4 Nf6 2.c4 c5 3.d5 e6: <i>Modern Benoni</i> </li>
  <li>  <b>A7</b>  A6 + 4.Nc3 exd5 5.cxd5 d6 6.e4 g6 7.Nf3 </li>
  <li>  <b>A8</b>  1.d4 f5: <i>Dutch Defence</i> </li>
  <li>  <b>A9</b>  1.d4 f5 2.c4 e6: <i>Dutch Defence</i> </li>
  </ul>
  
  <p>
  <b><blue><run ::windows::eco::Refresh B>B</run></blue></b>
  1.e4 c5;  1.e4 c6;  1.e4 d6;  1.e4 <i>various</i>
  <ul>
  <li>  <b>B0</b>  1.e4 ...
  (<b>B02-B05</b>  1.e4 Nf6: <i>Alekhine Defence</i>;
  <b>B07-B09</b>  1.e4 d6: <i>Pirc</i>) </li>
  <li>  <b>B1</b>  1.e4 c6: <i>Caro-Kann</i> </li>
  <li>  <b>B2</b>  1.e4 c5: <i>Sicilian Defence </i> </li>
  <li>  <b>B3</b>  1.e4 c5 2.Nf3 Nc6: <i>Sicilian</i> </li>
  <li>  <b>B4</b>  1.e4 c5 2.Nf3 e6: <i>Sicilian</i> </li>
  <li>  <b>B5</b>  1.e4 c5 2.Nf3 d6: <i>Sicilian</i> </li>
  <li>  <b>B6</b>  B5 + 3.d4 cxd4 4.Nxd4 Nf6 5.Nc3 Nc6 </li>
  <li>  <b>B7</b>  B5 + 4.Nxd4 Nf6 5.Nc3 g6: <i>Sicilian Dragon</i> </li>
  <li>  <b>B8</b>  B5 + 4.Nxd4 Nf6 5.Nc3 e6: <i>Sicilian Scheveningen</i> </li>
  <li>  <b>B9</b>  B5 + 4.Nxd4 Nf6 5.Nc3 a6: <i>Sicilian Najdorf</i> </li>
  </ul>
  
  <p>
  <b><blue><run ::windows::eco::Refresh C>C</run></blue></b>
  1.e4 e5;  1.e4 e6
  <ul>
  <li>  <b>C0</b>  1.e4 e6: <i>French Defence</i> </li>
  <li>  <b>C1</b>  1.e4 e6 2.d4 d5 3.Nc3: <i>French, Winawer/Classical</i> </li>
  <li>  <b>C2</b>  1.e4 e5: <i>Open Game</i> </li>
  <li>  <b>C3</b>  1.e4 e5 2.f4: <i>King's Gambit</i> </li>
  <li>  <b>C4</b>  1.e4 e5 2.Nf3: <i>Open Game</i> </li>
  <li>  <b>C5</b>  1.e4 e5 2.Nf3 Nc6 3.Bc4: <i>Italian; Two Knights</i> </li>
  <li>  <b>C6</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5: <i>Spanish (Ruy Lopez)</i> </li>
  <li>  <b>C7</b>  1.e4 e5 2.Nf3 Nc6 3.Bb5 a6 4.Ba4: <i>Spanish</i> </li>
  <li>  <b>C8</b>  C7 + 4...Nf6 5.O-O: <i>Spanish, Closed and Open</i>
  (<b>C80-C83</b>  5.O-O Nxe4: <i>Spanish, Open System</i>;
  <b>C84-C89</b>  5.O-O Be7: <i>Spanish, Closed System</i>) </li>
  <li>  <b>C9</b>  C8 + 5...Be7 6.Re1 b5 7.Bb3 d6: <i>Spanish, Closed</i> </li>
  </ul>
  
  <p>
  <b><blue><run ::windows::eco::Refresh D>D</run></blue></b>
  1.d4 d5; 1.d4 Nf6 2.c4 g6 with 3...d5
  <ul>
  <li>  <b>D0</b>   1.d4 d5: <i>Queen's Pawn</i> </li>
  <li>  <b>D1</b>   1.d4 d5 2.c4 c6: <i>Slav Defence</i> </li>
  <li>  <b>D2</b>  1.d4 d5 2.c4 dxc4: <i>Queen's Gambit Accepted (QGA)</i> </li>
  <li>  <b>D3</b>  1.d4 d5 2.c4 e6: <i>Queen's Gambit Declined (QGD)</i> </li>
  <li>  <b>D4</b>  D3 + 3.Nc3 Nf6 4.Nf3 c5/c6: <i>Semi-Tarrasch; Semi-Slav</i> </li>
  <li>  <b>D5</b>  D3 + 3.Nc3 Nf6 4.Bg5: <i>QGD Classical</i> </li>
  <li>  <b>D6</b>  D5 + 4...Be7 5.e3 O-O 6.Nf3 Nbd7: <i>QGD Orthodox</i> </li>
  <li>  <b>D7</b>  1.d4 Nf6 2.c4 g6 with 3...d5: <i>Grunfeld</i> </li>
  <li>  <b>D8</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5: <i>Grunfeld</i> </li>
  <li>  <b>D9</b>  1.d4 Nf6 2.c4 g6 3.Nc3 d5 4.Nf3: <i>Grunfeld</i> </li>
  </ul>
  
  <p>
  <b><blue><run ::windows::eco::Refresh E>E</run></blue></b>
  1.d4 Nf6 2.c4 e6; 1.d4 Nf6 2.c4 g6 </li>
  <ul>
  <li>  <b>E0</b>  1.d4 Nf6 2.c4 e6: <i>Catalan, etc</i> </li>
  <li>  <b>E1</b>  1.d4 Nf6 2.c4 e6 3.Nf3 (b6): <i>Queen's Indian, etc</i> </li>
  <li>  <b>E2</b>  1.d4 Nf6 2.c4 e6 3.Nc3 (Bb4): <i>Nimzo-Indian, etc</i> </li>
  <li>  <b>E3</b>  E2 + 4.Bg5 or 4.Qc2: <i>Nimzo-Indian</i> </li>
  <li>  <b>E4</b>  E2 + 4.e3: <i>Nimzo-Indian, Rubinstein</i> </li>
  <li>  <b>E5</b>  E4 + 4...O-O 5.Nf3: <i>Nimzo-Indian, main line</i> </li>
  <li>  <b>E6</b>  1.d4 Nf6 2.c4 g6: <i>King's Indian</i> </li>
  <li>  <b>E7</b>  1.d4 Nf6 2.c4 g6 3.Nc3 Bg7 4.e4: <i>King's Indian</i> </li>
  <li>  <b>E8</b>  E7 + 4...d6 5.f3: <i>King's Indian, Samisch</i> </li>
  <li>  <b>E9</b>  E7 + 4...d6 5.Nf3: <i>King's Indian, main lines</i> </li>
  </ul>
  
  <p><footer>(Updated: Scid 3.6.2, December 2006)</footer></p>
}


set helpTitle(Author) "Contact information"
set helpText(Author) {<h1>Contact Information</h1>
  <p>
  The Scid web page is located at: <br>
  <b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
  </p>
  <p>
  It has downloads of the latest version of Scid and any extra
  files that are available.
  </p>
  <p>
  Please send any comments, questions, suggestions or bug reports to
  the Scid mailinglist <b>scid-users@lists.sourceforge.net</b>.
  </p>
  
  <h3><name Related>Related Links</name></h3>
  <p>
  If you enjoy using Scid, you may find the following websites interesting:
  </p>
  <ul>
  <li><url http://scid.sourceforge.net/>http://scid.sourceforge.net</url>--
  The program upon which Scid is heavily based. Scid was written by
  Shane Hudson, with help from others.</li>
  <li><url http://www.tim-mann.org/chess.html>http://www.tim_mann.org/chess.html</url> --
  Home page of Tim Mann's <b>xboard & winboard</b> program which is a PGN
  reader and an interface for Internet chess servers. His site also has
  good information on Crafty, GNUchess and other free chess programs.</li>
  
  <li><url http://theweekinchess.com/twic>http://theweekinchess.com/twic</url> --
  TWIC (the week in chess), an excellent weekly bulletin of international
  chess games in available in <a PGN>PGN</a> format.</li>
  
  <li><url http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm>http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm</url> --
  the <b>PGN Standard</b>, created by Steven J. Edwards in 1994.
  This file explains the <a PGN>PGN</a> and EPD formats in detail.</li>
  </ul>
  
  <p><footer>(Updated: Scid 4.7, August 2018)</footer></p>
}

# Book window help
set helpTitle(Book) "Book Window"
set helpText(Book) {<h1>Book window</h1>
  <p>
  A list of all book files present in Scid's books directory is
  presented in the drop down list on top of the window. To specify the
  directory where Scid should search for opening books select Options /
  Books directory from the menu. The active book can be selected
  easily from that list.
  </p>
  <p>
  The format of books is the one used by Polyglot and the engines like
  Fruit and Toga, their usual extension is .bin. Currently, to build
  new books one has to use <term>polyglot</term> on the command line.
  Please refer to polyglots documentation about how to create a book.
  </p>
  <p>
  For each position, the book window displays all possible moves it
  contains and their relative weights in percent. When a move is
  entered, the book window is updated. Clicking on a move in the book
  window will play that move in current position.
  </p>
  <p>
  At the bottom of the book window, the button <i>Other moves</i> displays the moves
  that are not present in the book but part of lines that are present later on in the book.
  This allows an engine to play the best moves, and to have book replies available in the 
  book if the opponent chooses moves that are not in the book. The display of those <i>Other moves</i>
  shows where there are holes in a book.
  </p>
  <p>
  The book in use can be selected from the drop down list in the
  book window.
  </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# Tactical game window help
set helpTitle(TacticalGame) "Tactical Game Window"
set helpText(TacticalGame) {<h1>Tactical game window</h1>
  <p>
  Play a tactical game against an engine simulating an opponent with a
  given Elo rating.  The opponent is played by Phalanx and the coach
  by Toga or an UCI-Engine. The right engines are automatically selected by their
  names, and should be correctly configured (this is the default when
  Scid is installed).
  </p>
  <p>
  <b>Note</b> that a special version of the Phalanx engine is
  required. This special version comes with the Scid package.
  </p>
  <p>
  The following parameters must be configured :
  <ul>
  <li><term>Fixed level</term>: sets a fixed Elo rating for the opponent</li>
  <li><term>Random level</term>: chooses a random level between the
  minimum and maximum level specified by the left and right slider
  respectively.
  </li>
  <li><term>Opening:</term>
  <ul>
     <li><term>Start new game</term>: starts a new game choosing a
     random opening.</li>
     <li><term>Start from current position</term>: let the game begin
     with the current board position.</li>
     <li><term>Specific opening</term>: the opponent will play a
     specific opening, that can be chosen from the list below. This is
     useful for opening training.</li>
  </ul>
  <li><term>Limit engine analysis time</term> allows to limit the time used by the
  coach to check the players moves for errors. If this time is not
  limited the coach is allowed to think in the background.</li>
  </ul>
  <p>Tip: If you switch on the <a Graphs>score graph</a>, you can see the use of time and the rating of the position during the game.</p>
  <p>To start a tactical game press <term>Play</term></p> 

  <p><b>Note</b> a similar function can be achieved by playing a
  <a SeriousGame>serious game</a> against any UCI engine that allows
  for limiting its strength.
  </p>
  <p><footer>(Updated: Scid 4.7, August 2018)</footer></p>
}

# Opening Trainer window help
set helpTitle(OpeningTrainer) "Opening Trainer"
set helpText(OpeningTrainer) {<h1>Opening Trainer</h1>
  <p>
  A Scid database can be used as a repertoire, each game representing
  an opening line. The games can contain variations and may also
  contain NAG values to specify values for each line, and thus
  allowing to mark preferred or dubious lines. To be a valid database
  for the opening trainer it is also required to be of proper type.
  That is, if openings for white are to be trained, the database has
  to be of type <term>Openings for White</term> (similar for Black and
  both colors). The type can be set via the <a Maintenance>Maintenance
  window</a> by selecting the icon or via the database switchers
  context menu.
  </p>
  <p>
  <h2>Creating a repertoire base</h2>
  Before running the opening trainer, please be aware that the entire
  repertoire database will be loaded into the trainer. For this
  reason, it is good to use a smaller database. It is a good idea to
  first assemble a large database of quality games, then filter the
  database for a specific opening (e.g. the Ruy Lopez). These filtered
  games could then be copied to a new database for that specific
  opening you had in mind (please name it intelligently, so you can
  easily understand which opening it is for). Then instead of an
  entire 2 million or so game database, you have a much smaller
  repertoire database that will be loaded quickly into the opening
  trainer.
  </p>
  <p>
  You could also buy or download special databases that cover
  particular openings, although we cannot point you in the direction
  of any possible sources in this help file.
  </p>
  <p>
  Once you have a smaller database aimed at just the opening you
  require, set the type as mentioned using the <a
  Maintenance>Maintenance window</a>.  You will need to restart Scid
  to use the opening trainer with this new repertoire database.
  </p>
  <p>
  If you choose, for the opening trainer to work better, you may flag
  certain games as "White opening" or "Black opening". An exhaustive
  way of doing this would be to go through the entire database 'by
  hand' and assign the flags individually. A quicker way, may be to
  filter your database for white openings, then set the flag for all
  those filtered games, and similarly for black openings. Remember you
  can have a repertoire for both white and black in the same database.
  You can set the flags in this way via the <a Maintenance>Maintenance
  window</a>. How you choose to filter the games for flagging is
  entirely up to the user. One possible way is to filter 1-0 games for
  white openings, and 0-1 for black openings. This way is not the best
  however, and it is left to the user to find the system they feel
  most comfortable with.
  </p>
  <p>
  Finally, to work best, the Opening Trainer can use NAG values to understand 
  how a move in the opening is to be rated. Please refer to the <a NAGs>NAG 
  annotation help</a> for more information.
  </p>
  <p>
  <h2>Using the opening trainer</h2>
  To use the opening trainer first of all open the repertoire database you
  created, or one of the proper type. Then choose Play / Training / Opening Trainer.
  The upcoming dialogue offers some choices about the next training
  session
  <ul>
      <li><term>white</term>/<term>black</term>/<term>both</term> is
      used to select the side of the opening to train
      </li>
      <li><term>Allow only best moves</term> will treat lower rated moves
      as error. The rating of a line is given by NAG values.</li>
      <li><term>Opponent plays best moves</term> Scid will always play
      the best continuation according to the repertoire database. If
      unchecked Scid is allowed to choose also lower rated
      continuations. This is helpful to learn the refutations as well.
      </li>
      <li><term>Only flagged lines</term> Scid will only play lines
      from games flagged as <term>Opening for White</term> or
      <term>Opening for Black</term>.
      </li>
      <li><term>Reset statistics</term> will reset the statistics
      before the training session.</li>
  </ul>
  Press the <term>Continue</term> button to proceed with the training.
  </p>
  <p>
  The actual opening trainer will show up. Here one can display
  possible candidate moves (hidden by default) and also display their
  values by just enabling these functions. If <term>Show
  statistics</term> is enabled, the current statistics is shown in the
  color coded fields below the checkbox. Otherwise the overall
  statistics can be accessed by the button <term>Show report</term>
  
  <h3>Opening trainer statistics</h3>
  <p>
  Four numbers are displayed showing statistics for current position:
  <ul>
  <li><term>Green</term> the number of moves played by the user that
  are good moves</li>
  <li><term>Yellow</term> the number of dubious moves played that are
  in the repertoire</li>
  <li><term>Red</term> the number of moves played that are not in the
  repertoire</li>
  <li><term>White</term> the number of times the position was
  encountered</li>
  </ul>
  </p>
  
  <h3>The report</h3>
  <p>
  The report shows statistics for the whole repertoire and gives
  information about user's knowledge :
  <ul>
  <li><term>Positions in repertoire</term> the total number of
  positions in the repertoire (all lines in database)</li>
  <li><term>Positions not played</term> the positions that were never
  encountered</li>
  <li><term>Positions played</term> the positions that were played and
  the sum of the number of times they were encountered. Note that this
  figure represents the sum of occurrences of a position in all
  opening lines: this number can quickly become big for positions
  that are close to the start position</li>
  <li><term>Success</term> the number of good moves made by the player</li>
  <li><term>Dubious moves</term> the number of weak moves made by the
  player</li>
  <li><term>Out of repertoire</term> the number of moves made by the
  player that were not in repertoire</li>
  </ul>
  </p> 
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

####################
### Correspondence Chess help:
set helpTitle(Correspondence) "Correspondence Chess"
set helpText(Correspondence) {<h1>Correspondence Chess</h1>

<p>
Scid offers currently two main functionalities for correspondence
chess.
</p>
<ul>
   <li><b>eMail Chess</b> proceeds by sending the current game via eMail
   to your opponent once you made your move. To this end an eMail message
   is created in your preferred email program with the current game
   attached to it in <a PGN>PGN</a> format. Of course all comments and
   variations are stripped off before.
   </li>
   <li><b>Correspondence Chess Servers</b> are supported by means of the
   Xfcc protocol. Here external tools are used to fetch the games from
   your account(s) and deliver them to Scid for synchronisation. After
   you made your move this move is sent to your opponent also by means of
   Xfcc. The fetch and send tool are implemented as external tools for
   easy extension if other protocols arise.
   </li>
   <li><b>Postal play</b>: Scid allows support for postal play by
	adding a PGN file with the proper header information to its Inbox
	directory. If the additional header field <b>Mode</b> is set to
	<b>Postal</b> those games get their proper icon displayed. Note
	that also the header fields <b>CmailGamename</b> and <b>Gameid</b>
	should be present. 
	---TODO---: Printing of postcards is on the todo, this function
	will require the additional header fields WhiteAddress/BlackAddress
	to contain the postal address of both players.
   </li>
   <li><b>Observation of games</b> is supported by just adding the URL
   for the <a PGN>PGN</a> file to the list offered by <menu>Play / Correspondence
   Chess / Observe Game</menu>. For this function to work a connector
	for the site in question is required. (See below)
   </li>
</ul>
<p>
If any of the correspondence chess functions are accessed from the
menu a new window opens up. It can be opened manually from the window
menu or one can use the keyboard shortcut F12. There are two
additional shortcuts:
</p>
<ul>
   <li><b>Ctrl-F12</b>
      This will open the correspondence chess window and the default
      database. It will also process your current Inbox.
   </li>
   <li><b>Alt-F12</b>
      This will open the correspondence chess window, the default
      database and also initiate the fetch of Xfcc games in one go.
   </li
</ul>
<p>
Please see below for further details.
</p>

<p>
This window contains the necessary buttons to navigate through
ongoing games, shortcut keys to fetch games by means of the Xfcc
protocol and sync in eMail based games as well as a console stating
which messages where sent or retrieved. Additionally this window
contains a list of ongoing games retrieved from your Inbox directory.
</p>

<p>
To use the correspondence chess features a database of the type
"Correspondence chess" has to be opened before calling any
correspondence chess functions. If you do not have such a database
yet, just create a new database and set its type to "Correspondence
chess" by means of the <a Maintenance>Maintenance</a> function.
Setting the type is important as Scid will recognise the database for
synchronisation by this type. As this database is empty after the
creation Scid will treat all correspondence chess games it receives at
first synchronisation as new games and append them to this database.
</p>

<p>
If no database of the type "Correspondence chess" is currently opened
Scid will remind you of doing so. However, do not open more than one
database of this type as Scid then can not recognise the one to use.
</p>

<h3><name CCWorkflow>Basic functionality</name></h3>

<p>
If everything is set up correctly the usage of the correspondence
chess functions can easily accessed by the following buttons:
<ul>
   <li><button tb_CC_Retrieve> Retrieve the correspondence chess games.
   To this end the external fetch tool is called and all games retrieved
   via that way as well as all other games that are stored in Scid's Inbox
   (see below) are synchronised into the current correspondence chess
   database.
   </li>
   <li><button tb_CC_Send> Sends your move to the opponent by either
   creating a new eMail message in your preferred mail program or by
   sending the move to a chess server in case of Xfcc.
   </li>
   <li><button tb_CC_delete> empties your In- and Outbox directories.
   </li>
   <li><img tb_CC_online> is shown if the game list was refreshed
   from the server within the current Scid session. The tool tip for
   this icon shows date and time of the last refresh.
   </li>
   <li><img tb_CC_offline> indicates, that Xfcc status icons are
   restored from saved results. No update has taken place in the
   current Scid session. The tool tip for this icon shows date and
   time of the last refresh.
   </li>
   <li><img tb_CC_pluginactive> indicates, that Correspondence Chess
   plugin(s) were loaded and activated upon startup.
   </li>
</ul>
</p>
<p>
See also the list of <a CCIcons>Icons and Status Indicators</a>.
</p>

<h3>Configuration</h3>

<p>
Correspondence Chess within Scid is based upon a normal Scid
database that holds the games and some helpers external to Scid that
handle the "non-chess-parts". These tools and parameters must be set
up once, and are stored afterwards for future use.
</p>

<p>
To access the configuration dialog choose <menu>Play</menu>
<menu>Correspondence Chess</menu><menu>Configure</menu> from the
menu. The details are described in <a CCSetupDialog>Correspondence
Chess Setup</a>. Quitting this dialog by the <b>[Ok]</b> button will
automatically store your options.
</p>

<h3>Retrieving the games</h3>
<p>
Depending whether you play correspondence chess via eMail or via a
chess server the actual retrieval process differs slightly. Generally
it results in a set of games in <a PGN>PGN</a> format located in Scid's Inbox
directory. This offers also the possibility of automatic retrieval via
external software.
</p>
<p>
Once the games are in Scid's Inbox invoking <menu>Process Inbox</menu>
from the menu will work though the Inbox and add new moves to the
games already in the database. Additionally it will add games not
found in the current correspondence chess database as new games.
</p>

<p><a CCeMailChess>Correspondence Chess via eMail</a> describes the
details for the usage of eMail, while in <a CCXfcc>Correspondence
Chess via Chess Servers</a> describes the same for correspondence
chess servers.
</p>

<h3>Stepping through games</h3>
<p>
After games are retrieved they are loaded to Scid's clipboard database
and new moves are added and stored in the correspondence chess
database opened. The difference to
the functions from the <menu>Games</menu> menu is, that these two
buttons scroll only between the games in Scid's Inbox which are
supposed to be your actually ongoing games. Of course the
Correspondence Chess database might contain much more games, but
normally you do not want to go through all these to find out what your
opponent moved in a current game.
</p>
<p>
Note that a header search is required incorporating some fields that
are not indexed by Scid. Hence, storing your correspondence chess
games in a huge reference database might not be advisable as the
search times may be quite long. If you play a lot and your own
database gets quite large, search times can be reduced by moving
finished games to an archive database, or by just creating a new
database for the ongoing games. Scid will treat all games not existing
in the correspondence chess database already as new games and add them
automatically. Hence, it is sufficient to open an empty database of
type "Correspondence chess" and call <menu>Process Inbox</menu> to
import all currently ongoing games.
</p>
<p>
Equivalent to the two buttons mentioned are the items <menu>Previous
Game</menu> and <menu>Next Game</menu> from the <menu>Correspondence
Chess</menu> menu.
</p>
<p>
An alternate way to jump to a specific game is by double clicking on
it within the game list.
</p>
<p>
Note that if you set up your player names correctly (by means of
<menu>My Player Names</menu>) Scid will rotate the board for you to
play always upwards. You can have multiple player names. See also <a
Options MyPlayerNames>My Player Names</a> for details.
</p>

<h3>Analyse and make a move</h3>
<p>
All analysis features can be used for correspondence chess games.
Variations, annotations etc. can be added just like in normal game
analysis. Once finished, Scid will take the last half move added to
the game and treat it as the current move to send. No checking whether
only one half a move was added or which side to move is done here,
hence, only one half move to the mainline must be added!  In case a
chess server is used Scid also sends the last comment added to the
server which might be useful for communication with the opponent. In
eMail chess this can be done by the normal mail message, so there all
comments are stripped off.
</p>
<p>
Pressing the Send button <button tb_CC_Send> will have Scid to
determine the type of the correspondence chess game displayed (eMail or
a server game) and call either your eMail program or the external send
tool to submit your move. Calling <menu>Send move</menu> is equivalent
to this button. Alternatively, <menu>Mail move</menu> can be used to
send the current game via eMail. In case of an eMail game this
function is equivalent to <menu>Send move</menu>. In case of a server
based game an eMail message is generated. Note however, that it will
not necessarily contain a proper recipient as eMail addresses are not
exchanged in server based correspondence chess.
</p>

<h3>Observing Correspondence Games</h3>
Observing a game of correspondence chess is technically done by
retrieving the games <a PGN>PGN</a> notation from the webserver.
These games are then fed into the usual workflow of the
Correspondence Chess functions and show up there as usual games. For
this function to work a file named "connector.xml" has to be available
in ~/.scid/data. If this file does not exist Scid will try to generate
one suitable for observation of games from ICCF Webchess. Additional
servers can be added to this file by appending additional
server-blocks.	

To observe a game on ICCF Webchess point your web browser to the page
where the notation an the chess board gets displayed. Copy the URL of
that page to the clipboard and add it to the list displayed by
choosing <menu>Play / Correspondence Chess / Observe Game</menu>. Use
a new line for each game to be observed.

Close the dialogue by selecting Ok and refetch the correspondence
chess games. Now the newly added observed games should show up in the
Correspondence Chess games list.

<h3>Additional features of the Correspondence Chess Window</h3>
<p>
The Correspondence Chess window offers additional functions by means
of its own menu, which is identical to Play / Correspondence Chess. It
is also possible to use the usual scrolling features of Scid, like
jumping to the next (previous) game by Ctrl-Down (Ctrl-Up). Hovering
with the mouse over certain fields in the game list will also give
additional information as provided by the server. If
you want to copy the current game list to the clipboard one can use
the usual shortcuts Ctrl-Ins (or Ctrl-C).
</p>

<p><footer>(Updated: Scid 4.3, Jan 2011)</footer></p>
}

set helpTitle(CCIcons) "Correspondence Chess Icons and Status Indicators"
set helpText(CCIcons) {
<h1>Icons and Status Indicators</h1>
<p>
To shorten the display, a set of icons is used in the game list. Some
of them are only present in certain circumstances, some are only valid
for Xfcc based games, some for eMail based games. These indicators are
stored internally and are restored to the last update from the server
if no interet connection is available.
</p>
<ul>
   <li><img tb_CC_online> is shown if the game list was refreshed
   from the server within the current Scid session. The tool tip for
   this icon shows date and time of the last refresh.
   </li>
   <li><img tb_CC_offline> indicates, that Xfcc status icons are
   restored from saved results. No update has taken place in the
   current Scid session. The tool tip for this icon shows date and
   time of the last refresh.
   </li>
   <li><img tb_CC_pluginactive> indicates, that Correspondence Chess
   plugin(s) were loaded and activated upon startup.
   </li>
   <li><img tb_CC_envelope> This is an eMail based game. In those
   games many of the status flags used in Xfcc-based games are not
   available due to the limitation of the medium.
   </li>
   <li><img tb_CC_relay> This is a observed game, ie. you're just
   fetching it and you will not make any move in those games.
   </li>
   <li><img tb_CC_postal> The mode of this game is set to
   <i>postal</i> (ie. real classical correspondence play via postal
   service). Scid will show those games but ignore them in the update
   process as no <a PGN>PGN</a> game file will exist in postal play.
   </li>
   <li><img tb_CC_yourmove>
   Its your move.<br>
   <b>Note 1:</b> this status is only updated if you
   synchronise your games with the server, that is, it always refers
   to the servers status at last synchronisation.
   <br>
   <b>Note 2:</b>Hovering over this icon with the mouse will display
   the opponents last move.
   </li>
   <li><img tb_CC_oppmove>
   Its the opponents move. Note: this status is only updated if you
   synchronise your games with the server, that is, it always refers
   to the servers status at last synchronisation.
   </li>
   <li><img tb_CC_draw>
   Peace was agreed by a draw.
   </li>
   <li><img tb_CC_book>
   The use of opening books is allowed for this game.
   </li>
   <li><img tb_CC_database>
   The use of databases is allowed for this game.
   </li>
   <li><img tb_CC_tablebase>
   The use of endgame tablebases (e.g. Nalimov tablebases etc.) is
   allowed for this game.
   </li>
   <li><img tb_CC_engine>
   Chess Engines are allowed for this game. Sometimes these games are
   also referred to as "Advanced Chess".
   </li>
   <li><img tb_CC_outoftime>
   Your opponent ran out of time. You may claim a win on time.
   </li>
   <li><img tb_CC_message>
   Your opponent sent a message along with his last move. Check the
   game notation.
   </li>
</ul>
<p>
<b>Note 1:</b> If an event (e.g. a tournament) has not yet started, but
the setup was already retrieved via Xfcc the id, event and site
columns text show up in <gray><b>dark gray</b></gray>.
</p>
<p>
<b>Note 2:</b> Hovering over the site column will show the whole site
tag, hovering over the event column will show the whole event tag and
the time control if it was sent along with the game. If no time
control was sent, Scid will denote it as <i>10 / 50d (?)</i>, that is,
guessing ICCFs official default timing of 10 moves in 50 days. (The
ICCF server itself never sends any timings.)
</p>

<p>
In Xfcc games, each opponents country may be displayed by the
associated flag, if the server provides that information. For eMail
based games this can be achieved by adding additional <a PGN>PGN</a> tags for
<i>whiteCountry</i> and <i>blackCountry</i>, each followed by the
international three letter country code according to ISO 3166-1
(e.g. "EUR" <img flag_eur>, "USA" <img flag_usa>, "GBR" <img
flag_gbr>, "FRA" <img flag_fra>, "RUS" <img flag_rus>, "CHN"
<img flag_chn>...).
</p>
<p>
To show country flags for other types of games (postal, observed) just
add WhiteCountry/BlackCountry headers to the games in your database.
Note that the header values in the Scid database overwrite the values
supplied in the games of Scid's Inbox. That is even for Xfcc games that
one can add country flags or overwrite the games mode. (The latter is
required e.g. for mixed games on ICCF where ICCFs Xfcc interface
also supplies games even if they are played by post.)
</p>

<p>
See also the chapter <a Correspondence>Correspondence Chess</a> for
general information.
</p>


<p><footer>(Updated: Scid 4.3, Jun 2010)</footer></p>
}



set helpTitle(CCXfcc) "Correspondence Chess Servers"
set helpText(CCXfcc) {<h1>Correspondence Chess Servers</h1>

<p>
There exist several correspondence chess servers throughout the
internet. Generally, they are used by means of a web browser, so no
specific software is required. However many of them also offer an
interface to specialised chess software via a protocol called Xfcc.
The integration of Xfcc is done in Scid via external helper tools set
in the <a CCSetupDialog>Configuration</a> dialog for correspondence
chess.
</p>

<h3>Start a new game</h3>
<p>
Xfcc does not allow to start a new game itself. Searching for an
opponent and starting a game is instead handled by the chess server
on their web site. Once the game is started however, Scid can be used to
retrieve the moves of the opponent, add them to the internal database,
analyse them and so on. All features of Scid are to the users disposal
though certain modes of play may not allow them (e.g.  normal games
usually do not permit the usage of chess engines for analysis).
</p>

<h3>Retrieve games</h3>
<p>
Open a database that holds correspondence chess games. This database
has to be of type "Correspondence chess". 
</p>

Notes: 
<ul>
   <li>If Scid does not find a correspondence chess database it will
   inform you to open one.
   </li>
   <li>If the database does not hold the games that are fetched from
   the server they are treated as new games and added to the database
   automatically.
   </li>
   <li>Scid will use the first database of type "Correspondence Chess"
   that is currently open. For this reason only one such DB should be
   opened at a time.
   </li>
</ul>
<p>
Xfcc always retrieves all games hosted on a specified server for your
user ID at once. To retrieve the games just press the <button
tb_CC_Retrieve> icon or select <menu>Retrieve Games</menu> from the
<menu>Correspondence Chess</menu> menu. As a server connection is
required to fetch new games be sure that the system has network
access. Scid will call the fetch tool configured in the <a
CCSetupDialog>Configuration</a> dialog which will place the games in
PGN format in Scid's inbox. It may take some time to retrieve the
answer, so be patient. After the games are retrieved the
correspondence chess database is updated accordingly.
</p>

<p>
<b>Note</b>By using the <button tb_CC_delete> you can empty your whole
In- and Outbox directories.
</p>

<p>
Once the games are retrieved their counterpart is searched within the
correspondence chess db and new moves are added accordingly. As Xfcc
servers may offer various ways to insert moves (via web or mobile or
other programs...) it might well be that Scid will have to add half of
the game to the db. This poses no problem. Scid will add all moves
returned in the game from the server. Scid will however not replace
the game from the beginning as then all your analysis may be lost.
Hence it is <b>important to note</b> that you must not insert moves to
the main line beyond your own last move! To add continuations please
use variations!
</p>
<p>
Xfcc base games offer extensive status display within the games list.
This information, however, is only available if Scid's internal Xfcc
support is used.  The following icon are for visual display:
<ul>
   <li><img tb_CC_draw> A draw was agreed with the last move.
   </li>
   <li><img tb_CC_yourmove> You're on the move.
   </li>
   <li><img tb_CC_oppmove> Your opponent is on the move.
   </li>
   <li><img tb_CC_book> This game allows the use of opening books.
   </li>
   <li><img tb_CC_database> This game allows the use of databases.
   </li>
   <li><img tb_CC_tablebase> This game allows the use of tablebases.
   </li>
   <li><img tb_CC_engine> This game allows the use of chess engines.
   </li>
</ul>
<p>
Additionally Scid will display the clock for both parties <b>at the
time of sync</b> as well as the chess variant played. Note however
that Scid currently only supports standard chess.
</p>
<p>
Note: only if the proper icon (book, database, tablebase, engine)
is displayed, the usage of these tools is allowed. It is forbidden
otherwise. Be fair and respect these rules.
</p>
<p>
Note: if other sources have placed games in your inbox (e.g. from
your eMail correspondence chess) they are also synchronised in the
retrieval step into the database as the whole Inbox is worked through.
This allows for adding eMail games to the Inbox, then switch to Scid,
hit <button tb_CC_Retrieve> and all games are up to date.  Games that are not
yet found in the database are treated as new games and appended to the
database.
</p>
<p>
<b>Note</b>By using the <button tb_CC_delete> you can empty your whole
In- and Outbox directories.
</p>
<p>
<b>Note for programmers</b>: the fetch tool is called with the Inbox path as
parameter. It is thought to work through all server accounts and place
properly formatted <a PGN>PGN</a> files in the path passed to it. These files
should contain additional header fields as they are known by the cmail
tool. (See <a CCeMailChess>Correspondence Chess via eMail</a> for
information about the fields required.)
</p>

<p><footer>(Updated: Scid 3.6.23, March 2008)</footer></p>
}

#############
# eMail Chess:
set helpTitle(CCeMailChess) "Correspondence Chess via eMail"
set helpText(CCeMailChess) {<h1>Correspondence Chess via eMail</h1>

<p>
eMail offers a very convenient way to play correspondence chess. The
standard application in the Un*x world for this till today is xboard
together with its cmail helper. As it allows for almost automatic
handling of correspondence chess eMails and additionally does not add
anything not conforming to <a PGN>PGN</a> it is also the model for Scid to handle
eMail chess. By just preserving the whole <a PGN>PGN</a> header such games can be
played with any opponent who has a tool to handle PGN.
</p>

<h3>eMail Chess</h3>
<p>
Scid can handle eMail correspondence chess games almost automatically.
The way how this is done is kept compatible to the cmail utility that
comes with xboard on Un*x systems. (Having said this implies that you
can play against an opponent using cmail/xboard.) It works by sending
the games as whole <a PGN>PGN</a> files too and fro as mail attachments, while
the header contains certain tags that allows them to be recognised and
sorted together. For this reason the user has to be careful with
editing of the header fields.  Note that fields with explicit values have
to be set to exactly this value for eMail chess. Starting a game with
Scid will do this automatically, but you <b>must not</b> overwrite
or delete them!
</p>
<p>
Essential header fields are:
</p>
<ul>
   <li><term>Event</term>: by default "Email correspondence game"
   </li>
   <li><term>Site</term>: has to be "NET"
   </li>
   <li><term>Mode</term>: has to be "EM"
   </li>
   <li><term>WhiteNA</term>: contains the eMail address of the white player. Note
   that only the bare address is stored there in the form
   <term>user@host.org</term>.
   </li>
   <li><term>BlackNA</term>: contains the eMail address of the black player
   similar to WhiteNA.
   </li>
   <li><term>CmailGameName</term>: Contains a <b>unique</b> identifier for
   the game. This is used to sort the games together.
   <p>
   While Scid could use some database index this is not possible for
   non-DB-based tools like cmail. For this reason the
   <term>CmailGameName</term> parameter is user supplied. It must be
   unique! The easiest way is something of the form
   <term>xx-yy-yyyymmdd</term> where xx is a shortcut for the white
   player, yy one for the black player, and yyyymmdd the current date.
   </p>
   <p>For Xfcc-based games this field has also to be set to a unique
   identifier but there the server name and the unique game number on
   this server can be used, that is this identifier is of the form
   <term>MyXfccServer-12345</term>.
   </p>
   </li>
</ul>
<p>
eMail based chess does not contain that extended status codes as Xfcc.
These games show the <img tb_CC_envelope> icon to notify them as
eMail based. The same applies to observed games, denoted by <img
tb_CC_relay> and postal games which show the <img tb_CC_postal> icon.
</p>

<h3>Start a new game</h3>
<p>
This opens a dialog for the input of the own and the opponents name as
they should appear in the header as well as the eMail addresses of
both parties. Additionally a <b>unique</b> game ID has to be inserted.
The easiest way for this ID is something of the form
<term>xx-yy-yyyymmdd</term> where xx is a shortcut for the white
player, yy one for the black player, and yyyymmdd the current date.
This id is a text and it is important to identify the games uniquely.
Users of cmail will also know this ID as <i>game name</i>. It must
only contain letters and numbers, the minus sign and the underscore.
Please avoid other characters.
</p>
<p>
After the dialog is quit by pressing the <b>[Ok]</b> button a new
game is appended to the currently loaded correspondence chess database
and the <a PGN>PGN</a> header is set properly. Just make your move and send it as
mentioned below.
</p>

<h3>Retrieve games</h3>

<p>
Scid does not handle your mailbox automatically. This would,
considering the wide range of possible mail setups these days, involve
a huge amount of code. For this reason Scid relies on your normal
eMail program which is far more suitable for this purpose than Scid
can ever be. To get a game into Scid just save the attached <a PGN>PGN</a> file
to Scid's inbox and process the inbox by either <menu>Retrieve
Games</menu> or the <button tb_CC_Retrieve> button or
<menu>Process Inbox</menu>. The difference between the two is that
the first one will also fetch and populate the Inbox additionally with
games from another source (say Xfcc) by either the internal Xfcc
support or an external fetch tool called. Hence <button
tb_CC_Retrieve> is the most convenient way if you use both types of
correspondence chess games.
</p>
<p>
<b>Note</b> The <menu>Retrieve Games</menu> menu or the <button
tb_CC_Retrieve> button do <b>not</b> fetch your eMail messages! You
have to save your <a PGN>PGN</a> files to Scid's Inbox by hand. Probably this can
be automatised by your eMail program (on Un*x systems setting up a
mime handler is easy enough by means of <term>.mailcap</term>).
</p>
<p>
<b>Note</b>By using the <button tb_CC_delete> you can empty your whole
In- and Outbox directories.
</p>

<h3>Send the response</h3>

<p>
After making your move send it by either the <menu>Mail Move</menu>
item from the menu via <menu>Send move</menu> which is equivalent to
<button tb_CC_Send>. The latter will Scid have to recognise the game
as eMail correspondence and send it by mail while the former method
will force Scid to generate an eMail message.
</p>
<p>
Of course Scid strips the the game bare of any comments and variations
before attaching it to the outgoing eMail as you probably do not want to send
your analysis along.
</p>
<p>
If a GUI-mailer is used, its usual compose window is opened. The
address of your opponent is filled in as well as a generic subject
containing the game id for easy filtering and the bcc address if
specified in the <a CCSetupDialog>Configuration</a> dialog. The mail
body is set to contain the <term>FEN</term> of the final position and
the list of moves made so far. This way the opponent can quickly look
up your move. Finally, Scid attaches the current game including your
move in <a PGN>PGN</a> format to the mail message.
</p>
<p>
When using a mailx compatible tool no window is opened and the mail is
sent invisibly by invoking the tool specified in the background. In
this case the generated mail contains the <a PGN>PGN</a> also in the mail body.
</p>
<p>
Note that as eMail chess works by sending the whole <a PGN>PGN</a> file you must
not add more than your half move. Scid does not check here whether
more than one half move was added to the mainline, simply as Scid does
not know which move it was, when you sent yours.
</p>
<p><footer>(Updated: Scid 3.6.23, March 2008)</footer></p>
}

#############
# Correspondence Chess setup dialog help:
set helpTitle(CCSetupDialog) "Correspondence Chess Setup"
set helpText(CCSetupDialog) {<h1>Correspondence Chess Setup</h1>

<p>
The entries in the configuration dialog are preset to some default
parameters but those must not match the reality on your system, so
adoption will surely be necessary. All parameters are stored in the
configuration file automatically once the dialog is closed via the
<b>[Ok]</b> button. The parameters are effective immediately.
</p>

<p><b>Note</b> that Scid will use the defaults until this setup dialog
is called and quit by selecting the <term>OK</term> button. The
default values are never stored in Scid's internal config file until
then. Additionally, if Scid can not find a valid config, it will try
to set up the correspondence chess functions automatically. By default
it will store all data in the <term>data</term> subdir of Scid's
configuration. Here also a valid DB as well as the necessary
In/Outboxes are created.
</p>

<p>
<b>Default Database</b>:
This defines the default database for
correspondence chess games. It can be accessed easily via
<menu>Open Database</menu> in the <menu>Correspondence Chess</menu>
menu. The advantage of this method is, that this database does not
show up in the <i>recent databases</i> lists and that you can have a
specific file for this. This database <b>has to be</b> of type
"Correspondence chess". Opening a database of this type by any other
means is also ok, so probably you may want to ignore this setting
(e.g. if you call Scid with your correspondence chess database on
startup.)
</p>

<p>
<b>Inbox (path)</b>:
In this directory Scid will look for correspondence chess games stored
in <a PGN>PGN</a> format. These games are used for the synchronisation of the
correspondence chess database. Generally, Scid does not care how the
games come to this directory. It will just work through all <a PGN>PGN</a> files
located there. This offers the possibility to use some external tools
to fetch games to this location. Additionally, in eMail chess one
should just save the <a PGN>PGN</a> files received from the opponent in this
directory.
</p>
<p>
Scid will not read a mailbox of whatever sort, it just handles
all <a PGN>PGN</a> files placed in that directory. Also note, that it will
synchronise games with the current database. However, if a game
from this directory does not yet exist in the database it is
treated as new game and appended to the database.
</p>
<p>
For the synchronisation process to work the <a PGN>PGN</a> files must contain
some additional header information that are in perfect agreement with
the <a PGN>PGN</a> standard. Please have a look at <a CCeMailChess>Correspondence
Chess via eMail</a> if you want to create your own tool or if you are
migrating data from some other system.
</p>

<p>
<b>Outbox (path)</b>:
The inverse of the <i>Inbox</i>. Scid places here <a PGN>PGN</a> files of the
outgoing games. For eMail chess this is essential as the <a PGN>PGN</a> files have
to be attached to an eMail message.  For Xfcc, where only the move is
sent, this would not be necessary, however the Outbox directory offers
a convenient way to link up to your PDA or for any other usage as the
PGN files contained in the Outbox will also contain your last move.
</p>

<p>
<b>Use internal Xfcc support</b>:
If checked Scid will not use the external tools specified as external
protocol handlers but use its internal Xfcc support to fetch games and
send moves. This will be the most convenient way to access an Xfcc
server and should be used as default.
</p>
<p>
This feature requires http and tDOM support for TCL to be installed.
Usually, these modules are distributed with your TCL installation,
however, on some systems they have to be installed explicitly. If
either one is not found this function is disabled.
</p>
<p>
<b>Xfcc Configuration</b>:
Give the path and filename of the config file for the xfcc protocol
handler. This path is also passed on to the external protocol handlers
to be used by them.
</p>

<p>
<b>Fetch Tool</b>:
This program is called to retrieve correspondence chess
games from a correspondence chess server. This helper just has to
fetch the games from whatever source it likes, generate a proper PGN
file containing the necessary <a PGN>PGN</a> header. Tools for fetching games
from Xfcc-servers exist as external programs and these are the natural
tools to set up here. For future protocols one could easily generate
an external fetch tool that handles this protocol. Also automatisation
is possible if this functionality is done externally.
</p>
<p>
Note: This tool is <b>not</b> called for retrieval of eMail chess
messages!
</p>

<p>
<b>Send Tool</b>: 
This is the inverse of the fetch tool, primarily also meant for Xfcc
support or any future protocol that might come up. The send tool,
however, is called from Scid with several parameters where the call
looks like:
<term>
SendTool Outbox Name GameID MoveCount Move "Comment" resign claimDraw offerDraw acceptDraw
</term>
</p>

<p>
<b>Confirm moves</b>: Opens a confirmation dialogue after pressing the
send button for each move that is send to the server.
</p>

<p>
<b>Only games I have the move</b>: Checking this setting will shorten
the games listed in the Correspondence Chess window to only those
games where the player is to move.
</p>

<p>
<b>Sorting</b>: Allows to sort games by various criteria. This sorting
takes effect upon the next update of the games list, e.g. by reopening
the Correspondence Chess window, fetching games or processing the
Inbox.
</p>

<p>
The meaning of the parameters is as follows:
   <ul>
      <li><term>Outbox</term>: The Outbox path set in this dialog. The
      send tool is meant to generate a correctly formatted <a PGN>PGN</a> file
      there.
      </li>
      <li><term>Name</term>: The name of the player to move as stated
      in the <a PGN>PGN</a> header. For Xfcc this would be the login name. It is
      identical to the player name in the <a PGN>PGN</a> header.
      </li>
      <li><term>MoveCount</term>: The move number to send.
      </li>
      <li><term>Move</term>: The actual move in SAN.
      </li>
      <li><term>"Comment"</term>: A comment sent to the opponent. Scid
      inserts the last comment of the game. That is these comments are
      treated as comments to the opponent. Note that the comment is
      quoted, so multiline comments should be possible.
      </li>
      <li><term>resign</term>: 0 or 1, specifying whether the user
      wants to resign. Set to 1 if the user invokes
      <menu>Resign</menu> from the <menu>Correspondence Chess</menu>
      menu.
      </li>
      <li><term>claimDraw</term>: 0 or 1, specifying whether the user
      wants to claim a draw. Set to 1 if the user invokes
      <menu>Claim Draw</menu> from the <menu>Correspondence Chess</menu>
      menu.
      </li>
      <li><term>offerDraw</term>: 0 or 1, specifying whether the user
      wants to offer a draw. Set to 1 if the user invokes <menu>Offer
      Draw</menu> from the <menu>Correspondence Chess</menu> menu.
      </li>
      <li><term>acceptDraw</term>: 0 or 1, specifying whether the user
      wants to accept a draw offered by the opponent. Set to 1 if the
      user invokes <menu>Accept Draw</menu> from the
      <menu>Correspondence Chess</menu>
      menu.
      </li>
   </ul>
</p>
<p>
Note: This tool is <b>not</b> called for eMail chess!
</p>

<p>
<b>Mail program</b>:
This gives the path to your preferred eMail program. This program is
called for eMail chess to compose the message to the opponent.
</p>

<p>
<b>(B)CC Address</b>:
A copy of the outgoing message is sent to this address as blind copy.
Note however, that if a GUI mailer is used it has normally its own
outgoing mail handling. Hence, setting this address might duplicate
messages. It can be used to transfer a game to another address though.
</p>

<p>
<b>Mode</b>:
Unfortunately there exists a wide range of mail clients and they use
very different calling conventions. Some common conventions, and
examples of programs that use them, are listed here. The mailprogram
will be called with the convention selected. In case it is not known
which convention is used one of those offered might match and do the
trick. Note however that quite a number of mail programs are not
capable of sending attachments when called from another program. In
this case you will have to either change your mail client or add the
attachment placed in Scid's Outbox by hand.
</p>
<p>Hint: mailx or one of its many clones should be available as a
command line application on almost any platform as an easy to set up
tool. In case none of the conventions work with your preferred
client or this client can not handle mails with attachments by calls
from the command line, installing mailx would be an option.
</p>
<p>Hint: mutt uses the systems mail transport (aka
sendmail/exim/postfix). To hook up with those (arguably) not easy to
set up tools mutt is a perfect option. On a decent Un*x with a proper
setup it should be the most painless way to handle eMail chess.
(Though not many properly set up systems exist, especially in the
Linux world.)
</p>
<p>
<b>Attachment parameter</b>: 
This parameter is used to specify an attachment. It is <b>only</b>
used in <term>mailx</term> mode.
</p>
<p>
<b>Subject parameter</b>:
This parameter is used to specify the subject of the mail message. It
is <b>only</b> used in <term>mailx</term> mode.
</p>
<p><footer>(Updated: Scid 3.6.24, March 2008)</footer></p>
}

#############
# Correspondence Chess setup dialog help:
set helpTitle(CCXfccSetupDialog) "Xfcc Server Setup"
set helpText(CCXfccSetupDialog) {<h1>Xfcc Server Setup</h1>
<p>
The Xfcc Server Setup dialog reads in the currently specified xfcc
configuration and displays all servers specified in the config file.
The dialog is separated in two parts: the upper half lists all server
names defined, while the lower part lists all currently set
configuration values for these files.
</p>
<h2>Necessary entries</h2>
<ul>
<li><term>Server name</term>: This specifies the name used for this specific
server and to generate unique game IDs. The name should consist of a
single word containing only characters (a-z and A-Z), numbers and the
characters "-" and "_". It is treated case sensitive.
</li>
<li><term>Login name</term>: specifies the name used to log into a
specific server. It is a wise custom to use only characters, numbers
and "-" as well as "_" in this name.
</li>
<li><term>Password</term>: defines the password used for login. The
same rules apply as for the Login name. <b>Note</b> Scid currently
stores your passwords on the hard disk in unencrypted form. For this
reason keep the directory safe.
</li>
<li><term>URL</term>: This is the base URL for the Xfcc interface of the
correspondence chess server. It can be found at the servers homepage.
Some examples for common servers are:
<ul>
	<li>SchemingMind: <url
	http://www.schemingmind.com/xfcc/xfccbasic.asmx>
	http://www.schemingmind.com/xfcc/xfccbasic.asmx</url>
	</li>
	<li>ICCF: 
	<url https://www.iccf.com/XfccBasic.asmx>
	https://www.webchess.com/XfccBasic.asmx</url>
	</li>
	<li>MeinSchach.de / MyChess.de:
	<url http://www.myChess.de/xfcc/xfccbasic.php4>
	http://www.myChess.de/xfcc/xfccbasic.php4</url>
	</li>
</ul>
</li>
</ul>
<p>
To switch between the individual server settings just select the
server to change from the upper listbox. Its current values will then
be displayed in the entry fields and can be adopted. Clicking on
another server in the list will activate the new settings.
</p>
<p>
To add a new server, just hit the <term>Add</term> button. A new entry
will be created that is prefilled with some text to replace. Please
keep in mind that the server name has to be unique in your setup.
</p>
<p>
To delete a server select it from the list and press the
<term>Delete</term> button. All values for this specific server will
be prepended by a hash mark (#) marking this entry as deleted.
Therefore, if a server was deleted by accident, just remove the hash
marks in front of the entries.
</p>
<p>
Hitting <term>OK</term> will Scid have to store your current setup. At
this point all servers marked as deleted are deleted, all new servers
are added to the setup. By pressing <term>Cancel</term> all changes
are lost, the old setup stays in place.
</p>

<p><footer>(Updated: Scid 3.6.24, May 2008)</footer></p>
}

# Serious game window help
set helpTitle(SeriousGame) "Serious Game Window"
set helpText(SeriousGame) {<h1>Serious game window</h1>
  <p>
  Serious games can be played against any <term>UCI</term> engine set
  up for the usage with Scid. A list of all possible opponents is
  given on top of the <term>Game configuration</term> window. The
  button <term>Configure UCI engine</term> additionally gives access
  to the engines parameters. By default, they are set such as in the
  <a Analysis List>engine configuration</a>.
  </p>
  <p>
  Next, the book that should be used can be chosen from those opening
  books available to Scid. Unchecking the <term>Use book</term> box
  will disable the use of an opening book and the engine will start
  calculating moves right from the beginning.
  </p>
  <p>
  The section <term>Time mode</term> allows to set the timing used for
  the engine. Various settings are possible here:
  <ul>
     <li><term>Time + bonus</term> specifies the time for the whole
     game and a possible increment per move (Fisher clock). The
     default is set to 5 minutes per game and 10 seconds increment per
     move which is a usual setting for Blitz games. Note, that the
     times for Black and White can be set independently. This allows
     to set a short amount of time for the engine and give a longer
     time of thinking to the player, and thus strengthening the
     players analysing possibilities while weakening the engines
     abilities in case of <term>Permanent thinking</term> is off (see
     below).
     </li>

     <li><term>Fixed depth</term> does not set the time per game but
     the depth the engine will calculate in half moves. As this
     disables the ability to calculate deeper if necessary, the
     computer will not see certain mates and combinations, the engine
     may play weaker and thus offer a better partner for training
     purposes.
     <p>
     <b>Note</b>: some, especially commercial, engines also offer to
     weaken their strength in Elo units. Most likely this will offer a
     more suitable algorithm than limiting the search depth. In Scid,
     such games are also offered as <a TacticalGame>Tactical games</a>
     against the free Phalanx engine.
     </p>
     </li>

     <li><term>Nodes</term> is similar to limiting the search depth,
     but here the engine has to move after the evaluation of a certain
     number of positions. (The default is 10,000.)
     </li>

     <li><term>Seconds per move</term> allows the engine to spend a
     certain amount of time at maximum for a given position. Some
     engines will move faster in certain circumstances, but they will
     not exceed the time limit set here. As <term>Fixed depth</term>
     and <term>Nodes</term> this also limits the engines playing
     strength, but also gives a pretty responsive game play.
     </li>
  </ul>
  </p>
  <p>
  Serious games can start from the current board position if the box
  <term>Start from current position</term> is checked. This allows
  e.g. to play out defined middle game positions that arise from an
  opening.
  </p>
  <p>
  <term>Permanent thinking</term> (sometimes also called ponder)
  allows the engine to calculate on the players time. If unchecked, the
  engine will stop analysing the position if the player has the move.
  If the game is set for a fixed time per move, this will weaken the
  engine. On the other hand, the engine might move immediately, if the
  player made the move it was analysing on the players time.
  </p>
  <p>
  <term>Coach is watching</term> will open a dialogue offering to take
  back a move if the player made a blunder (due to the engines
  evaluation of his last move).
  </p>
  <p>
  For training of openings <term>Specific opening</term> can be
  checked. In the list below one can choose the opening to play. The
  player then should follow the line chosen, otherwise Scid will ask
  if the move should be taken back.
  </p>

  <p>
  After setting all parameters of the game and hitting the Play
  button, Scid will set up the opponent engine show the clocks and
  start the game. The player must not make a move till the clocks
  appear. Note that it might take some time for the chess engine to
  start up and initialise properly.
  </p>

  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# Tactics Trainer
set helpTitle(TacticsTrainer) "Training: Tactics"
set helpText(TacticsTrainer) {<h1>Training: Tactics</h1>
  <p>
  Scid offers the possibility to solve chess puzzles. For this feature
  special databases containing the puzzles are required. These
  databases are searched in the <term>Bases</term> directory, that can
  be specified via the menu Options / Bases directory. Unlike other
  bases these bases usually do not contain full games but just a
  starting position as is well known from the usual tactics puzzle
  books. In fact, every puzzle book can easily be converted to such a
  training base by just setting up the positions and storing them in
  the <term>Bases</term> directory. Additionally, one has to set the
  type of the base to <term>Tactics</term> by means of the <a
  Maintenance>Maintenance</a> window.
  </p>
  <p>
  After choosing Play / Training / Tactics a dialogue pops up that
  allows to choose a training base. There, the name of the base is
  displayed, followed by the number of solved puzzles and the total
  number of puzzles in the base in brackets. That is, Scid stores the
  puzzles the user already solved with the base. Choosing a base an
  clicking the <term>Reset scores</term> button will reset this
  information marking all puzzles as unsolved.
  </p>
  <p>
  <b>Note</b> it is advisable to close the <a PGN>PGN</a> window and check
  <term>hide next move</term> in the context menu of the information
  area of Scid's main window. Otherwise cheating is pretty simple.
  <p>
  To get a solution for the puzzles in a base the positions are
  analysed by the Toga chess engine (included with Scid). The
  <term>Limit engine analysis time</term> slider allows to limit the
  time the engine has to solve the position. Several seconds should be
  enough for most cases as usually tactical puzzles contain a
  forced continuation which will be found very quickly by almost all
  chess engines.
  </p>
  <p>
  Clicking the <term>Continue</term> button will start the exercise,
  displaying the first unsolved puzzle. That is, it is possible to
  continue to work through a base. Also if some puzzle was skipped in
  the first session or unsolved, it will be redisplayed. A new window
  will pop up containing a clock and several buttons. The clock is
  only for the user to check how long he thought about the position at
  hand. No evaluation is done on the time required to solve a problem.
  </p>
  <p>
  Some tactical exercises do not end in a mate, but the correct
  solution gives a clear advantage. If one wants to play out these
  scenarios and only count the exercise solved in case of a win, just
  check the <term>Win won game</term> option. (This option has no
  meaning in case of a clear mate solution.)
  </p>
  <p>
  If a problem can not be solved, one can check the 
  <term>Show solution</term> checkbox. The solution is then displayed
  underneath in the dark gray field.
  </p>
  <p>
  Clicking the <term>Next</term> button allows the user to skip a
  puzzle and move on, the <term>Abort</term> button will end tactical
  training and close the database. Besides the <term>Next</term>
  button, the user can choose an exercise by whatever means one can
  select a game within a database in Scid, e.g. by choosing a random
  game via Ctrl-? or jumping to some bookmark or simply by the <a
  GameList>game list</a>.
  </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# Find best move 
set helpTitle(FindBestMove) "Training: Find best move"
set helpText(FindBestMove) {<h1>Training: Find best move</h1>
  <p>
  When annotating games with a chess engine, the engine can search for
  tactical opportunities within a game. This can be achieve by setting
  <term>Mark Tactical Exercise</term> in the <a
  Analysis>Annotation</a> window accessible from analysis. In case a
  tactical opportunity is found, Scid will then flag the game with the
  <term>T</term> flag (Tactics) and add a special comment that is
  evaluated in this exercise.
  </p>
  <p>
  To use this training method, a properly prepared database is
  required. This can be achieved by batch annotating a set of games or
  one can just download them from the <url
  http://scid.sourceforge.net/>Scid website</url>.
  After opening a properly prepared database, just select Play /
  Training / Find best move. Scid will then jump to the next location
  of a tactical blow from the current game position. If necessary a
  suitable new game will be loaded and Scid will display the critical
  position. The user is now required to find the best continuation.
  To jump to the next tactical position one can just right click on
  the goto end of game button.
  </p>
  <p>
  For this exercise it is advisable to close the <a PGN>PGN</a> window and set
  <term>Hide next move</term> from the status areas context menu.
  </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# FICS Login
set helpTitle(FICSLogin) "FICS Login"
set helpText(FICSLogin) {<h1>FICS Login</h1>
  <p>
  The Free Internet Chess Server (FICS) is a good place to play chess
  online with people all over the world at various playing strengths.
  One of the great advantages is, that one can play human opponents.
  Additionally, FICS offers a rating system that allows to test the
  own strength and monitor the own progress. Furthermore, FICS relays
  international tournaments which can be observed and discussed life
  on the server and there exist several training options. For a
  detailed description of the services offered, on how to become a
  member of FICS etc. please refer to the FICS homepage at
  http://www.freechess.org.
  </p>
  <p>
  Though in principle FICS can be used with a plain telnet program
  playing with a real chess program offers several advantages.
  Therefore, Scid offers an interface to this server. To establish a
  connection to the server one has to log in first and several
  parameters are required:
  <ul>
      <li><term>Login:</term> This is your login name on the FICS
      server. Its value is stored in Scid's configuration for later
      reuse.</li>
      <li><term>Password:</term> specifies your password for login.
      <b>Note</b> that this password is displayed when you type,
      allowing everybody to read it. Additionally, this password is
      stored in plain text within Scid's configuration. If you are
      using a publicly accessible system please make sure to assign
      proper rights to Scid's config directory.
      </li>
      <li><term>Time seal</term> if checked, all connections to the
      FICS server are routed through the <term>timeseal</term>
      program. The purpose of <term>timeseal</term> is to cope with
      network lags and keeping the clocks in correct order, that means
      that you should not loose a game on time simply cause you are on
      a very slow network connection. The suitable
      <term>timeseal</term> program for your operating system has to
      be selected in the next input line. It is available for free,
      but required to be downloaded separately from
      http://www.freechess.org.
      </li>
      <li><term>Server port</term> specifies the port on the server.
      The default is 5000 and should be ok for almost all needs.</li>
      <li><term>Timeseal port</term> specifies the port where the
      <term>timeseal</term> program is listening. The default is 5001
      and should be ok for almost all needs.</li>
   </ul>
   All these settings are stored with Scid's configuration and
   therefore have to be entered only once.
   </p>
  <p>
  After checking the settings you can connect to the FICS server by
  clicking the <term>Connect</term> button. Alternatively, Sicd offers
  an anonymous login by choosing <term>Login as guest</term>. In this
  mode you can try all functions of FICS play there anonymously, but
  you will not be able to play rated games or obtain a rating
  yourself. For the difference between Guest account and usual account
  please refer to the documentation at the FICS homepage.
  </p>
  <p>
  <b>Note</b> Besides standard chess FICS also offers a bunch of chess
  variants like bughouse or crazyhouse etc. Scid does not support any
  of these variations, so you can not play them using Scid. If you
  want to play variations you may wish to check out other interfaces.
  FICS offers a bunch of graphical interfaces for download on its
  homepage.
  </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# FICS Find Opponent
set helpTitle(FICSfindOpp) "FICS Find Opponent"
set helpText(FICSfindOpp) {<h1>FICS Find Opponent</h1>
  <p>
  This dialogue offers a convenient way to challenge other players for
  a game, in FICS speak to <term>place a seek</term>. For this several
  parameters have to be set:
  <ul>
      <li><term>Initial time (min)</term> sets the initial time for
      the game in minutes.</li>
      <li><term>Increment (sec)</term> sets the increment per move,
      this is equivalent to a <term>Fisher Clock</term>. Setting it to
      0 will cause the game to last <term>Initial time</term> minutes.
      </li>
      <li><term>Rated game</term> If checked, the game will be rated,
      uncheck it to play a leisure game.</li>
      <li><term>color</term> If set to automatic, its up to the
      opponent to choose the color he wants to play, you will accept
      either he choses. If you want to play black or white explicitly,
      mark either of those choices.
      </li>
      <li><term>Limit rating between</term> allows you to offer a game
      to players in the given rating interval. Using this option can
      assure you to play opponents in your rating range and thus
      having a good game.
      </li>
      <li><term>Confirm manually</term> allows you to confirm or deny
      the game, once another player accepted your challenge.</li>
      <li><term>Filter with formula</term> On FICS every player can
      set a formula that describes what challenges will be denied
      automatically. This formula can be enabled by checking this box.
      </li>
   </ul>
   Clicking the <term>Issue seek</term> button will place your
   offer on the server.
  </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# FICS
set helpTitle(FICS) "FICS: Play on the Internet"
set helpText(FICS) {<h1>FICS: Play on the Internet</h1>
  <p>
  The window is split horizontally in tow main parts. On top the
  console window is shown. Here all messages sent to the server or
  retrieved from the server show up. Normal messages are written in
  green, game offers form other players show up in red, commands sent
  to the server are prepended by a prompt.
  </p>
  <p>
  Interaction with FICS is command driven. Therefore, below the
  console window is the command line. Here the user can enter commands
  sent to the server by either hitting enter or the <term>send</term>
  button. Describing all commands of FICS is beyond the scope of this
  document, however FICS offers an extensive online help system. To
  see a list of possible commands one can issue <term>help
  commands</term>. To see the detailed documentation of a specific
  command just prepend its name by <term>help</term>. Note, that a
  command may have several help pages. To scroll down issue the
  <term>next</term> command.
  </p>
  <p>
  Below the command line, the dialogue is split in two parts. On the
  left hand side the clocks show up, one for white and one for black.
  Clicking into a clock will halt it, inside the analogue clocks a
  digital representation is shown.
  </p>
  <p>
  On the right hand side of the clocks appear the command buttons:
  <ul>
    <li><term>Silence</term> will filter out most of the messages on
    FICS that are not explicitly directed to the user. It is
    equivalent to sending the FICS commands 
    <ul>
    <li>set gin 0</li>
    <li>set seek 0</li>
    <li>set silence 0</li>
    <li>set chanoff 1</li>
    </ul>
    </li>
    <li><term>Offers</term> will show a graphical display of the
    current game offers. The y-axis shows the Elo rating of the
    opponent (the higher his level, the further up the offer appears),
    while x-axis of the graph shows the timing of of the games (the
    further to the right, the slower the game). The first red line
    marks standard <term>Blitz</term> timing (5 min., no increment)
    while the second red line marks the standard <term>Rapid</term>
    timing (15 min., no increment). Additionally, the offers use the
    following coding:
    <ul>
       <li><green>Green</green>: offers from human opponents</li>
       <li><blue>Blue</blue>: offers from computer opponents</li>
       <li><red>Red</red>: games with a total time of more than 1 hour</li>
       <li><gray>Gray</gray>: anonymous offers, i.e. offers from guest logins</li>
       <li>Boxes: unrated games</li>
       <li>Circles: rated games</li>
    </ul>
    Hovering the mouse over a specific offer shows the full details in
    a textual form:
    <ul>
       <li>the game number</li>
       <li>the players login handle</li>
       <li>the rating of the player in brackets</li>
       <li>the initial time / the time increment</li>
       <li>the word "rated" or "unrated" depending on the offer</li>
       <li>the word "[white]" or "[black]" if the opponent wants to
       play the specified color only</li>
    </ul>
    To accept an offer just click on the symbol.
  <li><term>Find opponent</term> opens a  <a FICSfindOpp>dialogue</a>
  that allows to place an offer.</li>
  <li><term>Draw</term> offers a draw in the ongoing game</li>
  <li><term>Abort</term> aborts the ongoing game</li>
  <li>term>Resign</term> resigns the ongoing game</li>
  <li><term>Takeback</term> takes back a half move, useful in
  analysis</li>
  <li><term>Takback 2</term> takes back a full move, useful in
  analysis</li>
  <li><term>Games</li> gives a list of ongoing games on the server.
  Note that FICS console is considered to be 80 chars wide, therefore,
  to get a nice table it would be necessary to resize the FICS window.
  </li>
  <li>
  <li><term>Close</term> closes the connection to FICS</li>
  </ul>
  </p>

  <h3><name Training>FICS Lectures</h3>
  <p>
  FICS offers several options for chess training. One of the more
  prominent once are the lecture bots <term>LectureBot</term> and
  <term>WesBot</term>. They run all the time on FICS and offer various
  training sessions that can be visited using Scid. The start of each
  session is announced on <term>Channel 67</term> of FICS. Therefore,
  to see these announcements one should first add this channel to the
  personal observation list. This can be done by <term>+channel
  67</term> (it can be removed again by <term>-channel 67</term>).
  Once e.g. LectureBot announces a training session, one can take part
  by issuing <term>observe lecturebot</term>. Please refer to the
  online documentation of FICS for additional features of the Bots and
  also other bots available.
  </p>

  <h3><name Observe>Observe games on FICS</h3>
  <p>
  From time to time FICS <term>relays</term> major events in
  international chess. In these cases one can observe the games life
  on the server and discuss them with other users on FICS. To find out
  what games are currently relayed (if any) one can ask the relay for
  a list by <term>relay listgames</term>. As FICS expects the terminal
  to have 80 chars width it might be necessary to resize Scid's FICS
  window to get a nice table. The entries in the table are, first the
  game number, colon, than the opponents, the result of the game (*
  signifying an ongoing game as usual) and the <a ECO>ECO code</a> of
  the opening. To observe a specific game one can just <term>observe
  gamenumber</term>. Scid will then display the current board
  position, the clocks will display the proper values sent by the
  relay and it will fetch all moves of the game so far plus the usual
  <a PGN>PGN</a> header fields. If a player moves this move is performed in Scid
  as usual. For discussing the game with other observers,
  <term>whisper</term> and <term>kibitz</term> can be used. Please
  refer to the online help of these commands. All these conversations
  can be read in the console.
  </p>
  <p>
  Note that only one game can be observed within Scid.
  </p>

  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# Book tuning
set helpTitle(BookTuning) "Book tuning"
set helpText(BookTuning) {<h1>Book tuning</h1>
   <p>
   For each book move a percentage is given stating the probability
   that Scid will use this move. Using <term>Book tuning</term> one
   can adjust these values. First, the position where the lines should
   be adopted has to be set up. After calling Tools / Book tuning one
   gets a small window stating the moves in book and their percentage
   in a spin box. Note, that only integer values are shown, therefore
   a 0 may appear signifying that this move has a probability of "less
   than 1%". (Most likely this happens in automatically generated
   books from game collections.) All numbers add up to 100% of course.
   </p>
   <p>
   To navigate through the branches of the book one can just click on
   the line in the book tuning window or move around the game as usual
   in Scid.
   </p>
   <p>
   To adjust the probability, e.g. rise the probability of a certain
   variation, one can just increase its value. Though the other values
   stay the same, Scid will recalculate once <term>Save</term> is
   pressed.
   </p>
   <p>
   Choosing <term>Export</term> will export a branch of the book from
   the current position onwards into a single game. The continuation
   with the highest probability will make up the main line while all
   others are stored in variations. This allows for semi manually
   selecting lines to be included in a new book to be created. Note,
   that Scid can handle 3000 moves in a single game, therefore it will
   most likely not be possible (nor will it be very sensible) to
   export a whole opening book into one game. Also note that export
   can be done incrementally. That is, new lines are added to already
   existing ones. This also allows to merge several books.
   </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

# Novag Citrine
set helpTitle(Novag) "Connecting the Novag Citrine Chess board"
set helpText(Novag) {<h1>Connecting the Novag Citrine Chess board</h1>
   <p>
   The Novag Citrine is a wooden chess board that can be interfaced
   from a PC by means of a serial connection. It can be used with Scid
   to enter games, play against a computer opponent or on FICS
   offering a "natural" chess interface.
   </p>
   <p>
   <b>Note</b>: Before the board can be used, one has to <a
   HardwareConfig>configure the port to use.</a>
   </p>
   <p>
   Once the proper port is set, choose Tools / Connect Hardware /
   Connect Novag Citrine to hook up the board, or just click the
   hardware connection button <button tb_eng_disconnected>. This
   button also shows the <a HardwareStatus> status of the
   connection.</a>

   ###--- Detailed description needed ---###
   </p>
  <p><footer>(Updated: Scid 3.6.26, October 2008)</footer></p>
}

set helpTitle(HardwareConfig) "Connecting External Hardware"
set helpText(HardwareConfig) {<h1>Connecting External Hardware</h1>
  There are two types of hardware that can be used with Scid to play
  or input games. Select from the <term>Hardware</term> list the one
  you wish to use:
  <ul>
    <li><term>Novag Citrine</term> (and compatible boards) use an
    internal driver that was developed specifically for the Novag
    Citrine board, however there may exist other boards that support
    this protocol.  This driver allows to enter moves, but the boards
    logic does not recognise the position set up on the board nor the
    pieces as such.
    </li>
    <li><term>Input Engine</term> drivers are meant to be a free,
    open interface to hook up any hardware to some GUI like Scid. It
    is modeled after the usual style of a chess engine. The
    specifications of the protocol as well as a driver suitable for
    the DGT Electronic Chess boards can be found at the <url
    http://dgtdrv.sourceforge.net>dgtdrv website</url>.  Depending on
    the hardware the board may know the positions set up and the
    pieces by their move. This is e.g. the case for the DGT boards.
    </li>
  </ul>
  <p>
  <b>Note</b> Scid does not include any input engine by default. Input
  engines are meant to be independent programs that can be used with a
  variety of GUIs.
  </p>
  <p>
  After selecting the hardware to use at least the port, this hardware
  is connected to, has to be specified. Depending on the operating
  system and the board to use this port varies. However, usually
  external hardware is hooked up by a serial, USB or BlueTooth
  connection, where the latter two are just derivatives of serial
  connections. Depending on the platform usual names for the port in
  question are:
  </p>
  <ul>
    <li><term>Unix</term> (incl. <term>Linux</term>): usually a file
    in the <term>/dev</term> directory is used. For serial ports the
    common naming is <term>/dev/ttyS0</term>, for the first serial
    port, <term>/dev/ttyS1</term>, for the second and so on. For
    serial USB devices common names include <term>/dev/ttyUSB0</term>
    for the first, <term>/dev/ttyUSB1</term> for the second and so on.
    Other less common names are <term>/dev/usb/tts/*</term> or
    <term>/dev/usbdev*</term> (where the asterisk * stands for some
    additional name). BlueTooth devices commonly show up as
    <term>/dev/rfcomm0</term> for the first, <term>/dev/rfcomm1</term>
    for the second and so on.
    </li>
    <li><term>MacOS</term>:
    ###--- details for naming on Mac OS X required ---###
    </li>
    <li><term>Windows</term> follows the usual DOS convention, where
    the serial ports are labeled <term>COM1:</term>,
    <term>COM2:</term> and so on. This naming also applies to
    converters, however they sometimes get numbers beyond 4.
    </li>
    <li><term>Show button</term> will enable the <a
    HardwareStatus>hardware connect button</a> in the toolbar if
    checked. If unchecked the button will not show up to save space.
    Removal of the button needs to restart Scid.
    </li>
  </ul>
  <p>
  <b>Note</b>: if a board is connected by means of an USB to serial or
  BlueTooth to serial converter, these adaptors usually show up in the
  above scheme as well.
  </p>
  <p>
  If an Input Engine compatible driver should be used, the following
  fields need to be filled in (for the Novag driver they are
  disabled):
  </p>
  <ul>
     <li><term>Engine command</term>: The name of the program that is
     to be used as a driver engine. A fully qualified name may be
     required, like in the configuration of a <name Analysis
     List>chess engine</a>. (E.g. the DGT driver engine on a Linux
     system is usually called <term>dgtdrv2.i686</term>.)
     </li>
     <li><term>Engine parameter</term>: The text given in this field
     is passed along as parameters to the driver engine. The values
     required here depend on the driver and should be given in its
     documentation. (E.g. the DGT driver engine needs a two letter
     code specifying the board orientation and the moves that should
     be send to the GUI. The first letter may be <term>l</term> or
     <term>r</term> depending on the clock sitting to Whites left or
     right, the second letter may be <term>a</term>, <term>b</term> or
     <term>w</term> depending whether all, only black or only whites
     moves should be sent.)
     </li>
  </ul>
  <p>
  Hitting <term>OK</term> will store the setup in Scid's configuration
  and immediately start the driver selected.
  </p>
  <p>
  The status of the external board can be monitored by the <a
  HardwareStatus>Hardware status</a> button. This button can also be
  used to hook up already configured hardware immediately without
  calling the <term>Configuration</term> dialogue.
  </p>


  <p><footer>(Updated: Scid 3.6.27, October 2008)</footer></p>
}

set helpTitle(HardwareStatus) "Status of External Hardware"
set helpText(HardwareStatus) {<h1>Status of External Hardware</h1>
   <p>
   This button is located on the right of Scid's toolbar. Depending on
   the status of the external hardware it shows different icons:
   </p>
   <ul>
   <li><button tb_eng_disconnected>
   This is the normal state after program startup and shows that no
   external hardware is active at the moment. Pressing the button will
   hook up the configured hardware.
   </li>
   <li><button tb_eng_connecting>
   Scid started the communication with the external hardware,
   initialisation is in progress. Depending on the driver and hardware
   connected, it may take some seconds for things to settle.
   </li>
   <li><button tb_eng_error>
   While communicating withe the external hardware some error
   occurred. Usual sources of problems are e.g. another program
   accessing the external hardware, the hardware is not connected to
   the PC or simply is not switched on. In rare cases an external
   hardware may also behave unexpected. Trying to connect again might
   cure the problem as the hardware is usually reset upon disconnect.
   Also unplugging and/or switching off the device is an option in
   this case. Pressing the button will try again to hook up the
   configured hardware.
   </li>
   <li><button tb_eng_ok>
   The communication is established, the device is ready and can be
   used for move input. Pressing the button will disconnect the
   external hardware.
   </li>
   <li><button tb_eng_dgt>
   In case a DGT Electronic Chess board is connected and ready, this
   button shows up. Pressing the button will disconnect the
   external hardware.
   </li>
   <li><button tb_eng_query>
   The <a HardwareConfig</a> dialogue is open. Finish configuration
   before hooking up the hardware.
   </li>
   </ul>

  <p><footer>(Updated: Scid 3.6.27, October 2008)</footer></p>
}

set helpTitle(InputEngine) "Input Engine driver console"
set helpText(InputEngine) {<h1>Input Engine driver console</h1>
   <p>
   On top of this window, a console shows up that monitors the
   communication between Scid and the driver engine. Usually, this is
   of no interest to the user, but it may provide helpful hints in
   case of malfunction. All commands sent by Scid are prepended by an
   arrow to the right, all answers retrieved from the driver engine by
   an arrow to the left.  Below the console, the actual invocation of
   the driver by Scid shows up for information.
   </p>
   <p>
   <term>Moves sent for</term> allows to limit the moves sent by the
   external hardware. For game input the board should of course send
   the moves for both sides. For actually playing a game however, the
   moves made by the opponent should be ignored, as Scid would
   otherwise notify them as "illegal moves".
   </p>
   <p>
   The small board on the right shows the current position.
   </p>
   <p>
   If a move is made, in the area between the buttons and the small
   board the move performed (<term>move area</term>) on the external
   board is shown in figurine long algebraic notation. Valid moves
   show up on a <green>green</green> background while illegal moves
   show up on a <red>red</red> background. Additionally, illegal moves
   are announced by the alert sound, if Scid has sound enabled.
   Depending on the settings, the moves are additionally announced.
   </p>
   <p>
   The <term>Info</term> button calls up information from the driver
   engine. The extend of this information depends on the engine, but
   it should usually give as much as is available about the external
   hardware and the driver itself. Additionally, the external driver
   will return the current position on the external board as <term>FEN</term> which
   is then compared to Scid's internal representation. Discrepancies
   show up in the console and issue an alert.
   </p>
   <p>
   In case Scid and the external board got out of sync, the
   <term>Synchronise</term> button can be used. A new game is set up
   and the start position is set to the position on the external
   board.  </p>
   <p>
   The <term>Close</term> button finally disconnects the external
   hardware and closes the console.
   </p>

   <h2>Special Features</h2>
   <p>
   The following features depend on the driver engine and hardware
   that is used. Their description is based on the functions available
   with the <url http://www.dgt-projects.com>DGT Electronic Chess
   Board</url> and specified in the
   <url http://dgtdrv.sourceforge.net>Input Engine Protocol</url>
   description. Some of these functions however rely on the fact that
   the hardware is able to recognise the pieces on the board and their
   current placement.
   </p>

   <h3>Position setup</h3>
   <p>
   The position setup mode is invoked by removing both kings from the
   board. In this mode the <term>move area</term> is colored yellow
   and shows the White king and the string <b>Setup</b>.
   </p>
   <p>
   In setup mode any valid position can be set up on the external
   board, however Scid's internal representation is not updated till
   finished.
   </p>
   <p>
   To end the setup mode both kings are set back to the board. Note,
   that the king of the side to move is set back <b>last</b>, that is
   if white should be on the move first set back the black king, then
   the white king. Now, the <term>move area</term> shows the black
   Queen and the string <b>OK</b>.
   </p>

   <h3>End a game</h3>
   <p>
   In game input or game play one can end the current game by setting
   both kings into the center squares of the board. The result is
   given as follows:
   </p>
   <ul>
      <li><term>1-0</term> (White win): Set both kings to the squares
      e4 and d5 in any order, ie. to the white centre squares.
      The move area is colored in white, showing the white king and
      the result.
      </li>
      <li><term>0-1</term> (Black win): Set both kings to the squares
      e5 and d4 in any order, ie. to the black centre squares.
      The move area is colored in gray, showing the black king and
      the result.
      </li>
      <li><term>1/2-1/2</term> (Draw): Set one king on a white and one
      on a black centre square in any order.
      The move area is colored in black and white, showing the result.
      </li>
   </ul>
   <p>
   In either case the <term>Save / Add game</term> dialogue shows up
   to allow filling in the game tags and to store the game in the
   current database.
   </p>

   <h3>Start a new game</h3>
   <p>
   A new game can be stared by entering setup mode (ie. removing both
   kings) and setting up the start position. To notify, that Scid has
   recognised the call for a new game the <term>move area</term> is
   colored in blue showing the white king and the string
   <term>OK</term>.
   </p>


  <p><footer>(Updated: Scid 3.6.27, October 2008)</footer></p>
}

set helpTitle(ReviewGame) "Game Review"
set helpText(ReviewGame) {<h1>Reviewing a game</h1>
   <p>
	This feature is designed to study a game, which means you should
	try to guess the moves played during the match. So you first open a
	game from any Scid's base, and enter this function with the command
	<b>Review game</b> in the <b>Play</b> menu.  As usually, to play
	with Black, flip board first (you always play from the bottom of
	the board).
   </p>
	<p>
	For an effective training the following settings should be
	disabled:
	<ul>
		<li>Show last move (Options / Moves / Highlight last move)</li>
		<li>Show next move (Options / Game information / Hide next move)</li>
		<li>PGN window</li>
	</p>
The process is the following :
<ul>
<li>- engines ponders on the move played during the game</li>
<li>- engine ponders on the position and finds the best move</li>
<li>- user is then allowed to enter his move</li>
<li>- engine ponders on the move played by the user</li>
</ul>
If the move played by the user is either the move actually played
during the game or the move chosen by the engine or a move whose score
is close to the best move found by the engine (using the margin error
defined by the user), then the move is considered as a good one. If
the user disagrees with the engine he can use the <b>extended time</b>
button to get a confirmation of engine's analysis.
<p>
<b>Notes:</b> 
<ul>
<li>- The side must be chosen before game reviewing </li>
<li>- The user always plays from the bottom of the board</li>
</ul>
</p>
  <p><footer>(Updated: Scid 4.3, January 2011)</footer></p>
}

set helpTitle(Metadata) "Dublin Core Metadata"
set helpText(Metadata) {<h1>Dublin Core Metadata</h1>
   <p>
   The <url "http://dublincore.org">Dublin Core</a> metadata element
   defines a standardised and widely used way to exchange
   information about electronic resources (metadata, ie. data about
   data). Dublin Core was defined in 2003 by ISO Standard 15836, and
   NISO Standard Z39.85-2007.
   </p>
   <p>
   Some databases that are used with Scid may contain additional
   metadata information. Such information may refer to the License of
   a database, the source of the database (in case it is published on
   the Web), the date of a database and so on.
   </p>
   <p>
   This information can be viewed or appended to a database by
   choosing <term>Database information</term>. A new window will open
   up that shows the individual Dublin Core items and allows to edit
   them.
   </p>
   <p>
   Internally, metadata are stored in <term>sme</term> files that may
   come with a database. In case no <term>sme</term> file exists
   opening the <term>Database information</term> dialogue  will set
   default values based on the current database. This is signified by
   the labels showing up in <blue>blue</blue>.
   </p>
   <p>
   After choosing <term>OK</term> Scid stores the metadata to the
   <term>sme</term> file for usage with Scid. Additionally, an

   <term>XML</term> file is generated containing exactly the same
   metadata, but in XML format for easy data exchange.
   </p>
   <p>
   <b>Note</b>: Scid does not care about the XML file itself. It uses
   only the <term>sme</term> file for its internal procedures.
   However, other applications may well prefer the XML structure.
   </p>

  <p><footer>(Updated: Scid 3.6.27, October 2008)</footer></p>
}

set helpTitle(Appearance) "Customize Scid-GUI"
set helpText(Appearance) {<h1>Customize Scid-GUI</h1>
  <p>
 <p>
  Scid has some options to customize the GUI.
  </p>
  <h3><name Themes>Configure TTK-Themes</name></h3>
  <p>
    Starting with version 4.7, new GUI themes can be installed and selected.
    With the TTK themes, different appearances of the SCID user interface can be realized.<br>
    The scid repository provides a multicolored set of themes for direct use:
    <li><url https://sourceforge.net/projects/scid/files/Scid/Additional Files/>https://sourceforge.net/projects/scid/files/Scid/Additional Files</url> -- Home / Scid / Additional Files</li><br><br>
    Further themes can also be downloaded from the following addresses:
    <li><url https://wiki.tcl.tk/48689>https://wiki.tcl.tk/48689</url> -- wiki.tcl.tk List of ttk Themes</li>
    <li><url https://github.com/RedFantom/ttkthemes/tree/master/ttkthemes/themes>https://github.com/RedFantom/ttkthemes</url> -- RedFantom Collection of ttk Topics</li><br><br>
    To install the themes, proceed as follows:<br>
    <li>Extract the scidthemes files to any directory.</li>
    <li>Load themes: With the menu item <b>Options - Theme - Load Theme(s)</b> select the file pkgIndex.tcl from the directory,
    in which the themes are stored.</li>
    <li>Select theme: Using the menu item <b>Options - Theme - "Theme name"</b>, e.g. scidblue scidmint scidpurple scidpurple scidpurple scidsand scidpink,
    select the theme to use.</li>
    <li><b>Note:</b> pkgIndex.tcl are files that load additional tcl packages. Use only pkgIndex.tcl files that contain TTK-Themes.</li>
    </p>
  <h3><name MenuColors>Set menu colors</name></h3>
  <p>
    TTK-Themes have technically no adapted properties and colours for menus. The colors for menus must therefore be adjusted separately and matched to the colors of themes.<br>
    Under <b>Options - Setup menu colors</b> you can configure the colors for the menu:<br>
    <li>Background color of the main menu</li>
    <li>Foreground and background color of all menus</li>
    <li>Foreground and background color of the selected menu item</li>
    <li>Color of a selected option in the menu</li>
    <li><b>Note:</b> WINDOWS and MACOS ignore the configured colors for the main menu bar and use the system settings.</li>
  </p>
  <p>
  After configuring the theme and menu colors, save the settings with <b>Options - Save options</b>.
  </p>
  <p><footer>(Updated: Scid 4.7, August 2018)</footer></p>
}
