/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ir.LoopNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class DoWhileLoopNode
extends LoopNode {
    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitDoWhileLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getBlockNode().visit(irTreeVisitor, scope);
        if (this.getConditionNode() != null) {
            this.getConditionNode().visit(irTreeVisitor, scope);
        }
    }

    public DoWhileLoopNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        WriteScope.Variable loop;
        methodWriter.writeStatementOffset(this.getLocation());
        writeScope = writeScope.newScope();
        Label start = new Label();
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(start);
        this.getBlockNode().continueLabel = begin;
        this.getBlockNode().breakLabel = end;
        this.getBlockNode().write(classWriter, methodWriter, writeScope);
        methodWriter.mark(begin);
        if (!this.isContinuous()) {
            this.getConditionNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, end);
        }
        if ((loop = writeScope.getInternalVariable("loop")) != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        methodWriter.goTo(start);
        methodWriter.mark(end);
    }
}

