/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.kibana;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.reindex.RestDeleteByQueryAction;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.action.admin.indices.RestCreateIndexAction;
import org.elasticsearch.rest.action.admin.indices.RestGetAliasesAction;
import org.elasticsearch.rest.action.admin.indices.RestGetIndicesAction;
import org.elasticsearch.rest.action.admin.indices.RestIndexPutAliasAction;
import org.elasticsearch.rest.action.admin.indices.RestRefreshAction;
import org.elasticsearch.rest.action.admin.indices.RestUpdateSettingsAction;
import org.elasticsearch.rest.action.document.RestBulkAction;
import org.elasticsearch.rest.action.document.RestDeleteAction;
import org.elasticsearch.rest.action.document.RestGetAction;
import org.elasticsearch.rest.action.document.RestIndexAction;
import org.elasticsearch.rest.action.document.RestMultiGetAction;
import org.elasticsearch.rest.action.document.RestUpdateAction;
import org.elasticsearch.rest.action.search.RestClearScrollAction;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.search.RestSearchScrollAction;

public class KibanaPlugin
extends Plugin
implements SystemIndexPlugin {
    public static final Setting<List<String>> KIBANA_INDEX_NAMES_SETTING = Setting.listSetting((String)"kibana.system_indices", Collections.unmodifiableList(Arrays.asList(".kibana", ".kibana_*", ".reporting-*", ".apm-agent-configuration", ".apm-custom-link")), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.unmodifiableList(((List)KIBANA_INDEX_NAMES_SETTING.get(settings)).stream().map(pattern -> new SystemIndexDescriptor(pattern, "System index used by kibana")).collect(Collectors.toList()));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.unmodifiableList(Arrays.asList(new KibanaWrappedRestHandler((BaseRestHandler)new RestCreateIndexAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestGetAliasesAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestIndexPutAliasAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestRefreshAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestGetAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestMultiGetAction(settings)), new KibanaWrappedRestHandler((BaseRestHandler)new RestSearchAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestBulkAction(settings)), new KibanaWrappedRestHandler((BaseRestHandler)new RestDeleteAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestDeleteByQueryAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestUpdateSettingsAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestGetIndicesAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestIndexAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestIndexAction.CreateHandler()), new KibanaWrappedRestHandler((BaseRestHandler)new RestIndexAction.AutoIdHandler(nodesInCluster)), new KibanaWrappedRestHandler((BaseRestHandler)new RestUpdateAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestSearchScrollAction()), new KibanaWrappedRestHandler((BaseRestHandler)new RestClearScrollAction())));
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(KIBANA_INDEX_NAMES_SETTING);
    }

    static class KibanaWrappedRestHandler
    extends BaseRestHandler.Wrapper {
        KibanaWrappedRestHandler(BaseRestHandler delegate) {
            super(delegate);
        }

        public String getName() {
            return "kibana_" + super.getName();
        }

        public boolean allowSystemIndexAccessByDefault() {
            return true;
        }

        public List<RestHandler.Route> routes() {
            return Collections.unmodifiableList(super.routes().stream().map(route -> new RestHandler.Route(route.getMethod(), "/_kibana" + route.getPath())).collect(Collectors.toList()));
        }
    }
}

