/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ConfigLayerSpec
extends FeatureGroupSupport {
    private final ConfigId id;
    private final Map<String, ConfigLayerDependency> layerDeps;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(String layerName) {
        return new Builder(layerName);
    }

    protected ConfigLayerSpec(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.id = new ConfigId(builder.model, builder.getName());
        this.layerDeps = CollectionUtils.unmodifiable(builder.layerDeps);
    }

    @Override
    public ConfigId getId() {
        return this.id;
    }

    public String getModel() {
        return this.id.getModel();
    }

    @Override
    public boolean isLayer() {
        return true;
    }

    public boolean hasLayerDeps() {
        return !this.layerDeps.isEmpty();
    }

    public Collection<ConfigLayerDependency> getLayerDeps() {
        return this.layerDeps.values();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.layerDeps == null ? 0 : this.layerDeps.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigLayerSpec other = (ConfigLayerSpec)obj;
        return !(this.layerDeps == null ? other.layerDeps != null : !this.layerDeps.equals(other.layerDeps));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[name=").append(this.getName());
        if (this.layerDeps.isEmpty()) {
            buf.append(" layer-deps=");
            StringUtils.append(buf, this.layerDeps.values());
        }
        if (!this.isInheritFeatures()) {
            buf.append(" inherit-features=false");
        }
        if (this.hasIncludedSpecs()) {
            buf.append(" includedSpecs=");
            StringUtils.append(buf, this.getIncludedSpecs());
        }
        if (this.hasExcludedSpecs()) {
            buf.append(" exlcudedSpecs=");
            StringUtils.append(buf, this.getExcludedSpecs());
        }
        if (this.hasIncludedFeatures()) {
            buf.append(" includedFeatures=[");
            Iterator<Map.Entry<FeatureId, FeatureConfig>> i = this.getIncludedFeatures().entrySet().iterator();
            Map.Entry<FeatureId, FeatureConfig> entry = i.next();
            buf.append(entry.getKey());
            if (entry.getValue() != null) {
                buf.append("->").append(entry.getValue());
            }
            while (i.hasNext()) {
                entry = i.next();
                buf.append(';').append(entry.getKey());
                if (entry.getValue() == null) continue;
                buf.append("->").append(entry.getValue());
            }
            buf.append(']');
        }
        if (this.hasExcludedFeatures()) {
            buf.append(" exlcudedFeatures=");
            StringUtils.append(buf, this.getExcludedFeatures().keySet());
        }
        if (!this.items.isEmpty()) {
            buf.append(" items=");
            StringUtils.append(buf, this.items);
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeatureGroupBuilderSupport<Builder> {
        private String model;
        private Map<String, ConfigLayerDependency> layerDeps = Collections.emptyMap();

        protected Builder() {
        }

        protected Builder(String layerName) {
            super(layerName);
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder addLayerDep(String layerName) {
            return this.addLayerDep(layerName, false);
        }

        public Builder addLayerDep(String layerName, boolean optional) {
            this.layerDeps = CollectionUtils.putLinked(this.layerDeps, layerName, ConfigLayerDependency.forLayer(layerName, optional));
            return this;
        }

        public ConfigLayerSpec build() throws ProvisioningDescriptionException {
            return new ConfigLayerSpec(this);
        }
    }
}

