/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class ArrayDataPseudoInstruction
extends Instruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int elementWidth;
    private byte[] encodedValues;

    @Override
    public int getSize(int codeAddress) {
        return (this.encodedValues.length + 1) / 2 + 4 + codeAddress % 2;
    }

    public ArrayDataPseudoInstruction(int elementWidth, byte[] encodedValues) {
        super(Opcode.NOP);
        if (encodedValues.length % elementWidth != 0) {
            throw new RuntimeException("There are not a whole number of " + elementWidth + " byte elements");
        }
        this.elementWidth = elementWidth;
        this.encodedValues = encodedValues;
    }

    public ArrayDataPseudoInstruction(byte[] buffer, int bufferIndex) {
        super(Opcode.NOP);
        byte opcodeByte = buffer[bufferIndex];
        if (opcodeByte != 0) {
            throw new RuntimeException("Invalid opcode byte for an ArrayData pseudo-instruction");
        }
        byte subopcodeByte = buffer[bufferIndex + 1];
        if (subopcodeByte != 3) {
            throw new RuntimeException("Invalid sub-opcode byte for an ArrayData pseudo-instruction");
        }
        this.elementWidth = NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
        int elementCount = NumberUtils.decodeInt(buffer, bufferIndex + 4);
        this.encodedValues = new byte[elementCount * this.elementWidth];
        System.arraycopy(buffer, bufferIndex + 8, this.encodedValues, 0, elementCount * this.elementWidth);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.alignTo(4);
        int elementCount = this.encodedValues.length / this.elementWidth;
        out.writeByte(0);
        out.writeByte(3);
        out.writeShort(this.elementWidth);
        out.writeInt(elementCount);
        out.write(this.encodedValues);
        out.alignTo(2);
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.annotate(this.getSize(currentCodeAddress) * 2, "[0x" + Integer.toHexString(currentCodeAddress) + "] " + "fill-array-data instruction");
    }

    @Override
    public Format getFormat() {
        return Format.ArrayData;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    public int getElementCount() {
        return this.encodedValues.length / this.elementWidth;
    }

    public Iterator<ArrayElement> getElements() {
        return new Iterator<ArrayElement>(){
            final int elementCount;
            int i;
            int position;
            final ArrayElement arrayElement;
            {
                this.elementCount = ArrayDataPseudoInstruction.this.getElementCount();
                this.i = 0;
                this.position = 0;
                this.arrayElement = new ArrayElement(ArrayDataPseudoInstruction.this.encodedValues, ArrayDataPseudoInstruction.this.getElementWidth());
            }

            @Override
            public boolean hasNext() {
                return this.i < this.elementCount;
            }

            @Override
            public ArrayElement next() {
                this.arrayElement.bufferIndex = this.position;
                this.position += this.arrayElement.elementWidth;
                ++this.i;
                return this.arrayElement;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for an ArrayDataPseudoInstruction must be NOP");
            }
            return new ArrayDataPseudoInstruction(buffer, bufferIndex);
        }
    }

    public static class ArrayElement {
        public final byte[] buffer;
        public int bufferIndex;
        public final int elementWidth;

        public ArrayElement(byte[] buffer, int elementWidth) {
            this.buffer = buffer;
            this.elementWidth = elementWidth;
        }
    }
}

