/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Arrays;
import org.jf.dexlib.Util.Input;

public class OdexHeader {
    public static final byte[] MAGIC_35 = new byte[]{100, 101, 121, 10, 48, 51, 53, 0};
    public static final byte[] MAGIC_36 = new byte[]{100, 101, 121, 10, 48, 51, 54, 0};
    public final byte[] magic;
    public final int dexOffset;
    public final int dexLength;
    public final int depsOffset;
    public final int depsLength;
    public final int auxOffset;
    public final int auxLength;
    public final int flags;
    public final int version;

    public OdexHeader(Input in) {
        this.magic = in.readBytes(8);
        if (Arrays.equals(MAGIC_35, this.magic)) {
            this.version = 35;
        } else if (Arrays.equals(MAGIC_36, this.magic)) {
            this.version = 36;
        } else {
            throw new RuntimeException("The magic value is not one of the expected values");
        }
        this.dexOffset = in.readInt();
        this.dexLength = in.readInt();
        this.depsOffset = in.readInt();
        this.depsLength = in.readInt();
        this.auxOffset = in.readInt();
        this.auxLength = in.readInt();
        this.flags = in.readInt();
        in.readInt();
    }
}

