/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Log4jErrorLogger;
import ghidra.util.ErrorLogger;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import resources.ResourceManager;

public class LoggingInitialization {
    private static final String LOG4J_CONFIGURATION_PROPERTY = "log4j.configuration";
    private static final String PRODUCTION_LOGGING_CONFIGURATION_FILE = "generic.log4j.xml";
    private static final String DEVELOPMENT_LOGGING_CONFIGURATION_FILE = "generic.log4jdev.xml";
    private static boolean INITIALIZED = false;
    private static File SCRIPT_LOG_FILE = null;
    private static File APPLICATION_LOG_FILE = null;

    public static synchronized void initializeLoggingSystem() {
        if (INITIALIZED) {
            return;
        }
        URL resource = LoggingInitialization.getLoggingConfigFileUrl();
        if (resource != null) {
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(resource.toURI());
            }
            catch (URISyntaxException e) {
                Msg.error(LoggingInitialization.class, (Object)"Unable to convert URL to URI", (Throwable)e);
            }
        }
        Msg.setErrorLogger((ErrorLogger)new Log4jErrorLogger());
        String configFilename = resource == null ? "<no config file found>" : resource.toExternalForm();
        Msg.info(LoggingInitialization.class, (Object)("Using log config file: " + configFilename));
        Msg.info(LoggingInitialization.class, (Object)("Using log file: " + APPLICATION_LOG_FILE));
        INITIALIZED = true;
    }

    private static URL getLoggingConfigFileUrl() {
        URL resource = LoggingInitialization.getLogFileFromSystemProperty();
        if (resource != null) {
            return resource;
        }
        String loggingConfigFilename = PRODUCTION_LOGGING_CONFIGURATION_FILE;
        if (SystemUtilities.isInDevelopmentMode()) {
            loggingConfigFilename = DEVELOPMENT_LOGGING_CONFIGURATION_FILE;
        }
        return ResourceManager.getResource(loggingConfigFilename);
    }

    private static URL getLogFileFromSystemProperty() {
        String configString = System.getProperty(LOG4J_CONFIGURATION_PROPERTY);
        if (configString == null) {
            return null;
        }
        URL resource = ResourceManager.getResource(configString);
        if (resource != null) {
            return resource;
        }
        File configFile = new File(configString);
        if (!configFile.exists()) {
            try {
                URL url = new URL(configString);
                File file = new File(url.toURI());
                if (file.exists()) {
                    return url;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            System.setProperty(LOG4J_CONFIGURATION_PROPERTY, "");
            System.err.println("Log config file does not exist: " + configString);
            return null;
        }
        URI URI2 = configFile.toURI();
        try {
            return URI2.toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Unable to find requested log configuration file: " + configString);
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized File getApplicationLogFile() {
        if (APPLICATION_LOG_FILE == null) {
            throw new AssertException("Before logging system is used you must call Application.initializeApplication() AND its application configuration's setInitializeLogging() must NOT be set to false.");
        }
        return APPLICATION_LOG_FILE;
    }

    static synchronized void setApplicationLogFile(File file) {
        if (APPLICATION_LOG_FILE != null && !SystemUtilities.isInTestingMode()) {
            System.err.println("Cannot change the log file once it has been initialized!\nYou must call this method before calling LoggingInitialization.initializeLoggingSystem()");
            new IllegalStateException().printStackTrace();
        }
        APPLICATION_LOG_FILE = file;
        System.setProperty("logFilename", file.getAbsolutePath());
        if (INITIALIZED) {
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
    }

    public static synchronized File getScriptLogFile() {
        if (SCRIPT_LOG_FILE == null) {
            throw new AssertException("Must call Application.initializeApplication before logging system is used");
        }
        return SCRIPT_LOG_FILE;
    }

    static synchronized void setScriptLogFile(File file) {
        if (SCRIPT_LOG_FILE != null && !SystemUtilities.isInTestingMode()) {
            System.err.println("Cannot change the log file once it has been initialized!\nYou must call this method before calling LoggingInitialization.initializeLoggingSystem()");
            new IllegalStateException().printStackTrace();
        }
        SCRIPT_LOG_FILE = file;
        System.setProperty("scriptLogFilename", file.getAbsolutePath());
        if (INITIALIZED) {
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
    }
}

