/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.ebr;

import java.io.PrintStream;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.partitioning.MBRPartitionTable;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.jparted.lib.ps.ebr.ExtendedBootRecord;

public class EBRPartitionSystem
implements PartitionSystem {
    private final ExtendedBootRecord[] bootRecords;

    public EBRPartitionSystem(ReadableRandomAccessStream psStream, long ebrPartitionOffset, int sectorSize) {
        this(psStream, ebrPartitionOffset, -1L, sectorSize);
    }

    public EBRPartitionSystem(ReadableRandomAccessStream psStream, long ebrPartitionOffset, long ebrPartitionLength, int sectorSize) {
        ExtendedBootRecord ebr;
        byte[] tempBuffer = new byte[512];
        long curOffset = ebrPartitionOffset;
        psStream.seek(curOffset);
        psStream.readFully(tempBuffer);
        LinkedList<ExtendedBootRecord> recordList = new LinkedList<ExtendedBootRecord>();
        while ((ebr = new ExtendedBootRecord(tempBuffer, 0, ebrPartitionOffset, curOffset, sectorSize)).isValid()) {
            if (recordList.size() > 10000) {
                throw new RuntimeException("Number of EBR partitions capped at 10000.");
            }
            recordList.add(ebr);
            if (ebr.isTerminator()) break;
            curOffset = ebr.getSecondEntry().getStartOffset();
            if (ebrPartitionLength > 0L && curOffset > ebrPartitionOffset + ebrPartitionLength) {
                throw new RuntimeException("Invalid DOS Extended partition system (curOffset=" + curOffset + ").");
            }
            psStream.seek(curOffset);
            psStream.readFully(tempBuffer);
        }
        if (!ebr.isValid()) {
            throw new RuntimeException("Invalid extended partition table at index " + recordList.size() + ".");
        }
        this.bootRecords = recordList.toArray(new ExtendedBootRecord[recordList.size()]);
    }

    public boolean isValid() {
        return true;
    }

    public int getPartitionCount() {
        return this.bootRecords.length;
    }

    public Partition getPartitionEntry(int index) {
        return this.bootRecords[index].getFirstEntry();
    }

    public Partition[] getPartitionEntries() {
        Partition[] result = new Partition[this.bootRecords.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.bootRecords[i].getFirstEntry();
        }
        return result;
    }

    public int getUsedPartitionCount() {
        return this.getPartitionCount();
    }

    public Partition[] getUsedPartitionEntries() {
        return this.getPartitionEntries();
    }

    public String getLongName() {
        return "Extended Boot Record";
    }

    public String getShortName() {
        return "EBR";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " bootRecords:");
        for (int i = 0; i < this.bootRecords.length; ++i) {
            ExtendedBootRecord ebr = this.bootRecords[i];
            ps.print(prefix + "  [" + i + "]:");
            ebr.print(ps, prefix + "   ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }

    public static void main(String[] args) {
        System.err.println("Test code for Extended Boot Record");
        String inputFilename = args[0];
        WindowsLowLevelIO inputStream = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(inputFilename) : new ReadableFileStream(inputFilename);
        MBRPartitionTable mpt = new MBRPartitionTable(inputStream, 0);
        if (!mpt.isValid()) {
            throw new RuntimeException("Invalid MBR.");
        }
        int i = 0;
        for (Partition p : mpt.getUsedPartitionEntries()) {
            if (p.getType() == PartitionType.DOS_EXTENDED) {
                System.err.println("Found extended partition system at MBR partition " + i + ":");
                EBRPartitionSystem ebt = new EBRPartitionSystem(inputStream, p.getStartOffset(), p.getLength(), 512);
                ebt.print(System.err, "  ");
            }
            ++i;
        }
        inputStream.close();
    }
}

