/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractCreateDataBackgroundCmd<T extends AbstractCreateDataTypeModel>
extends BackgroundCommand {
    protected final String name;
    protected final Address address;
    protected final int count;
    protected final DataValidationOptions validationOptions;
    protected final DataApplyOptions applyOptions;
    protected T model;
    protected TaskMonitor monitor;

    protected AbstractCreateDataBackgroundCmd(T model, DataApplyOptions applyOptions) {
        super("Create " + ((AbstractCreateDataTypeModel)model).getName() + " Data", true, true, true);
        this.model = model;
        this.name = ((AbstractCreateDataTypeModel)model).getName();
        this.address = ((AbstractCreateDataTypeModel)model).getAddress();
        this.count = ((AbstractCreateDataTypeModel)model).getCount();
        this.validationOptions = ((AbstractCreateDataTypeModel)model).getValidationOptions();
        this.applyOptions = applyOptions;
    }

    protected AbstractCreateDataBackgroundCmd(String name, Address address, int count) {
        this(name, address, count, new DataValidationOptions(), new DataApplyOptions());
    }

    protected AbstractCreateDataBackgroundCmd(String name, Address address, int count, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("Create " + name + " Data", true, true, true);
        this.name = name;
        this.address = address;
        this.count = count;
        this.validationOptions = validationOptions;
        this.applyOptions = applyOptions;
    }

    public final boolean applyTo(DomainObject obj, TaskMonitor taskMonitor) {
        try {
            if (!(obj instanceof Program)) {
                String message = "Can only apply a " + this.name + " data type to a program.";
                this.handleError(message);
                return false;
            }
            return this.doApplyTo((Program)obj, taskMonitor);
        }
        catch (CancelledException e) {
            this.setStatusMsg("User cancelled " + this.getName() + ".");
            return false;
        }
    }

    protected abstract T createModel(Program var1);

    protected final DataType getDataType() {
        return ((AbstractCreateDataTypeModel)this.model).getDataType();
    }

    private boolean doApplyTo(Program program, TaskMonitor taskMonitor) throws CancelledException {
        try {
            this.monitor = taskMonitor;
            this.monitor.checkCanceled();
            this.model = this.createModel(program);
            ((AbstractCreateDataTypeModel)this.model).validate();
            try {
                if (((AbstractCreateDataTypeModel)this.model).isBlockedByInstructions()) {
                    String message = "Cannot create data in " + program.getDomainFile().getPathname() + " using " + ((AbstractCreateDataTypeModel)this.model).getName() + " from " + ((AbstractCreateDataTypeModel)this.model).getAddress() + " to " + ((AbstractCreateDataTypeModel)this.model).getEndAddress() + " since there are instructions in the way.";
                    this.handleErrorMessage(program, ((AbstractCreateDataTypeModel)this.model).getAddress(), message);
                    return false;
                }
            }
            catch (InvalidDataTypeException e) {
                this.handleErrorMessage(program, ((AbstractCreateDataTypeModel)this.model).getAddress(), e.getMessage());
                return false;
            }
            this.createData();
            boolean success = true;
            try {
                this.createMarkup();
            }
            catch (InvalidInputException e) {
                this.handleErrorMessage(program, this.name, this.address, this.address, (Exception)((Object)e));
                success = false;
            }
            if (this.applyOptions.shouldFollowData() && !this.createAssociatedData()) {
                success = false;
            }
            this.setStatusMsg(this.getName() + " completed successfully!");
            return success;
        }
        catch (AddressOutOfBoundsException | DataTypeConflictException | InvalidDataTypeException | CodeUnitInsertionException e) {
            this.handleErrorMessage(program, this.name, this.address, this.address, (Exception)e);
            return false;
        }
    }

    protected void createData() throws CodeUnitInsertionException, CancelledException {
        Program program = ((AbstractCreateDataTypeModel)this.model).getProgram();
        Memory memory = program.getMemory();
        DataType dt = this.getDataType();
        if (dt == null) {
            throw new CodeUnitInsertionException("Unable to get data type from model, " + ((AbstractCreateDataTypeModel)this.model).getName() + ".");
        }
        if (!memory.getLoadedAndInitializedAddressSet().contains(this.address)) {
            String message = "Can't create an " + dt.getName() + " @ " + this.address + " which isn't in loaded and initialized memory for " + program.getName();
            throw new CodeUnitInsertionException(message);
        }
        if (!((AbstractCreateDataTypeModel)this.model).isDataTypeAlreadyBasedOnCount() && this.count > 1) {
            dt = new ArrayDataType(dt, this.count, dt.getLength(), program.getDataTypeManager());
        }
        this.monitor.checkCanceled();
        if (this.matchingDataExists(dt, program, this.address)) {
            return;
        }
        this.monitor.checkCanceled();
        DataUtilities.createData((Program)program, (Address)this.address, (DataType)dt, (int)dt.getLength(), (boolean)false, (DataUtilities.ClearDataMode)this.getClearDataMode());
    }

    protected boolean matchingDataExists(DataType dt, Program program, Address startAddress) {
        Listing listing = program.getListing();
        Data dataAt = listing.getDataAt(startAddress);
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        DataType resolvedDt = dataTypeManager.resolve(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
        return dataAt != null && dataAt.getDataType() == resolvedDt;
    }

    protected abstract boolean createMarkup() throws CancelledException, InvalidInputException, InvalidDataTypeException;

    protected abstract boolean createAssociatedData() throws CancelledException;

    protected void handleErrorMessage(Program program, String dataName, Address dataAddress, Address bookmarkAddress) {
        this.handleErrorMessage(program, dataName, dataAddress, bookmarkAddress, null);
    }

    protected void handleErrorMessage(Program program, String dataName, Address dataAddress, Address bookmarkAddress, Exception e1) {
        String message = "Couldn't create " + dataName + " data @ " + dataAddress + ".";
        String detailedMessage = e1 == null || e1.getMessage() == null ? message : message + " " + e1.getMessage();
        this.handleErrorMessage(program, bookmarkAddress, detailedMessage, message);
    }

    protected void handleErrorMessage(Program program, Address bookmarkAddress, String message) {
        this.handleErrorMessage(program, bookmarkAddress, message, message);
    }

    protected void handleErrorMessage(Program program, Address bookmarkAddress, String errorMessage, String statusMessage) {
        Msg.error((Object)((Object)this), (Object)errorMessage);
        this.setStatusMsg(statusMessage);
        if (this.applyOptions.shouldCreateBookmarks()) {
            BookmarkManager bookmarkManager = program.getBookmarkManager();
            bookmarkManager.setBookmark(bookmarkAddress, "Error", "Data", errorMessage);
        }
    }

    protected void handleError(String message) {
        Msg.error((Object)((Object)this), (Object)message);
        this.setStatusMsg(message);
    }

    protected DataUtilities.ClearDataMode getClearDataMode() {
        return this.applyOptions.shouldClearDefinedData() ? DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA : DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA;
    }
}

