/*
 * Decompiled with CFR 0.152.
 */
package generic.hash;

import generic.hash.MessageDigest;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class AbstractMessageDigest
implements MessageDigest {
    public final String algorithm;
    public final int digestLength;

    protected AbstractMessageDigest(String algorithm, int digestLength) {
        this.algorithm = algorithm;
        this.digestLength = digestLength;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getDigestLength() {
        return this.digestLength;
    }

    @Override
    public final byte[] digest() {
        byte[] results = new byte[this.digestLength];
        this.digest(results, 0, this.digestLength);
        return results;
    }

    @Override
    public final void update(byte[] input, TaskMonitor monitor) throws CancelledException {
        this.update(input, 0, input.length, monitor);
    }

    @Override
    public final void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    @Override
    public void update(short input) {
        this.update((byte)(input >> 8 & 0xFF));
        this.update((byte)(input & 0xFF));
    }

    @Override
    public void update(int input) {
        this.update((byte)(input >> 24 & 0xFF));
        this.update((byte)(input >> 16 & 0xFF));
        this.update((byte)(input >> 8 & 0xFF));
        this.update((byte)(input & 0xFF));
    }

    @Override
    public void update(long input) {
        this.update((byte)(input >> 56 & 0xFFL));
        this.update((byte)(input >> 48 & 0xFFL));
        this.update((byte)(input >> 40 & 0xFFL));
        this.update((byte)(input >> 32 & 0xFFL));
        this.update((byte)(input >> 24 & 0xFFL));
        this.update((byte)(input >> 16 & 0xFFL));
        this.update((byte)(input >> 8 & 0xFFL));
        this.update((byte)(input & 0xFFL));
    }

    @Override
    public void update(byte[] input, int offset, int len) {
        for (int ii = 0; ii < len; ++ii) {
            this.update(input[offset++]);
        }
    }

    @Override
    public void update(byte[] input, int offset, int len, TaskMonitor monitor) throws CancelledException {
        for (int ii = 0; ii < len; ++ii) {
            monitor.checkCanceled();
            this.update(input[offset++]);
        }
    }
}

