/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

public class Range
implements Comparable<Range> {
    public int min;
    public int max;

    public Range(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Range max (" + max + ") cannot be less than min (" + min + ").");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public int compareTo(Range other) {
        if (this.min == other.min) {
            return 0;
        }
        if (this.min > other.min) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != Range.class) {
            return false;
        }
        Range other = (Range)obj;
        return other.min == this.min && other.max == this.max;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "(" + this.min + "," + this.max + ")";
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public long size() {
        return (long)this.max - (long)this.min + 1L;
    }
}

