/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.demangler.GenericDemangledType;
import util.demangler.GenericDemangledVariable;

public class GenericDemangledDataType
extends GenericDemangledType {
    protected static final Pattern ARRAY_SUBSCRIPT_PATTERN = Pattern.compile("\\[\\d*\\]");
    public static final char SPACE = ' ';
    private static final String STATIC = "static";
    public static final String UNALIGNED = "__unaligned";
    public static final String UNSIGNED = "unsigned";
    public static final String SIGNED = "signed";
    public static final String ARR_NOTATION = "[]";
    public static final String REF_NOTATION = "&";
    public static final String PTR_NOTATION = "*";
    public static final String VOLATILE = "volatile";
    public static final String COMPLEX = "complex";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String STRUCT = "struct";
    public static final String UNION = "union";
    public static final String COCLASS = "coclass";
    public static final String COINTERFACE = "cointerface";
    public static final String CONST = "const";
    protected static final String FAR = "far";
    protected static final String RESTRICT = "restrict";
    public static final String VARARGS = "...";
    public static final String VOID = "void";
    public static final String BOOL = "bool";
    public static final String CHAR = "char";
    public static final String WCHAR_T = "wchar_t";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String INT0_T = "int0_t";
    public static final String LONG = "long";
    public static final String LONG_LONG = "long long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String INT64 = "__int64";
    public static final String INT128 = "__int128";
    public static final String FLOAT128 = "__float128";
    public static final String LONG_DOUBLE = "long double";
    public static final String PTR64 = "__ptr64";
    public static final String STRING = "string";
    public static final String[] PRIMITIVES = new String[]{"void", "bool", "char", "wchar_t", "short", "int", "int0_t", "long", "long long", "float", "double", "__int128", "__float128", "long double"};
    protected String access;
    protected boolean isStatic;
    protected boolean isArray;
    protected boolean isClass;
    protected boolean isComplex;
    protected boolean isEnum;
    protected boolean isPointer64;
    protected boolean isReference;
    protected boolean isSigned;
    protected boolean isStruct;
    protected boolean isTemplate;
    protected boolean isUnaligned;
    protected boolean isUnion;
    protected boolean isUnsigned;
    protected boolean isVarArgs;
    protected boolean isVolatile;
    protected int pointerLevels = 0;
    protected boolean isFar;
    protected boolean isRestrict;
    protected String basedAttribute;
    protected String memberScope;
    protected boolean isCoclass;
    protected boolean isCointerface;

    public GenericDemangledDataType(String name) {
        super(name);
    }

    public GenericDemangledDataType copy() {
        GenericDemangledDataType copy = new GenericDemangledDataType(this.getName());
        this.copyInto(copy);
        return copy;
    }

    public void copyInto(GenericDemangledDataType destination) {
        GenericDemangledDataType source = this;
        destination.isStatic |= source.isStatic;
        destination.isArray |= source.isArray;
        destination.isClass |= source.isClass;
        destination.isComplex |= source.isComplex;
        destination.isEnum |= source.isEnum;
        destination.isPointer64 |= source.isPointer64;
        destination.isReference |= source.isReference;
        destination.isSigned |= source.isSigned;
        destination.isStruct |= source.isStruct;
        destination.isTemplate |= source.isTemplate;
        destination.isUnaligned |= source.isUnaligned;
        destination.isUnion |= source.isUnion;
        destination.isUnsigned |= source.isUnsigned;
        destination.isVarArgs |= source.isVarArgs;
        destination.isVolatile |= source.isVolatile;
        destination.pointerLevels += source.pointerLevels;
        destination.isFar |= source.isFar;
        destination.isRestrict |= source.isRestrict;
        this.updateAccess(destination, source);
        destination.setNamespace(source.getNamespace());
        destination.setTemplate(source.getTemplate());
        destination.basedAttribute = source.basedAttribute;
        destination.memberScope = source.memberScope;
        destination.isCoclass |= source.isCoclass;
        destination.isCointerface |= source.isCointerface;
        if (source.isConst()) {
            destination.setConst();
        }
        if (source.isVolatile()) {
            destination.setVolatile();
        }
    }

    private void updateAccess(GenericDemangledDataType destination, GenericDemangledDataType source) {
        String currentAccess = destination.getAccess();
        if (currentAccess != null && !currentAccess.trim().isEmpty()) {
            return;
        }
        destination.setAccess(source.getAccess());
    }

    public void copyInto(GenericDemangledVariable destination) {
        GenericDemangledDataType source = this;
        ArrayList<String> list = new ArrayList<String>();
        if (source.isConst()) {
            list.add(CONST);
        }
        if (source.isVolatile) {
            list.add(VOLATILE);
        }
        if (source.isFar) {
            list.add(FAR);
        }
        if (source.isRestrict) {
            list.add(RESTRICT);
        }
        StringBuilder buffy = new StringBuilder();
        for (String string : list) {
            buffy.append(string).append(' ');
        }
        String storage = buffy.toString().trim();
        destination.setStorageClass(storage.isEmpty() ? null : storage);
        destination.setStatic(source.isStatic());
        destination.setVisibilty(source.getAccess());
        if (source.isStruct) {
            destination.setStruct();
        }
        if (source.isUnsigned) {
            destination.setUnsigned();
        }
    }

    public int getPointerLevels() {
        return this.pointerLevels;
    }

    public void setPointerLevels(int levels) {
        this.pointerLevels = levels;
    }

    public void incrementPointerLevels() {
        ++this.pointerLevels;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getAccess() {
        return this.access;
    }

    public void setStatic() {
        this.isStatic = true;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setArray() {
        this.isArray = true;
    }

    public void setClass() {
        this.isClass = true;
    }

    public void setComplex() {
        this.isComplex = true;
    }

    public void setEnum() {
        this.isEnum = true;
    }

    public void setPointer64() {
        this.isPointer64 = true;
    }

    public void setReference() {
        this.isReference = true;
    }

    public void setSigned() {
        this.isSigned = true;
    }

    public void setStruct() {
        this.isStruct = true;
    }

    public void setTemplate() {
        this.isTemplate = true;
    }

    public void setUnion() {
        this.isUnion = true;
    }

    public void setCoclass() {
        this.isCoclass = true;
    }

    public void setCointerface() {
        this.isCointerface = true;
    }

    public void setUnsigned() {
        this.isUnsigned = true;
    }

    public void setUnaligned() {
        this.isUnaligned = true;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public void setVarArgs() {
        this.isVarArgs = true;
    }

    @Override
    public void setVolatile() {
        this.isVolatile = true;
    }

    public void setFar() {
        this.isFar = true;
    }

    public boolean isFar() {
        return this.isFar;
    }

    public void setRestrict() {
        this.isRestrict = true;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isPointer() {
        return this.pointerLevels > 0;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isStruct() {
        return this.isStruct;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public boolean isCoclass() {
        return this.isCoclass;
    }

    public boolean isCointerface() {
        return this.isCointerface;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isVoid() {
        return VOID.equals(this.getName());
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public String getBasedName() {
        return this.basedAttribute;
    }

    public void setBasedName(String basedName) {
        this.basedAttribute = basedName;
    }

    public String getMemberScope() {
        return this.memberScope;
    }

    public void setMemberScope(String memberScope) {
        this.memberScope = memberScope;
    }

    public boolean isPrimitive() {
        boolean isPrimitiveDT;
        boolean bl = isPrimitiveDT = !this.isArray && !this.isClass && !this.isComplex && !this.isEnum && !this.isPointer() && !this.isPointer64 && !this.isSigned && !this.isTemplate && !this.isUnion && !this.isCoclass && !this.isCointerface && !this.isVarArgs && !this.isVolatile;
        if (isPrimitiveDT) {
            for (String primitiveNames : PRIMITIVES) {
                if (!this.getName().equals(primitiveNames)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toSignature() {
        Matcher matcher;
        boolean hasPointers;
        StringBuffer buffer = new StringBuffer();
        if (this.access != null) {
            buffer.append(this.access).append(' ');
        }
        if (this.isStatic) {
            buffer.append(STATIC).append(' ');
        }
        if (this.isUnion) {
            buffer.append(UNION).append(' ');
        }
        if (this.isStruct) {
            buffer.append(STRUCT).append(' ');
        }
        if (this.isEnum) {
            buffer.append(ENUM).append(' ');
        }
        if (this.isClass) {
            buffer.append(CLASS).append(' ');
        }
        if (this.isCoclass) {
            buffer.append(COCLASS).append(' ');
        }
        if (this.isCointerface) {
            buffer.append(COINTERFACE).append(' ');
        }
        if (this.isComplex) {
            buffer.append(COMPLEX).append(' ');
        }
        if (this.isSigned) {
            buffer.append(SIGNED).append(' ');
        }
        if (this.isUnsigned) {
            buffer.append(UNSIGNED).append(' ');
        }
        if (this.getNamespace() != null) {
            buffer.append(this.getNamespace().toNamespace());
        }
        String space = "";
        if (this.getName() != null) {
            buffer.append(this.getName());
            space = String.valueOf(' ');
        }
        if (this.getTemplate() != null) {
            buffer.append(this.getTemplate().toTemplate());
            space = String.valueOf(' ');
        }
        if (this.isConst()) {
            buffer.append(space).append(CONST);
            space = String.valueOf(' ');
        }
        if (this.isVolatile()) {
            buffer.append(space).append(VOLATILE);
            space = String.valueOf(' ');
        }
        if (this.isUnaligned) {
            buffer.append(space).append(UNALIGNED);
            space = String.valueOf(' ');
        }
        if (this.isFar) {
            buffer.append(space).append(FAR);
            space = String.valueOf(' ');
        }
        if (this.isRestrict) {
            buffer.append(space).append(RESTRICT);
            space = String.valueOf(' ');
        }
        boolean bl = hasPointers = this.pointerLevels >= 1;
        if (hasPointers) {
            buffer.append(space + PTR_NOTATION);
            space = String.valueOf(' ');
        }
        if (this.isReference) {
            if (this.isConst() && hasPointers) {
                buffer.append(space).append(CONST);
                space = String.valueOf(' ');
            }
            if (this.isVolatile() && hasPointers) {
                buffer.append(space).append(VOLATILE);
                space = String.valueOf(' ');
            }
            buffer.append(space).append(REF_NOTATION);
            space = String.valueOf(' ');
        }
        if (this.isPointer64) {
            buffer.append(space).append(PTR64);
            space = String.valueOf(' ');
        }
        for (int i = 1; i < this.pointerLevels; ++i) {
            if (this.isConst()) {
                buffer.append(space).append(CONST);
                space = String.valueOf(' ');
            }
            if (this.isVolatile()) {
                buffer.append(space).append(VOLATILE);
                space = String.valueOf(' ');
            }
            buffer.append(space).append(PTR_NOTATION);
            space = String.valueOf(' ');
            if (!this.isPointer64) continue;
            buffer.append(space).append(PTR64);
            space = String.valueOf(' ');
        }
        if (this.isArray && !(matcher = ARRAY_SUBSCRIPT_PATTERN.matcher(this.getName())).find()) {
            buffer.append(ARR_NOTATION);
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.toSignature();
    }
}

