/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import java.util.Map;
import java.util.Set;

public class ConstantValueSolver
extends AbstractExpressionSolver<ConstantValue> {
    public ConstantValueSolver() {
        super(ConstantValue.class);
    }

    @Override
    public AssemblyResolution solve(ConstantValue cv, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) {
        MaskedLong value = this.getValue(cv, vals, res, cur);
        return ConstantValueSolver.checkConstAgrees(value, goal, description);
    }

    @Override
    public MaskedLong getValue(ConstantValue cv, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) {
        return MaskedLong.fromLong(cv.getValue());
    }

    @Override
    public int getInstructionLength(ConstantValue cv, Map<Integer, Object> res) {
        return 0;
    }

    @Override
    public MaskedLong valueForResolution(ConstantValue cv, AssemblyResolvedConstructor rc) {
        return MaskedLong.fromLong(cv.getValue());
    }

    static AssemblyResolution checkConstAgrees(MaskedLong value, MaskedLong goal, String description) {
        if (!value.agrees(goal)) {
            return AssemblyResolution.error("Constant value " + value + " does not agree with child requirements", description, null);
        }
        return AssemblyResolution.nop(description, null);
    }
}

