/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CompositeDBAdapterV1
extends CompositeDBAdapter
implements RecordTranslator {
    static final int VERSION = 1;
    static final int V1_COMPOSITE_NAME_COL = 0;
    static final int V1_COMPOSITE_COMMENT_COL = 1;
    static final int V1_COMPOSITE_IS_UNION_COL = 2;
    static final int V1_COMPOSITE_CAT_COL = 3;
    static final int V1_COMPOSITE_LENGTH_COL = 4;
    static final int V1_COMPOSITE_NUM_COMPONENTS_COL = 5;
    static final int V1_COMPOSITE_SOURCE_ARCHIVE_ID_COL = 6;
    static final int V1_COMPOSITE_UNIVERSAL_DT_ID_COL = 7;
    static final int V1_COMPOSITE_SOURCE_SYNC_TIME_COL = 8;
    static final int V1_COMPOSITE_LAST_CHANGE_TIME_COL = 9;
    static final Schema V1_COMPOSITE_SCHEMA = new Schema(1, "Data Type ID", new Class[]{StringField.class, StringField.class, BooleanField.class, LongField.class, IntField.class, IntField.class, LongField.class, LongField.class, LongField.class, LongField.class}, new String[]{"Name", "Comment", "Is Union", "Category ID", "Length", "Number Of Components", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table compositeTable;

    public CompositeDBAdapterV1(DBHandle handle) throws VersionException {
        this.compositeTable = handle.getTable("Composite Data Types");
        if (this.compositeTable == null) {
            throw new VersionException("Missing Table: Composite Data Types");
        }
        int version = this.compositeTable.getSchema().getVersion();
        if (version != 1) {
            String msg = "Expected version 1 for table Composite Data Types but got " + this.compositeTable.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public Record createRecord(String name, String comments, boolean isUnion, long categoryID, int length, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime, int internalAlignment, int externalAlignment) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #1 of Composite Data Types table.");
    }

    @Override
    public Record getRecord(long dataTypeID) throws IOException {
        return this.translateRecord(this.compositeTable.getRecord(dataTypeID));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.compositeTable.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long compositeID) throws IOException {
        return this.compositeTable.deleteRecord(compositeID);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Composite Data Types");
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(archiveID), 6);
    }

    public Record translateRecord(Record oldRec) {
        if (oldRec == null) {
            return null;
        }
        Record rec = CompositeDBAdapter.COMPOSITE_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setBooleanValue(2, oldRec.getBooleanValue(2));
        rec.setLongValue(3, oldRec.getLongValue(3));
        rec.setIntValue(4, oldRec.getIntValue(4));
        rec.setIntValue(5, oldRec.getIntValue(5));
        rec.setLongValue(6, oldRec.getLongValue(6));
        rec.setLongValue(7, oldRec.getLongValue(7));
        rec.setLongValue(8, oldRec.getLongValue(8));
        rec.setLongValue(9, oldRec.getLongValue(9));
        rec.setIntValue(10, -1);
        rec.setIntValue(11, 0);
        return rec;
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        long[] keys = this.compositeTable.findRecords((Field)new LongField(datatypeID.getValue()), 7);
        for (int i = 0; i < keys.length; ++i) {
            Record record = this.compositeTable.getRecord(keys[i]);
            if (record.getLongValue(6) != sourceID.getValue()) continue;
            return this.translateRecord(record);
        }
        return null;
    }
}

