/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import docking.framework.DockingApplicationConfiguration;
import docking.widgets.label.GDLabel;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.program.database.data.DataTypeArchiveTransformerPanel;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import utility.application.ApplicationLayout;

public class DataTypeArchiveTransformer
implements GhidraLaunchable {
    static File myOldFile = null;
    static File myNewFile = null;
    static File myDestinationFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(File oldFile, File newFile, File destinationFile, boolean useOldFileID, TaskMonitor monitor) throws InvalidInputException, DuplicateFileException, IOException, CancelledException {
        monitor.setMessage("Beginning transformation...");
        DataTypeArchiveTransformer.validate(oldFile, newFile, destinationFile);
        FileDataTypeManager oldFileArchive = null;
        FileDataTypeManager newFileArchive = null;
        try {
            monitor.initialize(100L);
            oldFileArchive = FileDataTypeManager.openFileArchive(oldFile, false);
            newFileArchive = FileDataTypeManager.openFileArchive(newFile, true);
            UniversalID oldUniversalID = oldFileArchive.getUniversalID();
            UniversalID newUniversalID = newFileArchive.getUniversalID();
            Msg.info(DataTypeArchiveTransformer.class, (Object)("Old file ID = " + oldUniversalID));
            Msg.info(DataTypeArchiveTransformer.class, (Object)("New file ID = " + newUniversalID));
            DataTypeArchiveTransformer.transformEachDataType(oldFileArchive, newFileArchive, monitor);
            monitor.setProgress(50L);
            DataTypeArchiveTransformer.fixEachDataTypeTimestamp(oldFileArchive, newFileArchive, monitor);
            monitor.setProgress(100L);
            monitor.setMessage("Saving " + destinationFile.getAbsolutePath());
            if (useOldFileID) {
                DataTypeArchiveTransformer.saveNewArchive(oldFileArchive, newFileArchive, destinationFile);
            } else {
                DataTypeArchiveTransformer.saveNewArchive(newFileArchive, destinationFile);
            }
        }
        finally {
            if (oldFileArchive != null) {
                oldFileArchive.close();
            }
            if (newFileArchive != null) {
                newFileArchive.close();
            }
        }
    }

    private static void validate(File oldFile, File newFile, File destinationFile) throws InvalidInputException {
        if (oldFile == null || oldFile.getPath().length() == 0) {
            throw new InvalidInputException("Old data type archive file must be specified.");
        }
        if (newFile == null || newFile.getPath().length() == 0) {
            throw new InvalidInputException("New data type archive file must be specified.");
        }
        if (destinationFile == null || destinationFile.getPath().length() == 0) {
            throw new InvalidInputException("Destination data type archive file must be specified.");
        }
        if (!oldFile.getPath().endsWith(".gdt")) {
            throw new InvalidInputException("Old data type archive file must end with .gdt");
        }
        if (!newFile.getPath().endsWith(".gdt")) {
            throw new InvalidInputException("New data type archive file must end with .gdt");
        }
        if (!destinationFile.getPath().endsWith(".gdt")) {
            throw new InvalidInputException("Destination data type archive file must end with .gdt");
        }
        if (!oldFile.exists()) {
            throw new InvalidInputException("Old data type archive file must already exist.");
        }
        if (!newFile.exists()) {
            throw new InvalidInputException("New data type archive file must already exist.");
        }
        if (!oldFile.isFile()) {
            throw new InvalidInputException("Old data type archive file must be a file.");
        }
        if (!newFile.isFile()) {
            throw new InvalidInputException("New data type archive file must be a file.");
        }
        if (oldFile.length() == 0L) {
            throw new InvalidInputException("Old data type archive file cannot be empty.");
        }
        if (newFile.length() == 0L) {
            throw new InvalidInputException("New data type archive file cannot be empty.");
        }
        if (destinationFile.exists()) {
            throw new InvalidInputException("Destination file \"" + destinationFile.getAbsolutePath() + "\" cannot already exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformEachDataType(FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive, TaskMonitor monitor) throws CancelledException {
        boolean commit = false;
        int transactionID = newFileArchive.startTransaction("Transforming Data Type Archive");
        try {
            DataTypeArchiveTransformer.assignNewUniversalIDs(newFileArchive, monitor);
            Iterator<DataType> allDataTypes = newFileArchive.getAllDataTypes();
            while (allDataTypes.hasNext()) {
                monitor.checkCanceled();
                DataType newDataType = allDataTypes.next();
                if (DataTypeArchiveTransformer.isAnonymousType(newDataType) || newDataType instanceof Pointer || newDataType instanceof Array || newDataType instanceof BuiltIn) continue;
                DataType oldDataType = DataTypeArchiveTransformer.transformDataType(newDataType, oldFileArchive, newFileArchive);
                DataTypeArchiveTransformer.processAnonymous(oldDataType, newDataType, oldFileArchive, newFileArchive);
                monitor.setMessage("Transforming ID for " + newDataType.getPathName());
            }
            DataTypeArchiveTransformer.processUnmatchedEnums(oldFileArchive, newFileArchive, monitor);
            commit = true;
        }
        finally {
            newFileArchive.endTransaction(transactionID, commit);
        }
    }

    private static void assignNewUniversalIDs(FileDataTypeManager newFileArchive, TaskMonitor monitor) throws CancelledException {
        Iterator<DataType> allDataTypes = newFileArchive.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            monitor.checkCanceled();
            DataType newDataType = allDataTypes.next();
            if (!(newDataType instanceof DataTypeDB)) continue;
            ((DataTypeDB)newDataType).setUniversalID(UniversalIdGenerator.nextID());
        }
    }

    private static void processUnmatchedEnums(FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive, TaskMonitor monitor) throws CancelledException {
        Iterator<DataType> allDataTypes = newFileArchive.getAllDataTypes();
        while (allDataTypes.hasNext()) {
            Enum oldEnum;
            UniversalID newDtUniversalID;
            DataType matchingDt;
            monitor.checkCanceled();
            DataType newDataType = allDataTypes.next();
            if (!(newDataType instanceof Enum) || !DataTypeArchiveTransformer.isAnonymousType(newDataType) || (matchingDt = oldFileArchive.findDataTypeForID(newDtUniversalID = newDataType.getUniversalID())) != null || (oldEnum = DataTypeArchiveTransformer.findMatchingAnonEnum((Enum)newDataType, oldFileArchive)) == null || !DataTypeArchiveTransformer.areSameClassType(newDataType, oldEnum)) continue;
            DataTypeArchiveTransformer.transformDataType(newDataType, newFileArchive, oldEnum);
        }
    }

    private static Enum findMatchingAnonEnum(Enum newEnum, FileDataTypeManager oldFileArchive) {
        DataType[] dataTypes;
        CategoryPath categoryPath = newEnum.getCategoryPath();
        Category category = oldFileArchive.getCategory(categoryPath);
        if (category == null) {
            return null;
        }
        for (DataType oldDataType : dataTypes = category.getDataTypes()) {
            Enum oldEnum;
            if (!(oldDataType instanceof Enum) || !DataTypeArchiveTransformer.isAnonymousType(oldDataType) || !DataTypeArchiveTransformer.isMatchingEnum(newEnum, oldEnum = (Enum)oldDataType)) continue;
            return oldEnum;
        }
        return null;
    }

    private static boolean isMatchingEnum(Enum newEnum, Enum oldEnum) {
        String[] names = newEnum.getNames();
        int totalNames = names.length;
        int nameMatches = 0;
        int exactMatches = 0;
        for (String name : names) {
            try {
                long newValue = newEnum.getValue(name);
                try {
                    long oldValue = oldEnum.getValue(name);
                    ++nameMatches;
                    if (newValue != oldValue) continue;
                    ++exactMatches;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            catch (NoSuchElementException e1) {
                Msg.error(DataTypeArchiveTransformer.class, (Object)("Couldn't get the value for the name " + name + " in enum " + newEnum.getName()));
            }
        }
        int threshold = totalNames / 2;
        if (exactMatches > 0 && exactMatches >= threshold) {
            return true;
        }
        if (nameMatches > 0) {
            Msg.info(DataTypeArchiveTransformer.class, (Object)("Enum " + newEnum.getName() + " had " + nameMatches + " name matches with " + oldEnum.getName()));
        }
        return false;
    }

    private static void processAnonymous(DataType oldDataType, DataType newDataType, FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive) {
        if (newDataType instanceof Composite && oldDataType instanceof Composite) {
            DataTypeComponent[] newComponents;
            Composite newComposite = (Composite)newDataType;
            Composite oldComposite = (Composite)oldDataType;
            boolean isNewDtAnonymous = DataTypeArchiveTransformer.isAnonymousType(newDataType);
            boolean isOldDtAnonymous = DataTypeArchiveTransformer.isAnonymousType(oldDataType);
            if (isNewDtAnonymous && isOldDtAnonymous && newComposite.getNumComponents() != oldComposite.getNumComponents()) {
                return;
            }
            for (DataTypeComponent newComp : newComponents = newComposite.getComponents()) {
                DataTypeArchiveTransformer.transformAnonymousComponent(oldFileArchive, newFileArchive, oldComposite, newComposite, newComp);
            }
        } else if (newDataType instanceof TypeDef && oldDataType instanceof TypeDef) {
            TypeDef oldTypeDef = (TypeDef)oldDataType;
            TypeDef newTypeDef = (TypeDef)newDataType;
            DataTypeArchiveTransformer.transformInnerAnonymousDataType(oldTypeDef.getDataType(), newTypeDef.getDataType(), oldFileArchive, newFileArchive);
        } else if (newDataType instanceof Pointer && oldDataType instanceof Pointer) {
            Pointer oldPointer = (Pointer)oldDataType;
            Pointer newPointer = (Pointer)newDataType;
            DataTypeArchiveTransformer.transformInnerAnonymousDataType(oldPointer.getDataType(), newPointer.getDataType(), oldFileArchive, newFileArchive);
        } else if (newDataType instanceof Array && oldDataType instanceof Array) {
            Array oldArray = (Array)oldDataType;
            Array newArray = (Array)newDataType;
            if (oldArray.getNumElements() == newArray.getNumElements()) {
                DataTypeArchiveTransformer.transformInnerAnonymousDataType(oldArray.getDataType(), newArray.getDataType(), oldFileArchive, newFileArchive);
            }
        }
    }

    private static void transformAnonymousComponent(FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive, Composite oldComposite, Composite newComposite, DataTypeComponent newComponent) {
        DataTypeComponent matchingComponent;
        DataType newCompDt = newComponent.getDataType();
        int anonymousPointerDepth = DataTypeArchiveTransformer.getAnonymousPointerDepth(newCompDt);
        int anonymousArrayNumElements = DataTypeArchiveTransformer.getAnonymousArrayElementCount(newCompDt);
        int anonymousTypeDefDepth = DataTypeArchiveTransformer.getAnonymousTypeDefDepth(newCompDt);
        if ((DataTypeArchiveTransformer.isAnonymousType(newCompDt) || anonymousPointerDepth > 0 || anonymousArrayNumElements > 0 || anonymousTypeDefDepth > 0) && (matchingComponent = DataTypeArchiveTransformer.getAnonymousMatch(oldComposite, newComposite, newComponent)) != null) {
            DataType oldCompDt = matchingComponent.getDataType();
            if (anonymousPointerDepth > 0) {
                int oldPointerDepth = DataTypeArchiveTransformer.getAnonymousPointerDepth(oldCompDt);
                if (anonymousPointerDepth != oldPointerDepth) {
                    return;
                }
                newCompDt = DataTypeUtilities.getBaseDataType(newCompDt);
                oldCompDt = DataTypeUtilities.getBaseDataType(oldCompDt);
            }
            if (anonymousArrayNumElements > 0) {
                int oldArrayNumElements = DataTypeArchiveTransformer.getAnonymousArrayElementCount(oldCompDt);
                if (anonymousArrayNumElements != oldArrayNumElements) {
                    return;
                }
                newCompDt = DataTypeUtilities.getBaseDataType(newCompDt);
                oldCompDt = DataTypeUtilities.getBaseDataType(oldCompDt);
            }
            if (anonymousTypeDefDepth > 0) {
                int oldTypeDefDepth = DataTypeArchiveTransformer.getAnonymousTypeDefDepth(oldCompDt);
                if (anonymousTypeDefDepth != oldTypeDefDepth) {
                    return;
                }
                newCompDt = DataTypeUtilities.getBaseDataType(newCompDt);
                oldCompDt = DataTypeUtilities.getBaseDataType(oldCompDt);
            }
            if (DataTypeArchiveTransformer.areSameClassType(newCompDt, oldCompDt) && DataTypeArchiveTransformer.isAnonymousType(oldCompDt)) {
                DataTypeArchiveTransformer.transformDataType(newCompDt, newFileArchive, oldCompDt);
                DataTypeArchiveTransformer.processAnonymous(oldCompDt, newCompDt, oldFileArchive, newFileArchive);
            }
        }
    }

    private static void transformInnerAnonymousDataType(DataType oldDataType, DataType newDataType, FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive) {
        boolean isOldAnonymous = DataTypeArchiveTransformer.isAnonymousType(oldDataType);
        boolean isNewAnonymous = DataTypeArchiveTransformer.isAnonymousType(newDataType);
        if (isOldAnonymous && isNewAnonymous && DataTypeArchiveTransformer.areSameClassType(newDataType, oldDataType)) {
            DataTypeArchiveTransformer.transformDataType(newDataType, newFileArchive, oldDataType);
        }
        DataTypeArchiveTransformer.processAnonymous(oldDataType, newDataType, oldFileArchive, newFileArchive);
    }

    private static DataTypeComponent getAnonymousMatch(Composite oldComposite, Composite newComposite, DataTypeComponent newComponent) {
        String newFieldName = newComponent.getFieldName();
        if (newFieldName != null && !newFieldName.isEmpty()) {
            return DataTypeArchiveTransformer.getNamedComponent(oldComposite, newFieldName);
        }
        if (oldComposite.getNumComponents() == newComposite.getNumComponents()) {
            int ordinal = newComponent.getOrdinal();
            return oldComposite.getComponent(ordinal);
        }
        return null;
    }

    private static int getAnonymousPointerDepth(DataType newComponentDt) {
        int depth = 0;
        DataType currentDt = newComponentDt;
        while (currentDt instanceof Pointer) {
            Pointer pointer = (Pointer)currentDt;
            currentDt = pointer.getDataType();
            ++depth;
        }
        if (DataTypeArchiveTransformer.isAnonymousType(currentDt)) {
            return depth;
        }
        return 0;
    }

    private static int getAnonymousArrayElementCount(DataType newCompDt) {
        int elementCount = 0;
        DataType currentDt = newCompDt;
        while (currentDt instanceof Array) {
            Array array = (Array)currentDt;
            currentDt = array.getDataType();
            if (elementCount == 0) {
                elementCount = 1;
            }
            elementCount *= array.getNumElements();
        }
        if (DataTypeArchiveTransformer.isAnonymousType(currentDt)) {
            return elementCount;
        }
        return 0;
    }

    private static int getAnonymousTypeDefDepth(DataType newCompDt) {
        int depth = 0;
        DataType currentDt = newCompDt;
        while (currentDt instanceof TypeDef) {
            TypeDef typeDef = (TypeDef)currentDt;
            currentDt = typeDef.getDataType();
            ++depth;
        }
        if (DataTypeArchiveTransformer.isAnonymousType(currentDt)) {
            return depth;
        }
        return 0;
    }

    private static DataTypeComponent getNamedComponent(Composite composite, String fieldName) {
        DataTypeComponent[] components;
        for (DataTypeComponent dataTypeComponent : components = composite.getComponents()) {
            if (!fieldName.equals(dataTypeComponent.getFieldName())) continue;
            return dataTypeComponent;
        }
        return null;
    }

    private static DataType transformDataType(DataType newDataType, FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive) {
        DataType matchingDataType = DataTypeArchiveTransformer.getMatchingDataType(newDataType, oldFileArchive, newFileArchive);
        DataTypeArchiveTransformer.transformDataType(newDataType, newFileArchive, matchingDataType);
        return matchingDataType;
    }

    private static void transformDataType(DataType newDataType, FileDataTypeManager newFileArchive, DataType matchingDataType) {
        if (matchingDataType != null && newDataType.getClass() == matchingDataType.getClass()) {
            SourceArchive oldSourceArchive = matchingDataType.getSourceArchive();
            UniversalID oldUniversalID = matchingDataType.getUniversalID();
            SourceArchive newSourceArchive = newDataType.getSourceArchive();
            UniversalID newUniversalID = newDataType.getUniversalID();
            boolean isNewSourceArchiveLocal = DataTypeArchiveTransformer.isLocalSourceArchive(newDataType);
            if (oldSourceArchive != null) {
                boolean isOldSourceArchiveLocal = DataTypeArchiveTransformer.isLocalSourceArchive(matchingDataType);
                UniversalID oldSourceArchiveID = oldSourceArchive.getSourceArchiveID();
                UniversalID newSourceArchiveID = newSourceArchive.getSourceArchiveID();
                if (isOldSourceArchiveLocal) {
                    if (!isNewSourceArchiveLocal) {
                        SourceArchive localSourceArchive = DataTypeArchiveTransformer.getLocalSourceArchive(newDataType);
                        if (DataTypeArchiveTransformer.dataTypeIDExists(newFileArchive, newDataType, localSourceArchive, oldUniversalID)) {
                            return;
                        }
                        newDataType.setSourceArchive(localSourceArchive);
                    }
                } else if (DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID.equals((Object)oldSourceArchiveID)) {
                    if (!DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID.equals((Object)newSourceArchiveID)) {
                        Msg.warn(DataTypeArchiveTransformer.class, (Object)("DataType " + newDataType.getName() + " has source of " + newSourceArchive.getName() + " when old data type was BUILT-IN."));
                    }
                } else if (!DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID.equals((Object)newSourceArchiveID)) {
                    if (newUniversalID == null) {
                        Msg.error(DataTypeArchiveTransformer.class, (Object)("Error: " + newDataType.getPathName() + " doesn't have a Universal ID."));
                    } else if (!newUniversalID.equals((Object)oldUniversalID) || !isNewSourceArchiveLocal) {
                        SourceArchive resolvedSourceArchive = newFileArchive.resolveSourceArchive(oldSourceArchive);
                        if (DataTypeArchiveTransformer.dataTypeIDExists(newFileArchive, newDataType, resolvedSourceArchive, oldUniversalID)) {
                            return;
                        }
                        newDataType.setSourceArchive(oldSourceArchive);
                    }
                }
            }
            if (!(newDataType instanceof BuiltIn) && oldUniversalID != null && !oldUniversalID.equals((Object)newUniversalID)) {
                ((DataTypeDB)newDataType).setUniversalID(oldUniversalID);
            }
        }
    }

    private static boolean dataTypeIDExists(FileDataTypeManager newFileArchive, DataType newDataType, SourceArchive newSourceArchive, UniversalID oldUniversalID) {
        if (oldUniversalID != null) {
            return false;
        }
        DataType existingDataType = newFileArchive.getDataType(newSourceArchive, oldUniversalID);
        if (existingDataType != null) {
            Msg.warn(DataTypeArchiveTransformer.class, (Object)("Can't transform dataType \"" + newDataType.getPathName() + "\"\nsince dataType \"" + existingDataType.getPathName() + "\" already exists\nwith old ID of " + oldUniversalID + "."));
            return true;
        }
        return false;
    }

    private static DataType getMatchingDataType(DataType newDataType, FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive) {
        DataType oldArchiveDataType;
        DataType oldDataType = oldFileArchive.getDataType(newDataType.getCategoryPath(), newDataType.getName());
        if (oldDataType != null) {
            return oldDataType;
        }
        ArrayList<DataType> oldDataTypeList = new ArrayList<DataType>();
        oldFileArchive.findDataTypes(newDataType.getName(), oldDataTypeList);
        if (oldDataTypeList.isEmpty()) {
            return null;
        }
        ArrayList<DataType> newDataTypeList = new ArrayList<DataType>();
        newFileArchive.findDataTypes(newDataType.getName(), newDataTypeList);
        if (oldDataTypeList.size() == 1 && newDataTypeList.size() == 1 && DataTypeArchiveTransformer.areSameClassType(newDataType, oldArchiveDataType = oldDataTypeList.get(0))) {
            return oldArchiveDataType;
        }
        String newPath = newDataType.getCategoryPath().getPath().toLowerCase();
        DataType ignoreCaseDataType = null;
        for (DataType oldArchiveDataType2 : oldDataTypeList) {
            String oldPath = oldArchiveDataType2.getCategoryPath().getPath().toLowerCase();
            if (!oldPath.equals(newPath)) continue;
            if (ignoreCaseDataType == null) {
                ignoreCaseDataType = oldArchiveDataType2;
                continue;
            }
            return null;
        }
        if (ignoreCaseDataType != null) {
            int countNewWithoutCase = 0;
            for (DataType newArchiveDataType : newDataTypeList) {
                String otherNewPath = newArchiveDataType.getCategoryPath().getPath().toLowerCase();
                if (!otherNewPath.equals(newPath)) continue;
                ++countNewWithoutCase;
            }
            if (countNewWithoutCase == 1 && DataTypeArchiveTransformer.areSameClassType(newDataType, ignoreCaseDataType)) {
                return ignoreCaseDataType;
            }
        }
        return null;
    }

    private static boolean areSameClassType(DataType dataType1, DataType dataType2) {
        if (dataType1 == null || dataType2 == null) {
            return false;
        }
        return dataType1.getClass() == dataType2.getClass();
    }

    private static boolean isAnonymousType(DataType newDataType) {
        String name = newDataType.getName();
        if (newDataType instanceof Structure && DataTypeArchiveTransformer.hasAnonymousName(name, "_struct_")) {
            return true;
        }
        if (newDataType instanceof Union && name.startsWith("_union_")) {
            return true;
        }
        return newDataType instanceof Enum && name.startsWith("enum_");
    }

    private static boolean hasAnonymousName(String name, String prefix) {
        if (!name.startsWith(prefix)) {
            return false;
        }
        String suffix = name.substring(prefix.length());
        return StringUtils.isNumeric((CharSequence)suffix);
    }

    private static SourceArchive getLocalSourceArchive(DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        return dataTypeManager.getLocalSourceArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixEachDataTypeTimestamp(FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive, TaskMonitor monitor) throws CancelledException {
        boolean commit = false;
        int transactionID = newFileArchive.startTransaction("Fixing Data Type Archive Timestamps");
        try {
            Iterator<DataType> allDataTypes = newFileArchive.getAllDataTypes();
            while (allDataTypes.hasNext()) {
                monitor.checkCanceled();
                DataType newDataType = allDataTypes.next();
                DataTypeArchiveTransformer.fixDataTypeTimestamp(newDataType, oldFileArchive, newFileArchive);
                monitor.setMessage("Fixing timestamp for " + newDataType.getPathName());
            }
            commit = true;
        }
        finally {
            newFileArchive.endTransaction(transactionID, commit);
        }
    }

    private static void fixDataTypeTimestamp(DataType newDataType, FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive) {
        DataType oldDataType;
        UniversalID universalID = newDataType.getUniversalID();
        SourceArchive sourceArchive = newDataType.getSourceArchive();
        if (sourceArchive == newFileArchive.getLocalSourceArchive()) {
            sourceArchive = oldFileArchive.getLocalSourceArchive();
        }
        if ((oldDataType = universalID != null ? oldFileArchive.getDataType(sourceArchive, universalID) : oldFileArchive.getDataType(newDataType.getCategoryPath(), newDataType.getName())) != null && oldDataType.equals(newDataType)) {
            long oldLastChangeTime = oldDataType.getLastChangeTime();
            newDataType.setLastChangeTime(oldLastChangeTime);
        }
    }

    private static boolean isLocalSourceArchive(DataType sameNamedDataType) {
        UniversalID universalID;
        DataTypeManager dataTypeManager = sameNamedDataType.getDataTypeManager();
        SourceArchive sourceArchive = sameNamedDataType.getSourceArchive();
        UniversalID sourceArchiveID = sourceArchive.getSourceArchiveID();
        return sourceArchiveID == (universalID = dataTypeManager.getUniversalID());
    }

    private static void saveNewArchive(FileDataTypeManager oldFileArchive, FileDataTypeManager newFileArchive, File destinationFile) throws DuplicateFileException, IOException {
        UniversalID oldUniversalID = oldFileArchive.getUniversalID();
        newFileArchive.saveAs(destinationFile, oldUniversalID);
        Msg.info(DataTypeArchiveTransformer.class, (Object)("Resulting file ID = " + newFileArchive.dbHandle.getDatabaseId()));
    }

    private static void saveNewArchive(FileDataTypeManager newFileArchive, File destinationFile) throws DuplicateFileException, IOException {
        newFileArchive.saveAs(destinationFile);
        FileDataTypeManager destinationFileArchive = FileDataTypeManager.openFileArchive(destinationFile, false);
        if (destinationFileArchive != null) {
            UniversalID destinationUniversalID = destinationFileArchive.getUniversalID();
            destinationFileArchive.close();
            Msg.info(DataTypeArchiveTransformer.class, (Object)("Resulting file ID = " + destinationUniversalID.getValue()));
        }
    }

    public void launch(GhidraApplicationLayout layout, String[] args) {
        DockingApplicationConfiguration appConfig = new DockingApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)appConfig);
        this.performClassSearching(appConfig.getTaskMonitor());
        DataTypeArchiveTransformer.fixupGUI();
        UniversalIdGenerator.initialize();
        JFrame frame = new JFrame("Transform Data Type Archive");
        frame.setLayout(new GridBagLayout());
        DataTypeArchiveTransformerPanel filePanel = new DataTypeArchiveTransformerPanel();
        JPanel statusPanel = new JPanel(new BorderLayout());
        JButton transformButton = new JButton("Transform");
        JButton exitButton = new JButton("Exit");
        RunManager runManager = new RunManager();
        JComponent monitorComponent = runManager.getMonitorComponent();
        runManager.showCancelButton(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        filePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        frame.add((Component)filePanel, gbc);
        Dimension monitorSize = monitorComponent.getPreferredSize();
        monitorSize.width = filePanel.getPreferredSize().width;
        monitorComponent.setPreferredSize(monitorSize);
        monitorComponent.setVisible(true);
        statusPanel.add((Component)monitorComponent, "East");
        GDLabel statusLabel = new GDLabel("    ");
        statusPanel.add((Component)statusLabel, "Center");
        Dimension preferredSize = statusLabel.getPreferredSize();
        preferredSize.height = monitorComponent.getPreferredSize().height;
        statusLabel.setPreferredSize(preferredSize);
        statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        statusLabel.setHorizontalAlignment(0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        frame.add((Component)statusPanel, gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        transformButton.addActionListener(arg_0 -> DataTypeArchiveTransformer.lambda$launch$1(transformButton, exitButton, (JLabel)statusLabel, filePanel, runManager, arg_0));
        frame.add((Component)transformButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        exitButton.addActionListener(e -> {
            frame.setVisible(false);
            System.exit(0);
        });
        frame.add((Component)exitButton, gbc);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                System.exit(0);
            }
        });
        frame.pack();
        monitorComponent.setVisible(false);
        frame.setVisible(true);
    }

    private void performClassSearching(TaskMonitor monitor) {
        try {
            ClassSearcher.search((boolean)false, (TaskMonitor)monitor);
        }
        catch (CancelledException e) {
            Msg.debug((Object)this, (Object)"Class searching unexpectedly cancelled.");
        }
    }

    public static void fixupGUI() {
        SystemUtilities.runSwingNow(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e1) {
                Msg.debug(DataTypeArchiveTransformer.class, (Object)"Unable to install the system Look and Feel");
            }
        });
        Font f = new Font("Monospaced", 0, 12);
        UIManager.put("PasswordField.font", f);
        UIManager.put("TextArea.font", f);
    }

    private static /* synthetic */ void lambda$launch$1(JButton transformButton, JButton exitButton, JLabel statusLabel, DataTypeArchiveTransformerPanel filePanel, RunManager runManager, ActionEvent e) {
        MonitoredRunnable r = monitor -> {
            try {
                transformButton.setEnabled(false);
                exitButton.setEnabled(false);
                String inProgressMessage = "";
                statusLabel.setText(inProgressMessage);
                statusLabel.setToolTipText(inProgressMessage);
                filePanel.transform(monitor);
                File destinationFile = filePanel.getDestinationFile();
                statusLabel.setForeground(Color.blue);
                String message = "Transformation successfully created " + destinationFile.getAbsolutePath() + ".";
                statusLabel.setText(message);
                statusLabel.setToolTipText(message);
            }
            catch (CancelledException cancelExc) {
                String cancelMessage = "User canceled transformation.";
                statusLabel.setText(cancelMessage);
                statusLabel.setToolTipText(cancelMessage);
            }
            catch (Exception exc) {
                statusLabel.setForeground(Color.red);
                statusLabel.setText(exc.getMessage());
                statusLabel.setToolTipText(exc.getMessage());
                exc.printStackTrace();
            }
            finally {
                transformButton.setEnabled(true);
                exitButton.setEnabled(true);
            }
        };
        runManager.runNow(r, "", 250);
    }
}

