/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.framework.model.DomainFile;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProjectArchiveBasedDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ProjectDataTypeManager
extends DataTypeManagerDB
implements ProjectArchiveBasedDataTypeManager {
    private DataTypeArchiveDB dataTypeArchive;

    public ProjectDataTypeManager(DBHandle handle, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, null, openMode, errHandler, lock, monitor);
    }

    public void setDataTypeArchive(DataTypeArchiveDB dtArchive) {
        this.dataTypeArchive = dtArchive;
    }

    @Override
    public String getName() {
        return this.dataTypeArchive.getDomainFile().getName();
    }

    @Override
    public Pointer getPointer(DataType dt) {
        return PointerDataType.getPointer(dt, this.dataTypeArchive.getDefaultPointerSize());
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.dataTypeArchive.setName(name);
        this.categoryRenamed(CategoryPath.ROOT, null);
    }

    @Override
    public void dataTypeChanged(DataType dt) {
        super.dataTypeChanged(dt);
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 108, null, dt);
    }

    @Override
    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        super.dataTypeAdded(newDt, originalDataType);
        this.dataTypeArchive.dataTypeAdded(this.getID(newDt), 104, null, newDt);
    }

    @Override
    protected void dataTypeReplaced(long existingDtID, DataTypePath existingPath, DataType replacementDt) {
        super.dataTypeReplaced(existingDtID, existingPath, replacementDt);
        this.dataTypeArchive.dataTypeChanged(existingDtID, 110, existingPath, replacementDt);
    }

    @Override
    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        super.dataTypeDeleted(deletedID, deletedDataTypePath);
        this.dataTypeArchive.dataTypeChanged(deletedID, 105, deletedDataTypePath, null);
    }

    @Override
    protected void dataTypeMoved(DataType dt, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(dt, oldPath, newPath);
        Category category = this.getCategory(oldPath.getCategoryPath());
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 107, category, dt);
    }

    @Override
    protected void dataTypeNameChanged(DataType dt, String oldName) {
        super.dataTypeNameChanged(dt, oldName);
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 106, oldName, dt);
    }

    @Override
    protected void categoryCreated(Category newCategory) {
        super.categoryCreated(newCategory);
        this.dataTypeArchive.categoryAdded(newCategory.getID(), 100, newCategory.getParent(), newCategory);
    }

    @Override
    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.dataTypeArchive.categoryChanged(category.getID(), 102, oldPath.getName(), category);
    }

    @Override
    protected void categoryRemoved(Category parent, String name, long categoryID) {
        super.categoryRemoved(parent, name, categoryID);
        this.dataTypeArchive.categoryChanged(categoryID, 101, parent, name);
    }

    @Override
    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.dataTypeArchive.categoryChanged(category.getID(), 103, oldPath.getParent(), category);
    }

    @Override
    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        super.favoritesChanged(dataType, isFavorite);
    }

    @Override
    protected void replaceDataTypeIDs(long oldDataTypeID, long newDataTypeID) {
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) throws CancelledException {
        long[] ids = new long[deletedIds.size()];
        Iterator it = deletedIds.iterator();
        int i = 0;
        while (it.hasNext()) {
            ids[i++] = (Long)it.next();
        }
    }

    @Override
    public int startTransaction(String description) {
        return this.dataTypeArchive.startTransaction(description);
    }

    @Override
    public void flushEvents() {
        this.dataTypeArchive.flushEvents();
    }

    @Override
    public void endTransaction(int transactionID, boolean commit) {
        this.dataTypeArchive.endTransaction(transactionID, commit);
    }

    @Override
    public void close() {
    }

    @Override
    public DomainFile getDomainFile() {
        return this.dataTypeArchive.getDomainFile();
    }

    @Override
    public String getDomainFileID() {
        DomainFile domainFile = this.getDomainFile();
        return domainFile != null ? domainFile.getFileID() : null;
    }

    @Override
    public String getPath() {
        DomainFile domainFile = this.getDomainFile();
        return domainFile != null ? domainFile.getPathname() : null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.PROJECT;
    }

    public void archiveReady(int openMode, TaskMonitor monitor) throws CancelledException {
        if (openMode == 3) {
            this.doSourceArchiveUpdates(null, monitor);
        }
    }
}

