/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBListener;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.function.FunctionTagAdapter;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionTagAdapterV0
extends FunctionTagAdapter
implements DBListener {
    static final int SCHEMA_VERSION = 0;
    static final int V0_TAG_NAME_COL = 0;
    static final int V0_COMMENT_COL = 1;
    static final Schema V0_SCHEMA = new Schema(0, "ID", new Class[]{StringField.class, StringField.class}, new String[]{"Tag", "Comment"});
    private Table table;
    private final DBHandle dbHandle;

    FunctionTagAdapterV0(DBHandle dbHandle, boolean create) throws VersionException {
        this.dbHandle = dbHandle;
        dbHandle.addListener((DBListener)this);
        if (!create) {
            this.table = dbHandle.getTable("Function Tags");
            if (this.table == null) {
                return;
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    Record getRecord(String tag) throws IOException {
        if (this.table == null) {
            return null;
        }
        for (Record rec : this.table) {
            if (!rec.getString(0).equals(tag)) continue;
            return rec;
        }
        return null;
    }

    @Override
    Record createTagRecord(String tag, String comment) throws IOException {
        Record rec = this.getRecord(tag);
        if (rec == null) {
            rec = V0_SCHEMA.createRecord(this.getTable().getKey());
            rec.setString(0, tag);
            rec.setString(1, comment);
            this.updateRecord(rec);
        }
        return rec;
    }

    @Override
    void removeTagRecord(long id) throws IOException {
        if (this.table != null) {
            this.table.deleteRecord(id);
        }
    }

    @Override
    RecordIterator getRecords() throws IOException {
        if (this.table == null) {
            return new EmptyRecordIterator();
        }
        return this.table.iterator();
    }

    @Override
    int getNumTags() {
        if (this.table == null) {
            return 0;
        }
        return this.table.getRecordCount();
    }

    @Override
    Record getRecord(long id) throws IOException {
        if (this.table == null) {
            return null;
        }
        return this.table.getRecord(id);
    }

    @Override
    void updateRecord(Record record) throws IOException {
        this.getTable().putRecord(record);
    }

    private Table getTable() throws IOException {
        if (this.table == null) {
            this.table = this.dbHandle.createTable("Function Tags", V0_SCHEMA);
        }
        return this.table;
    }

    public void dbRestored(DBHandle dbh) {
        this.table = dbh.getTable("Function Tags");
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table table) {
    }

    public void tableAdded(DBHandle dbh, Table table) {
    }
}

