/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.Record;
import db.RecordIterator;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.util.Query;
import ghidra.program.database.util.QueryRecordIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import java.io.IOException;
import java.util.Iterator;

class AddressSetFilteredSymbolIterator
implements SymbolIterator {
    private SymbolManager symbolMgr;
    private AddressRangeIterator rangeIter;
    private QueryRecordIterator recIter;
    private Symbol currentSymbol;
    private SymbolDatabaseAdapter adapter;
    private boolean forward;
    private Query query;

    AddressSetFilteredSymbolIterator(SymbolManager symbolMgr, AddressSetView set, Query query, boolean forward) {
        this.symbolMgr = symbolMgr;
        this.rangeIter = set.getAddressRanges(forward);
        this.adapter = symbolMgr.getDatabaseAdapter();
        this.forward = forward;
        this.query = query;
    }

    @Override
    public boolean hasNext() {
        if (this.currentSymbol == null) {
            try {
                this.findNext();
            }
            catch (IOException e) {
                this.symbolMgr.dbError(e);
            }
        }
        return this.currentSymbol != null;
    }

    @Override
    public Symbol next() {
        if (this.hasNext()) {
            Symbol s = this.currentSymbol;
            this.currentSymbol = null;
            return s;
        }
        return null;
    }

    private void findNext() throws IOException {
        if (this.recIter != null && this.recIter.hasNext()) {
            Record rec = this.recIter.next();
            this.currentSymbol = this.symbolMgr.getSymbol(rec);
        } else {
            while (this.rangeIter.hasNext()) {
                AddressRange range = (AddressRange)this.rangeIter.next();
                RecordIterator it = this.adapter.getSymbols(range.getMinAddress(), range.getMaxAddress(), this.forward);
                this.recIter = new QueryRecordIterator(it, this.query, this.forward);
                if (!this.recIter.hasNext()) continue;
                Record rec = this.recIter.next();
                this.currentSymbol = this.symbolMgr.getSymbol(rec);
                break;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this;
    }
}

