/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.Field;
import db.Record;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.symbol.EquateDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class EquateDBAdapterV0
extends EquateDBAdapter {
    private Table equateTable;

    EquateDBAdapterV0(DBHandle handle, boolean create) throws IOException, VersionException {
        if (create) {
            this.equateTable = handle.createTable("Equates", EQUATES_SCHEMA, new int[]{0});
        } else {
            this.equateTable = handle.getTable("Equates");
            if (this.equateTable == null) {
                throw new VersionException("Missing Table: Equates");
            }
            if (this.equateTable.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    void updateRecord(Record record) throws IOException {
        this.equateTable.putRecord(record);
    }

    @Override
    void removeRecord(long key) throws IOException {
        this.equateTable.deleteRecord(key);
    }

    @Override
    long getRecordKey(String name) throws IOException, NotFoundException {
        long[] keys = this.equateTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            throw new NotFoundException("Equate named " + name + " was not found");
        }
        if (keys.length > 1) {
            throw new AssertException("Expected one record for " + name + " but found " + keys.length);
        }
        return keys[0];
    }

    @Override
    boolean hasRecord(String name) throws IOException {
        long[] keys = this.equateTable.findRecords((Field)new StringField(name), 0);
        return keys.length > 0;
    }

    @Override
    Record createEquate(String name, long value) throws IOException {
        Record rec = this.equateTable.getSchema().createRecord(this.equateTable.getKey());
        rec.setString(0, name);
        rec.setLongValue(1, value);
        this.equateTable.putRecord(rec);
        return rec;
    }

    @Override
    Record getRecord(long key) throws IOException {
        return this.equateTable.getRecord(key);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.equateTable.iterator();
    }
}

