/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AlignedComponentPacker;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.InternalDataTypeComponent;
import ghidra.program.model.data.Structure;
import java.util.Iterator;
import java.util.List;

public class AlignedStructurePacker {
    private final Structure structure;
    private final List<? extends InternalDataTypeComponent> components;
    private final DataOrganization dataOrganization;

    protected AlignedStructurePacker(Structure structure, List<? extends InternalDataTypeComponent> components) {
        this.structure = structure;
        this.components = components;
        this.dataOrganization = structure.getDataOrganization();
    }

    protected StructurePackResult pack() {
        int n;
        int padSize;
        int alignment;
        int n2;
        boolean componentsChanged = false;
        int componentCount = 0;
        AlignedComponentPacker packer = new AlignedComponentPacker(this.structure.getPackingValue(), this.dataOrganization);
        Iterator<? extends InternalDataTypeComponent> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            InternalDataTypeComponent dataTypeComponent = componentIterator.next();
            DataType componentDt = dataTypeComponent.getDataType();
            if (DataType.DEFAULT == componentDt) {
                componentIterator.remove();
                componentsChanged = true;
            }
            ++componentCount;
        }
        int index = 0;
        for (InternalDataTypeComponent internalDataTypeComponent : this.components) {
            boolean isLastComponent = ++index == componentCount;
            packer.addComponent(internalDataTypeComponent, isLastComponent);
        }
        int externalAlignment = packer.getExternalAlignment();
        int n3 = packer.getLength();
        componentsChanged |= packer.componentsChanged();
        DataTypeComponent flexibleArrayComponent = this.structure.getFlexibleArrayComponent();
        if (flexibleArrayComponent != null) {
            int componentAlignment = CompositeAlignmentHelper.getPackedAlignment(this.dataOrganization, this.structure.getPackingValue(), flexibleArrayComponent);
            n2 = DataOrganizationImpl.getOffset(componentAlignment, n3);
            externalAlignment = DataOrganizationImpl.getLeastCommonMultiple(externalAlignment, componentAlignment);
        }
        if ((alignment = this.structure.getMinimumAlignment()) < externalAlignment) {
            alignment = externalAlignment;
        }
        if (n2 != 0 && (padSize = DataOrganizationImpl.getPaddingSize(alignment, n2)) > 0) {
            n = n2 + padSize;
        }
        return new StructurePackResult(componentCount, n, alignment, componentsChanged);
    }

    public static StructurePackResult packComponents(Structure structure, List<? extends InternalDataTypeComponent> components) {
        AlignedStructurePacker packer = new AlignedStructurePacker(structure, components);
        return packer.pack();
    }

    public static class StructurePackResult {
        public final int numComponents;
        public final int structureLength;
        public final int alignment;
        public final boolean componentsChanged;

        StructurePackResult(int numComponents, int structureLength, int alignment, boolean componentsChanged) {
            this.numComponents = numComponents;
            this.structureLength = structureLength;
            this.alignment = alignment;
            this.componentsChanged = componentsChanged;
        }
    }
}

