/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.UnsignedIntegerDataType;

public class IntegerDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final IntegerDataType dataType = new IntegerDataType();

    public IntegerDataType() {
        this(null);
    }

    public IntegerDataType(DataTypeManager dtm) {
        super("int", true, dtm);
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getIntegerSize();
    }

    @Override
    public String getDescription() {
        return "Signed Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "int";
    }

    @Override
    public UnsignedIntegerDataType getOppositeSignednessDataType() {
        return UnsignedIntegerDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public IntegerDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new IntegerDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return null;
    }
}

