/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

public class ExternalPath {
    private static final String DELIMITER_STRING = "::";
    private String[] strings;

    public ExternalPath(String ... strings) {
        for (String string : strings) {
            if (string != null && string.length() > 0) continue;
            throw new IllegalArgumentException("An external path cannot contain a null or empty string.");
        }
        if (strings.length < 2) {
            throw new IllegalArgumentException("An external path must specify a library name and a label.");
        }
        this.strings = strings;
    }

    public String getLibraryName() {
        return this.strings[0];
    }

    public String getName() {
        return this.strings[this.strings.length - 1];
    }

    public String[] getPathElements() {
        String[] path = new String[this.strings.length];
        System.arraycopy(this.strings, 0, path, 0, this.strings.length);
        return path;
    }

    public String toString() {
        int lastIndex = this.strings.length - 1;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.strings.length; ++i) {
            buffer.append(this.strings[i]);
            if (i >= lastIndex) continue;
            buffer.append(DELIMITER_STRING);
        }
        return buffer.toString();
    }
}

