/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.ANTLRUtil;
import ghidra.sleigh.grammar.LineArrayListWriter;
import java.io.IOException;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.UnwantedTokenException;

public class BaseRecognizerOverride {
    static final String NEWLINE = System.getProperty("line.separator");

    public String getErrorMessage(RecognitionException e, String[] tokenNames, LineArrayListWriter writer) {
        MismatchedSetException mse;
        String tokenName;
        Object msg = e.getMessage();
        if (e instanceof UnwantedTokenException) {
            UnwantedTokenException ute = (UnwantedTokenException)e;
            tokenName = "<unknown>";
            if (ute.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[ute.expecting];
            }
            msg = "extraneous input " + this.getTokenErrorDisplay(ute.getUnexpectedToken()) + " expecting " + tokenName;
        } else if (e instanceof MissingTokenException) {
            MissingTokenException mte = (MissingTokenException)e;
            tokenName = "<unknown>";
            msg = mte.expecting == -1 ? "unexpected token: " + this.getTokenErrorDisplay(e.token) : "missing " + tokenName + " at " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedTokenException) {
            msg = "unexpected token: " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            tokenName = "<unknown>";
            if (mtne.expecting == -1) {
                tokenName = "EOF";
            } else if (tokenNames != null) {
                tokenName = tokenNames[mtne.expecting];
            }
            msg = "mismatched tree node: " + mtne.node + " expecting " + tokenName;
        } else if (e instanceof NoViableAltException) {
            msg = "unexpected token: " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof EarlyExitException) {
            msg = "required (...)+ loop did not match anything at input " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedSetException) {
            mse = (MismatchedSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            mse = (MismatchedNotSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            msg = "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
        String line = "<internal error fetching line>";
        try {
            line = ANTLRUtil.getLine(writer, e.line);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int position = ANTLRUtil.tabCompensate(line, e.charPositionInLine);
        return (String)msg + ":" + NEWLINE + NEWLINE + line + NEWLINE + ANTLRUtil.generateArrow(position);
    }

    public String getTokenErrorDisplay(Token t) {
        Object s = t.getText();
        if (s == null) {
            s = t.getType() == -1 ? "<EOF>" : "<" + t.getType() + ">";
        }
        s = ((String)s).replaceAll("\n", "\\\\n");
        s = ((String)s).replaceAll("\r", "\\\\r");
        s = ((String)s).replaceAll("\t", "\\\\t");
        return "'" + (String)s + "'";
    }
}

