/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.UserAdmin;
import ghidra.server.UserManager;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.security.auth.x500.X500Principal;
import utility.application.ApplicationLayout;

public class ServerAdmin
implements GhidraLaunchable {
    private static final String CONFIG_FILE_PROPERTY = "UserAdmin.config";
    private static final String SERVER_DIR_CONFIG_PROPERTY = "ghidra.repositories.dir";
    private static final String INVOCATION_NAME_PROPERTY = "UserAdmin.invocation";
    private static final String LIST_COMMAND = "-list";
    private static final String USERS_COMMAND = "-users";
    private static final String MIGRATE_COMMAND = "-migrate";
    private static final String MIGRATE_ALL_COMMAND = "-migrate-all";
    private boolean propertyUsed = false;

    public void launch(GhidraApplicationLayout layout, String[] args) {
        if (!Application.isInitialized()) {
            ApplicationConfiguration configuration = new ApplicationConfiguration();
            configuration.setInitializeLogging(false);
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        }
        this.execute(args);
    }

    public void execute(String[] args) {
        File cmdDir;
        File serverDir = null;
        int ix = 0;
        serverDir = args.length != 0 && !args[0].startsWith("-") ? new File(args[ix++]) : this.getServerDirFromConfig();
        if (serverDir == null || args.length - ix == 0) {
            this.displayUsage("");
            System.exit(-1);
            return;
        }
        try {
            serverDir = serverDir.getCanonicalFile();
        }
        catch (IOException e1) {
            System.err.println("Failed to resolve server directory: " + serverDir);
            System.exit(-1);
        }
        if (this.propertyUsed) {
            System.out.println("Using server directory: " + serverDir);
        }
        File userFile = new File(serverDir, "users");
        if (!serverDir.isDirectory() || !userFile.isFile()) {
            System.err.println("Invalid Ghidra server directory!");
            System.exit(-1);
        }
        if (!(cmdDir = new File(serverDir, UserAdmin.ADMIN_CMD_DIR)).isDirectory() || !cmdDir.canWrite()) {
            System.err.println("Insufficient privilege or server not started!");
            System.exit(-1);
        }
        boolean listRepositories = false;
        boolean listUsers = false;
        boolean migrationConfirmed = false;
        boolean migrationAbort = false;
        ArrayList<String> cmdList = new ArrayList<String>();
        int cmdLen = 1;
        while (ix < args.length) {
            boolean queueCmd = true;
            if ("-add".equals(args[ix])) {
                cmdLen = 2;
                this.validateSID(args, ix + 1);
            } else if ("-remove".equals(args[ix])) {
                cmdLen = 2;
                this.validateSID(args, ix + 1);
            } else if ("-reset".equals(args[ix])) {
                cmdLen = 2;
                this.validateSID(args, ix + 1);
            } else if ("-dn".equals(args[ix])) {
                cmdLen = 3;
                this.validateSID(args, ix + 1);
                this.validateDN(args, ix + 2);
            } else if ("-admin".equals(args[ix])) {
                cmdLen = 3;
                this.validateSID(args, ix + 1);
                this.validateRepName(args, ix + 2, serverDir);
            } else if (LIST_COMMAND.equals(args[ix])) {
                cmdLen = 1;
                queueCmd = false;
                listRepositories = true;
            } else if (USERS_COMMAND.equals(args[ix])) {
                cmdLen = 1;
                queueCmd = false;
                listUsers = true;
            } else if (MIGRATE_ALL_COMMAND.equals(args[ix])) {
                cmdLen = 1;
                queueCmd = false;
                if (!migrationConfirmed && !ServerAdmin.confirmMigration()) {
                    migrationAbort = true;
                }
                migrationConfirmed = true;
                if (!migrationAbort) {
                    RepositoryManager.markAllRepositoriesForIndexMigration(serverDir);
                }
            } else if (MIGRATE_COMMAND.equals(args[ix])) {
                cmdLen = 2;
                queueCmd = false;
                if (ix == args.length - 1) {
                    System.err.println("Missing -migrate repository name argument");
                } else {
                    String repositoryName = args[ix + 1];
                    if (!migrationConfirmed && !ServerAdmin.confirmMigration()) {
                        migrationAbort = true;
                    }
                    migrationConfirmed = true;
                    if (!migrationAbort) {
                        Repository.markRepositoryForIndexMigration(serverDir, repositoryName, false);
                    }
                }
            } else {
                this.displayUsage("Invalid usage!");
                System.exit(-1);
            }
            if (queueCmd) {
                ServerAdmin.addCommand(cmdList, args, ix, cmdLen);
            }
            ix += cmdLen;
        }
        try {
            UserAdmin.writeCommands(cmdList, cmdDir);
        }
        catch (IOException e) {
            System.err.println("Failed to queue commands: " + e.toString());
            System.exit(-1);
        }
        System.out.println(cmdList.size() + " command(s) queued.");
        if (listUsers) {
            UserManager.listUsers(serverDir);
        }
        if (listRepositories) {
            RepositoryManager.listRepositories(serverDir, listUsers);
        }
        System.out.println();
    }

    private static void addCommand(ArrayList<String> cmdList, String[] args, int argOffset, int argCnt) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < argCnt; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(args[argOffset + i]);
        }
        cmdList.add(buf.toString());
    }

    private static boolean confirmMigration() {
        System.out.print("\nWARNING!  Please confirm the requested migration of one or more\nGhidra Server repositories.  Once migrated to indexed storage,\nany attempt to use these server repositories with a Ghidra Server\nolder than version 5.5 will corrupt the data storage.\n\nWould you like to continue? [y/n]: ");
        try {
            if (121 == System.in.read()) {
                System.out.println();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\nAll repository data migration(s) has been aborted.");
        return false;
    }

    private void validateDN(String[] args, int i) {
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage!");
            System.exit(-1);
        }
        String dn = args[i];
        try {
            X500Principal x500User = new X500Principal(dn);
            args[i] = "\"" + x500User.getName() + "\"";
        }
        catch (Exception e) {
            Msg.error(UserAdmin.class, (Object)("Invalid DN: " + dn));
            System.exit(-1);
        }
    }

    private void validateSID(String[] args, int i) {
        String sid;
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage!");
            System.exit(-1);
        }
        if (!UserManager.isValidUserName(sid = args[i])) {
            Msg.error(UserAdmin.class, (Object)("Invalid username/sid: " + sid));
            System.exit(-1);
        }
    }

    private void validateRepName(String[] args, int i, File rootDirFile) {
        String repName;
        File f;
        if (args.length < i + 1) {
            this.displayUsage("Invalid usage!");
            System.exit(-1);
        }
        if (!(f = new File(rootDirFile, NamingUtilities.mangle((String)(repName = args[i])))).isDirectory()) {
            Msg.error(UserAdmin.class, (Object)("Repository not found: " + repName));
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getServerDirFromConfig() {
        String p = System.getProperty(CONFIG_FILE_PROPERTY);
        if (p == null) {
            return null;
        }
        this.propertyUsed = true;
        File configFile = new File(p);
        if (!configFile.exists()) {
            System.out.println("Config file not found: " + configFile.getAbsolutePath());
        }
        Properties config = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            config.load(in);
        }
        catch (IOException e) {
            System.out.println("Failed to read " + configFile.getName() + ": " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
        p = config.getProperty(SERVER_DIR_CONFIG_PROPERTY);
        if (p == null) {
            return null;
        }
        File dir = new File(p);
        if (!dir.isAbsolute()) {
            ResourceFile installRoot = Application.getInstallationDirectory();
            if (installRoot == null || installRoot.getFile(false) == null) {
                System.out.println("Failed to resolve installation root directory!");
                return null;
            }
            dir = new File(installRoot.getFile(false), p);
        }
        return dir;
    }

    private void displayUsage(String msg) {
        String invocationName;
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("Usage: " + (String)((invocationName = System.getProperty(INVOCATION_NAME_PROPERTY)) != null ? invocationName : "java " + UserAdmin.class.getName()) + (this.propertyUsed ? "" : " <serverPath>") + " [<command>] [<command>] ...");
        System.err.println("\nSupported commands:");
        System.err.println("  -add <sid>");
        System.err.println("      Add a new user to the server identified by their sid identifier");
        System.err.println("  -remove <sid>");
        System.err.println("      Remove the specified user from the server's user list");
        System.err.println("  -reset <sid>");
        System.err.println("      Reset the specified user's server login password");
        System.err.println("  -dn <sid> \"<dname>\"");
        System.err.println("      When PKI authentication is used, add the specified X500 Distinguished Name for a user");
        System.err.println("  -admin <sid> \"<repository-name>\"");
        System.err.println("      Grant ADMIN privilege to the specified user with the specified repository");
        System.err.println("  -list [-users]");
        System.err.println("      Output list of repositories to the console (user access list will be included with -users)");
        System.err.println("  -users");
        System.err.println("      Output list of users to console which have server access");
        System.err.println("  -migrate \"<repository-name>\"");
        System.err.println("      Migrate the specified repository to the latest file system storage schema (see svrREADME.html)");
        System.err.println("  -migrate-all");
        System.err.println("      Migrate the all repositories to the latest file system storage schema (see svrREADME.html)");
        System.err.println();
    }
}

