/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.FieldAnnotation;
import ghidra.file.formats.android.dex.format.MethodAnnotation;
import ghidra.file.formats.android.dex.format.ParameterAnnotation;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationsDirectoryItem
implements StructConverter {
    private int classAnnotationsOffset;
    private int fieldsSize;
    private int annotatedMethodsSize;
    private int annotatedParametersSize;
    private List<FieldAnnotation> fieldAnnotations = new ArrayList<FieldAnnotation>();
    private List<MethodAnnotation> methodAnnotations = new ArrayList<MethodAnnotation>();
    private List<ParameterAnnotation> parameterAnnotations = new ArrayList<ParameterAnnotation>();
    private AnnotationSetItem _classAnnotations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationsDirectoryItem(BinaryReader reader) throws IOException {
        int i;
        this.classAnnotationsOffset = reader.readNextInt();
        this.fieldsSize = reader.readNextInt();
        this.annotatedMethodsSize = reader.readNextInt();
        this.annotatedParametersSize = reader.readNextInt();
        for (i = 0; i < this.fieldsSize; ++i) {
            this.fieldAnnotations.add(new FieldAnnotation(reader));
        }
        for (i = 0; i < this.annotatedMethodsSize; ++i) {
            this.methodAnnotations.add(new MethodAnnotation(reader));
        }
        for (i = 0; i < this.annotatedParametersSize; ++i) {
            this.parameterAnnotations.add(new ParameterAnnotation(reader));
        }
        if (this.classAnnotationsOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.classAnnotationsOffset);
                this._classAnnotations = new AnnotationSetItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getClassAnnotationsOffset() {
        return this.classAnnotationsOffset;
    }

    public int getFieldsSize() {
        return this.fieldsSize;
    }

    public int getAnnotatedMethodsSize() {
        return this.annotatedMethodsSize;
    }

    public int getAnnotatedParametersSize() {
        return this.annotatedParametersSize;
    }

    public List<FieldAnnotation> getFieldAnnotations() {
        return Collections.unmodifiableList(this.fieldAnnotations);
    }

    public List<MethodAnnotation> getMethodAnnotations() {
        return Collections.unmodifiableList(this.methodAnnotations);
    }

    public List<ParameterAnnotation> getParameterAnnotations() {
        return Collections.unmodifiableList(this.parameterAnnotations);
    }

    public AnnotationSetItem getClassAnnotations() {
        return this._classAnnotations;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("annotations_directory_item_" + this.fieldsSize + "_" + this.annotatedMethodsSize + "_" + this.annotatedParametersSize, 0);
        structure.add(DWORD, "class_annotations_off", null);
        structure.add(DWORD, "fields_size", null);
        structure.add(DWORD, "annotated_methods_size", null);
        structure.add(DWORD, "annotated_parameters_size", null);
        int index = 0;
        for (FieldAnnotation field : this.fieldAnnotations) {
            structure.add(field.toDataType(), "field_" + index, null);
            ++index;
        }
        index = 0;
        for (MethodAnnotation method : this.methodAnnotations) {
            structure.add(method.toDataType(), "method_" + index, null);
            ++index;
        }
        index = 0;
        for (ParameterAnnotation parameter : this.parameterAnnotations) {
            structure.add(parameter.toDataType(), "parameter_" + index, null);
            ++index;
        }
        structure.setCategoryPath(new CategoryPath("/dex/annotations_directory_item"));
        return structure;
    }
}

