/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatable.ProjectDataActionContext;
import ghidra.framework.main.datatable.ProjectDataContextAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.util.List;
import javax.swing.Icon;

public class ProjectDataOpenToolAction
extends ProjectDataContextAction {
    private String toolName;

    public ProjectDataOpenToolAction(String owner, String group, String toolName, Icon icon) {
        super("Open" + toolName, owner);
        this.toolName = toolName;
        String[] menuPath = new String[]{"Open With", HTMLUtilities.escapeHTML((String)toolName)};
        this.setPopupMenuData(new MenuData(menuPath, icon, "Open"));
        this.setHelpLocation(new HelpLocation(owner, "Open_File_With"));
    }

    @Override
    protected void actionPerformed(ProjectDataActionContext context) {
        List<DomainFile> selectedFiles = context.getSelectedFiles();
        this.openInTool(selectedFiles);
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataActionContext context) {
        return context.getSelectedFiles().size() > 0 && context.getSelectedFolders().size() == 0;
    }

    private void openInTool(List<DomainFile> fileList) {
        Project project = AppInfo.getActiveProject();
        ToolChest toolChest = project.getLocalToolChest();
        ToolManager toolManager = project.getToolManager();
        Workspace activeWorkspace = toolManager.getActiveWorkspace();
        ToolTemplate template = toolChest.getToolTemplate(this.toolName);
        Tool newTool = activeWorkspace.runTool(template);
        DomainFile[] files = fileList.toArray(new DomainFile[fileList.size()]);
        newTool.acceptDomainFiles(files);
    }
}

