/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import ghidra.graph.graphs.FilteringVisualGraph;
import ghidra.graph.job.AbstractGraphVisibilityTransitionJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import util.CollectionUtils;

public class FilterVerticesJob<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphVisibilityTransitionJob<V, E> {
    private static final double MIN_ALPHA = 0.2;
    private boolean removeVertices;
    private FilteringVisualGraph<V, E> filterGraph;
    private Set<V> passedVertices;
    private Set<V> failedVertices;
    private Set<E> failedEdges;
    private Set<E> passedEdges;
    private Predicate<V> filter;

    public FilterVerticesJob(GraphViewer<V, E> viewer, FilteringVisualGraph<V, E> graph, Predicate<V> filter, boolean remove) {
        super(viewer, true);
        this.filter = filter;
        this.removeVertices = remove;
        this.filterGraph = graph;
    }

    @Override
    void start() {
        this.initialize();
        super.start();
    }

    private void initialize() {
        Iterator<V> vertices = this.filterGraph.getAllVertices();
        Set matching = CollectionUtils.asStream(vertices).filter(this.filter).collect(Collectors.toSet());
        Set<V> related = this.filterGraph.getAllReachableVertices(matching);
        matching.addAll(related);
        this.passedVertices = matching;
        this.failedVertices = this.findCurrentVerticesFailingTheFitler(matching);
        this.failedEdges = this.filterGraph.getAllEdges(this.failedVertices);
        Set<E> allRelatedEdges = this.filterGraph.getAllEdges(this.passedVertices);
        allRelatedEdges.removeAll(this.failedEdges);
        this.passedEdges = allRelatedEdges;
        this.filterGraph.unfilterVertices(this.passedVertices);
    }

    private Set<V> findCurrentVerticesFailingTheFitler(Set<V> validVertices) {
        UnmodifiableIterator nonMatchingIterator = Iterators.filter(this.filterGraph.getUnfilteredVertices(), v -> !validVertices.contains(v));
        Set nonMatching = CollectionUtils.asSet((Iterator)nonMatchingIterator);
        return nonMatching;
    }

    @Override
    protected void updateOpacity(double percentComplete) {
        double percentRemaining = 1.0 - percentComplete;
        double fadeOutAlpha = Math.max(percentRemaining, this.getMinimumAlpha());
        this.failedVertices.forEach(v -> this.fadeOutAlpha((E)v, fadeOutAlpha));
        this.failedEdges.forEach(e -> this.fadeOutAlpha((E)e, fadeOutAlpha));
        double fadeInAlpha = percentComplete;
        this.passedVertices.forEach(v -> this.fadeInAlpha((E)v, fadeInAlpha));
        this.passedEdges.forEach(e -> this.fadeInAlpha((E)e, fadeInAlpha));
    }

    private double getMinimumAlpha() {
        return this.removeVertices ? 0.0 : 0.2;
    }

    private void fadeOutAlpha(V v, double fadeOutAlpha) {
        double alpha = v.getAlpha();
        double newAlpha = Math.min(alpha, fadeOutAlpha);
        v.setAlpha(newAlpha);
    }

    private void fadeOutAlpha(E e, double fadeOutAlpha) {
        double alpha = e.getAlpha();
        double newAlpha = Math.min(alpha, fadeOutAlpha);
        e.setAlpha(newAlpha);
    }

    private void fadeInAlpha(V v, double fadeInAlpha) {
        double alpha = v.getAlpha();
        double newAlpha = Math.max(alpha, fadeInAlpha);
        v.setAlpha(newAlpha);
    }

    private void fadeInAlpha(E e, double fadeInAlpha) {
        double alpha = e.getAlpha();
        double newAlpha = Math.max(alpha, fadeInAlpha);
        e.setAlpha(newAlpha);
    }

    @Override
    protected void finished() {
        if (this.passedVertices == null) {
            this.initialize();
        }
        super.finished();
        if (this.removeVertices) {
            this.filterGraph.filterVertices(this.failedVertices);
        }
    }
}

