/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.listing.ConflictInfoPanel;
import ghidra.app.merge.listing.ListingMergeConstants;
import ghidra.app.merge.listing.RegisterMergeManager;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.Comparator;

public class ProgramContextMergeManager
implements MergeResolver,
ListingMergeConstants {
    private static String[] PROGRAM_CONTEXT_PHASE = new String[]{"Program Context"};
    private ProgramMultiUserMergeManager mergeManager;
    private ListingMergePanel mergePanel;
    private ConflictInfoPanel conflictInfoPanel;
    RegisterMergeManager rmm;
    Program resultPgm;
    Program originalPgm;
    Program latestPgm;
    Program myPgm;
    ProgramChangeSet latestChanges;
    ProgramChangeSet myChanges;
    AddressSetView latestSet;
    AddressSetView mySet;
    TaskMonitor currentStatusMonitor;
    ProgramContext originalContext;
    ProgramContext latestContext;
    ProgramContext myContext;
    ProgramContext resultContext;
    Register[] registers;
    ProgramDiff diffOriginalLatest;
    ProgramDiff diffOriginalMy;
    ProgramDiffFilter diffFilter;
    ProgramMergeFilter mergeFilter;

    public ProgramContextMergeManager(ProgramMultiUserMergeManager mergeManager, Program resultPgm, Program originalPgm, Program latestPgm, Program myPgm, ProgramChangeSet latestChanges, ProgramChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.resultPgm = resultPgm;
        this.originalPgm = originalPgm;
        this.latestPgm = latestPgm;
        this.myPgm = myPgm;
        this.latestChanges = latestChanges;
        this.myChanges = myChanges;
    }

    @Override
    public void apply() {
        if (this.rmm != null) {
            this.rmm.apply();
        }
    }

    @Override
    public void cancel() {
        if (this.rmm != null) {
            this.rmm.cancel();
        }
    }

    @Override
    public String getDescription() {
        return "Merge Program Context Registers";
    }

    @Override
    public String getName() {
        return "Program Context Registers Merger";
    }

    private void initMergeInfo() {
        Memory resultSet = this.resultPgm.getMemory();
        this.latestSet = this.latestChanges.getRegisterAddressSet().intersect((AddressSetView)resultSet);
        this.mySet = this.myChanges.getRegisterAddressSet().intersect((AddressSetView)resultSet);
        this.originalContext = this.originalPgm.getProgramContext();
        this.latestContext = this.latestPgm.getProgramContext();
        this.myContext = this.myPgm.getProgramContext();
        this.resultContext = this.resultPgm.getProgramContext();
        this.registers = this.myContext.getRegisters();
        try {
            this.diffOriginalLatest = new ProgramDiff(this.originalPgm, this.latestPgm);
            this.diffOriginalMy = new ProgramDiff(this.originalPgm, this.myPgm);
            this.diffFilter = new ProgramDiffFilter(1);
            this.mergeFilter = new ProgramMergeFilter(1, 1);
        }
        catch (ProgramConflictException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)((Object)e));
        }
        catch (IllegalArgumentException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(PROGRAM_CONTEXT_PHASE);
        this.mergeManager.updateProgress(0, "Initializing merge of program context registers...");
        this.initMergeInfo();
        if (this.mergeManager != null) {
            this.mergePanel = this.mergeManager.getListingMergePanel();
            if (this.conflictInfoPanel == null) {
                this.conflictInfoPanel = new ConflictInfoPanel();
            }
            this.mergePanel.setTopComponent(this.conflictInfoPanel);
        }
        try {
            Object[] latestNames = this.latestContext.getRegisterNames();
            Object[] myNames = this.myContext.getRegisterNames();
            Arrays.sort(latestNames);
            Arrays.sort(myNames);
            if (!Arrays.equals(latestNames, myNames)) {
                this.mergeManager.setStatusText("Program Context Registers don't match between the programs.");
                this.cancel();
                return;
            }
            Register[] regs = this.latestContext.getRegisters();
            Arrays.sort(regs, new Comparator<Register>(){

                @Override
                public int compare(Register r1, Register r2) {
                    return r2.getBitLength() - r1.getBitLength();
                }
            });
            int transactionID = this.resultPgm.startTransaction(this.getDescription());
            boolean commit = false;
            try {
                int numRegs = regs.length;
                monitor.initialize((long)numRegs);
                for (int i = 0; i < numRegs; ++i) {
                    if (regs[i].isProcessorContext()) continue;
                    String regName = regs[i].getName();
                    int currentProgressPercentage = (int)(100.0f / (float)numRegs * (float)i);
                    this.mergeManager.updateProgress(currentProgressPercentage, "Merging register values for " + regName);
                    monitor.setProgress((long)i);
                    monitor.checkCanceled();
                    this.rmm = new RegisterMergeManager(regName, this.mergeManager, this.resultPgm, this.originalPgm, this.latestPgm, this.myPgm, this.latestChanges, this.myChanges);
                    this.rmm.merge(monitor);
                }
                this.mergeManager.updateProgress(100, "Done merging program context registers...");
                commit = true;
            }
            catch (CancelledException e) {
                this.mergeManager.setStatusText("User cancelled merge.");
                this.cancel();
            }
            finally {
                this.resultPgm.endTransaction(transactionID, commit);
            }
        }
        finally {
            monitor = null;
        }
        this.mergeManager.setCompleted(PROGRAM_CONTEXT_PHASE);
    }

    void setConflictDecision(int decision) {
        if (decision == 0 || decision == 2 || decision == 4 || decision == 1) {
            if (this.rmm != null) {
                this.rmm.setConflictDecision(decision);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{PROGRAM_CONTEXT_PHASE};
    }
}

