/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.data.DataType;

class ClearFunctionAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;
    private Class<?> locationEnabledClass;

    ClearFunctionAction(String name, FunctionPlugin plugin, Class<?> locationEnabledClass) {
        super(name, plugin.getName());
        this.funcPlugin = plugin;
        this.locationEnabledClass = locationEnabledClass;
        this.setKeyBindingData(new KeyBindingData(67, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.funcPlugin.createData(DataType.DEFAULT, context, false);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        return this.locationEnabledClass.isAssignableFrom(context.getLocation().getClass());
    }
}

