/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.stackeditor.StackEditorModel;
import ghidra.app.plugin.core.stackeditor.StackEditorProvider;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.util.exception.UsrException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StackEditorPanel
extends CompositeEditorPanel {
    private JTextField frameSizeField;
    private JTextField localSizeField;
    private JTextField paramSizeField;
    private JTextField paramOffsetField;
    private JTextField returnAddrOffsetField;

    public StackEditorPanel(Program program, StackEditorModel model, StackEditorProvider provider) {
        super(model, provider);
    }

    int getFrameSize() {
        return Integer.decode(this.frameSizeField.getText());
    }

    int getLocalSize() {
        return Integer.decode(this.localSizeField.getText());
    }

    int getParamSize() {
        return Integer.decode(this.paramSizeField.getText());
    }

    int getParamOffset() {
        return Integer.decode(this.paramOffsetField.getText());
    }

    int getReturnAddrOffset() {
        return Integer.decode(this.returnAddrOffsetField.getText());
    }

    @Override
    protected JPanel createInfoPanel() {
        this.setBorder(BEVELED_BORDER);
        this.setupFrameSize();
        this.setupLocalSize();
        this.setupParamSize();
        this.setupParamOffset();
        this.setupReturnAddrOffset();
        this.adjustStackInfo();
        JPanel frameSizePanel = this.createNamedTextPanel(this.frameSizeField, "Frame Size");
        JPanel localSizePanel = this.createNamedTextPanel(this.localSizeField, "Local Size");
        JPanel paramSizePanel = this.createNamedTextPanel(this.paramSizeField, "Parameter Size");
        JPanel paramOffsetPanel = this.createNamedTextPanel(this.paramOffsetField, "Parameter Offset");
        JPanel returnAddrOffsetPanel = this.createNamedTextPanel(this.returnAddrOffsetField, "Return Address Offset");
        JComponent[] hPanels = new JPanel[]{this.createHorizontalPanel(new JPanel[]{frameSizePanel, returnAddrOffsetPanel, localSizePanel}), this.createHorizontalPanel(new JPanel[]{paramOffsetPanel, paramSizePanel})};
        JPanel outerPanel = this.createVerticalPanel(hPanels);
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return outerPanel;
    }

    private void setupFrameSize() {
        this.frameSizeField = new JTextField(20);
        this.frameSizeField.setName("Frame Size");
        this.frameSizeField.setEditable(false);
    }

    private void setupLocalSize() {
        this.localSizeField = new JTextField(20);
        this.localSizeField.setName("Local Size");
        this.localSizeField.setEditable(true);
        this.localSizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StackEditorPanel.this.updatedLocalSize();
            }
        });
        this.localSizeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StackEditorPanel.this.updatedLocalSize();
            }
        });
    }

    private void updatedLocalSize() {
        String valueStr = this.localSizeField.getText();
        try {
            Integer value = Integer.decode(valueStr);
            int localSize = value;
            if (localSize < 0) {
                this.model.setStatus("Local size cannot be negative.", true);
            } else {
                try {
                    ((StackEditorModel)this.model).setLocalSize(localSize);
                }
                catch (UsrException ue) {
                    this.model.setStatus("Invalid local size \"" + valueStr + "\". " + ue.getMessage(), true);
                }
            }
        }
        catch (NumberFormatException e1) {
            this.model.setStatus("Invalid local size \"" + valueStr + "\".", true);
        }
        this.compositeInfoChanged();
    }

    private void setupParamSize() {
        this.paramSizeField = new JTextField(20);
        this.paramSizeField.setName("Parameter Size");
        this.paramSizeField.setEditable(true);
        this.paramSizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StackEditorPanel.this.updatedParamSize();
            }
        });
        this.paramSizeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StackEditorPanel.this.updatedParamSize();
            }
        });
    }

    private void updatedParamSize() {
        String valueStr = this.paramSizeField.getText();
        try {
            Integer value = Integer.decode(valueStr);
            int paramSize = value;
            try {
                ((StackEditorModel)this.model).setParameterSize(paramSize);
            }
            catch (UsrException ue) {
                this.model.setStatus("Invalid parameter size \"" + valueStr + "\". " + ue.getMessage(), true);
            }
        }
        catch (NumberFormatException e1) {
            this.model.setStatus("Invalid parameter size \"" + valueStr + "\".", true);
        }
        this.compositeInfoChanged();
    }

    private void setupParamOffset() {
        this.paramOffsetField = new JTextField(20);
        this.paramOffsetField.setName("Parameter Offset");
        this.paramOffsetField.setEditable(false);
    }

    private void setupReturnAddrOffset() {
        this.returnAddrOffsetField = new JTextField(20);
        this.returnAddrOffsetField.setName("Return Address Offset");
        this.returnAddrOffsetField.setEditable(false);
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustStackInfo();
    }

    private String getNumberString(int value) {
        return this.model.isShowingNumbersInHex() ? StackFrameDataType.getHexString(value, true) : Integer.toString(value);
    }

    private void adjustStackInfo() {
        StackFrameDataType editorStack = ((StackEditorModel)this.model).getEditorStack();
        String frameSize = this.getNumberString(editorStack.getFrameSize());
        if (!this.frameSizeField.getText().trim().equals(frameSize)) {
            this.frameSizeField.setText(frameSize);
        }
        String localSize = this.getNumberString(editorStack.getLocalSize());
        if (!this.localSizeField.getText().trim().equals(localSize)) {
            this.localSizeField.setText(localSize);
        }
        String paramSize = this.getNumberString(editorStack.getParameterSize());
        if (!this.paramSizeField.getText().trim().equals(paramSize)) {
            this.paramSizeField.setText(paramSize);
        }
        String paramOffset = this.getNumberString(editorStack.getParameterOffset());
        if (!this.paramOffsetField.getText().trim().equals(paramOffset)) {
            this.paramOffsetField.setText(paramOffset);
        }
        String returnAddressOffset = this.getNumberString(editorStack.getReturnAddressOffset());
        if (!this.returnAddrOffsetField.getText().trim().equals(returnAddressOffset)) {
            this.returnAddrOffsetField.setText(returnAddressOffset);
        }
    }

    @Override
    public void componentDataChanged() {
    }

    @Override
    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        boolean reload = true;
        String objectType = "domain object";
        if (domainObject instanceof Program) {
            objectType = "program";
        } else if (domainObject instanceof DataTypeArchive) {
            objectType = "data type archive";
        }
        DataTypeManager dtm = ((StackEditorModel)this.model).getOriginalDataTypeManager();
        Object originalDt = ((StackEditorModel)this.model).getOriginalComposite();
        if (originalDt instanceof StackFrameDataType) {
            StackFrameDataType sfdt = (StackFrameDataType)originalDt;
            Function function = sfdt.getFunction();
            if (function instanceof DatabaseObject && !((DatabaseObject)function).checkIsValid()) {
                this.provider.dispose();
                PluginTool tool = ((StackEditorProvider)this.provider).getPlugin().getTool();
                tool.setStatusInfo("Stack Editor was closed for " + this.provider.getName());
                return;
            }
            StackFrame stack = function.getStackFrame();
            StackFrameDataType newSfdt = new StackFrameDataType(stack, dtm);
            if (!newSfdt.equals(((StackEditorModel)this.model).getViewComposite())) {
                originalDt = newSfdt;
            }
        }
        ((StackEditorModel)this.model).updateAndCheckChangeState();
        if (this.model.hasChanges()) {
            String name = ((StackEditorModel)this.model).getTypeName();
            String question = "The " + objectType + " \"" + domainObject.getName() + "\" has been restored.\n\"" + this.model.getCompositeName() + "\" may have changed outside the editor.\nDiscard edits & reload the " + name + " Editor?";
            String title = "Reload " + name + " Editor?";
            int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)title, (String)question);
            if (response != 1) {
                reload = false;
            }
        }
        if (reload) {
            this.cancelCellEditing();
            this.model.load((Composite)originalDt, this.model.isOffline());
            this.model.updateAndCheckChangeState();
        } else {
            ((StackEditorModel)this.model).refresh();
        }
    }

    @Override
    public void dispose() {
        this.removeFocusListeners(this.localSizeField);
        this.removeFocusListeners(this.paramSizeField);
        this.removeFocusListeners(this.paramOffsetField);
        this.removeFocusListeners(this.returnAddrOffsetField);
        super.dispose();
    }

    private void removeFocusListeners(JTextField textField) {
        FocusListener[] fl = textField.getFocusListeners();
        for (int i = 0; i < fl.length; ++i) {
            textField.removeFocusListener(fl[i]);
        }
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
    }

    @Override
    protected void adjustCompositeInfo() {
    }
}

