/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.CodeSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.OrganizationNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class LabelCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_LABELS_ICON = ResourceManager.loadImage((String)"images/openFolderLabels.png");
    public static final Icon CLOSED_FOLDER_LABELS_ICON = ResourceManager.loadImage((String)"images/closedFolderLabels.png");

    public LabelCategoryNode(Program program) {
        super(SymbolCategory.LABEL_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_LABELS_ICON : CLOSED_FOLDER_LABELS_ICON;
    }

    @Override
    public String getToolTip() {
        return "Symbols for Global Labels";
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        for (DataFlavor flavor : dataFlavors) {
            if (flavor != CodeSymbolNode.LOCAL_DATA_FLAVOR) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<GTreeNode> getSymbols(SymbolType type, TaskMonitor monitor) throws CancelledException {
        return this.getSymbols(type, true, monitor);
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        for (GTreeNode treeNode : pastedNodes) {
            if (treeNode instanceof LabelCategoryNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return OrganizationNode.COMPARATOR;
    }

    @Override
    public void symbolAdded(Symbol symbol) {
        if (!this.isChildrenLoadedOrInProgress()) {
            return;
        }
        if (!symbol.isGlobal()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        SymbolNode newNode = SymbolNode.createNode(symbol, this.program);
        this.doAddNode((GTreeNode)this, (GTreeNode)newNode);
    }
}

