/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.util.Msg;
import java.lang.reflect.Field;

public final class MachHeaderFileTypes {
    public static final int MH_OBJECT = 1;
    public static final int MH_EXECUTE = 2;
    public static final int MH_FVMLIB = 3;
    public static final int MH_CORE = 4;
    public static final int MH_PRELOAD = 5;
    public static final int MH_DYLIB = 6;
    public static final int MH_DYLINKER = 7;
    public static final int MH_BUNDLE = 8;
    public static final int MH_DYLIB_STUB = 9;
    public static final int MH_DSYM = 10;
    public static final int MH_KEXT_BUNDLE = 11;

    public static final String getFileTypeName(int fileType) {
        Field[] fields;
        for (Field field : fields = MachHeaderFileTypes.class.getDeclaredFields()) {
            if (!field.getName().startsWith("MH_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (value != fileType) continue;
                return field.getName().substring("MH_".length());
            }
            catch (Exception e) {
                Msg.error(MachConstants.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return "Unrecognized file type: 0x" + Integer.toHexString(fileType);
    }

    public static final String getFileTypeDescription(int fileType) {
        switch (fileType) {
            case 1: {
                return "Relocatable Object File";
            }
            case 2: {
                return "Demand Paged Executable File";
            }
            case 3: {
                return "Fixed VM Shared Library File";
            }
            case 4: {
                return "Core File";
            }
            case 5: {
                return "Preloaded Executable File";
            }
            case 6: {
                return "Dynamically Bound Shared Library";
            }
            case 7: {
                return "Dynamic Link Editor";
            }
            case 8: {
                return "Dynamically Bound Bundle File";
            }
            case 9: {
                return "Shared Library Stub for Static Linking Only";
            }
            case 10: {
                return "Companion file with only debug sections";
            }
            case 11: {
                return "x86 64 Kernel Extension";
            }
        }
        return "Unrecognized file type: 0x" + Integer.toHexString(fileType);
    }
}

