/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Implementation
implements StructConverter {
    private boolean _is32bit;
    private long _index;
    private long imp;

    public ObjectiveC2_Implementation(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._is32bit = state.is32bit;
        this._index = reader.getPointerIndex();
        this.imp = state.is32bit ? (long)reader.readNextInt() & 0xFFFFFFFFL : reader.readNextLong();
    }

    public long getImplementation() {
        return this.imp;
    }

    public long getIndex() {
        return this._index;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        if (this._is32bit) {
            return new TypedefDataType("Implementation", DWORD);
        }
        return new TypedefDataType("Implementation", QWORD);
    }

    public void applyTo() throws Exception {
    }
}

