/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.CPP;

import ghidra.app.util.cparser.CPP.DefineTable;
import ghidra.app.util.cparser.CPP.JavaCharStream;
import ghidra.app.util.cparser.CPP.ParseException;
import ghidra.app.util.cparser.CPP.PreProcessorConstants;
import ghidra.app.util.cparser.CPP.PreProcessorTokenManager;
import ghidra.app.util.cparser.CPP.Token;
import ghidra.app.util.cparser.CPP.TokenMgrError;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class PreProcessor
implements PreProcessorConstants {
    int shift;
    boolean emitExecSwitch = true;
    Hashtable<String, Boolean> files = new Hashtable();
    Stack<String> fileStack = new Stack();
    Stack<PPToken> execStack = new Stack();
    Vector<String> pathList = new Vector();
    int ifDepth = 0;
    DefineTable defs = new DefineTable();
    PrintStream outputStream = System.out;
    private HashMap<String, Integer> alreadyDone;
    private static int verboseLevel = 0;
    public PreProcessorTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[44];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[41];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public int verboseLevel() {
        int vl = verboseLevel;
        return vl;
    }

    public String curFileStackTop() {
        return this.fileStack.empty() ? "" : this.fileStack.peek().toString();
    }

    public DefineTable getDefinitions() {
        return this.defs;
    }

    public PPToken getDef(PPToken def) {
        PPToken pt;
        if (verboseLevel == 6 || verboseLevel == 5 || verboseLevel == 4 || verboseLevel == 3) {
            this.println("Defs: containsKey: " + def.image + " = " + this.defs.containsKey(def.image));
        }
        if ((pt = this.defs.get(def.image)) != null && pt.image.length() > 0) {
            pt.image = this.defs.expand(pt.image, false);
        } else {
            pt = def;
        }
        return pt;
    }

    private void setDef(PPToken def) {
        if (verboseLevel == 3 || verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + def.beginLine + ": Defining: " + def.image);
        }
        if (this.emitExecSwitch) {
            this.defs.put(def.image, new PPToken(""));
        }
    }

    private void setDef(PPToken key, PPToken val) {
        if (verboseLevel == 4 || verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " = " + val.image);
        }
        if (this.emitExecSwitch) {
            val.image = val.image.trim();
            val.setPath(this.curFileStackTop());
            this.defs.put(key.image, val);
        }
    }

    private void setArg(PPToken key, Vector val) {
        if (verboseLevel == 4 || verboseLevel == 6) {
            this.print(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " (");
            for (int i = 0; i < val.size(); ++i) {
                if (i == 0) {
                    this.print(((PPToken)val.elementAt((int)i)).image);
                    continue;
                }
                if (i < val.size() - 1) {
                    this.print("," + ((PPToken)val.elementAt((int)i)).image);
                    continue;
                }
                this.println("," + ((PPToken)val.elementAt((int)i)).image + ")");
            }
        }
        if (this.emitExecSwitch) {
            this.defs.putArg(key.image, val);
        }
    }

    private void setMacro(PPToken key, Vector marg, PPToken val) {
        if (verboseLevel == 5 || verboseLevel == 6) {
            this.println(this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " = " + val.image);
        }
        if (this.emitExecSwitch) {
            this.setDef(key, val);
        }
        if (verboseLevel == 5 || verboseLevel == 6) {
            this.println("\t" + this.curFileStackTop() + "'" + key.beginLine + ": Defining text: " + key.image + " (");
            for (int i = 0; i < marg.size(); ++i) {
                if (i == 0) {
                    this.print(((PPToken)marg.elementAt((int)i)).image);
                    continue;
                }
                if (i < marg.size() - 1) {
                    this.print("," + ((PPToken)marg.elementAt((int)i)).image);
                    continue;
                }
                this.println("," + ((PPToken)marg.elementAt((int)i)).image + ")");
            }
        }
        if (this.emitExecSwitch) {
            this.setArg(key, marg);
        }
    }

    private void UnDefine(PPToken def) {
        if (this.isArg(def)) {
            this.Forget(def);
        }
        if (this.isDef(def) && this.emitExecSwitch) {
            this.defs.remove(def.image);
        }
    }

    private void Forget(PPToken val) {
        if (this.emitExecSwitch) {
            this.defs.removeArg(val.image);
        }
    }

    private void localPlace(PPToken inc, boolean xsym) throws ParseException {
        String def = inc.image;
        File incFile = null;
        FileInputStream fis = null;
        String srcPath = null;
        try {
            if (srcPath == null) {
                srcPath = "." + File.separator;
            }
            if ((incFile = new File(srcPath + def)).exists()) {
                fis = new FileInputStream(incFile);
            } else {
                incFile = new File(srcPath + def.toLowerCase());
                if (incFile.exists()) {
                    fis = new FileInputStream(incFile);
                }
            }
        }
        catch (FileNotFoundException fene) {
            Msg.error((Object)this, (Object)(fene.getMessage() + " " + incFile));
        }
        if (fis == null) {
            this.standardPlace(inc, xsym);
        } else {
            if (verboseLevel == 2) {
                this.print("Line " + inc.beginLine + ": " + this.curFileStackTop() + " => ");
            }
            this.swapFileStreams(incFile, fis);
        }
    }

    private void swapFileStreams(File incFile, FileInputStream fis) {
        if (verboseLevel == 2) {
            this.print(incFile.getAbsolutePath() + "\n");
        } else if (verboseLevel == 1) {
            this.println("Parsing stream " + incFile.getAbsolutePath() + " ... ");
        }
        PreProcessor parser = null;
        try {
            int pos = -1;
            int count = 0;
            do {
                if ((pos = this.fileStack.indexOf(incFile.getAbsolutePath(), pos + 1)) >= 0) {
                    ++count;
                }
                if (count <= 5) continue;
                Msg.error((Object)this, (Object)("Error: Possible infinite inclusion recursion detected: " + incFile.getAbsolutePath()));
                Msg.error((Object)this, this.fileStack);
                return;
            } while (pos != -1);
            Integer val = this.alreadyDone.get(incFile.getAbsolutePath());
            if (val != null) {
                if (val > 2) {
                    return;
                }
            } else {
                val = new Integer(0);
            }
            this.alreadyDone.put(incFile.getAbsolutePath(), val + 1);
            this.fileStack.push(incFile.getAbsolutePath());
            parser = new PreProcessor(this);
            parser.ReInit(fis);
            parser.Input();
            this.fileStack.pop();
        }
        catch (ParseException e) {
            Msg.error((Object)this, (Object)("PERROR parsing Included File: In " + incFile.getName() + ": " + e.getMessage()));
            Msg.error((Object)this, (Object)("PreProcessor Parse Error:  " + e.getMessage()));
        }
        catch (TokenMgrError e) {
            Msg.error((Object)this, (Object)("ERROR parsing Included File: " + incFile.getName()));
            Msg.error((Object)this, (Object)("PreProcessor Token Error:  " + e.getMessage()));
        }
    }

    private void standardPlace(PPToken inc, boolean xsym) throws ParseException {
        this.includeFile(inc, xsym);
    }

    private boolean isNDef(PPToken def) {
        if (verboseLevel == 6) {
            this.print("Line " + def.beginLine + ": " + this.curFileStackTop() + " Check isNDef " + def.image);
        }
        if (!this.defs.containsKey(def.image)) {
            if (verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    public boolean isDef(PPToken def) {
        if (verboseLevel == 6) {
            this.print("Line " + def.beginLine + ": " + this.curFileStackTop() + " Check isDef " + def.image);
        }
        if (this.defs.containsKey(def.image)) {
            if (verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    public boolean isArg(PPToken arg) {
        if (verboseLevel == 6) {
            this.print("Line " + arg.beginLine + ": " + this.curFileStackTop() + " Check isArg " + arg.image);
        }
        if (this.defs.isArg(arg.image)) {
            if (verboseLevel == 6) {
                this.println("True");
            }
            return true;
        }
        if (verboseLevel == 6) {
            this.println("False");
        }
        return false;
    }

    private void includeFile(PPToken inc, boolean xsym) throws ParseException {
        String ft = inc.image;
        String fn = new String(ft);
        if ((fn = fn.trim()).charAt(0) == '\"' && fn.endsWith("\"")) {
            fn = fn.substring(1, fn.length() - 1);
        }
        FileInputStream fis = null;
        File iFile = null;
        this.addFile(fn);
        for (int i = 0; i < this.pathList.size() && ((iFile = this.getFile(this.pathList.elementAt(i), fn, xsym)) != null && iFile.getAbsolutePath().equals(this.fileStack.peek()) || (fis = this.getFIS(iFile)) == null); ++i) {
        }
        if (fis == null) {
            iFile = new File((String)this.fileStack.lastElement());
            iFile = this.getFile(iFile.getParent(), fn, xsym);
            fis = this.getFIS(iFile);
        }
        if (fis == null) {
            Msg.error((Object)this, (Object)("No path to #include " + ft + "\nUse -I option"));
            Msg.error((Object)this, (Object)"    Current Include Path: ");
            for (int pi = 0; pi < this.fileStack.size(); ++pi) {
                Msg.error((Object)this, (Object)("     :   " + (String)this.fileStack.get(pi)));
            }
            Msg.error((Object)this, (Object)"    Assuming not needed");
        } else {
            if (verboseLevel == 2) {
                this.print("Line " + inc.beginLine + ": " + this.curFileStackTop() + " => ");
            }
            StringBuffer pad = new StringBuffer();
            for (int padInd = 0; padInd < this.fileStack.size(); ++padInd) {
                pad.append("   ");
            }
            Msg.info((Object)this, (Object)("      " + pad + iFile));
            this.swapFileStreams(iFile, fis);
            if (verboseLevel == 1) {
                Msg.info((Object)this, (Object)("Include depth " + this.fileStack.size() + ": Done!"));
            }
        }
    }

    private File getFile(String parent, String filename) {
        return this.getFile(parent, filename, true);
    }

    private File getFile(String parent, String filename, boolean possibleXsym) {
        File file = this.findFile(parent, filename, possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent, filename.toLowerCase(), possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent.toLowerCase(), filename.toLowerCase(), possibleXsym);
        if (file != null) {
            return file;
        }
        file = this.findFile(parent.toUpperCase(), filename.toUpperCase(), possibleXsym);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File findFile(String parent, String filename, boolean possibleXsym) {
        Object child;
        File iFile;
        block16: {
            File frameFile;
            iFile = null;
            iFile = new File(parent + File.separator + filename);
            if (iFile.exists()) {
                return iFile;
            }
            File sameiFile = new File(parent + File.separator + new File(filename).getName());
            if (sameiFile.exists()) {
                return sameiFile;
            }
            if (!possibleXsym) return null;
            child = "";
            do {
                if (iFile == null) return null;
                if (iFile.getParent() == null) return null;
                child = ((String)child).length() <= 0 ? iFile.getName() : iFile.getName() + File.separator + (String)child;
                iFile = iFile.getParentFile();
                if (iFile.exists()) break block16;
            } while (!(frameFile = new File(iFile.getAbsolutePath() + ".framework" + File.separator + iFile.getName())).exists());
            iFile = frameFile;
        }
        if (!iFile.isFile()) {
            if (!iFile.getName().equals("..")) return null;
            return this.getFile(iFile.getParent(), (String)child);
        }
        FileInputStream fis = this.getFIS(iFile);
        if (fis == null) {
            return null;
        }
        String nPath = "";
        try {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String str = br.readLine();
                if (str == null || !str.equals("XSym")) {
                    File subFile = this.getFile(iFile.getParent() + File.separator + "Headers", (String)child, true);
                    if (subFile != null) {
                        File file = subFile;
                        return file;
                    }
                    File file = this.getFile(iFile.getParent(), (String)child, true);
                    return file;
                }
                str = br.readLine();
                str = br.readLine();
                nPath = br.readLine();
                if (nPath.length() <= 0) {
                    File file = null;
                    return file;
                }
                iFile = new File(iFile.getParent() + File.separator + nPath + File.separator + (String)child);
                File file = this.getFile(iFile.getParent(), iFile.getName(), true);
                return file;
            }
            finally {
                fis.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private FileInputStream getFIS(File iFile) {
        if (iFile == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            File lowerFile;
            if (iFile.exists()) {
                fis = new FileInputStream(iFile);
            }
            if (fis == null && (lowerFile = new File(iFile.getParent(), iFile.getName().toLowerCase())).exists()) {
                fis = new FileInputStream(lowerFile);
            }
        }
        catch (FileNotFoundException fene) {
            Msg.error((Object)this, (Object)(fene.getMessage() + " " + iFile));
        }
        return fis;
    }

    private void addFile(String file) {
        this.files.put(file, Boolean.TRUE);
    }

    private void print(String text) {
        this.outputStream.print(text);
    }

    private void println(String text) {
        this.outputStream.println(" " + text);
    }

    private void printFiles() {
        Enumeration<String> eFiles = this.files.keys();
        while (eFiles.hasMoreElements()) {
            Msg.info((Object)this, (Object)("PreProcessor: " + eFiles.nextElement()));
        }
    }

    private int getopt(String[] args) throws ParseException {
        int i;
        int argc = args.length;
        block14: for (i = 0; i < argc; ++i) {
            String argString = args[i];
            switch (argString.charAt(0)) {
                case '-': {
                    String optValue = "";
                    if (argString.length() > 2) {
                        optValue = argString.substring(2);
                    } else if (i < args.length - 1) {
                        optValue = args[++i];
                    }
                    switch (argString.charAt(1)) {
                        case 'I': {
                            this.addIncludePath(optValue);
                            continue block14;
                        }
                        case 'D': {
                            Token k;
                            StringTokenizer parms = new StringTokenizer(optValue, "=");
                            if (parms.hasMoreTokens()) {
                                String key = parms.nextToken();
                                String val = parms.hasMoreTokens() ? parms.nextToken() : "";
                                if (verboseLevel == 3 || verboseLevel == 6) {
                                    System.out.print("Predefining " + key + " to " + val);
                                }
                                k = new Token();
                                Token v = new Token();
                                k.image = key;
                                v.image = val;
                                v.kind = this.getNumericType(val);
                                k.kind = 115;
                                PPToken ppk = new PPToken(k);
                                PPToken ppv = new PPToken(v);
                                this.setDef(ppk, ppv);
                                if (verboseLevel != 3 && verboseLevel != 6) continue block14;
                                Msg.info((Object)this, (Object)("Defs: containsKey: " + key + " = " + this.defs.containsKey(key) + " " + this.defs.size()));
                                continue block14;
                            }
                            if (verboseLevel == 3 || verboseLevel == 6) {
                                System.out.print("Predefining " + optValue);
                            }
                            k = new Token();
                            k.image = argString.substring(2);
                            PPToken ppk = new PPToken(k);
                            k.kind = 115;
                            this.setDef(ppk);
                            continue block14;
                        }
                        case 'U': {
                            this.defs.remove(optValue);
                            continue block14;
                        }
                        case 'v': {
                            try {
                                verboseLevel = Integer.parseInt(optValue, 10);
                                continue block14;
                            }
                            catch (NumberFormatException nfe) {
                                Msg.error((Object)this, (Object)("Verbose Level Error: " + nfe.getMessage()));
                                throw new ParseException("Bad verbosity level " + optValue);
                            }
                        }
                        case 'O': {
                            try {
                                this.setOutputStream(new FileOutputStream(optValue));
                                continue block14;
                            }
                            catch (FileNotFoundException exc) {
                                Msg.error((Object)this, (Object)("Couldn't create file " + optValue));
                                throw new ParseException("Couldn't create file " + optValue);
                            }
                        }
                        default: {
                            Msg.error((Object)this, (Object)("Unknown option: " + argString));
                            throw new ParseException("Unknown option: " + argString);
                        }
                    }
                }
                default: {
                    return i;
                }
            }
        }
        return i;
    }

    public void addIncludePath(String path) {
        this.pathList.addElement(path);
    }

    public int getNumericType(String val) {
        try {
            Double.parseDouble(val);
            return 114;
        }
        catch (NumberFormatException nfe) {
            try {
                if (val.endsWith("L") || val.endsWith("l") || val.endsWith("U")) {
                    val = val.substring(0, val.length() - 1);
                }
                if (val.startsWith("0x") || val.startsWith("0X")) {
                    Integer.parseInt(val.substring(2), 16);
                } else {
                    Integer.parseInt(val);
                }
                return 113;
            }
            catch (NumberFormatException numberFormatException) {
                return 115;
            }
        }
    }

    public Double getDoubleValue(String val) {
        double value = 0.0;
        try {
            value = Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            value = this.getLongValue(val).doubleValue();
        }
        return value;
    }

    private BigInteger getLongValue(String str) throws NumberFormatException {
        try {
            if (str.endsWith("L") || str.endsWith("l") || str.endsWith("U")) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.startsWith("--")) {
                str = str.substring(2, str.length());
            }
            if (str.startsWith("0x") || str.startsWith("0X")) {
                return new BigInteger(str.substring(2), 16);
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Couldn't parse number: '" + str + "'");
        }
    }

    public void setArgs(String[] args) throws ParseException {
        this.shift = this.getopt(args);
    }

    public void setOutputStream(OutputStream fos) {
        this.outputStream = new PrintStream(fos);
    }

    public void parse(String filename) {
        if (verboseLevel == 1) {
            Msg.info((Object)this, (Object)("PreProcessor Version 0.0:  Reading from file " + filename + " . . ."));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fis == null) {
            for (int i = 0; i < this.pathList.size(); ++i) {
                File iFile = this.getFile(this.pathList.elementAt(i), filename);
                fis = this.getFIS(iFile);
                if (fis == null) continue;
                filename = iFile.getAbsolutePath();
                break;
            }
        }
        if (fis == null) {
            Msg.error((Object)this, (Object)("PreProcessor Version 0.0:  File " + filename + " not found."));
            return;
        }
        this.fileStack.push(filename);
        this.alreadyDone = new HashMap();
        this.ReInit(fis);
        try {
            this.Input();
            this.fileStack.pop();
            if (this.fileStack.size() == 0 && verboseLevel == 1) {
                Msg.info((Object)this, (Object)"PreProcessor Version 0.0:  Java program parsed successfully.");
            }
        }
        catch (ParseException e) {
            Msg.error((Object)this, (Object)("ERROR parsing: " + filename));
            Msg.error((Object)this, (Object)("PreProcessor Parse Error:  " + e.getMessage()));
        }
        catch (TokenMgrError e) {
            Msg.error((Object)this, (Object)("ERROR parsing: " + filename));
            Msg.error((Object)this, (Object)("PreProcessor Token Error:  " + e.getMessage()));
        }
    }

    PreProcessor(PreProcessor parent) {
        this(System.in);
        this.defs = parent.defs;
        this.execStack = parent.execStack;
        this.files = parent.files;
        this.fileStack = parent.fileStack;
        this.ifDepth = parent.ifDepth;
        this.outputStream = parent.outputStream;
        this.pathList = parent.pathList;
        this.shift = parent.shift;
        this.alreadyDone = parent.alreadyDone;
    }

    public PreProcessor(String[] args) throws ParseException {
        this(System.in);
        this.shift = this.getopt(args);
        if (args.length - this.shift == 0) {
            if (verboseLevel == 1) {
                Msg.info((Object)this, (Object)"PreProcessor Version 0.0:  Reading from standard input . . .");
            }
            this.fileStack.push("stdin");
        } else {
            while (args.length - this.shift >= 1) {
                this.parse(args[this.shift]);
                ++this.shift;
            }
        }
    }

    public PreProcessor(String filename) throws ParseException {
        this(System.in);
        try {
            FileInputStream fis = new FileInputStream(filename);
            this.ReInit(fis);
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)this, (Object)("PreProcessor Version 0.0:  File " + filename + " not found."));
            Msg.error((Object)this, (Object)"Usage is one of:");
            Msg.error((Object)this, (Object)"         java PreProcessor < inputfile ...");
            Msg.error((Object)this, (Object)"OR");
            Msg.error((Object)this, (Object)"         java PreProcessor inputfile ...");
            return;
        }
    }

    public PreProcessor() throws ParseException {
        this(System.in);
    }

    public static void main(String[] args) {
        try {
            PreProcessor preProcessor = new PreProcessor(args);
        }
        catch (ParseException e) {
            System.out.println("PreProcessor Version 0.0:  Encountered errors during parse.");
            System.out.println("PreProcessor: " + e.getMessage());
        }
    }

    public final void Input() throws ParseException {
        boolean b = true;
        int conditionDepth = this.execStack.size();
        PPToken ppt = new PPToken("\n#line 1: \"" + this.curFileStackTop() + "\"\n");
        ppt.emit();
        block3: do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 113: 
                case 129: 
                case 130: 
                case 131: 
                case 137: 
                case 139: 
                case 140: 
                case 141: 
                case 151: 
                case 152: 
                case 154: 
                case 157: 
                case 162: 
                case 169: 
                case 170: 
                case 171: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
        } while (b = this.TranslationUnit());
        if (conditionDepth != this.execStack.size()) {
            Msg.error((Object)this, (Object)("Imbalance in sequence/nesting of compile-time conditions/logic in input file " + this.curFileStackTop()));
            Msg.error((Object)this, (Object)("              " + this.execStack));
            while (conditionDepth != this.execStack.size() && this.execStack.size() > 0) {
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
            }
        }
    }

    public final boolean TranslationUnit() throws ParseException {
        boolean b = true;
        while ((b = this.Group()) && this.jj_2_1(2)) {
        }
        return b;
    }

    public final void NoMas() throws ParseException {
        this.jj_consume_token(0);
    }

    public final boolean Group() throws ParseException {
        boolean b = true;
        if (this.jj_2_3(2)) {
            b = this.GroupPart();
            return b;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                do {
                    if (b = this.IFSection()) continue;
                    return b;
                } while (this.jj_2_2(2));
                return b;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean GroupPart() throws ParseException {
        boolean b = true;
        PPToken u = new PPToken("");
        Token v = new Token();
        v.image = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 130: 
            case 141: 
            case 152: 
            case 170: {
                do {
                    PPToken t = this.Text();
                    block10: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 62: {
                                break;
                            }
                            default: {
                                this.jj_la1[2] = this.jj_gen;
                                break block10;
                            }
                        }
                        v = this.jj_consume_token(62);
                        u.image = u.image + v.image;
                    }
                    t.image = t.image + u.image;
                    if (this.emitExecSwitch) {
                        t.emit();
                    }
                    t.image = "";
                    u.image = "";
                } while (this.jj_2_4(2));
                return b;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        if (this.jj_2_6(3)) {
            b = this.IFSection();
            return b;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: 
            case 113: 
            case 129: 
            case 131: 
            case 137: 
            case 139: 
            case 140: 
            case 151: 
            case 154: 
            case 157: 
            case 162: 
            case 169: 
            case 171: {
                b = this.ControlLine();
                return b;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean ControlLine() throws ParseException {
        PPToken t = null;
        Object u = null;
        boolean b = true;
        Vector vals = new Vector();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 113: 
            case 129: 
            case 131: 
            case 137: 
            case 139: 
            case 140: 
            case 151: 
            case 154: 
            case 157: 
            case 162: 
            case 169: 
            case 171: {
                if (this.jj_2_7(2)) {
                    t = this.Define();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 129: 
                        case 131: 
                        case 137: 
                        case 139: {
                            this.Include();
                            break;
                        }
                        case 162: {
                            this.UnDef();
                            break;
                        }
                        case 140: {
                            this.Pragma();
                            break;
                        }
                        case 151: {
                            this.Error();
                            break;
                        }
                        case 154: {
                            this.Warning();
                            break;
                        }
                        case 157: {
                            this.Info();
                            break;
                        }
                        case 113: 
                        case 171: {
                            this.LineInfo();
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (vals != null && vals.size() == 0) {
                    vals = null;
                }
                return true;
            }
            case 0: {
                this.NoMas();
                return false;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean IFSection() throws ParseException {
        boolean b = this.IFGroup();
        return this.GroupPart();
    }

    public final boolean IFGroup() throws ParseException {
        PPToken t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                PPToken e = this.If();
                t = this.IfCondition();
                e.setEmitSave(this.emitExecSwitch);
                e.setTruth(t.getTruth());
                this.execStack.push(e);
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = e.getTruth();
                }
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]If " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 86: {
                PPToken e = this.ElIf();
                t = this.ElseIfCondition();
                e.setTruth(t.getTruth());
                if (this.execStack.size() == 0) {
                    Msg.error((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected"));
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
                e.setEmitSave(this.emitExecSwitch);
                this.emitExecSwitch = !olde.getTruth() && this.emitExecSwitch ? e.getTruth() : false;
                if (olde.getTruth()) {
                    e.setTruth(true);
                }
                this.execStack.push(e);
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]ElIf " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 89: {
                PPToken e = this.IfDef();
                t = this.IfDefExpr();
                t.setEmitSave(this.emitExecSwitch);
                this.execStack.push(t);
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = t.getTruth();
                }
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]IfDef " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 90: {
                PPToken e = this.IfNDef();
                t = this.IfNDefExpr();
                t.setEmitSave(this.emitExecSwitch);
                this.execStack.push(t);
                if (this.emitExecSwitch) {
                    this.emitExecSwitch = t.getTruth();
                }
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]IfNDef " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 87: {
                t = this.Else();
                if (this.execStack.size() == 0) {
                    Msg.error((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected"));
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
                t.setEmitSave(this.emitExecSwitch);
                if (this.emitExecSwitch && olde.getTruth()) {
                    this.emitExecSwitch = false;
                }
                this.execStack.push(t);
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]" + this.curFileStackTop() + "'" + t.beginLine + ": Else now " + t.getTruth() + " : " + this.emitExecSwitch);
                break;
            }
            case 88: {
                t = this.EndIf();
                if (this.execStack.size() == 0) {
                    Msg.error((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected"));
                    throw new ParseException(this.curFileStackTop() + "'" + t.beginLine + "Unbalanced IF directive detected");
                }
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
                if (verboseLevel != 6 && verboseLevel != 7) break;
                this.println("[" + this.execStack.size() + "]" + this.curFileStackTop() + "'" + t.beginLine + ": Endif  : " + this.emitExecSwitch);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.getTruth();
    }

    public final PPToken IfCondition() throws ParseException {
        PPToken t = this.CompoundConditionalExpression();
        return t;
    }

    public final PPToken ElseIfCondition() throws ParseException {
        PPToken t = this.CompoundConditionalExpression();
        return t;
    }

    public final PPToken Include() throws ParseException {
        PPToken pt;
        Token t;
        int conditionDepth = this.execStack.size();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: {
                t = this.jj_consume_token(139);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.localPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 137: {
                t = this.jj_consume_token(137);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.standardPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 131: {
                t = this.jj_consume_token(131);
                pt = new PPToken(t);
                pt.image = this.defs.expand(pt.image, true);
                if (!this.emitExecSwitch) break;
                this.standardPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            case 129: {
                t = this.jj_consume_token(129);
                pt = new PPToken(t);
                if (!this.emitExecSwitch) break;
                this.localPlace(pt, true);
                this.println("\n#line " + t.beginLine + ": \"" + this.curFileStackTop() + "\"");
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (conditionDepth != this.execStack.size()) {
            Msg.error((Object)this, (Object)("Imbalance in sequence/nesting of compile-time conditions/logic in included file " + t.image));
            Msg.error((Object)this, (Object)("              " + this.execStack));
            while (conditionDepth != this.execStack.size() && this.execStack.size() > 0) {
                PPToken olde = this.execStack.pop();
                this.emitExecSwitch = olde.getEmitSave();
            }
        }
        return pt;
    }

    public final PPToken LineInfo() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 171: {
                t = this.jj_consume_token(171);
                break;
            }
            case 113: {
                t = this.jj_consume_token(113);
                t.image = "#line " + t.image + ": \"" + this.curFileStackTop() + "\"";
                this.println(t.image);
                this.token_source.SwitchTo(0);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(t);
    }

    public final PPToken Define() throws ParseException {
        PPToken pt;
        Token t;
        PPToken u = null;
        PPToken v = null;
        PPToken w = null;
        PPToken x = null;
        Vector<PPToken> dargs = new Vector<PPToken>();
        if (this.jj_2_10(2)) {
            t = this.jj_consume_token(169);
            if (this.jj_2_8(2)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 187: {
                        block28: while (true) {
                            u = this.MacroArgs();
                            dargs.add(u);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 187: {
                                    continue block28;
                                }
                            }
                            break;
                        }
                        this.jj_la1[10] = this.jj_gen;
                        break;
                    }
                    case 181: 
                    case 182: 
                    case 186: 
                    case 196: 
                    case 204: {
                        u = this.MacroVals();
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 181: 
                    case 182: 
                    case 186: 
                    case 196: 
                    case 204: {
                        block29: while (true) {
                            w = this.MacroVals();
                            if (x == null) {
                                if (dargs.size() > 0) {
                                    x = w;
                                } else {
                                    x = u;
                                    x.image = x.image + w.image;
                                }
                            } else {
                                x.image = x.image + w.image;
                            }
                            v = x;
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 181: 
                                case 182: 
                                case 186: 
                                case 196: 
                                case 204: {
                                    continue block29;
                                }
                            }
                            break;
                        }
                        this.jj_la1[12] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break;
                    }
                }
            }
        } else if (this.jj_2_11(2)) {
            t = this.jj_consume_token(169);
            u = this.MacroArgs();
            dargs.add(u);
            if (this.jj_2_9(2)) {
                v = this.Define();
            }
        } else if (this.jj_2_12(2)) {
            t = this.jj_consume_token(169);
            block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 187: {
                    block30: while (true) {
                        u = this.MacroArgs();
                        dargs.add(u);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 187: {
                                continue block30;
                            }
                        }
                        break;
                    }
                    this.jj_la1[14] = this.jj_gen;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 181: 
                        case 182: 
                        case 186: 
                        case 196: 
                        case 204: {
                            v = this.MacroVals();
                            break block13;
                        }
                    }
                    this.jj_la1[15] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 169: {
                    t = this.jj_consume_token(169);
                    block31: while (true) {
                        this.jj_consume_token(62);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 62: {
                                continue block31;
                            }
                        }
                        break;
                    }
                    this.jj_la1[17] = this.jj_gen;
                    u = this.Define();
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (!this.isDef(pt = new PPToken(t))) {
            if (u != null && v != null) {
                PPToken pv = new PPToken((Token)v);
                this.setMacro(pt, dargs, pv);
            } else if (u == null && v == null) {
                this.setDef(pt);
            } else if (v != null) {
                PPToken pv = new PPToken((Token)v);
                this.setDef(pt, pv);
            } else if (u != null) {
                if (dargs.size() > 0) {
                    PPToken pv = new PPToken("");
                    this.setMacro(pt, dargs, pv);
                } else {
                    PPToken pu = new PPToken((Token)u);
                    this.setDef(pt, pu);
                }
            }
        } else if (verboseLevel == 5 || verboseLevel == 6) {
            this.println("PreProcessor: " + this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + " aready defined. Undefine first.");
        }
        if (dargs != null && dargs.size() == 0) {
            dargs = null;
        }
        return pt;
    }

    public final PPToken UnDef() throws ParseException {
        Token t = this.jj_consume_token(162);
        PPToken pt = new PPToken(t);
        if (this.isDef(pt)) {
            this.UnDefine(pt);
        }
        return pt;
    }

    public final PPToken MacroArgs() throws ParseException {
        Object u = null;
        Token t = this.jj_consume_token(187);
        return new PPToken(t);
    }

    public final PPToken MacroVals() throws ParseException {
        Token u = new Token();
        u.image = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: 
            case 182: 
            case 186: {
                u = this.Values();
                break;
            }
            case 196: 
            case 204: {
                Token t;
                do {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 196: {
                            t = this.jj_consume_token(196);
                            u.image = u.image + t.image;
                            break;
                        }
                        case 204: {
                            t = this.jj_consume_token(204);
                            u.image = u.image + "\"" + t.image + "\"";
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                } while (this.jj_2_13(2));
                if (!this.jj_2_15(2)) break;
                while (true) {
                    t = this.Values();
                    u.image = u.image + t.image;
                    if (!this.jj_2_14(2)) break block0;
                }
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(u);
    }

    public final PPToken Pragma() throws ParseException {
        Token t = this.jj_consume_token(140);
        PPToken pt = new PPToken(t);
        if (this.emitExecSwitch) {
            this.println("#pragma " + this.defs.expand(t.image, true));
        }
        return pt;
    }

    public final PPToken IfDef() throws ParseException {
        Token t = this.jj_consume_token(89);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isDef(pt));
        return pt;
    }

    public final PPToken IfDefExpr() throws ParseException {
        Token t = this.jj_consume_token(143);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isDef(pt));
        return pt;
    }

    public final PPToken IfNDef() throws ParseException {
        Token t = this.jj_consume_token(90);
        PPToken pt = new PPToken(t);
        if (verboseLevel == 6 || verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " IFNDEF: ");
        }
        pt.setTruth(this.isNDef(pt));
        return pt;
    }

    public final PPToken IfNDefExpr() throws ParseException {
        Token t = this.jj_consume_token(147);
        PPToken pt = new PPToken(t);
        if (this.verboseLevel() == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + ": " + t.image + ": ");
        }
        pt.setTruth(this.isNDef(pt));
        return pt;
    }

    public final PPToken Error() throws ParseException {
        Token t = this.jj_consume_token(151);
        if (this.emitExecSwitch) {
            Msg.error((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + " Compiler Error:"));
            Msg.error((Object)this, (Object)t.image);
        }
        return new PPToken(t);
    }

    public final PPToken Warning() throws ParseException {
        Token t = this.jj_consume_token(154);
        if (this.emitExecSwitch) {
            Msg.error((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + " Warning: "));
            Msg.error((Object)this, (Object)t.image);
        }
        return new PPToken(t);
    }

    public final PPToken Info() throws ParseException {
        Token t = this.jj_consume_token(157);
        if (this.emitExecSwitch) {
            Msg.info((Object)this, (Object)(this.curFileStackTop() + "'" + t.beginLine + " Info: "));
            Msg.info((Object)this, (Object)t.image);
        }
        return new PPToken(t);
    }

    public final PPToken EndIf() throws ParseException {
        Token t = this.jj_consume_token(88);
        return new PPToken(t);
    }

    public final PPToken Else() throws ParseException {
        Token t = this.jj_consume_token(87);
        return new PPToken(t);
    }

    public final PPToken If() throws ParseException {
        Token t = this.jj_consume_token(85);
        if (verboseLevel == 6 || verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " IF: ");
        }
        return new PPToken(t);
    }

    public final PPToken ElIf() throws ParseException {
        Token t = this.jj_consume_token(86);
        if (verboseLevel == 6 || verboseLevel == 7) {
            this.print(this.curFileStackTop() + "'" + t.beginLine + " ElseIf: ");
        }
        return new PPToken(t);
    }

    public final PPToken Values() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 181: {
                t = this.jj_consume_token(181);
                t.kind = this.getNumericType(t.image);
                break;
            }
            case 186: {
                t = this.QuotedValue();
                break;
            }
            case 182: {
                t = this.jj_consume_token(182);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        PPToken pt = new PPToken(t);
        pt.join();
        return pt;
    }

    public final PPToken QuotedValue() throws ParseException {
        Token t = new Token();
        t.image = "\"";
        Token u = this.jj_consume_token(186);
        t.image = t.image + u.image;
        t.image = t.image + "\"";
        return new PPToken(t);
    }

    public final PPToken Text() throws ParseException {
        Token t = new Token();
        StringBuffer buf = new StringBuffer();
        t.image = "";
        if (this.jj_2_27(3)) {
            while (true) {
                Token u;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 63: {
                        u = this.jj_consume_token(63);
                        if (this.emitExecSwitch) {
                            buf.append(u.image);
                        }
                        while (this.jj_2_16(2)) {
                            u = this.NewLines();
                            if (!this.emitExecSwitch) continue;
                            buf.append(u.image);
                        }
                        break;
                    }
                    case 65: {
                        u = this.jj_consume_token(65);
                        if (!this.emitExecSwitch) break;
                        buf.append(u.image);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.jj_2_17(2)) {
                    u = this.NewLines();
                    if (this.emitExecSwitch) {
                        buf.append(u.image);
                    }
                }
                if (this.jj_2_18(2)) {
                    u = this.QuotedText();
                    if (this.emitExecSwitch) {
                        buf.append(u.image);
                    }
                }
                if (this.jj_2_20(2)) {
                    u = this.jj_consume_token(65);
                    if (this.emitExecSwitch) {
                        buf.append(u.image);
                    }
                    while (this.jj_2_19(2)) {
                        u = this.NewLines();
                        if (!this.emitExecSwitch) continue;
                        buf.append(u.image);
                    }
                }
                if (this.jj_2_21(2)) {
                    continue;
                }
                break;
            }
        } else {
            block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: 
                case 66: {
                    while (true) {
                        Token u;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 66: {
                                u = this.QuotedText();
                                if (this.emitExecSwitch) {
                                    buf.append(u.image);
                                }
                                if (!this.jj_2_22(2)) break;
                                u = this.NewLines();
                                if (!this.emitExecSwitch) break;
                                buf.append(u.image);
                                break;
                            }
                            case 65: {
                                u = this.jj_consume_token(65);
                                if (!this.emitExecSwitch) break;
                                buf.append(u.image);
                                break;
                            }
                            default: {
                                this.jj_la1[23] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (this.jj_2_23(2)) {
                            t = this.NewLines();
                            if (this.emitExecSwitch) {
                                buf.append(u.image);
                            }
                        }
                        if (this.jj_2_24(2)) {
                            u = this.jj_consume_token(65);
                            if (this.emitExecSwitch) {
                                buf.append(u.image);
                            }
                        }
                        if (this.jj_2_25(2)) {
                            u = this.NewLines();
                            if (this.emitExecSwitch) {
                                buf.append(u.image);
                            }
                        }
                        if (!this.jj_2_26(2)) break block4;
                    }
                }
                case 64: 
                case 130: 
                case 141: 
                case 152: 
                case 170: {
                    PPToken u = this.NewLines();
                    if (!this.emitExecSwitch) break;
                    buf.append(u.image);
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new PPToken(buf.toString());
    }

    public final PPToken NewLines() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                t = this.jj_consume_token(64);
                break;
            }
            case 152: {
                t = this.jj_consume_token(152);
                break;
            }
            case 170: {
                t = this.jj_consume_token(170);
                break;
            }
            case 141: {
                t = this.jj_consume_token(141);
                break;
            }
            case 130: {
                t = this.jj_consume_token(130);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(t);
    }

    public final PPToken QuotedText() throws ParseException {
        Token u = this.jj_consume_token(66);
        return new PPToken(u);
    }

    public final PPToken CompoundConditionalExpression() throws ParseException {
        PPToken t;
        if (this.jj_2_29(2)) {
            t = this.ConditionalExpression();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: 
                case 87: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 108: 
                case 109: 
                case 113: 
                case 114: 
                case 115: 
                case 116: {
                    if (this.jj_2_28(2)) {
                        t = this.CompoundOrExpression();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 85: 
                        case 87: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 108: 
                        case 109: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: {
                            t = this.CompoundAndExpression();
                            break block0;
                        }
                    }
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return new PPToken(t);
    }

    public final PPToken CompoundAndExpression() throws ParseException {
        PPToken t = this.ConditionalExpression();
        while (this.jj_2_30(2)) {
            PPToken u = this.And();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.ConditionalExpression();
            t.setTruth(t.getTruth() && v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken CompoundOrExpression() throws ParseException {
        PPToken t = this.ConditionalExpression();
        while (this.jj_2_31(2)) {
            PPToken u = this.Or();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.ConditionalExpression();
            t.setTruth(t.getTruth() || v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken ConditionalExpression() throws ParseException {
        PPToken t = this.LogicalOrExpression();
        while (this.jj_2_32(2)) {
            PPToken u = this.Qmark();
            PPToken i = this.LogicalOrExpression();
            u = this.ElseMark();
            PPToken e = this.LogicalOrExpression();
            if (t.getTruth()) {
                t = i;
                continue;
            }
            t = e;
        }
        return t;
    }

    public final PPToken LogicalOrExpression() throws ParseException {
        PPToken t = this.LogicalAndExpression();
        while (this.jj_2_33(2)) {
            PPToken u = this.Or();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LogicalAndExpression();
            t.setTruth(t.getTruth() || v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LogicalAndExpression() throws ParseException {
        PPToken t = this.EqualityExpression();
        while (this.jj_2_34(2)) {
            PPToken u = this.And();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.EqualityExpression();
            t.setTruth(t.getTruth() && v.getTruth());
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken EqualityExpression() throws ParseException {
        PPToken t = this.InEqualityExpression();
        while (this.jj_2_35(2)) {
            PPToken u = this.EqualTo();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.InEqualityExpression();
            try {
                t.setTruth(t.compareTo(v) == 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken InEqualityExpression() throws ParseException {
        PPToken t = this.RelationalExpression();
        while (this.jj_2_36(2)) {
            PPToken u = this.NotEqualTo();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.RelationalExpression();
            try {
                t.setTruth(t.compareTo(v) != 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(true);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken RelationalExpression() throws ParseException {
        PPToken t = this.LessExpression();
        while (this.jj_2_37(2)) {
            PPToken u = this.LessThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LessExpression();
            try {
                t.setTruth(t.compareTo(v) < 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken GreaterThanExpression() throws ParseException {
        PPToken t = this.LogNegation();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.GreaterThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LogNegation();
            try {
                t.setTruth(t.compareTo(v) > 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken GreaterThanOrEqualExpression() throws ParseException {
        PPToken t = this.GreaterThanExpression();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.GreaterThanOrEqual();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.GreaterThanExpression();
            try {
                t.setTruth(t.compareTo(v) >= 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LessThanOrEqualExpression() throws ParseException {
        PPToken t = this.GreaterThanOrEqualExpression();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block5;
                }
            }
            PPToken u = this.LessThanOrEqual();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.GreaterThanOrEqualExpression();
            try {
                t.setTruth(t.compareTo(v) <= 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken LessExpression() throws ParseException {
        PPToken t = this.LessThanOrEqualExpression();
        while (this.jj_2_38(2)) {
            PPToken u = this.LessThan();
            if (this.verboseLevel() == 7) {
                this.print(u.image);
            }
            PPToken v = this.LessThanOrEqualExpression();
            try {
                t.setTruth(t.compareTo(v) < 0);
            }
            catch (NumberFormatException exc) {
                t.setTruth(false);
            }
            if (this.verboseLevel() != 7) continue;
            this.print(": ");
        }
        return t;
    }

    public final PPToken Or() throws ParseException {
        Token t = this.jj_consume_token(103);
        return new PPToken(t);
    }

    public final PPToken And() throws ParseException {
        Token t = this.jj_consume_token(102);
        return new PPToken(t);
    }

    public final PPToken EqualTo() throws ParseException {
        Token t = this.jj_consume_token(96);
        return new PPToken(t);
    }

    public final PPToken NotEqualTo() throws ParseException {
        Token t = this.jj_consume_token(97);
        return new PPToken(t);
    }

    public final PPToken LessThan() throws ParseException {
        Token t = this.jj_consume_token(98);
        return new PPToken(t);
    }

    public final PPToken LessThanOrEqual() throws ParseException {
        Token t = this.jj_consume_token(100);
        return new PPToken(t);
    }

    public final PPToken GreaterThan() throws ParseException {
        Token t = this.jj_consume_token(99);
        return new PPToken(t);
    }

    public final PPToken GreaterThanOrEqual() throws ParseException {
        Token t = this.jj_consume_token(101);
        return new PPToken(t);
    }

    public final PPToken Qmark() throws ParseException {
        Token t = this.jj_consume_token(111);
        return new PPToken(t);
    }

    public final PPToken ElseMark() throws ParseException {
        Token t = this.jj_consume_token(112);
        return new PPToken(t);
    }

    public final PPToken LogNegation() throws ParseException {
        PPToken pt = null;
        boolean negate = false;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 91: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            Token t = this.jj_consume_token(91);
            negate = true;
            if (this.verboseLevel() != 7) continue;
            this.print(t.image);
        }
        pt = this.Expression();
        if (negate) {
            pt.setContra(true);
        }
        return pt;
    }

    public final PPToken Negation() throws ParseException {
        PPToken pt = null;
        boolean negate = false;
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block5;
                }
            }
            Token t = this.jj_consume_token(108);
            negate = true;
            if (this.verboseLevel() != 7) continue;
            this.print(t.image);
        }
        pt = this.Expression();
        if (negate) {
            BigInteger tvalue = BigInteger.ZERO;
            BigInteger result = BigInteger.ZERO;
            try {
                tvalue = this.getLongValue(this.getDef((PPToken)pt).image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = tvalue.negate();
            pt = new PPToken(pt);
            pt.image = result.toString();
            pt.kind = 113;
            pt.setTruth(!result.equals(BigInteger.ZERO));
        }
        return pt;
    }

    public final PPToken Assertion() throws ParseException {
        PPToken pt = null;
        boolean checkDefined = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: {
                Token t = this.jj_consume_token(92);
                if (this.verboseLevel() == 7) {
                    this.print(t.image);
                }
                pt = this.Expression();
                pt = new PPToken(pt);
                pt.setTruth(this.isDef(pt));
                return pt;
            }
            case 93: 
            case 94: 
            case 95: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 95: {
                        Token t = this.jj_consume_token(95);
                        break;
                    }
                    case 93: {
                        Token t = this.jj_consume_token(93);
                        break;
                    }
                    case 94: {
                        Token t = this.jj_consume_token(94);
                        if (this.verboseLevel() != 7) break;
                        this.print(t.image);
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(116);
                pt = this.Expression();
                this.jj_consume_token(117);
                return pt;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PPToken Expression() throws ParseException {
        PPToken t = this.ValueExpression();
        while (this.jj_2_39(3)) {
            PPToken op = this.SubtractFrom();
            PPToken v = this.ValueExpression();
            BigInteger tvalue = BigInteger.ZERO;
            BigInteger result = BigInteger.ZERO;
            BigInteger vvalue = BigInteger.ZERO;
            try {
                tvalue = this.getLongValue(this.getDef((PPToken)t).image);
                vvalue = this.getLongValue(this.getDef((PPToken)v).image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (op.kind) {
                case 108: {
                    result = tvalue.subtract(vvalue);
                    break;
                }
                case 109: {
                    result = tvalue.add(vvalue);
                    break;
                }
                case 110: {
                    result = tvalue.multiply(vvalue);
                    break;
                }
                case 105: {
                    result = tvalue.and(vvalue);
                    break;
                }
                case 104: {
                    result = tvalue.or(vvalue);
                    break;
                }
                case 107: {
                    result = tvalue.shiftRight(vvalue.intValue());
                    break;
                }
                case 106: {
                    result = tvalue.shiftLeft(vvalue.intValue());
                }
            }
            t.image = result.toString();
            t.kind = 113;
            t.setTruth(result != BigInteger.ZERO);
        }
        return new PPToken(t);
    }

    public final PPToken SubtractFrom() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 108: {
                t = this.jj_consume_token(108);
                break;
            }
            case 109: {
                t = this.jj_consume_token(109);
                break;
            }
            case 110: {
                t = this.jj_consume_token(110);
                break;
            }
            case 105: {
                t = this.jj_consume_token(105);
                break;
            }
            case 104: {
                t = this.jj_consume_token(104);
                break;
            }
            case 107: {
                t = this.jj_consume_token(107);
                break;
            }
            case 106: {
                t = this.jj_consume_token(106);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new PPToken(t);
    }

    public final PPToken ValueExpression() throws ParseException {
        PPToken tv = null;
        Token u = null;
        Vector<Token> dargs = new Vector<Token>();
        boolean negation = false;
        boolean positive = false;
        if (this.jj_2_41(2)) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: 
                case 109: 
                case 113: {
                    block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: 
                        case 109: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 108: {
                                    this.jj_consume_token(108);
                                    negation = true;
                                    break block7;
                                }
                                case 109: {
                                    this.jj_consume_token(109);
                                    positive = true;
                                    break block7;
                                }
                            }
                            this.jj_la1[36] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                        }
                    }
                    t = this.jj_consume_token(113);
                    break;
                }
                case 114: {
                    t = this.jj_consume_token(114);
                    break;
                }
                case 87: {
                    t = this.jj_consume_token(87);
                    break;
                }
                case 85: {
                    t = this.jj_consume_token(85);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (this.verboseLevel() == 7) {
                this.print(t.image);
            }
            PPToken pt = new PPToken(t);
            if (negation) {
                pt.image = "-" + pt.image;
            }
            if (positive) {
                pt.image = "+" + pt.image;
            }
            if (pt.compareToZero() == 0) {
                pt.setTruth(false);
            } else {
                pt.setTruth(true);
            }
            return pt;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 116: {
                this.jj_consume_token(116);
                PPToken pt = this.CompoundConditionalExpression();
                this.jj_consume_token(117);
                return pt;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                PPToken pt = this.Assertion();
                return pt;
            }
            case 108: 
            case 109: 
            case 115: {
                block19 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 108: 
                    case 109: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 108: {
                                this.jj_consume_token(108);
                                negation = true;
                                break block19;
                            }
                            case 109: {
                                this.jj_consume_token(109);
                                positive = true;
                                break block19;
                            }
                        }
                        this.jj_la1[39] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                    }
                }
                Token t = this.jj_consume_token(115);
                if (this.jj_2_40(4)) {
                    this.jj_consume_token(116);
                    block34: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 115: {
                                u = this.jj_consume_token(115);
                                break;
                            }
                            case 113: {
                                u = this.jj_consume_token(113);
                                break;
                            }
                            default: {
                                this.jj_la1[41] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        dargs.add(u);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 113: 
                            case 115: {
                                continue block34;
                            }
                        }
                        break;
                    }
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(117);
                }
                if (this.verboseLevel() == 7) {
                    this.print(t.image);
                }
                PPToken pt = new PPToken(t);
                if (dargs.size() > 0) {
                    pt.image = pt.image + "(";
                    Enumeration denum = dargs.elements();
                    int index = 0;
                    while (denum.hasMoreElements()) {
                        Token atok = (Token)denum.nextElement();
                        if (index++ != 0) {
                            pt.image = pt.image + ",";
                        }
                        pt.image = pt.image + atok.image;
                    }
                    pt.image = pt.image + ")";
                    pt.image = this.defs.expand(pt.image, true);
                    try {
                        if (negation) {
                            pt.image = "-" + pt.image;
                        }
                        if (positive) {
                            pt.image = "+" + pt.image;
                        }
                        int val = Integer.parseInt(pt.image);
                        pt.kind = 113;
                        pt.setTruth(true);
                        if (pt.compareToZero() == 0) {
                            pt.setTruth(false);
                        }
                        return pt;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                pt.setTruth(this.isDef(pt));
                if (pt.getTruth()) {
                    tv = this.getDef(pt);
                    if (!pt.image.equals(tv.image)) {
                        tv.image = this.defs.expand(tv.image, true);
                        tv.kind = this.getNumericType(tv.image);
                    }
                    if (negation) {
                        tv.image = "-" + tv.image;
                    }
                    if (positive) {
                        tv.image = "+" + tv.image;
                    }
                    if (tv.kind != 0 && tv.compareToZero() == 0) {
                        pt.setTruth(false);
                    } else {
                        pt.setTruth(true);
                    }
                }
                return pt;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    private boolean jj_3_38() {
        if (this.jj_3R_65()) {
            return true;
        }
        return this.jj_3R_67();
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(143);
    }

    private boolean jj_3R_66() {
        Token xsp;
        if (this.jj_3R_67()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_38());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3_14() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(196);
    }

    private boolean jj_3R_148() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(140);
    }

    private boolean jj_3R_67() {
        Token xsp;
        if (this.jj_3R_85()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_148());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_15() {
        Token xsp;
        if (this.jj_3_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_14());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_98() {
        Token xsp;
        if (this.jj_3_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_13());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_97() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_98()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_149() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(187);
    }

    private boolean jj_3R_85() {
        Token xsp;
        if (this.jj_3R_100()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_149());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_136() {
        return this.jj_scan_token(162);
    }

    private boolean jj_3R_40() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_151() {
        return this.jj_3R_153();
    }

    private boolean jj_3R_100() {
        Token xsp;
        if (this.jj_3R_118()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_151());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_37() {
        if (this.jj_3R_65()) {
            return true;
        }
        return this.jj_3R_66();
    }

    private boolean jj_3R_82() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_43() {
        Token xsp;
        if (this.jj_3R_82()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_82());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_78() {
        Token xsp;
        if (this.jj_scan_token(169)) {
            return true;
        }
        if (this.jj_scan_token(62)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(62));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3R_66()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(115)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(113)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_38();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(169)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_79() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_39() {
        Token xsp;
        if (this.jj_3R_79()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_79());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(169)) {
            return true;
        }
        return this.jj_3R_42();
    }

    private boolean jj_3_36() {
        if (this.jj_3R_63()) {
            return true;
        }
        return this.jj_3R_64();
    }

    private boolean jj_3R_81() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_41() {
        Token xsp;
        if (this.jj_3R_81()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_81());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_62() {
        Token xsp;
        if (this.jj_3R_64()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(169)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_12()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_78()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_40() {
        Token xsp;
        if (this.jj_scan_token(116)) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_70());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(117);
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(113);
    }

    private boolean jj_3_35() {
        if (this.jj_3R_61()) {
            return true;
        }
        return this.jj_3R_62();
    }

    private boolean jj_3R_60() {
        Token xsp;
        if (this.jj_3R_62()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_35());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_141() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(171)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_147()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(129);
    }

    private boolean jj_3_34() {
        if (this.jj_3R_55()) {
            return true;
        }
        return this.jj_3R_60();
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_145() {
        return this.jj_scan_token(131);
    }

    private boolean jj_3R_59() {
        Token xsp;
        if (this.jj_3R_60()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_34());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_144() {
        return this.jj_scan_token(137);
    }

    private boolean jj_3_33() {
        if (this.jj_3R_56()) {
            return true;
        }
        return this.jj_3R_59();
    }

    private boolean jj_3R_143() {
        return this.jj_scan_token(139);
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_144()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_145()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_146()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_58() {
        Token xsp;
        if (this.jj_3R_59()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_33());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_109() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_107() {
        return this.jj_3R_101();
    }

    private boolean jj_3_32() {
        if (this.jj_3R_57()) {
            return true;
        }
        return this.jj_3R_58();
    }

    private boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_103()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(115)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_54() {
        Token xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_32());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_87() {
        return this.jj_3R_102();
    }

    private boolean jj_3R_86() {
        if (this.jj_scan_token(116)) {
            return true;
        }
        return this.jj_3R_101();
    }

    private boolean jj_3_31() {
        if (this.jj_3R_56()) {
            return true;
        }
        return this.jj_3R_54();
    }

    private boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_105()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3R_53() {
        Token xsp;
        if (this.jj_3R_54()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_31());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(113);
    }

    private boolean jj_3_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(114)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(87)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(85)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_95() {
        return this.jj_3R_115();
    }

    private boolean jj_3R_69() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_87()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_88()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_133() {
        return this.jj_3R_142();
    }

    private boolean jj_3_30() {
        if (this.jj_3R_55()) {
            return true;
        }
        return this.jj_3R_54();
    }

    private boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(109)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(110)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(105)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(104)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(107)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(106)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_142() {
        Token xsp;
        if (this.jj_3R_54()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_3R_114();
    }

    private boolean jj_3_28() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_133()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_29() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_93() {
        if (this.jj_3R_112()) {
            return true;
        }
        return this.jj_3R_113();
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_119()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_48() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_92() {
        if (this.jj_3R_110()) {
            return true;
        }
        return this.jj_3R_111();
    }

    private boolean jj_3R_134() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(64)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(152)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(170)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(141)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(130)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_22() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_51() {
        if (this.jj_3R_48()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_91() {
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_3R_109();
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3_25() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_47();
    }

    private boolean jj_3_16() {
        return this.jj_3R_47();
    }

    private boolean jj_3_24() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3_23() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_49() {
        Token xsp;
        if (this.jj_scan_token(63)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_16());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_39() {
        if (this.jj_3R_68()) {
            return true;
        }
        return this.jj_3R_69();
    }

    private boolean jj_3_19() {
        return this.jj_3R_47();
    }

    private boolean jj_3_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_76() {
        Token xsp;
        if (this.jj_3_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_132() {
        Token xsp;
        if (this.jj_3R_69()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_39());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_90() {
        if (this.jj_3R_106()) {
            return true;
        }
        return this.jj_3R_107();
    }

    private boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_92()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_94()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_95()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_20() {
        Token xsp;
        if (this.jj_scan_token(65)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_19());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_18() {
        return this.jj_3R_48();
    }

    private boolean jj_3_17() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_34() {
        return this.jj_3R_73();
    }

    private boolean jj_3_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_18()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(95)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(93)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_134()) {
                    return true;
                }
            }
        }
        return this.jj_scan_token(116);
    }

    private boolean jj_3_27() {
        Token xsp;
        if (this.jj_3_21()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_76()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_77()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_117() {
        return this.jj_scan_token(0);
    }

    private boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_120()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_121()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_120() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        return this.jj_3R_132();
    }

    private boolean jj_3R_130() {
        return this.jj_3R_141();
    }

    private boolean jj_3R_99() {
        return this.jj_scan_token(186);
    }

    private boolean jj_3R_129() {
        return this.jj_3R_140();
    }

    private boolean jj_3R_128() {
        return this.jj_3R_139();
    }

    private boolean jj_3R_127() {
        return this.jj_3R_138();
    }

    private boolean jj_3R_126() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_125() {
        return this.jj_3R_136();
    }

    private boolean jj_3R_124() {
        return this.jj_3R_135();
    }

    private boolean jj_3_7() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_117()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_125()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_126()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_127()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_128()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_129()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_130()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_75() {
        return this.jj_3R_96();
    }

    private boolean jj_3_6() {
        Token xsp;
        if (this.jj_3_5()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_84() {
        return this.jj_3R_99();
    }

    private boolean jj_3R_83() {
        return this.jj_scan_token(181);
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(182)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3_4() {
        Token xsp;
        if (this.jj_3R_36()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_6()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_75()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_74() {
        Token xsp;
        if (this.jj_3_4()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_108() {
        return this.jj_scan_token(86);
    }

    private boolean jj_3_2() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_72() {
        Token xsp;
        if (this.jj_3_2()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_2());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(91);
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(85);
    }

    private boolean jj_3R_118() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_131());
        this.jj_scanpos = xsp;
        return this.jj_3R_132();
    }

    private boolean jj_3_1() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(87);
    }

    private boolean jj_3R_115() {
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_57() {
        return this.jj_scan_token(111);
    }

    private boolean jj_3R_152() {
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_140() {
        return this.jj_scan_token(157);
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(99);
    }

    private boolean jj_3R_150() {
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_139() {
        return this.jj_scan_token(154);
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(98);
    }

    private boolean jj_3R_63() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_138() {
        return this.jj_scan_token(151);
    }

    private boolean jj_3R_61() {
        return this.jj_scan_token(96);
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(102);
    }

    private boolean jj_3R_113() {
        return this.jj_scan_token(147);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(204);
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(103);
    }

    private boolean jj_3R_112() {
        return this.jj_scan_token(90);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{Integer.MIN_VALUE, 0, 0x40000000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x7E00007, 0x7E00000, 0, 7, 0, 0, 0, 0x7E00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 6, 7, 1, -123731968, -123731968, 0, 0, 0, 0x8000000, 0, -536870912, -268435456, 0, 0, 0, 0xA00000, 0, 0, 0, 0, -268435456};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{131072, 0, 0, 0, 131072, 131072, 131072, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1978368, 1978368, 8, 32, 16, 0, 4096, 0, 0, 32512, 12288, 12288, 405504, 12288, 12288, 655360, 655360, 1585152};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{629160462, 0, 0, 16785412, 612375050, 612375050, 612375050, 0, 2570, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16785412, 16785412, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{3588, 0, 0, 1024, 2564, 2052, 2564, 0, 0, 2048, 0x8000000, 0xC600000, 0x4600000, 0x4600000, 0x8000000, 0x4600000, 0x8000000, 0, 512, 0, 0x4600000, 0x4600000, 0, 0, 1024, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4112, 4112, 4112, 0, 4112, 0, 0, 0, 4112, 4112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public PreProcessor(InputStream stream) {
        this(stream, null);
    }

    public PreProcessor(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PreProcessorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PreProcessor(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new PreProcessorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PreProcessor(PreProcessorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PreProcessorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 44; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[208];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 44; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 208; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 41; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PreProcessor.jj_la1_init_0();
        PreProcessor.jj_la1_init_1();
        PreProcessor.jj_la1_init_2();
        PreProcessor.jj_la1_init_3();
        PreProcessor.jj_la1_init_4();
        PreProcessor.jj_la1_init_5();
        PreProcessor.jj_la1_init_6();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    class PPToken
    extends Token {
        private String path = null;
        boolean truth;
        boolean contradict;
        boolean emitExecSave;
        int comparison;

        public PPToken(PPToken ptk) {
            this.kind = ptk.kind;
            this.image = ptk.image;
            this.beginLine = ptk.beginLine;
            this.truth = ptk.truth;
            this.comparison = ptk.comparison;
            this.contradict = ptk.contradict;
        }

        public PPToken(Token tk) {
            this.kind = tk.kind;
            this.image = tk.image;
            this.beginLine = tk.beginLine;
            this.comparison = 0;
            this.truth = false;
            this.contradict = false;
        }

        public PPToken(Token tk, boolean truth) {
            this.kind = tk.kind;
            this.image = tk.image;
            this.beginLine = tk.beginLine;
            this.comparison = 0;
            this.truth = truth;
            this.contradict = false;
        }

        public PPToken(String val) {
            this.kind = 0;
            this.image = val;
            this.beginLine = 0;
            this.comparison = 0;
            this.truth = false;
            this.contradict = false;
        }

        void setTruth(boolean truth) {
            this.truth = truth;
            this.contradict = false;
        }

        void setContra(boolean truth) {
            this.contradict = truth;
        }

        void setKind(int kind) {
            this.kind = kind;
        }

        void setLine(int line) {
            this.beginLine = line;
        }

        void setEmitSave(boolean truth) {
            this.emitExecSave = truth;
        }

        void setPath(String path) {
            this.path = path;
        }

        String getPath() {
            return this.path;
        }

        public boolean equals(Object t) {
            if (t.getClass() == this.getClass()) {
                return this.image.equals(((PPToken)t).image);
            }
            try {
                if (t.getClass() == Class.forName("CPP.Token")) {
                    return this.image.equals(((Token)t).image);
                }
                if (t.getClass() == Class.forName("java.lang.String")) {
                    return this.image.equals((String)t);
                }
            }
            catch (ClassNotFoundException e) {
                Msg.error((Object)this, (Object)("PPToken.equals: " + e.getMessage()));
            }
            return false;
        }

        double Double() {
            return Double.parseDouble(this.image);
        }

        int Integer() {
            return Integer.parseInt(this.image);
        }

        void fixupNumericValue(PPToken val) {
            int cpos;
            int opos = val.image.indexOf(40);
            if (opos >= 0 && (cpos = val.image.lastIndexOf(41)) >= 0 && cpos != opos + 1) {
                val.image = val.image.substring(opos + 1, cpos - 1).trim();
            }
            val.image = PreProcessor.this.defs.expand(val.image, true);
            val.kind = PreProcessor.this.getNumericType(val.image);
        }

        int compareToZero() {
            try {
                switch (this.kind) {
                    case 59: 
                    case 114: {
                        Double thisFP = new Double(this.image);
                        Double zeroFP = new Double(0.0);
                        this.comparison = thisFP.compareTo(zeroFP);
                        break;
                    }
                    case 54: 
                    case 113: {
                        BigInteger value = PreProcessor.this.getLongValue(this.image);
                        this.comparison = value.compareTo(BigInteger.ZERO);
                        break;
                    }
                    case 115: 
                    case 169: 
                    case 181: {
                        if (PreProcessor.this.isDef(this)) {
                            PPToken pPToken = PreProcessor.this.getDef(this);
                        }
                        break;
                    }
                    default: {
                        Msg.error((Object)this, (Object)("Cannot compareToZero Token: " + this.image + " kind " + this.kind));
                        break;
                    }
                }
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("CMP2Zero:Numeric Conversion Error: " + e.getMessage()));
            }
            return this.comparison;
        }

        int compareTo(PPToken that) {
            PPToken replVal;
            Double thisFP = new Double(0.0);
            Double thatFP = new Double(0.0);
            String thisVal = null;
            String thatVal = null;
            try {
                switch (this.kind) {
                    case 59: 
                    case 114: {
                        thisFP = new Double(this.image);
                        break;
                    }
                    case 54: 
                    case 113: {
                        thisFP = new Double(PreProcessor.this.getLongValue(this.image).doubleValue());
                        break;
                    }
                    default: {
                        replVal = PreProcessor.this.getDef(this);
                        if (replVal == null) {
                            replVal = new PPToken(this);
                        }
                        thisVal = replVal.image;
                        this.fixupNumericValue(replVal);
                        thisFP = PreProcessor.this.getDoubleValue(replVal.image);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                thisFP = null;
            }
            catch (Exception e) {
                thisFP = null;
            }
            try {
                switch (that.kind) {
                    case 59: 
                    case 114: {
                        thatFP = new Double(that.image);
                        break;
                    }
                    case 54: 
                    case 113: {
                        thatFP = new Double(PreProcessor.this.getLongValue(that.image).doubleValue());
                        break;
                    }
                    default: {
                        replVal = PreProcessor.this.getDef(that);
                        if (replVal == null) {
                            replVal = new PPToken(that);
                        }
                        thatVal = replVal.image;
                        this.fixupNumericValue(replVal);
                        thatFP = PreProcessor.this.getDoubleValue(replVal.image);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                thatFP = null;
            }
            catch (Exception e) {
                thatFP = null;
            }
            if (this.image.equals(that.image)) {
                return 0;
            }
            if (this.image.equals(thatVal)) {
                return 0;
            }
            if (thisVal != null && thisVal.equals(that.image)) {
                return 0;
            }
            if (thisVal != null && thisVal.equals(thatVal)) {
                return 0;
            }
            if (thisFP != null && thatFP != null) {
                this.comparison = thisFP.compareTo(thatFP);
            } else if (thisFP != null && thatFP == null) {
                this.comparison = 1;
            } else if (thisFP == null && thatFP != null) {
                this.comparison = -1;
            } else if (thisVal != null && thatVal != null) {
                this.comparison = thisVal.compareTo(thatVal);
            }
            return this.comparison;
        }

        boolean getEmitSave() {
            return this.emitExecSave;
        }

        boolean getTruth() {
            if (!this.contradict) {
                return this.truth;
            }
            return !this.truth;
        }

        void join() {
            StringBuffer buf = new StringBuffer(this.image);
            int pos = this.image.length();
            while (pos > 0) {
                if ((pos = this.image.lastIndexOf("\\\n", pos)) >= 0) {
                    buf.replace(pos, pos + 2, " ");
                    --pos;
                    continue;
                }
                if ((pos = this.image.lastIndexOf("\\\r\n", pos)) >= 0) {
                    buf.replace(pos, pos + 3, " ");
                    --pos;
                    continue;
                }
                if ((pos = this.image.lastIndexOf("\\\r", pos)) < 0) continue;
                buf.replace(pos, pos + 2, " ");
                --pos;
            }
            this.image = buf.toString();
        }

        void emit() {
            this.image = PreProcessor.this.defs.expand(this.image, true);
            PreProcessor.this.print(this.image);
        }
    }
}

